/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick.transformers;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.alfresco.transform.base.executors.AbstractCommandExecutor;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ImageMagickCommandExecutor
extends AbstractCommandExecutor {
    @Value(value="${transform.core.imagemagick.exe}")
    private String exe;
    @Value(value="${transform.core.imagemagick.dyn}")
    private String dyn;
    @Value(value="${transform.core.imagemagick.root}")
    private String root;
    @Value(value="${transform.core.imagemagick.coders}")
    private String coders;
    @Value(value="${transform.core.imagemagick.config}")
    private String config;

    @PostConstruct
    private void createCommands() {
        if (StringUtils.isEmpty((CharSequence)this.exe)) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_EXE variable cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.dyn)) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_DYN variable cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.root)) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_ROOT variable cannot be null or empty");
        }
        this.transformCommand = this.createTransformCommand();
        this.checkCommand = this.createCheckCommand();
    }

    protected RuntimeExec createTransformCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "${source}", "SPLIT:${options}", "-strip", "-quiet", "${target}"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        HashMap<String, String> processProperties = new HashMap<String, String>();
        processProperties.put("MAGICK_HOME", this.root);
        processProperties.put("DYLD_FALLBACK_LIBRARY_PATH", this.dyn);
        processProperties.put("LD_LIBRARY_PATH", this.dyn);
        if (this.coders != null && !this.coders.isBlank()) {
            processProperties.put("MAGICK_CODER_MODULE_PATH", this.coders);
        }
        if (this.config != null && !this.config.isBlank()) {
            processProperties.put("MAGICK_CONFIGURE_PATH", this.config);
        }
        runtimeExec.setProcessProperties(processProperties);
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        defaultProperties.put("options", null);
        runtimeExec.setDefaultProperties(defaultProperties);
        runtimeExec.setErrorCodes("1,2,255,400,405,410,415,420,425,430,435,440,450,455,460,465,470,475,480,485,490,495,499,700,705,710,715,720,725,730,735,740,750,755,760,765,770,775,780,785,790,795,799");
        return runtimeExec;
    }

    protected RuntimeExec createCheckCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "-version"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        return runtimeExec;
    }
}

