/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.example;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.TransformManager;
import org.springframework.stereotype.Component;

@Component
public class HelloTransformer
implements CustomTransformer {
    public String getTransformerName() {
        return "hello";
    }

    public void transform(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        String name = new String(inputStream.readAllBytes(), transformOptions.get("sourceEncoding"));
        String greeting = String.format(this.getGreeting(transformOptions.get("language")), name);
        byte[] bytes = greeting.getBytes(transformOptions.get("sourceEncoding"));
        outputStream.write(bytes, 0, bytes.length);
    }

    private String getGreeting(String language) {
        return "Hello %s";
    }
}

