/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.stream.Collector;
import org.slf4j.Logger;

public class LookAheadBufferedReader
extends BufferedReader {
    static final String BUFFERING_DISABLED_INFO_MESSAGE = "Not available: please set the logging LEVEL to DEBUG or TRACE.";
    private final BufferingMode bufferingMode;

    LookAheadBufferedReader(Reader in, int windowSize, boolean isDebugEnabled, boolean isTraceEnabled) {
        super(in);
        this.bufferingMode = isTraceEnabled ? new WholeValue() : (isDebugEnabled ? new Windowing(windowSize) : new NoOp());
    }

    public LookAheadBufferedReader(Reader in, int windowSize, Logger logger) {
        this(in, windowSize, logger.isDebugEnabled(), logger.isTraceEnabled());
    }

    public LookAheadBufferedReader(Reader in, Logger logger) {
        this(in, 250, logger);
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch != -1) {
            this.bufferingMode.append((char)ch);
        }
        return ch;
    }

    public String lookAheadAndGetBufferedContent() {
        try {
            int ch;
            while ((ch = super.read()) != -1 && this.bufferingMode.canAccept(true)) {
                this.bufferingMode.forceAppend((char)ch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bufferingMode.toString();
    }

    boolean isInWindowingMode() {
        return this.bufferingMode instanceof Windowing;
    }

    boolean isInCollectEverythingMode() {
        return this.bufferingMode instanceof WholeValue;
    }

    boolean isBufferingDisabled() {
        return this.bufferingMode instanceof NoOp;
    }

    private static class WholeValue
    implements BufferingMode {
        private final StringBuilder content = new StringBuilder();

        private WholeValue() {
        }

        @Override
        public void append(char ch) {
            this.content.append(ch);
        }

        @Override
        public void forceAppend(char ch) {
            this.content.append(ch);
        }

        public String toString() {
            return this.content.toString();
        }

        @Override
        public boolean canAccept(boolean force) {
            return true;
        }
    }

    private static interface BufferingMode {
        public void append(char var1);

        public void forceAppend(char var1);

        public boolean canAccept(boolean var1);
    }

    private static class Windowing
    implements BufferingMode {
        private final LinkedList<Character> window = new LinkedList();
        private final int maxSize;

        private Windowing(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void append(char ch) {
            this.window.add(Character.valueOf(ch));
            if (this.window.size() == this.maxSize) {
                this.window.removeFirst();
            }
        }

        @Override
        public void forceAppend(char ch) {
            this.window.add(Character.valueOf(ch));
        }

        @Override
        public boolean canAccept(boolean force) {
            return this.window.size() < this.maxSize * 2;
        }

        public String toString() {
            return this.window.stream().collect(Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        }
    }

    private static class NoOp
    implements BufferingMode {
        private NoOp() {
        }

        @Override
        public void append(char ch) {
        }

        @Override
        public void forceAppend(char ch) {
        }

        @Override
        public boolean canAccept(boolean force) {
            return false;
        }

        public String toString() {
            return LookAheadBufferedReader.BUFFERING_DISABLED_INFO_MESSAGE;
        }
    }
}

