/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.alfresco.httpclient.Response;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.util.Pair;
import org.json.JSONException;

public class SOLRAPIQueueClient
extends SOLRAPIClient {
    public static final List<AclChangeSet> ACL_CHANGE_SET_QUEUE = Collections.synchronizedList(new ArrayList());
    public static final Map<Long, List<Acl>> ACL_MAP = Collections.synchronizedMap(new HashMap());
    public static final Map<Long, AclReaders> ACL_READERS_MAP = Collections.synchronizedMap(new HashMap());
    public static final List<Transaction> TRANSACTION_QUEUE = Collections.synchronizedList(new ArrayList());
    public static final Map<Long, List<Node>> NODE_MAP = Collections.synchronizedMap(new HashMap());
    public static final Map<Long, NodeMetaData> NODE_META_DATA_MAP = Collections.synchronizedMap(new HashMap());
    public static final Map<Long, Map<QName, String>> NODE_CONTENT_MAP = Collections.synchronizedMap(new HashMap());
    private static boolean throwException;

    public SOLRAPIQueueClient(NamespaceDAO namespaceDAO) {
        super(null, null, namespaceDAO);
    }

    public static void setThrowException(boolean _throwException) {
        throwException = _throwException;
    }

    @Override
    public AclChangeSets getAclChangeSets(Long fromCommitTime, Long minAclChangeSetId, Long toCommitTime, Long maxAclChangeSetId, int maxResults) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        AtomicLong maxTime = new AtomicLong();
        AtomicLong maxId = new AtomicLong();
        if (fromCommitTime == null && toCommitTime == null) {
            return new AclChangeSets(ACL_CHANGE_SET_QUEUE.stream().filter(aclChangeSet -> aclChangeSet.getId() >= minAclChangeSetId && aclChangeSet.getId() < maxAclChangeSetId).limit(maxResults).peek(aclChangeSet -> {
                maxTime.set(Math.max(aclChangeSet.getCommitTimeMs(), maxTime.get()));
                maxId.set(Math.max(aclChangeSet.getId(), maxId.get()));
            }).collect(Collectors.toList()), maxTime.get(), maxId.get());
        }
        return new AclChangeSets(ACL_CHANGE_SET_QUEUE.stream().filter(aclChangeSet -> fromCommitTime != null && aclChangeSet.getCommitTimeMs() >= fromCommitTime && toCommitTime != null && aclChangeSet.getCommitTimeMs() <= toCommitTime).limit(maxResults).peek(aclChangeSet -> {
            maxTime.set(Math.max(aclChangeSet.getCommitTimeMs(), maxTime.get()));
            maxId.set(Math.max(aclChangeSet.getId(), maxId.get()));
        }).collect(Collectors.toList()), maxTime.get(), maxId.get());
    }

    @Override
    public List<Acl> getAcls(List<AclChangeSet> aclChangeSets, Long minAclId, int maxResults) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return aclChangeSets.stream().map(AclChangeSet::getId).map(ACL_MAP::get).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<AclReaders> getAclReaders(List<Acl> acls) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return acls.stream().map(Acl::getId).map(ACL_READERS_MAP::get).collect(Collectors.toList());
    }

    @Override
    public List<AlfrescoModelDiff> getModelsDiff(String coreName, List<AlfrescoModel> currentModels) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return Collections.emptyList();
    }

    @Override
    public Long getNextTxCommitTime(String coreName, Long fromCommitTime) throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }

    @Override
    public Pair<Long, Long> getTxIntervalCommitTime(String coreName, Long fromNodeId, Long toNodeId) {
        List transactionCommitTimestamps = TRANSACTION_QUEUE.stream().filter(txn -> NODE_MAP.get(txn.getId()).stream().anyMatch(node -> node.getId() >= fromNodeId && node.getId() <= toNodeId)).map(tx -> tx.getCommitTimeMs()).sorted().collect(Collectors.toList());
        if (transactionCommitTimestamps.size() > 0) {
            return new Pair((Object)((Long)transactionCommitTimestamps.get(0)), (Object)((Long)transactionCommitTimestamps.get(transactionCommitTimestamps.size() - 1)));
        }
        return new Pair((Object)-1L, (Object)-1L);
    }

    @Override
    public Transactions getTransactions(Long fromCommitTime, Long minTxnId, Long toCommitTime, Long maxTxnId, int maxResults) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return this.getTransactions(fromCommitTime, minTxnId, toCommitTime, maxTxnId, maxResults, null);
    }

    @Override
    public Transactions getTransactions(Long fromCommitTime, Long minTxnId, Long toCommitTime, Long maxTxnId, int maxResults, ShardState shardState) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        AtomicLong maxTime = new AtomicLong();
        AtomicLong maxId = new AtomicLong();
        if (fromCommitTime == null && toCommitTime == null) {
            return new Transactions(TRANSACTION_QUEUE.stream().filter(txn -> txn.getId() >= minTxnId && txn.getId() < maxTxnId).limit(maxResults).peek(txn -> {
                maxTime.set(Math.max(txn.getCommitTimeMs(), maxTime.get()));
                maxId.set(Math.max(txn.getId(), maxId.get()));
            }).collect(Collectors.toList()), maxTime.get(), maxId.get());
        }
        return new Transactions(TRANSACTION_QUEUE.stream().filter(txn -> fromCommitTime != null && txn.getCommitTimeMs() >= fromCommitTime && toCommitTime != null && txn.getCommitTimeMs() <= toCommitTime).limit(maxResults).peek(txn -> {
            maxTime.set(Math.max(txn.getCommitTimeMs(), maxTime.get()));
            maxId.set(Math.max(txn.getId(), maxId.get()));
        }).collect(Collectors.toList()), maxTime.get(), maxId.get());
    }

    @Override
    public List<Node> getNodes(GetNodesParameters parameters, int maxResults) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return parameters.getTransactionIds() != null ? parameters.getTransactionIds().stream().map(NODE_MAP::get).flatMap(Collection::stream).collect(Collectors.toList()) : NODE_MAP.values().stream().flatMap(Collection::stream).filter(node -> {
            Long fromNodeId = parameters.getFromNodeId();
            Long toNodeId = parameters.getToNodeId();
            return !(fromNodeId != null && node.getId() < fromNodeId || toNodeId != null && node.getId() > toNodeId);
        }).collect(Collectors.toList());
    }

    @Override
    public List<NodeMetaData> getNodesMetaData(NodeMetaDataParameters params) throws IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return Optional.ofNullable(params.getNodeIds()).map(identifiers -> identifiers.stream().map(NODE_META_DATA_MAP::get).map(metadata -> this.getOnlyRequestedMetadata((NodeMetaData)metadata, params)).collect(Collectors.toList())).orElseGet(() -> Optional.ofNullable(params.getFromNodeId()).map(NODE_META_DATA_MAP::get).map(metadata -> this.getOnlyRequestedMetadata((NodeMetaData)metadata, params)).map(Collections::singletonList).orElseGet(Collections::emptyList));
    }

    private NodeMetaData getOnlyRequestedMetadata(NodeMetaData nodeMetaData, NodeMetaDataParameters params) {
        NodeMetaData paramFiltered = new NodeMetaData();
        paramFiltered.setId(nodeMetaData.getId());
        if (params.isIncludeType()) {
            paramFiltered.setType(nodeMetaData.getType());
        }
        if (params.isIncludeAclId()) {
            paramFiltered.setAclId(nodeMetaData.getAclId());
        }
        if (params.isIncludeAspects()) {
            paramFiltered.setAspects(nodeMetaData.getAspects());
        }
        if (params.isIncludeProperties()) {
            paramFiltered.setProperties(nodeMetaData.getProperties());
        }
        if (params.isIncludeChildAssociations()) {
            paramFiltered.setChildAssocs(nodeMetaData.getChildAssocs());
        }
        if (params.isIncludeParentAssociations()) {
            paramFiltered.setParentAssocs(nodeMetaData.getParentAssocs());
            paramFiltered.setParentAssocsCrc(nodeMetaData.getParentAssocsCrc());
        }
        if (params.isIncludeChildIds()) {
            paramFiltered.setChildIds(nodeMetaData.getChildIds());
        }
        if (params.isIncludePaths()) {
            paramFiltered.setPaths(nodeMetaData.getPaths());
            paramFiltered.setNamePaths(nodeMetaData.getNamePaths());
        }
        if (params.isIncludeOwner()) {
            paramFiltered.setOwner(nodeMetaData.getOwner());
        }
        if (params.isIncludeNodeRef()) {
            paramFiltered.setNodeRef(nodeMetaData.getNodeRef());
        }
        if (params.isIncludeTxnId()) {
            paramFiltered.setTxnId(nodeMetaData.getTxnId());
        }
        paramFiltered.setAncestors(nodeMetaData.getAncestors());
        paramFiltered.setAncestorPaths(nodeMetaData.getAncestorPaths());
        paramFiltered.setTenantDomain(nodeMetaData.getTenantDomain());
        return paramFiltered;
    }

    @Override
    public SOLRAPIClient.GetTextContentResponse getTextContent(Long nodeId, QName propertyQName, Long modifiedSince) throws IOException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        if (NODE_CONTENT_MAP.containsKey(nodeId)) {
            return new SOLRAPIClient.GetTextContentResponse(new DummyResponse(NODE_CONTENT_MAP.get(nodeId).get(propertyQName)));
        }
        return new SOLRAPIClient.GetTextContentResponse(new DummyResponse("Hello world " + nodeId));
    }

    @Override
    public void close() {
    }

    private static class DummyResponse
    implements Response {
        private final String text;

        public DummyResponse(String text) {
            this.text = text;
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.text.getBytes());
        }

        public int getStatus() {
            return 200;
        }

        public void release() {
        }

        public String getHeader(String key) {
            return null;
        }

        public String getContentType() {
            return "text/html";
        }
    }
}

