/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.slingshot.web.scripts;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.admin.NodeBrowserPost;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.SearchParameters;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodeBrowserScript
extends NodeBrowserPost
implements Serializable {
    private static final long serialVersionUID = 48743409337475896L;
    private Long searchElapsedTime = null;

    public List<NodeBrowserPost.Node> submitSearch(String store, final String query, final String queryLanguage, final int maxResults) throws IOException {
        long start = System.currentTimeMillis();
        final StoreRef storeRef = new StoreRef(store);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeBrowserPost.Node>> searchCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeBrowserPost.Node>>(){

            public List<NodeBrowserPost.Node> execute() throws Throwable {
                ArrayList<Object> searchResults = null;
                if (queryLanguage.equals("storeroot")) {
                    NodeRef rootNodeRef = NodeBrowserScript.this.getNodeService().getRootNode(storeRef);
                    searchResults = new ArrayList<NodeBrowserPost.Node>(1);
                    searchResults.add(new NodeBrowserPost.Node((NodeBrowserPost)NodeBrowserScript.this, rootNodeRef));
                    return searchResults;
                }
                if (queryLanguage.equals("noderef")) {
                    NodeRef nodeRef = new NodeRef(query);
                    boolean exists = NodeBrowserScript.this.getNodeService().exists(nodeRef);
                    if (!exists) {
                        throw new WebScriptException(500, "Node " + String.valueOf(nodeRef) + " does not exist.");
                    }
                    searchResults = new ArrayList(1);
                    searchResults.add(new NodeBrowserPost.Node((NodeBrowserPost)NodeBrowserScript.this, nodeRef));
                    return searchResults;
                }
                SearchParameters sp = new SearchParameters();
                sp.addStore(storeRef);
                sp.setLanguage(queryLanguage);
                sp.setQuery(query);
                if (maxResults > 0) {
                    sp.setLimit(maxResults);
                    sp.setLimitBy(LimitBy.FINAL_SIZE);
                }
                List nodeRefs = NodeBrowserScript.this.getSearchService().query(sp).getNodeRefs();
                searchResults = new ArrayList(nodeRefs.size());
                for (NodeRef nodeRef : nodeRefs) {
                    searchResults.add(new NodeBrowserPost.Node((NodeBrowserPost)NodeBrowserScript.this, nodeRef));
                }
                return searchResults;
            }
        };
        try {
            List results = (List)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)searchCallback, true);
            this.searchElapsedTime = System.currentTimeMillis() - start;
            return results;
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected Long getSearchElapsedTime() {
        return this.searchElapsedTime;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (req.getPathInfo().equals("/slingshot/node/search")) {
            HashMap<String, Object> tmplMap = new HashMap<String, Object>(1);
            try {
                if (req.getParameter("store") == null || req.getParameter("store").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Store name not provided");
                    status.setRedirect(true);
                    return null;
                }
                if (req.getParameter("q") == null || req.getParameter("q").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Search query not provided");
                    status.setRedirect(true);
                    return null;
                }
                if (req.getParameter("lang") == null || req.getParameter("lang").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Search language not provided");
                    status.setRedirect(true);
                    return null;
                }
                int maxResult = 0;
                try {
                    maxResult = Integer.parseInt(req.getParameter("maxResults"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                List<NodeBrowserPost.Node> nodes = this.submitSearch(req.getParameter("store"), req.getParameter("q"), req.getParameter("lang"), maxResult);
                tmplMap.put("results", nodes);
                tmplMap.put("searchElapsedTime", this.getSearchElapsedTime());
            }
            catch (IOException e) {
                status.setCode(500);
                status.setMessage(e.getMessage());
                status.setRedirect(true);
            }
            return tmplMap;
        }
        if (req.getPathInfo().equals("/slingshot/node/stores")) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("stores", this.getStores());
            return model;
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars.get("protocol") == null || ((String)templateVars.get("protocol")).length() == 0 || templateVars.get("store") == null || ((String)templateVars.get("store")).length() == 0 || templateVars.get("id") == null || ((String)templateVars.get("id")).length() == 0) {
            status.setCode(400);
            status.setMessage("Node not provided");
            status.setRedirect(true);
            return null;
        }
        NodeRef nodeRef = new NodeRef((String)templateVars.get("protocol"), (String)templateVars.get("store"), (String)templateVars.get("id"));
        HashMap<String, Object> permissionInfo = new HashMap<String, Object>(3);
        permissionInfo.put("entries", this.getPermissions(nodeRef));
        permissionInfo.put("owner", this.getOwnableService().getOwner(nodeRef));
        permissionInfo.put("inherit", this.getInheritPermissions(nodeRef));
        permissionInfo.put("storePermissions", this.getStorePermissionMasks(nodeRef));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("node", new NodeBrowserPost.Node((NodeBrowserPost)this, nodeRef));
        model.put("properties", this.getProperties(nodeRef));
        model.put("aspects", this.getAspects(nodeRef));
        model.put("children", this.getChildren(nodeRef));
        model.put("parents", this.getParents(nodeRef));
        model.put("assocs", this.getAssocs(nodeRef));
        model.put("sourceAssocs", this.getSourceAssocs(nodeRef));
        model.put("permissions", permissionInfo);
        return model;
    }
}

