/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.wiki.AbstractWikiWebScript;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WikiPageVersionGet
extends AbstractWikiWebScript {
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\d+\\.\\d+");
    private static final String PARAM_CONTENT = "content";
    private ContentService contentService;
    private VersionService versionService;

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String pageTitle, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ContentReader reader;
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String versionId = (String)templateVars.get("versionId");
        if (versionId == null) {
            String error = "No versionId supplied";
            throw new WebScriptException(400, error);
        }
        WikiPageInfo page = this.wikiService.getWikiPage(site.getShortName(), pageTitle);
        if (page == null) {
            String message = "The Wiki Page could not be found";
            status.setCode(404);
            status.setMessage(message);
            model.put(PARAM_CONTENT, "");
            return model;
        }
        VersionHistory versionHistory = null;
        Version version = null;
        try {
            versionHistory = this.versionService.getVersionHistory(page.getNodeRef());
        }
        catch (AspectMissingException aspectMissingException) {
            // empty catch block
        }
        if (versionHistory == null) {
            model.put(PARAM_CONTENT, "");
            return model;
        }
        Matcher m = LABEL_PATTERN.matcher(versionId);
        if (m.matches()) {
            try {
                version = versionHistory.getVersion(versionId);
            }
            catch (VersionDoesNotExistException versionDoesNotExistException) {}
        } else {
            for (Version v : versionHistory.getAllVersions()) {
                if (!v.getFrozenStateNodeRef().getId().equals(versionId)) continue;
                version = v;
            }
        }
        String contents = version != null ? ((reader = this.contentService.getReader(version.getFrozenStateNodeRef(), ContentModel.PROP_CONTENT)) != null ? reader.getContentString() : "") : "";
        model.put(PARAM_CONTENT, contents);
        model.put("page", page);
        model.put("site", site);
        model.put("siteId", site.getShortName());
        return model;
    }
}

