/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.web.scripts.wiki.AbstractWikiWebScript;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WikiPageMovePost
extends AbstractWikiWebScript {
    private static final String MSG_MOVED = "page-moved";
    private static final String MSG_MOVED_HERE = "page-moved-here";
    private static final String MSG_NOT_FOUND = "page-not-found";
    private static final String OLD_TITLE_KEY = "custom0";

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String pageTitle, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        ResourceBundle rb = this.getResources();
        WikiPageInfo page = this.wikiService.getWikiPage(site.getShortName(), pageTitle);
        if (page == null) {
            String message = "The Wiki Page could not be found";
            status.setCode(404);
            status.setMessage(message);
            model.put("error", rb.getString(MSG_NOT_FOUND));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("result", model);
            return result;
        }
        String newTitle = (String)json.get((Object)"name");
        String oldTitle = page.getTitle().length() == 0 ? pageTitle : page.getTitle();
        try {
            page.setTitle(newTitle);
            page = this.wikiService.updateWikiPage(page);
        }
        catch (FileExistsException e) {
            throw new WebScriptException(409, "Duplicate page name");
        }
        String movedContent = rb.getString(MSG_MOVED) + " [[" + page.getTitle() + "|" + rb.getString(MSG_MOVED_HERE) + "]].";
        this.wikiService.createWikiPage(site.getShortName(), oldTitle, movedContent);
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put(OLD_TITLE_KEY, oldTitle);
        this.addActivityEntry("renamed", page, site, req, json, additionalData);
        model.put("name", page.getSystemName());
        model.put("title", page.getTitle());
        model.put("page", page);
        model.put("siteId", site.getShortName());
        model.put("site", site);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", model);
        return result;
    }
}

