/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.wiki;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQueryFactory;
import org.alfresco.repo.query.NodeBackedEntity;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.wiki.WikiPageInfoImpl;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.service.cmr.wiki.WikiService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikiServiceImpl
implements WikiService {
    public static final String WIKI_COMPONENT = "wiki";
    protected static final String CANNED_QUERY_GET_CHILDREN = "wikiGetChildrenCannedQueryFactory";
    private static Log logger = LogFactory.getLog(WikiServiceImpl.class);
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private SiteService siteService;
    private ContentService contentService;
    private TaggingService taggingService;
    private FileFolderService fileFolderService;
    private TransactionService transactionService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    protected NodeRef getSiteWikiContainer(String siteShortName, boolean create) {
        return SiteServiceImpl.getSiteContainer((String)siteShortName, (String)WIKI_COMPONENT, (boolean)create, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
    }

    private static String buildName(String title) {
        String name = title.replace(' ', '_');
        name = name.replaceAll("\"", "%22");
        name = name.replaceAll("[*]", "%2a");
        name = name.replaceAll("<", "%3c");
        name = name.replaceAll(">", "%3e");
        name = name.replaceAll(":", "%3a");
        name = name.replaceAll("([.]?[.]+$)", "%2e");
        return name;
    }

    private WikiPageInfo buildPage(NodeRef nodeRef, NodeRef container, String name, String preLoadedContents) {
        ContentReader reader;
        WikiPageInfoImpl page = new WikiPageInfoImpl(nodeRef, container, name);
        Map props = this.nodeService.getProperties(nodeRef);
        page.setCreator((String)props.get(ContentModel.PROP_CREATOR));
        page.setModifier((String)props.get(ContentModel.PROP_MODIFIER));
        page.setCreatedAt((Date)props.get(ContentModel.PROP_CREATED));
        page.setModifiedAt((Date)props.get(ContentModel.PROP_MODIFIED));
        page.setTitle(((String)props.get(ContentModel.PROP_TITLE)).replaceAll(" ", "_"));
        String contents = preLoadedContents;
        if (contents == null && (reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT)) != null) {
            contents = reader.getContentString();
        }
        page.setContents(contents);
        page.setTags(this.taggingService.getTags(nodeRef));
        return page;
    }

    @Override
    public WikiPageInfo getWikiPage(String siteShortName, String pageTitle) {
        NodeRef container = this.getSiteWikiContainer(siteShortName, false);
        if (container == null) {
            return null;
        }
        String pageName = WikiServiceImpl.buildName(pageTitle);
        NodeRef link = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, pageName);
        if (link != null) {
            return this.buildPage(link, container, pageName, null);
        }
        return null;
    }

    @Override
    public WikiPageInfo createWikiPage(String siteShortName, String title, String content) {
        NodeRef container = this.getSiteWikiContainer(siteShortName, true);
        String name = WikiServiceImpl.buildName(title);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_TITLE, title);
        NodeRef nodeRef = this.nodeService.createNode(container, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT, props).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        return this.buildPage(nodeRef, container, name, content);
    }

    @Override
    public WikiPageInfo updateWikiPage(WikiPageInfo page) {
        if (page.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a page that was never persisted, call create instead");
        }
        NodeRef nodeRef = page.getNodeRef();
        String nodeName = WikiServiceImpl.buildName(page.getTitle());
        boolean renamed = false;
        if (!this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE).equals(page.getTitle())) {
            try {
                this.fileFolderService.rename(nodeRef, nodeName);
                renamed = true;
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Invalid node state - wiki page no longer found");
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)page.getTitle()));
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(page.getContents());
        this.taggingService.setTags(nodeRef, page.getTags());
        if (renamed) {
            page = this.buildPage(nodeRef, page.getContainerNodeRef(), nodeName, page.getContents());
        }
        return page;
    }

    @Override
    public void deleteWikiPage(WikiPageInfo page) {
        if (page.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a wiki page that was never persisted");
        }
        this.nodeService.deleteNode(page.getNodeRef());
    }

    @Override
    public PagingResults<WikiPageInfo> listWikiPages(String siteShortName, PagingRequest paging) {
        return this.listWikiPages(siteShortName, null, paging);
    }

    @Override
    public PagingResults<WikiPageInfo> listWikiPages(String siteShortName, String user, PagingRequest paging) {
        return this.listWikiPages(siteShortName, user, null, null, null, null, paging);
    }

    @Override
    public PagingResults<WikiPageInfo> listWikiPagesByCreated(String siteShortName, Date from, Date to, PagingRequest paging) {
        return this.listWikiPages(siteShortName, null, from, to, null, null, paging);
    }

    @Override
    public PagingResults<WikiPageInfo> listWikiPagesByModified(String siteShortName, Date from, Date to, PagingRequest paging) {
        return this.listWikiPages(siteShortName, null, null, null, from, to, paging);
    }

    public PagingResults<WikiPageInfo> listWikiPages(String siteShortName, String username, Date createdFrom, Date createdTo, Date modifiedFrom, Date modifiedTo, PagingRequest paging) {
        NodeRef container = this.getSiteWikiContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        GetChildrenAuditableCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenAuditableCannedQueryFactory)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN);
        CannedQuerySortDetails sorting = getChildrenCannedQueryFactory.createDateDescendingCQSortDetails();
        GetChildrenAuditableCannedQuery cq = (GetChildrenAuditableCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(container, ContentModel.TYPE_CONTENT, username, createdFrom, createdTo, null, modifiedFrom, modifiedTo, sorting, paging);
        CannedQueryResults results = cq.execute();
        return this.wrap((PagingResults<NodeBackedEntity>)results, container);
    }

    private PagingResults<WikiPageInfo> wrap(final PagingResults<NodeBackedEntity> results, final NodeRef container) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NodeBackedEntity node : results.getPage()) {
            ids.add(node.getId());
        }
        this.nodeDAO.cacheNodesById(ids);
        return new PagingResults<WikiPageInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<WikiPageInfo> getPage() {
                ArrayList<WikiPageInfo> pages = new ArrayList<WikiPageInfo>();
                for (NodeBackedEntity node : results.getPage()) {
                    NodeRef nodeRef = node.getNodeRef();
                    String name = node.getName();
                    pages.add(WikiServiceImpl.this.buildPage(nodeRef, container, name, null));
                }
                return pages;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }
}

