/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.service.cmr.wiki.WikiService;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.json.JSONWriter;

public abstract class AbstractWikiWebScript
extends DeclarativeWebScript {
    public static final String WIKI_SERVICE_ACTIVITY_APP_NAME = "wiki";
    protected static final int MAX_QUERY_ENTRY_COUNT = 1000;
    private static Log logger = LogFactory.getLog(AbstractWikiWebScript.class);
    protected NodeService nodeService;
    protected SiteService siteService;
    protected WikiService wikiService;
    protected PersonService personService;
    protected ActivityService activityService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setWikiService(WikiService wikiService) {
        this.wikiService = wikiService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    protected String getOrNull(JSONObject json, String key) {
        if (json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        return null;
    }

    protected PagingRequest buildPagingRequest(WebScriptRequest req) {
        return new ScriptPagingDetails(req, 1000);
    }

    protected void addActivityEntry(String event, WikiPageInfo wikiPage, SiteInfo site, WebScriptRequest req, JSONObject json) {
        this.addActivityEntry(event, wikiPage, site, req, json, Collections.emptyMap());
    }

    protected void addActivityEntry(String event, WikiPageInfo wikiPage, SiteInfo site, WebScriptRequest req, JSONObject json, Map<String, String> additionalData) {
        String page = req.getParameter("page");
        if (page == null && json != null && json.containsKey((Object)"page")) {
            page = (String)json.get((Object)"page");
        }
        if (page == null) {
            page = WIKI_SERVICE_ACTIVITY_APP_NAME;
        }
        try {
            StringWriter activityJson = new StringWriter();
            JSONWriter activity = new JSONWriter((Writer)activityJson);
            activity.startObject();
            activity.writeValue("title", wikiPage.getTitle());
            activity.writeValue("page", page + "?title=" + URLEncoder.encodeUriComponent((String)wikiPage.getTitle()));
            for (Map.Entry<String, String> entry : additionalData.entrySet()) {
                activity.writeValue(entry.getKey(), entry.getValue());
            }
            activity.endObject();
            this.activityService.postActivity("org.alfresco.wiki.page-" + event, site.getShortName(), WIKI_SERVICE_ACTIVITY_APP_NAME, activityJson.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Error adding wiki page " + event + " to activities feed"), (Throwable)e);
        }
    }

    protected NodeRef personForModel(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        try {
            return this.personService.getPerson(username);
        }
        catch (NoSuchPersonException e) {
            return null;
        }
    }

    protected Map<String, Object> renderWikiPage(WikiPageInfo page) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("page", page);
        res.put("node", page.getNodeRef());
        res.put("name", page.getSystemName());
        res.put("title", page.getTitle());
        res.put("contents", page.getContents());
        res.put("tags", page.getTags());
        res.put("createdOn", page.getCreatedAt());
        res.put("modifiedOn", page.getModifiedAt());
        res.put("created", page.getCreatedAt());
        res.put("modified", page.getModifiedAt());
        for (Map.Entry entry : res.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue("");
        }
        res.put("createdBy", this.personForModel(page.getCreator()));
        res.put("modifiedBy", this.personForModel(page.getModifier()));
        return res;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String siteName;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            throw new WebScriptException(400, "No parameters supplied");
        }
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException | ParseException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
        }
        if ((siteName = (String)templateVars.get("siteId")) == null) {
            siteName = req.getParameter("site");
        }
        if (siteName == null && json != null) {
            if (json.containsKey((Object)"siteid")) {
                siteName = (String)json.get((Object)"siteid");
            } else if (json.containsKey((Object)"siteId")) {
                siteName = (String)json.get((Object)"siteId");
            } else if (json.containsKey((Object)"site")) {
                siteName = (String)json.get((Object)"site");
            }
        }
        if (siteName == null) {
            throw new WebScriptException(400, "No site given");
        }
        SiteInfo site = this.siteService.getSite(siteName);
        if (site == null) {
            String error = "Could not find site: " + siteName;
            throw new WebScriptException(404, error);
        }
        String pageTitle = (String)templateVars.get("pageTitle");
        return this.executeImpl(site, pageTitle, req, json, status, cache);
    }

    protected abstract Map<String, Object> executeImpl(SiteInfo var1, String var2, WebScriptRequest var3, JSONObject var4, Status var5, Cache var6);
}

