/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.io.IOExceptionOutputStream;
import de.schlichtherle.truezip.io.IOExceptionSeekableByteChannel;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private static final int INITIAL_CAPACITY = HashMaps.initialCapacity(FsOutputOption.values().length);
    private static final StandardOpenOption[] WRITE_STANDARD_OPEN_OPTION = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry entry, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        assert (null != entry);
        assert (null != options);
        if (options.get(FsOutputOption.EXCLUSIVE) && options.get(FsOutputOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.entry = entry;
        this.options = options;
        this.template = template;
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    private FileEntry begin() throws IOException {
        FileEntry temp;
        block8: {
            Path parentFile;
            Path entryFile = this.entry.getPath();
            Boolean exists = null;
            if (this.options.get(FsOutputOption.EXCLUSIVE) && (exists = Boolean.valueOf(Files.exists(entryFile, new LinkOption[0]))).booleanValue()) {
                throw new FileAlreadyExistsException(this.entry.toString());
            }
            if (this.options.get(FsOutputOption.CACHE)) {
                if (Boolean.TRUE.equals(exists) || null == exists && (exists = Boolean.valueOf(Files.exists(entryFile, new LinkOption[0]))).booleanValue()) {
                    entryFile.getFileSystem().provider().checkAccess(entryFile, AccessMode.WRITE);
                } else {
                    Files.createFile(entryFile, new FileAttribute[0]);
                }
                temp = this.entry.createTempFile();
            } else {
                temp = this.entry;
            }
            if (this.options.get(FsOutputOption.CREATE_PARENTS) && !Boolean.TRUE.equals(exists) && null != (parentFile = entryFile.getParent())) {
                try {
                    Files.createDirectories(parentFile, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    if (Files.isDirectory(parentFile, new LinkOption[0])) break block8;
                    throw ex;
                }
            }
        }
        return temp;
    }

    private void append(FileEntry temp) throws IOException {
        if (temp != this.entry && this.options.get(FsOutputOption.APPEND) && Files.exists(this.entry.getPath(), new LinkOption[0])) {
            IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
        }
    }

    private Set<OpenOption> optionSet() {
        HashSet<OpenOption> set = new HashSet<OpenOption>(INITIAL_CAPACITY);
        Collections.addAll(set, WRITE_STANDARD_OPEN_OPTION);
        if (this.options.get(FsOutputOption.APPEND)) {
            set.add(StandardOpenOption.APPEND);
            set.remove(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.options.get(FsOutputOption.EXCLUSIVE)) {
            set.add(StandardOpenOption.CREATE_NEW);
        }
        return set;
    }

    private OpenOption[] optionArray() {
        Set<OpenOption> set = this.optionSet();
        return set.toArray(new OpenOption[set.size()]);
    }

    private void close(FileEntry temp, boolean commit) throws IOException {
        Path entryFile = this.entry.getPath();
        if (temp != this.entry) {
            Path tempFile = temp.getPath();
            this.copyAttributes(tempFile);
            if (commit) {
                try {
                    Files.move(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    IOSocket.copy(temp.getInputSocket(), this.entry.getOutputSocket());
                    this.copyAttributes(entryFile);
                }
                this.release(temp, null);
            }
        } else {
            this.copyAttributes(entryFile);
        }
    }

    private void copyAttributes(Path file) throws IOException {
        Entry template = this.template;
        if (null == template) {
            return;
        }
        Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }

    private void release(FileEntry temp, @CheckForNull IOException ex) throws IOException {
        try {
            temp.release();
        }
        catch (IOException ex2) {
            ex2.initCause(ex);
            throw ex2;
        }
    }

    @Override
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        final FileEntry temp = this.begin();
        try {
            this.append(temp);
            class SeekableByteChannel
            extends IOExceptionSeekableByteChannel {
                boolean closed;

                SeekableByteChannel() throws IOException {
                    super(Files.newByteChannel(fileEntry.getPath(), FileOutputSocket.this.optionSet(), new FileAttribute[0]));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(temp, null == this.exception);
                }
            }
            return new SeekableByteChannel();
        }
        catch (IOException ex) {
            this.release(temp, ex);
            throw ex;
        }
    }

    @Override
    public OutputStream newOutputStream() throws IOException {
        final FileEntry temp = this.begin();
        try {
            this.append(temp);
            class OutputStream
            extends IOExceptionOutputStream {
                boolean closed;

                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                OutputStream() throws IOException {
                    super(Files.newOutputStream(fileEntry.getPath(), FileOutputSocket.this.optionArray()));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(temp, null == this.exception);
                }
            }
            return new OutputStream();
        }
        catch (IOException ex) {
            this.release(temp, ex);
            throw ex;
        }
    }
}

