/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class AlfrescoFileUtils {
    public static boolean areDirectoryEquals(Path dir, Path dir2, String[] extensions, boolean recursive) {
        Map<String, File> filesDir1 = FileUtils.listFiles((File)new File(dir.toUri()), (String[])extensions, (boolean)recursive).stream().collect(Collectors.toMap(f -> f.getName(), f -> f));
        Map<String, File> filesDir2 = FileUtils.listFiles((File)new File(dir2.toUri()), (String[])extensions, (boolean)recursive).stream().collect(Collectors.toMap(f -> f.getName(), f -> f));
        if (filesDir1.size() != filesDir2.size()) {
            return false;
        }
        return filesDir1.entrySet().stream().allMatch(e -> {
            File fileDir2 = (File)filesDir2.get(e.getKey());
            if (fileDir2 == null) {
                return false;
            }
            try {
                byte[] otherBytes = Files.readAllBytes(((File)e.getValue()).toPath());
                byte[] thisBytes = Files.readAllBytes(fileDir2.toPath());
                return Arrays.equals(otherBytes, thisBytes);
            }
            catch (IOException ex) {
                return false;
            }
        });
    }
}

