/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.repo.index.shard.ShardStateBuilder;
import org.alfresco.repo.index.shard.ShardStateBuilderBase;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.Tracker;
import org.apache.commons.codec.EncoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardStatePublisher
extends AbstractTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShardStatePublisher.class);
    private static final Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static final Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private final boolean isMaster;

    public ShardStatePublisher(boolean isMaster, Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer) {
        super(p, client, coreName, informationServer, Tracker.Type.NODE_STATE_PUBLISHER);
        this.isMaster = isMaster;
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
    }

    @Override
    protected void doTrack(String iterationId) {
        try {
            ShardState shardstate = this.getShardState();
            this.client.getTransactions(Long.valueOf(0L), null, Long.valueOf(0L), null, 0, shardstate);
        }
        catch (IOException | AuthenticationException | EncoderException exception) {
            LOGGER.error("Unable to publish this node state. A failure condition has been met during the outbound subscription message encoding process. See the stacktrace below for further details.", exception);
        }
    }

    @Override
    public void maintenance() {
    }

    @Override
    public boolean hasMaintenance() {
        return false;
    }

    @Override
    public TrackerState getTrackerState() {
        return this.infoSrv.getTrackerInitialState();
    }

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    ShardState getShardState() {
        TrackerState transactionsTrackerState = this.getTrackerState();
        TrackerState changeSetsTrackerState = Optional.of(this.infoSrv.getAdminHandler()).map(AlfrescoCoreAdminHandler::getTrackerRegistry).map(registry -> registry.getTrackerForCore(this.coreName, AclTracker.class)).map(Tracker::getTrackerState).orElse(transactionsTrackerState);
        HashMap<String, String> propertyBag = new HashMap<String, String>();
        propertyBag.put("coreName", this.coreName);
        this.updateShardProperty();
        propertyBag.putAll(this.docRouter.getProperties(this.shardProperty));
        return ((ShardStateBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceBuilderBase.ShardShardBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardInstanceBuilderBase.ShardShardBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)ShardStateBuilder.shardState().withMaster(this.isMaster)).withLastUpdated(System.currentTimeMillis())).withLastIndexedChangeSetCommitTime(changeSetsTrackerState.getLastIndexedChangeSetCommitTime())).withLastIndexedChangeSetId(changeSetsTrackerState.getLastIndexedChangeSetId())).withLastIndexedTxCommitTime(transactionsTrackerState.getLastIndexedTxCommitTime())).withLastIndexedTxId(transactionsTrackerState.getLastIndexedTxId())).withPropertyBag(propertyBag)).withShardInstance().withBaseUrl(this.infoSrv.getBaseUrl())).withPort(this.infoSrv.getPort())).withHostName(this.infoSrv.getHostName())).withShard().withInstance(this.shardInstance)).withFloc().withNumberOfShards(this.shardCount)).withAddedStoreRef(this.storeRef)).withTemplate(this.shardTemplate)).withHasContent(this.transformContent)).withShardMethod(this.shardMethod)).endFloc()).endShard()).endShardInstance()).build();
    }

    public boolean isOnMasterOrStandalone() {
        return this.isMaster;
    }
}

