/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.ComposableDocRouter;

public class ExplicitShardIdWithDynamicPropertyRouter
extends ComposableDocRouter {
    public ExplicitShardIdWithDynamicPropertyRouter() {
    }

    public ExplicitShardIdWithDynamicPropertyRouter(boolean isInStandaloneMode) {
        super(isInStandaloneMode);
    }

    @Override
    public Boolean routeAcl(int shardCount, int shardInstance, Acl acl) {
        return true;
    }

    @Override
    public Boolean routeNode(int shardCount, int shardInstance, Node node) {
        String shardBy = node.getShardPropertyValue();
        if (shardBy == null || shardBy.trim().length() == 0) {
            this.debug("Shard {}: EXPLICIT_ID routing specified but no shard id property found for node {}", shardInstance, node.getNodeRef());
            return this.negativeReturnValue();
        }
        try {
            int shardid = Integer.parseInt(shardBy.trim());
            return shardid == shardInstance;
        }
        catch (NumberFormatException exception) {
            this.debug("Shard {} EXPLICIT_ID routing specified but failed to parse a shard property value ({}) for node {}", shardInstance, shardBy, node.getNodeRef());
            return this.negativeReturnValue();
        }
    }

    @Override
    public Map<String, String> getProperties(Optional<QName> shardProperty) {
        return shardProperty.map(QName::getPrefixString).map(prefix -> Map.of("shard.key", prefix)).orElse(Collections.emptyMap());
    }
}

