/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.SolrPathQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.WrappedQuery;

public class SolrCachingPathQuery
extends Query {
    final SolrPathQuery pathQuery;

    public SolrCachingPathQuery(SolrPathQuery pathQuery) {
        if (pathQuery == null) {
            throw new IllegalStateException("pathQuery cannot be null");
        }
        this.pathQuery = pathQuery;
    }

    public Weight createWeight(IndexSearcher indexSearcher, boolean requiresScore) throws IOException {
        SolrIndexSearcher searcher = null;
        if (!(indexSearcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        searcher = (SolrIndexSearcher)indexSearcher;
        DocSet results = (DocSet)searcher.cacheLookup("alfrescoPathCache", (Object)this.pathQuery);
        if (results == null) {
            WrappedQuery wrapped = new WrappedQuery((Query)this.pathQuery);
            wrapped.setCache(false);
            results = searcher.getDocSet((Query)wrapped);
            searcher.cacheInsert("alfrescoPathCache", (Object)this.pathQuery, (Object)results);
        }
        return new ConstantScoreQuery((Query)results.getTopFilter()).createWeight((IndexSearcher)searcher, false);
    }

    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CACHED -> :");
        stringBuilder.append(this.pathQuery.toString());
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SolrCachingPathQuery)) {
            return false;
        }
        SolrCachingPathQuery that = (SolrCachingPathQuery)((Object)o);
        return this.pathQuery.equals((Object)that.pathQuery);
    }

    public int hashCode() {
        return this.pathQuery.hashCode();
    }
}

