/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.AbstractAuthorityQuery;
import org.alfresco.solr.query.AbstractAuthorityQueryWeight;
import org.alfresco.solr.query.SolrAuthorityScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrAuthorityQuery
extends AbstractAuthorityQuery {
    public SolrAuthorityQuery(String authority) {
        super(authority);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AUTHORITY").append(':');
        stringBuilder.append(this.authority);
        return stringBuilder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrAuthorityQueryWeight((SolrIndexSearcher)searcher, needsScores, this, this.authority);
    }

    private class SolrAuthorityQueryWeight
    extends AbstractAuthorityQueryWeight {
        public SolrAuthorityQueryWeight(SolrIndexSearcher searcher, boolean needsScores, Query query, String authority) throws IOException {
            super(searcher, needsScores, query, "AUTHORITY", authority);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return SolrAuthorityScorer.createAuthorityScorer(this, context, this.searcher, SolrAuthorityQuery.this.authority);
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(new Term("AUTHORITY", SolrAuthorityQuery.this.authority));
        }
    }
}

