/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.Counter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DelegatingCollector;

public class MimetypeGroupingCollector
extends DelegatingCollector {
    HashMap<String, Counter> counters = new HashMap();
    ResponseBuilder rb;
    private HashMap<String, String> mappings;
    private boolean doGroup;
    String schemaFieldName;
    SchemaField schemaField;
    SortedDocValues sortedDocValues;

    public MimetypeGroupingCollector(ResponseBuilder rb, HashMap<String, String> mappings, boolean doGroup) {
        this.rb = rb;
        this.mappings = mappings;
        this.doGroup = doGroup;
        this.schemaFieldName = AlfrescoSolrDataModel.getInstance().mapProperty("content.mimetype", AlfrescoSolrDataModel.FieldUse.FACET, rb.req);
        this.schemaField = rb.req.getSchema().getFieldOrNull(this.schemaFieldName);
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        if (this.schemaField != null) {
            try {
                this.sortedDocValues = context.reader().getSortedDocValues(this.schemaFieldName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void collect(int doc) throws IOException {
        int ordinal;
        if (this.sortedDocValues != null && (ordinal = this.sortedDocValues.getOrd(doc)) > -1) {
            Counter counter;
            String group;
            String value = (String)this.schemaField.getType().toObject(this.schemaField, this.sortedDocValues.lookupOrd(ordinal));
            String string = group = this.doGroup ? this.mappings.get(value) : value;
            if (group == null) {
                group = value;
            }
            if ((counter = this.counters.get(group)) == null) {
                counter = Counter.newCounter();
                this.counters.put(group, counter);
            }
            counter.addAndGet(1L);
        }
        this.leafDelegate.collect(doc);
    }

    public void finish() throws IOException {
        NamedList analytics = new NamedList();
        this.rb.rsp.add("analytics", (Object)analytics);
        NamedList fieldCounts = new NamedList();
        analytics.add("mimetype()", (Object)fieldCounts);
        for (Map.Entry<String, Counter> counter : this.counters.entrySet()) {
            fieldCounts.add(counter.getKey(), (Object)counter.getValue().get());
        }
        if (this.delegate instanceof DelegatingCollector) {
            ((DelegatingCollector)this.delegate).finish();
        }
    }
}

