/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.alfresco.service.cmr.repository.MLText;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.springframework.extensions.surf.util.I18NUtil;

public class AlfrescoCollatableMLTextFieldType
extends StrField {
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.getName(), (FieldComparatorSource)new MLTextSortFieldComparatorSource(), reverse);
    }

    public Object marshalSortValue(Object value) {
        return value;
    }

    public Object unmarshalSortValue(Object value) {
        return value;
    }

    public static class MLTextSortFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator<String> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new MLTextSortFieldComparator(numHits, fieldname, I18NUtil.getLocale());
        }
    }

    public static final class MLTextSortFieldComparator
    extends FieldComparator<String>
    implements LeafFieldComparator {
        private final String[] values;
        private BinaryDocValues docTerms;
        Bits docsWithField;
        private final String field;
        Collator collator;
        String bottom;
        String top;
        Locale collatorLocale;

        MLTextSortFieldComparator(int numHits, String field, Locale collatorLocale) {
            this.values = new String[numHits];
            this.field = field;
            this.collatorLocale = collatorLocale;
            this.collator = Collator.getInstance(collatorLocale);
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            return this.compareValues(val1, val2);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public int compareBottom(int doc) {
            String comparableString = this.findBestValue(doc, this.docTerms.get(doc));
            return this.compareValues(this.bottom, comparableString);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.findBestValue(doc, this.docTerms.get(doc));
        }

        public String value(int slot) {
            return this.values[slot];
        }

        private String findBestValue(int doc, BytesRef term) {
            if (term.length == 0 && this.docsWithField != null && !this.docsWithField.get(doc)) {
                return null;
            }
            String withLocale = term.utf8ToString();
            if (withLocale == null) {
                return withLocale;
            }
            if (withLocale.startsWith("\u0000")) {
                MLText mlText = new MLText();
                String[] parts = withLocale.split("\u0000");
                int i = 0;
                while (i + 2 <= parts.length) {
                    Locale locale = null;
                    String[] localeParts = parts[i + 1].split("_");
                    if (localeParts.length == 1) {
                        locale = new Locale(localeParts[0]);
                    } else if (localeParts.length == 2) {
                        locale = new Locale(localeParts[0], localeParts[1]);
                    } else if (localeParts.length == 3) {
                        locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                    }
                    if (locale != null) {
                        if (i + 2 == parts.length) {
                            mlText.addValue(locale, "");
                        } else {
                            mlText.addValue(locale, parts[i + 2]);
                        }
                    }
                    i += 3;
                }
                return mlText.getClosestValue(this.collatorLocale);
            }
            return withLocale;
        }

        public void setTopValue(String value) {
            this.top = value;
        }

        public int compareTop(int doc) throws IOException {
            String comparableString = this.findBestValue(doc, this.docTerms.get(doc));
            return this.compareValues(this.top, comparableString);
        }

        public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
            this.docTerms = DocValues.getBinary((LeafReader)context.reader(), (String)this.field);
            this.docsWithField = DocValues.getDocsWithField((LeafReader)context.reader(), (String)this.field);
            if (this.docsWithField instanceof Bits.MatchAllBits) {
                this.docsWithField = null;
            }
            return this;
        }

        public int compareValues(String val1, String val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        public void setScorer(Scorer scorer) {
        }
    }
}

