/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExplicitIDWithLRISRouterIT {
    private DocRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        this.router = DocRouterFactory.getRouter((Properties)new Properties(), (ShardMethodEnum)ShardMethodEnum.EXPLICIT_ID);
    }

    @Test
    public void aclsAreReplicatedAcrossShards() {
        IntStream.range(0, 100).forEach(index -> Assert.assertTrue((boolean)this.router.routeAcl(AlfrescoSolrUtils.randomPositiveInteger(), AlfrescoSolrUtils.randomPositiveInteger(), this.acl)));
    }

    @Test
    public void shardPropertyEmpty_shouldFallBackToDBID() {
        Node node = new Node();
        node.setShardPropertyValue("\n\n\n\n    \t\t");
        this.assertDataIsDistributedAccordingWithDBIDRouting(node);
    }

    @Test
    public void shardPropertyNull_shouldFallBackToDBID() {
        Node node = new Node();
        node.setShardPropertyValue(null);
        this.assertDataIsDistributedAccordingWithDBIDRouting(node);
    }

    @Test
    public void shardPropertyNaN_shouldFallBackToDBID() {
        Node node = new Node();
        node.setShardPropertyValue("This is not a valid Number that can be used as shard ID.");
        this.assertDataIsDistributedAccordingWithDBIDRouting(node);
    }

    @Test
    public void explicitShardMatchesShardInstance() {
        int shardCount = 2;
        int firstShardInstance = 0;
        int secondShardInstance = 1;
        Node prototypeNodeOnFirstShard = new Node();
        prototypeNodeOnFirstShard.setShardPropertyValue(String.valueOf(firstShardInstance));
        Node prototypeNodeOnSecondShard = new Node();
        prototypeNodeOnSecondShard.setShardPropertyValue(String.valueOf(secondShardInstance));
        int howManyDocumentsPerShard = 1000;
        HashMap nodeDistributionMap = new HashMap();
        IntStream.range(0, 2).forEach(shardId -> IntStream.range(0, howManyDocumentsPerShard).forEach(index -> {
            if (this.router.routeNode(shardCount, shardId, prototypeNodeOnFirstShard).booleanValue()) {
                nodeDistributionMap.merge(shardId, 1, Integer::sum);
            }
            if (this.router.routeNode(shardCount, shardId, prototypeNodeOnSecondShard).booleanValue()) {
                nodeDistributionMap.merge(shardId, 1, Integer::sum);
            }
        }));
        Assert.assertEquals((long)shardCount, (long)nodeDistributionMap.size());
        Assert.assertEquals((long)howManyDocumentsPerShard, (long)((Integer)nodeDistributionMap.get(firstShardInstance)).intValue());
        Assert.assertEquals((long)howManyDocumentsPerShard, (long)((Integer)nodeDistributionMap.get(secondShardInstance)).intValue());
    }

    @Test
    public void explicitShardDoesntMatchShardInstance() {
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn((Object)String.valueOf(shardInstance));
        Assert.assertFalse((boolean)this.router.routeNode(shardCount, shardInstance + 1, this.node));
    }

    private void assertDataIsDistributedAccordingWithDBIDRouting(Node node) {
        int[] shardIdentifiers = IntStream.range(0, 15).toArray();
        int shardCount = shardIdentifiers.length;
        int howManyDocumentsPerShard = 10000;
        HashMap nodeDistributionMap = new HashMap();
        IntStream.range(0, shardCount * howManyDocumentsPerShard).mapToLong(Long::valueOf).forEach(id -> {
            node.setId(id);
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeNode(shardCount, shardId, node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
        });
        StandardDeviation sd = new StandardDeviation();
        double deviation = sd.evaluate(nodeDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        double norm = deviation / (double)howManyDocumentsPerShard * 100.0;
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        Assert.assertTrue((String)(nodeDistributionMap.values().toString() + ", SD = " + deviation + ", SD_NORM = " + norm + "%"), (norm < 30.0 ? 1 : 0) != 0);
    }
}

