/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.util.Pair;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.carrot2.shaded.guava.common.collect.ImmutableList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedCascadeTrackerIT
extends AbstractAlfrescoDistributedIT {
    private Node parentFolder;
    private NodeMetaData parentFolderMetadata;
    private Node childShard0;
    private NodeMetaData childShardMetadata0;
    private Node childShard1;
    private NodeMetaData childShardMetadata1;
    private final String pathParent = "pathParent";
    private final String pathChild0 = "pathChild0";
    private final String pathChild1 = "pathChild2";

    @Before
    public void initData() throws Throwable {
        DistributedCascadeTrackerIT.initSolrServers(2, DistributedCascadeTrackerIT.getSimpleClassName(), this.getShardMethod());
        this.indexData();
    }

    @After
    public void destroyData() {
        DistributedCascadeTrackerIT.dismissSolrServers();
    }

    private void indexData() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, (List<Acl>)ImmutableList.of((Object)acl), (List<AclReaders>)ImmutableList.of((Object)aclReaders));
        this.indexNodes(acl);
    }

    @Test
    public void testCascadeShouldHappenInBothShardsAfterUpdateParentFolder() throws Exception {
        String cascadingFirstChild = "cascadingFirstChild";
        String cascadingSecondChild = "cascadingSecondChild";
        this.childShardMetadata0.setPaths((List)ImmutableList.of((Object)new Pair((Object)cascadingFirstChild, null)));
        this.childShardMetadata1.setPaths((List)ImmutableList.of((Object)new Pair((Object)cascadingSecondChild, null)));
        DistributedCascadeTrackerIT.assertShardCount(0, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:pathChild0"}), 1);
        DistributedCascadeTrackerIT.assertShardCount(1, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:pathChild2"}), 1);
        this.indexParentFolderWithCascade();
        DistributedCascadeTrackerIT.waitForDocCount(DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:" + cascadingFirstChild}), 1, 100000L);
        DistributedCascadeTrackerIT.waitForDocCount(DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:" + cascadingSecondChild}), 1, 100000L);
        DistributedCascadeTrackerIT.assertShardCount(0, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:" + cascadingFirstChild}), 1);
        DistributedCascadeTrackerIT.assertShardCount(1, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:" + cascadingSecondChild}), 1);
        DistributedCascadeTrackerIT.assertShardCount(0, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:pathChild0"}), 0);
        DistributedCascadeTrackerIT.assertShardCount(1, DistributedCascadeTrackerIT.params((String[])new String[]{"qt", "/afts", "q", "PATH:pathChild2"}), 0);
    }

    private void indexNodes(Acl acl) throws Exception {
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, 3);
        this.parentFolder = AlfrescoSolrUtils.getNode(0L, bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.parentFolderMetadata = AlfrescoSolrUtils.getNodeMetaData(this.parentFolder, bigTxn, acl, "elia", null, false);
        this.parentFolderMetadata.setPaths((List)ImmutableList.of((Object)new Pair((Object)"pathParent", null)));
        this.childShard0 = AlfrescoSolrUtils.getNode(99L, bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.childShardMetadata0 = AlfrescoSolrUtils.getNodeMetaData(this.childShard0, bigTxn, acl, "elia", AlfrescoSolrUtils.ancestors(this.parentFolderMetadata.getNodeRef()), false);
        this.childShardMetadata0.setPaths((List)ImmutableList.of((Object)new Pair((Object)"pathChild0", null)));
        this.childShard1 = AlfrescoSolrUtils.getNode(101L, bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.childShardMetadata1 = AlfrescoSolrUtils.getNodeMetaData(this.childShard1, bigTxn, acl, "elia", AlfrescoSolrUtils.ancestors(this.parentFolderMetadata.getNodeRef()), false);
        this.childShardMetadata1.setPaths((List)ImmutableList.of((Object)new Pair((Object)"pathChild2", null)));
        DistributedCascadeTrackerIT.indexTransaction(bigTxn, (List<Node>)ImmutableList.of((Object)this.parentFolder, (Object)this.childShard0, (Object)this.childShard1), (List<NodeMetaData>)ImmutableList.of((Object)this.parentFolderMetadata, (Object)this.childShardMetadata0, (Object)this.childShardMetadata1));
        DistributedCascadeTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 3, 100000L);
        DistributedCascadeTrackerIT.assertShardCount(0, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2);
        DistributedCascadeTrackerIT.assertShardCount(1, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 1);
    }

    private void indexParentFolderWithCascade() {
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, 1);
        this.parentFolder.setTxnId(bigTxn.getId());
        this.parentFolderMetadata.setTxnId(bigTxn.getId());
        this.parentFolderMetadata.getProperties().put(ContentModel.PROP_CASCADE_TX, new StringPropertyValue(Long.toString(bigTxn.getId())));
        DistributedCascadeTrackerIT.indexTransaction(bigTxn, (List<Node>)ImmutableList.of((Object)this.parentFolder), (List<NodeMetaData>)ImmutableList.of((Object)this.parentFolderMetadata));
    }

    private Properties getShardMethod() {
        Properties prop = new Properties();
        prop.put("shard.method", "DB_ID_RANGE");
        return prop;
    }
}

