/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrTrackerIT.initSolrServers(2, DistributedAlfrescoSolrTrackerIT.getSimpleClassName(), null);
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @Test
    public void testTracker() throws Exception {
        AlfrescoSolrUtils.TestActChanges testActChanges = new AlfrescoSolrUtils.TestActChanges().createBasicTestData();
        AclChangeSet aclChangeSet = testActChanges.getChangeSet();
        Acl acl = testActChanges.getFirstAcl();
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 2);
        Node folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node errorNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, txn, acl, "mike", null, false);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
        NodeMetaData errorMetaData = AlfrescoSolrUtils.getNodeMetaData(errorNode, txn, acl, "lisa", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), true);
        DistributedAlfrescoSolrTrackerIT.indexTransaction(txn, Arrays.asList(errorNode, folderNode, fileNode), Arrays.asList(errorMetaData, folderMetaData, fileMetaData));
        DistributedAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("READER", "jim")), 1, 80000L);
        DistributedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2, 100000L);
        DistributedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(fileNode.getId()))), 1, 80000L);
        DistributedAlfrescoSolrTrackerIT.putHandleDefaults();
        this.query(DistributedAlfrescoSolrTrackerIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}", DistributedAlfrescoSolrTrackerIT.params((String[])new String[]{"q", "t1:world", "qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "6", "sort", "id asc"}));
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (int i = 0; i < numNodes; ++i) {
            Node node = AlfrescoSolrUtils.getNode(bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, acl, "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes + 2, 100000L);
        this.query(DistributedAlfrescoSolrTrackerIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}", DistributedAlfrescoSolrTrackerIT.params((String[])new String[]{"q", "t1:world", "qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "100", "sort", "id asc"}));
        DistributedAlfrescoSolrTrackerIT.assertNodesPerShardGreaterThan((int)((double)numNodes * 0.44));
        int numAcls = 1000;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i = 0; i < numAcls; ++i) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel"), Collections.singletonList("phil"), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        DistributedAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("READER", "joel")), numAcls + 1, 80000L);
    }
}

