/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT
extends AbstractAlfrescoDistributedIT {
    private static final int NUMBER_OF_SHARDS = 3;

    @BeforeClass
    public static void initData() throws Throwable {
        Properties properties = new Properties();
        properties.put("shard.method", ShardMethodEnum.DB_ID.toString());
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.initSolrServers(3, DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.getSimpleClassName(), properties);
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.dismissSolrServers();
    }

    @Test
    public void shouldReindexNodeOnlyOnShardWhereNodeBelongsTo() throws Exception {
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.putHandleDefaults();
        Node node = this.indexNewNode();
        long nodeId = node.getId();
        long txnId = node.getTxnId();
        this.assertThatNodeIsIndexedOnExactlyOneShard(nodeId);
        this.triggerTransactionReindexing(txnId);
        for (int assertCount = 1; assertCount <= 10; ++assertCount) {
            this.assertThatNodeIsIndexedOnExactlyOneShard(nodeId);
            Thread.sleep(Duration.ofSeconds(1L).toMillis());
        }
    }

    private void triggerTransactionReindexing(long txnId) throws Exception {
        Map cores = DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.getCores(solrShards).stream().collect(Collectors.toMap(SolrCore::getName, Function.identity()));
        List<AlfrescoCoreAdminHandler> adminHandlers = DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.getAdminHandlers(solrShards);
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertEquals((long)3L, (long)adminHandlers.size());
        for (int i = 0; i < 3; ++i) {
            SolrCore core = (SolrCore)cores.get("shard" + i);
            DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertNotNull((Object)core);
            AlfrescoCoreAdminHandler admin = adminHandlers.get(i);
            DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertNotNull((Object)admin);
            LocalSolrQueryRequest reindexRequest = new LocalSolrQueryRequest(core, (SolrParams)DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.params((String[])new String[]{"action", "REINDEX", "core", core.getName(), "txid", Long.toString(txnId)}));
            SolrQueryResponse reindexResponse = new SolrQueryResponse();
            admin.handleRequestBody((SolrQueryRequest)reindexRequest, reindexResponse);
            DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertNull((Object)reindexResponse.getException());
        }
    }

    private void assertThatNodeIsIndexedOnExactlyOneShard(long nodeId) {
        List<SolrClient> allClients = DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.getShardedClients();
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertEquals((long)3L, (long)allClients.size());
        ModifiableSolrParams queryParams = DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.params((String[])new String[]{"qt", "/afts", "q", "DBID:" + nodeId});
        long sumForAllShards = allClients.stream().map(c -> {
            try {
                return c.query((SolrParams)queryParams);
            }
            catch (IOException | SolrServerException e) {
                throw new RuntimeException(e);
            }
        }).map(QueryResponse::getResults).mapToLong(SolrDocumentList::getNumFound).sum();
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.assertEquals((long)1L, (long)sumForAllShards);
    }

    private Node indexNewNode() throws Exception {
        Transaction tx = AlfrescoSolrUtils.getTransaction(0, 1);
        Acl acl = this.getAcl();
        Node node = AlfrescoSolrUtils.getNode(tx, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, tx, acl, "testOwner", null, false);
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.indexTransaction(tx, List.of(node), List.of(nodeMetaData));
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 1, 100000L);
        return node;
    }

    private Acl getAcl() throws Exception {
        AlfrescoSolrUtils.TestActChanges testActChanges = new AlfrescoSolrUtils.TestActChanges().createBasicTestData();
        AclChangeSet aclChangeSet = testActChanges.getChangeSet();
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrMetadataTrackerReindexingByTransactionIdUsingDbIdShardingMethodIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        return testActChanges.getFirstAcl();
    }
}

