/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.core.SolrCore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoSolrTrackerStateIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoSolrTrackerStateIT.initAlfrescoCore("schema.xml");
    }

    @After
    public void clearQueue() throws Exception {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    @Before
    public void indexTestAclTransactionAndNodes() throws Exception {
        Acl acl = this.createAndIndexSomeAclData();
        this.createAndIndexTransactionWithSomeNodes(4, acl, "first");
    }

    @Test
    public void shardStateMustBeConsistentWithCoreSummaryStats() throws Exception {
        SolrCore core = AlfrescoSolrTrackerStateIT.getCore();
        ShardStatePublisher tracker = Optional.of(AlfrescoSolrUtils.coreAdminHandler(core)).map(AlfrescoCoreAdminHandler::getTrackerRegistry).map(registry -> (ShardStatePublisher)registry.getTrackerForCore(core.getName(), ShardStatePublisher.class)).orElseThrow(() -> new IllegalStateException("Cannot retrieve the Metadata tracker on this test core."));
        ShardState shardStateAfterFirstIndexingRound = tracker.getShardState();
        AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(shardStateAfterFirstIndexingRound, core);
        Acl acl = this.createAndIndexSomeAclData();
        ShardState shardStateAfterIndexingSomeAdditionalAcl = tracker.getShardState();
        Assert.assertEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedTxId(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxId());
        Assert.assertEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedTxCommitTime(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxCommitTime());
        Assert.assertNotEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedChangeSetId(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetId());
        Assert.assertNotEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedChangeSetCommitTime(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetCommitTime());
        AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(shardStateAfterIndexingSomeAdditionalAcl, core);
        this.createAndIndexTransactionWithSomeNodes(5, acl, "second");
        ShardState shardStateAfterIndexingAnAdditionalTransaction = tracker.getShardState();
        Assert.assertNotEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxId(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedTxId());
        Assert.assertNotEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxCommitTime(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedTxCommitTime());
        Assert.assertEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetId(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedChangeSetId());
        Assert.assertEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetCommitTime(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedChangeSetCommitTime());
        AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(tracker.getShardState(), core);
    }

    private void makeSureTransactionHasBeenIndexed(long transactionId) throws Exception {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)transactionId, (Long)(transactionId + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrTrackerStateIT.waitForDocCount((Query)waitForQuery, 1L, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    private void makeSureNodesHaveBeenIndexed(int expectedCount, String searchText) throws Exception {
        AlfrescoSolrTrackerStateIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", searchText)), expectedCount, AlfrescoSolrUtils.MAX_WAIT_TIME);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", searchText)), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", "mike")), BooleanClause.Occur.MUST));
        AlfrescoSolrTrackerStateIT.waitForDocCount((Query)builder.build(), expectedCount, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    private Acl createAndIndexSomeAclData() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(acl, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrTrackerStateIT.waitForDocCount((Query)waitForQuery, 1L, AlfrescoSolrUtils.MAX_WAIT_TIME);
        return acl;
    }

    private void createAndIndexTransactionWithSomeNodes(int howManyTestNodes, Acl acl, String sampleTextContent) throws Exception {
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        Map.Entry<List<Node>, List<NodeMetaData>> data = TestDataProvider.nSampleNodesWithSampleContent(acl, txn, howManyTestNodes);
        AlfrescoSolrTrackerStateIT.indexTransaction(txn, data.getKey(), data.getValue(), IntStream.range(0, howManyTestNodes).mapToObj(index -> sampleTextContent).collect(Collectors.toList()));
        this.makeSureTransactionHasBeenIndexed(txn.getId());
        this.makeSureNodesHaveBeenIndexed(data.getKey().size(), sampleTextContent);
    }
}

