/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import java.util.Locale;
import java.util.stream.LongStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.requestHandler.AbstractRequestHandlerIT;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AFTSRequestHandlerIT
extends AbstractRequestHandlerIT
implements QueryConstants {
    private static TestDataProvider DATASETS_PROVIDER;

    @BeforeClass
    public static void loadData() throws Exception {
        DATASETS_PROVIDER = new TestDataProvider(h);
        DATASETS_PROVIDER.loadTestDataset();
        FTS_TEST_DATE = DATASETS_PROVIDER.getFtsTestDate();
        TEST_NODEREF = DATASETS_PROVIDER.getTestNodeRef();
        TEST_ROOT_NODEREF = DATASETS_PROVIDER.getRootNode();
    }

    @Test
    public void ancestorField() {
        this.assertResponseCardinality("ANCESTOR", "\"" + String.valueOf(DATASETS_PROVIDER.getTestNodeRef()) + "\"", 10);
    }

    @Test
    public void qNameField() {
        this.assertResponseCardinality("QNAME", "\"cm:one\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:two\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:three\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:four\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:five\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:six\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:seven\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:eight-0\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:eight-1\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:eight-2\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:nine\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:ten\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:eleven\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:twelve\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:thirteen\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:fourteen\"", 2);
        this.assertResponseCardinality("QNAME", "\"cm:fifteen\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:common\"", 1);
        this.assertResponseCardinality("QNAME", "\"cm:link\"", 1);
    }

    @Test
    public void primaryAssociationTypeQNameField() {
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:one\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:two\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:three\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:four\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:five\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:six\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:seven\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:eight-0\"", 0);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:eight-1\"", 0);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:eight-2\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:nine\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:ten\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:eleven\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:twelve\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:thirteen\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:fourteen\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:fifteen\"", 1);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:common\"", 0);
        this.assertResponseCardinality("PRIMARYASSOCQNAME", "\"cm:link\"", 0);
        this.assertResponseCardinality("PRIMARYASSOCTYPEQNAME", "\"" + ContentModel.ASSOC_CHILDREN.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 4);
    }

    @Test
    public void isNodeField() {
        this.assertResponseCardinality("ISNODE", "T", 16);
    }

    @Test
    public void associationTypeQNameField() {
        this.assertResponseCardinality("ASSOCTYPEQNAME", "\"" + ContentModel.ASSOC_CHILDREN.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 5);
    }

    @Test
    public void primaryParentField() {
        this.assertResponseCardinality("PRIMARYPARENT", "\"" + String.valueOf(TEST_NODEREF) + "\"", 2);
    }

    @Test
    public void dbIdField() {
        this.assertResponseCardinality("DBID", "1", 1);
        this.assertResponseCardinality("DBID", "2", 1);
        this.assertResponseCardinality("DBID", "3", 1);
        this.assertResponseCardinality("DBID", "4", 1);
        this.assertResponseCardinality("DBID", "5", 1);
        this.assertResponseCardinality("DBID", "6", 1);
        this.assertResponseCardinality("DBID", "7", 1);
        this.assertResponseCardinality("DBID", "8", 1);
        this.assertResponseCardinality("DBID", "9", 1);
        this.assertResponseCardinality("DBID", "10", 1);
        this.assertResponseCardinality("DBID", "11", 1);
        this.assertResponseCardinality("DBID", "12", 1);
        this.assertResponseCardinality("DBID", "13", 1);
        this.assertResponseCardinality("DBID", "14", 1);
        this.assertResponseCardinality("DBID", "15", 1);
        this.assertResponseCardinality("DBID", "16", 1);
        this.assertResponseCardinality("DBID", "17", 0);
    }

    @Test
    public void authorityFilterEnabled() {
        this.checkAuthorityFilter(true);
    }

    @Test
    public void authorityFilterDisabled() {
        this.checkAuthorityFilter(false);
    }

    @Test
    public void ownerField() {
        this.assertResponseCardinality("OWNER", "andy", 1);
        this.assertResponseCardinality("OWNER", "bob", 1);
        this.assertResponseCardinality("OWNER", "cid", 1);
        this.assertResponseCardinality("OWNER", "dave", 1);
        this.assertResponseCardinality("OWNER", "eoin", 1);
        this.assertResponseCardinality("OWNER", "fred", 1);
        this.assertResponseCardinality("OWNER", "gail", 1);
        this.assertResponseCardinality("OWNER", "hal", 1);
        this.assertResponseCardinality("OWNER", "ian", 1);
        this.assertResponseCardinality("OWNER", "jake", 1);
        this.assertResponseCardinality("OWNER", "kara", 1);
        this.assertResponseCardinality("OWNER", "loon", 1);
        this.assertResponseCardinality("OWNER", "mike", 1);
        this.assertResponseCardinality("OWNER", "noodle", 1);
        this.assertResponseCardinality("OWNER", "ood", 1);
    }

    @Test
    public void parentAssociationCrcField() {
        this.assertResponseCardinality("PARENTASSOCCRC", "0", 16);
    }

    @Test
    public void txIdFields() {
        this.assertResponseCardinality("TXID", "1", 1);
        this.assertResponseCardinality("INTXID", "1", 17);
        this.assertResponseCardinality("ACLTXID", "1", 1);
        this.assertResponseCardinality("INACLTXID", "1", 2);
        this.assertResponseCardinality("INACLTXID", "2", 0);
    }

    @Test
    public void text() {
        this.assertResponseCardinality("\"lazy\"", 1);
        this.assertResponseCardinality("lazy and dog", 1);
        this.assertResponseCardinality("-lazy and -dog", 15);
        this.assertResponseCardinality("|lazy and |dog", 1);
        this.assertResponseCardinality("|eager and |dog", 1);
        this.assertResponseCardinality("|lazy and |wolf", 1);
        this.assertResponseCardinality("|eager and |wolf", 0);
        this.assertResponseCardinality("-lazy or -dog", 15);
        this.assertResponseCardinality("-eager or -dog", 16);
        this.assertResponseCardinality("-lazy or -wolf", 16);
        this.assertResponseCardinality("-eager or -wolf", 16);
        this.assertResponseCardinality("lazy dog", 1);
        this.assertResponseCardinality("lazy and not dog", 0);
        this.assertResponseCardinality("lazy not dog", 16);
        this.assertResponseCardinality("lazy and !dog", 0);
        this.assertResponseCardinality("lazy !dog", 16);
        this.assertResponseCardinality("lazy and -dog", 0);
        this.assertResponseCardinality("lazy -dog", 16);
        this.assertResponseCardinality("TEXT:\"lazy\"", 1);
        this.assertResponseCardinality("cm_content:\"lazy\"", 1);
        this.assertResponseCardinality("d:content:\"lazy\"", 1);
        this.assertResponseCardinality("=cm_content:\"lazy\"", 1);
        this.assertResponseCardinality("~cm_content:\"lazy\"", 1);
        this.assertResponseCardinality("cm:content:big OR cm:content:lazy", 1);
        this.assertResponseCardinality("cm:content:big AND cm:content:lazy", 0);
        this.assertResponseCardinality("{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1);
        this.assertResponseCardinality("=lazy", 1);
        this.assertResponseCardinality("@cm:content:big OR @cm:content:lazy", 1);
        this.assertResponseCardinality("@cm:content:big AND @cm:content:lazy", 0);
        this.assertResponseCardinality("@{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1);
        this.assertResponseCardinality("~@cm:content:big OR ~@cm:content:lazy", 1);
        this.assertResponseCardinality("brown * quick", 0);
        this.assertResponseCardinality("brown * dog", 1);
        this.assertResponseCardinality("brown *(0) dog", 0);
        this.assertResponseCardinality("brown *(1) dog", 0);
        this.assertResponseCardinality("brown *(2) dog", 0);
        this.assertResponseCardinality("brown *(3) dog", 0);
        this.assertResponseCardinality("brown *(4) dog", 0);
        this.assertResponseCardinality("brown *(5) dog", 1);
        this.assertResponseCardinality("brown *(6) dog", 1);
        this.assertResponseCardinality("TEXT:(\"lazy\")", 1);
        this.assertResponseCardinality("TEXT:(lazy and dog)", 1);
        this.assertResponseCardinality("TEXT:(-lazy and -dog)", 15);
        this.assertResponseCardinality("TEXT:(-lazy and dog)", 0);
        this.assertResponseCardinality("TEXT:(lazy and -dog)", 0);
        this.assertResponseCardinality("TEXT:(|lazy and |dog)", 1);
        this.assertResponseCardinality("TEXT:(|eager and |dog)", 1);
        this.assertResponseCardinality("TEXT:(|lazy and |wolf)", 1);
        this.assertResponseCardinality("TEXT:(|eager and |wolf)", 0);
        this.assertResponseCardinality("TEXT:(-lazy or -dog)", 15);
        this.assertResponseCardinality("TEXT:(-eager or -dog)", 16);
        this.assertResponseCardinality("TEXT:(-lazy or -wolf)", 16);
        this.assertResponseCardinality("TEXT:(-eager or -wolf)", 16);
        this.assertResponseCardinality("TEXT:(lazy dog)", 1);
        this.assertResponseCardinality("TEXT:(lazy and not dog)", 0);
        this.assertResponseCardinality("TEXT:(lazy not dog)", 16);
        this.assertResponseCardinality("TEXT:(lazy and !dog)", 0);
        this.assertResponseCardinality("TEXT:(lazy !dog)", 16);
        this.assertResponseCardinality("TEXT:(lazy and -dog)", 0);
        this.assertResponseCardinality("TEXT:(lazy -dog)", 16);
        this.assertResponseCardinality("cm_content:(\"lazy\")", 1);
        this.assertResponseCardinality("cm:content:(big OR lazy)", 1);
        this.assertResponseCardinality("cm:content:(big AND lazy)", 0);
        this.assertResponseCardinality("{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1);
        this.assertResponseCardinality("TEXT:(=lazy)", 1);
        this.assertResponseCardinality("@cm:content:(big) OR @cm:content:(lazy)", 1);
        this.assertResponseCardinality("@cm:content:(big) AND @cm:content:(lazy)", 0);
        this.assertResponseCardinality("@{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1);
        this.assertResponseCardinality("@cm:content:(~big OR ~lazy)", 1);
        this.assertResponseCardinality("TEXT:(brown * quick)", 0);
        this.assertResponseCardinality("TEXT:(brown * dog)", 1);
        this.assertResponseCardinality("TEXT:(brown *(0) dog)", 0);
        this.assertResponseCardinality("TEXT:(brown *(1) dog)", 0);
        this.assertResponseCardinality("TEXT:(brown *(2) dog)", 0);
        this.assertResponseCardinality("TEXT:(brown *(3) dog)", 0);
        this.assertResponseCardinality("TEXT:(brown *(4) dog)", 0);
        this.assertResponseCardinality("TEXT:(brown *(5) dog)", 1);
        this.assertResponseCardinality("TEXT:(brown *(6) dog)", 1);
    }

    @Test
    public void ranges() {
        String fieldName = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"float\\-ista").toString();
        this.assertResponseCardinality(fieldName, "3.40", 1);
        this.assertResponseCardinality(fieldName, "3..4", 1);
        this.assertResponseCardinality(fieldName, "3..3.39", 0);
        this.assertResponseCardinality(fieldName, "3..3.40", 1);
        this.assertResponseCardinality(fieldName, "3.41..3.9", 0);
        this.assertResponseCardinality(fieldName, "3.40..3.9", 1);
        this.assertResponseCardinality(fieldName, "[3 TO 4]", 1);
        this.assertResponseCardinality(fieldName, "[3 TO 3.39]", 0);
        this.assertResponseCardinality(fieldName, "[3 TO 3.4]", 1);
        this.assertResponseCardinality(fieldName, "[3.41 TO 4]", 0);
        this.assertResponseCardinality(fieldName, "[3.4 TO 4]", 1);
        this.assertResponseCardinality(fieldName, "[3 TO 3.4>", 0);
        this.assertResponseCardinality(fieldName, "<3.4 TO 4]", 0);
        this.assertResponseCardinality(fieldName, "<3.4 TO 3.4>", 0);
        this.assertResponseCardinality(fieldName, "(3.40)", 1);
        this.assertResponseCardinality(fieldName, "(3..4)", 1);
        this.assertResponseCardinality(fieldName, "(3..3.39)", 0);
        this.assertResponseCardinality(fieldName, "(3..3.40)", 1);
        this.assertResponseCardinality(fieldName, "(3.41..3.9)", 0);
        this.assertResponseCardinality(fieldName, "(3.40..3.9)", 1);
        this.assertResponseCardinality(fieldName, "([3 TO 4])", 1);
        this.assertResponseCardinality(fieldName, "([3 TO 3.39])", 0);
        this.assertResponseCardinality(fieldName, "([3 TO 3.4])", 1);
        this.assertResponseCardinality(fieldName, "([3.41 TO 4])", 0);
        this.assertResponseCardinality(fieldName, "([3.4 TO 4])", 1);
        this.assertResponseCardinality(fieldName, "([3 TO 3.4>)", 0);
        this.assertResponseCardinality(fieldName, "(<3.4 TO 4])", 0);
        this.assertResponseCardinality(fieldName, "(<3.4 TO 3.4>)", 0);
        this.assertResponseCardinality("test:float_x002D_ista", "3.40", 1);
    }

    @Test
    public void txCommitTimeFields() {
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/native", "q", "TXCOMMITTIME:*"), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/native", "q", "ACLTXCOMMITTIME:*"), null), "*[count(//doc)=1]");
    }

    @Test
    public void aclIdField() {
        this.assertResponseCardinality("ACLID", "1", 17);
    }

    @Test
    public void readerField() {
        this.assertResponseCardinality("READER", "\"GROUP_EVERYONE\"", 16);
    }

    @Test
    public void idField() {
        LongStream.range(1L, 16L).mapToObj(dbId -> this.escape(AlfrescoSolrDataModel.getNodeDocumentId((String)"_DEFAULT_", (Long)dbId))).forEach(id -> this.assertResponseCardinality("id", (String)id, 1));
    }

    @Test
    public void docTypeField() {
        this.assertResponseCardinality("DOC_TYPE", "Node", 16);
        this.assertResponseCardinality("DOC_TYPE", "Acl", 1);
        this.assertResponseCardinality("DOC_TYPE", "AclTx", 1);
        this.assertResponseCardinality("DOC_TYPE", "Tx", 1);
    }

    @Test
    public void parentField() {
        this.assertResponseCardinality("PARENT", "\"" + String.valueOf(TEST_NODEREF) + "\"", 4);
    }

    @Test
    public void paging() {
        this.assertPage("PATH:\"//.\"", "DBID asc", 16, 1000000, 0, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        this.assertPage("PATH:\"//.\"", "DBID asc", 16, 20, 0, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        this.assertPage("PATH:\"//.\"", "DBID asc", 6, 6, 0, new int[]{1, 2, 3, 4, 5, 6});
        this.assertPage("PATH:\"//.\"", "DBID asc", 6, 6, 6, new int[]{7, 8, 9, 10, 11, 12});
        this.assertPage("PATH:\"//.\"", "DBID asc", 4, 6, 12, new int[]{13, 14, 15, 16});
    }

    @Test
    public void mimetypes() {
        this.assertResponseCardinality("cm:content.mimetype:\"text/plain\"", 1);
        this.assertResponseCardinality("cm_content.mimetype:\"text/plain\"", 1);
        this.assertResponseCardinality("@cm_content.mimetype:\"text/plain\"", 1);
        this.assertResponseCardinality("content.mimetype:\"text/plain\"", 1);
        this.assertResponseCardinality("@{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1);
        this.assertResponseCardinality("{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1);
    }

    @Test
    public void lazy() {
        this.assertResponseCardinality("lazy", 1);
        this.assertResponseCardinality("laz*", 1);
        this.assertResponseCardinality("l*y", 1);
        this.assertResponseCardinality("l??y", 1);
        this.assertResponseCardinality("?az?", 1);
        this.assertResponseCardinality("*zy", 1);
        this.assertResponseCardinality("\"lazy\"", 1);
        this.assertResponseCardinality("\"laz*\"", 1);
        this.assertResponseCardinality("\"l*y\"", 1);
        this.assertResponseCardinality("\"l??y\"", 1);
        this.assertResponseCardinality("\"?az?\"", 1);
        this.assertResponseCardinality("\"*zy\"", 1);
        this.assertResponseCardinality("cm:content", "lazy", 1);
        this.assertResponseCardinality("cm:content", "laz*", 1);
        this.assertResponseCardinality("cm:content", "l*y", 1);
        this.assertResponseCardinality("cm:content", "l??y", 1);
        this.assertResponseCardinality("cm:content", "?az?", 1);
        this.assertResponseCardinality("cm:content", "*zy", 1);
        this.assertResponseCardinality("cm:content", "\"lazy\"", 1);
        this.assertResponseCardinality("cm:content", "\"laz*\"", 1);
        this.assertResponseCardinality("cm:content", "\"l*y\"", 1);
        this.assertResponseCardinality("cm:content", "\"l??y\"", 1);
        this.assertResponseCardinality("cm:content", "\"?az?\"", 1);
        this.assertResponseCardinality("cm:content", "\"*zy\"", 1);
        this.assertResponseCardinality("cm:content", "(lazy)", 1);
        this.assertResponseCardinality("cm:content", "(laz*)", 1);
        this.assertResponseCardinality("cm:content", "(l*y)", 1);
        this.assertResponseCardinality("cm:content", "(l??y)", 1);
        this.assertResponseCardinality("cm:content", "(?az?)", 1);
        this.assertResponseCardinality("cm:content", "(*zy)", 1);
        this.assertResponseCardinality("cm:content", "(\"lazy\")", 1);
        this.assertResponseCardinality("cm:content", "(\"laz*\")", 1);
        this.assertResponseCardinality("cm:content", "(\"l*y\")", 1);
        this.assertResponseCardinality("cm:content", "(\"l??y\")", 1);
        this.assertResponseCardinality("cm:content", "(\"?az?\")", 1);
        this.assertResponseCardinality("cm:content", "(\"*zy\")", 1);
        this.assertResponseCardinality("lazy^2 dog^4.2", 1);
        this.assertResponseCardinality("lazy~0.7", 1);
        this.assertResponseCardinality("cm:content", "laxy~0.7", 1);
        this.assertResponseCardinality("laxy~0.7", 1);
        this.assertResponseCardinality("=laxy~0.7", 1);
        this.assertResponseCardinality("~laxy~0.7", 1);
        this.assertResponseCardinality("\"quick fox\"~0", 0);
        this.assertResponseCardinality("\"quick fox\"~1", 1);
        this.assertResponseCardinality("\"quick fox\"~2", 1);
        this.assertResponseCardinality("\"quick fox\"~3", 1);
        this.assertResponseCardinality("\"fox quick\"~0", 0);
        this.assertResponseCardinality("\"fox quick\"~1", 0);
        this.assertResponseCardinality("\"fox quick\"~2", 1);
        this.assertResponseCardinality("\"fox quick\"~3", 1);
        this.assertResponseCardinality("lazy", 1);
        this.assertResponseCardinality("-lazy", 15);
        this.assertResponseCardinality("lazy -lazy", 16);
        this.assertResponseCardinality("lazy^20 -lazy", 16);
        this.assertResponseCardinality("lazy^20 -lazy^20", 16);
        this.assertResponseCardinality("cm:content", "lazy", 1);
        this.assertResponseCardinality("content", "lazy", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", 16);
        this.assertResponseCardinality("+PATH", "\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\"", 0);
        this.assertResponseCardinality("+PATH", "\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 15);
        this.assertResponseCardinality("+PATH", "\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" AND -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 0);
        this.assertResponseCardinality("(brown *(6) dog)", 1);
        this.assertResponseCardinality("TEXT", "(brown *(6) dog)", 1);
        this.assertResponseCardinality("\"//.\"", 0);
        this.assertResponseCardinality("cm:content", "brown", 1);
        this.assertResponseCardinality("modified", "*", 2);
        this.assertResponseCardinality("modified", "[MIN TO NOW]", 2);
        this.assertResponseCardinality("TYPE", TEST_TYPE.toString(), 1);
        this.assertResponseCardinality("TYPE", TEST_TYPE.toString(), "mimetype():document", 0);
        this.assertResponseCardinality("TYPE", ContentModel.TYPE_CONTENT.toString(), 1);
        this.assertResponseCardinality("TYPE", ContentModel.TYPE_CONTENT.toString(), "mimetype():document", 1);
        this.assertResponseCardinality("TYPE", ContentModel.TYPE_CONTENT.toString(), "mimetype():\"text/plain\"", 1);
        this.assertResponseCardinality("TYPE", ContentModel.TYPE_CONTENT.toString(), "contentSize():[0 TO 100]", 0);
        this.assertResponseCardinality("TYPE", ContentModel.TYPE_CONTENT.toString(), "contentSize():[100 TO 1000]", 1);
        this.assertResponseCardinality("modified", "[NOW/DAY-1DAY TO NOW/DAY+1DAY]", 2);
        this.assertResponseCardinality("modified", "[NOW/DAY-1DAY TO *]", 2);
        this.assertResponseCardinality("modified", "[* TO NOW/DAY+1DAY]", 2);
        this.assertResponseCardinality("modified", "[* TO *]", 2);
    }

    @Test
    public void synonyms() {
        this.assertResponseCardinality("quick", 1);
        this.assertResponseCardinality("fast", 1);
        this.assertResponseCardinality("rapid", 1);
        this.assertResponseCardinality("speedy", 1);
        this.assertResponseCardinality("\"brown fox jumped\"", 1);
        this.assertResponseCardinality("\"leaping reynard\"", 1);
        this.assertResponseCardinality("\"springer\"", 1);
        this.assertResponseCardinality("lazy", 1);
        this.assertResponseCardinality("\"bone idle\"", 1);
    }

    @Test
    public void sort() {
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", String.valueOf(ContentModel.PROP_CONTENT) + ".size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", ContentModel.PROP_CONTENT.toString() + ".size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@cm:content.size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@cm:content.size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "cm:content.size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "cm:content.size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@content.size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@content.size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "content.size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "content.size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("-eager or -dog", "@" + ContentModel.PROP_NAME.toString() + " asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", "@" + ContentModel.PROP_NAME.toString() + " desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", ContentModel.PROP_NAME.toString() + " asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", ContentModel.PROP_NAME.toString() + " desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", "@cm:name asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", "@cm:name desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", "cm:name asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", "cm:name desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", "cm_name desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", "@name asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", "@name desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("-eager or -dog", "name asc", null, 16, new Integer[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3});
        this.assertAQueryIsSorted("-eager or -dog", "name desc", null, 16, new Integer[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "DBID asc", null, 16, new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "DBID desc", null, 16, new Integer[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "ID asc", null, 16, new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "ID desc", null, 16, new Integer[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(CREATED_DATE) + " asc", null, 16, new Integer[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(CREATED_DATE) + " desc", null, 16, new Integer[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(CREATED_TIME) + " asc", null, 16, new Integer[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(CREATED_TIME) + " desc", null, 16, new Integer[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_DOUBLE) + " asc", null, 16, new Integer[]{15, 13, 11, 9, 7, 5, 3, 2, 1, 4, 6, 8, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_DOUBLE) + " desc", null, 16, new Integer[]{16, 14, 12, 10, 8, 6, 4, 1, 2, 3, 5, 7, 9, 11, 13, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_FLOAT) + " asc", null, 16, new Integer[]{15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 1, 8, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_FLOAT) + " desc", null, 16, new Integer[]{16, 14, 12, 10, 8, 1, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LONG) + " asc", null, 16, new Integer[]{15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 1, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LONG) + " desc", null, 16, new Integer[]{16, 14, 12, 10, 1, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_INT) + " asc", null, 16, new Integer[]{15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 1, 8, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_INT) + " desc", null, 16, new Integer[]{16, 14, 12, 10, 8, 1, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_TEXT) + " asc", null, 16, new Integer[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_TEXT) + " desc", null, 16, new Integer[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " asc", Locale.ENGLISH, 16, new Integer[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 7, 8, 14, 15, 16, 9});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " desc", Locale.ENGLISH, 16, new Integer[]{9, 16, 15, 14, 8, 7, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " asc", Locale.FRENCH, 16, new Integer[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 8, 7, 14, 15, 16, 9});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " desc", Locale.FRENCH, 16, new Integer[]{9, 16, 15, 14, 7, 8, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " asc", Locale.GERMAN, 16, new Integer[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 7, 8, 14, 15, 16, 9});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " desc", Locale.GERMAN, 16, new Integer[]{9, 16, 15, 14, 8, 7, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " asc", new Locale("sv"), 16, new Integer[]{1, 11, 2, 3, 4, 5, 13, 6, 7, 8, 12, 14, 15, 16, 9, 10});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_TEXT) + " desc", new Locale("sv"), 16, new Integer[]{10, 9, 16, 15, 14, 12, 8, 7, 6, 13, 5, 4, 3, 2, 11, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_ML_TEXT) + " asc", Locale.ENGLISH, 16, new Integer[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_ML_TEXT) + " desc", Locale.ENGLISH, 16, new Integer[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_ML_TEXT) + " asc", Locale.FRENCH, 16, new Integer[]{1, 14, 16, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_ML_TEXT) + " desc", Locale.FRENCH, 16, new Integer[]{15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 16, 14, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " asc", Locale.ENGLISH, 16, new Integer[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " desc", Locale.ENGLISH, 16, new Integer[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " asc", Locale.FRENCH, 16, new Integer[]{1, 16, 15, 14, 13, 12, 2, 3, 4, 5, 11, 10, 9, 8, 7, 6});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " desc", Locale.FRENCH, 16, new Integer[]{6, 7, 8, 9, 10, 11, 5, 4, 3, 2, 12, 13, 14, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " asc", Locale.GERMAN, 16, new Integer[]{1, 16, 15, 2, 3, 4, 5, 6, 7, 9, 8, 10, 12, 14, 11, 13});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " desc", Locale.GERMAN, 16, new Integer[]{13, 11, 14, 12, 10, 8, 9, 7, 6, 5, 4, 3, 2, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " asc", new Locale("es"), 16, new Integer[]{1, 16, 15, 7, 14, 8, 9, 10, 11, 12, 13, 2, 3, 4, 5, 6});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ORDER_LOCALISED_ML_TEXT) + " desc", new Locale("es"), 16, new Integer[]{6, 5, 4, 3, 2, 13, 12, 11, 10, 9, 8, 14, 7, 15, 16, 1});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".size asc", null, 16, new Integer[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".size desc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".mimetype asc", null, 16, new Integer[]{15});
        this.assertAQueryIsSorted("PATH:\"//.\"", "@" + String.valueOf(ContentModel.PROP_CONTENT) + ".mimetype desc", null, 16, new Integer[]{15});
    }

    private void checkAuthorityFilter(boolean postFilter) {
        System.setProperty("alfresco.postfilter", Boolean.toString(postFilter));
        this.assertResponseCardinality("PATH:\"//.\"", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{!afts}|DENIED:andy", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{!afts}|DENYSET\":andy:bob:cid\"", 0);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:andy", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:bob", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:cid", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:dave", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:eoin", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:fred", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:gail", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:hal", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:ian", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:jake", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:kara", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:loon", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:mike", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:noodle", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:ood", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:pig", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|READER:pig", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:pig", 0);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|DENIED:pig", 0);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:something |AUTHORITY:GROUP_EVERYONE", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|READER:something", 0);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|OWNER:something", 0);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|DENIED:something", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"something\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"something\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"andy\" ], \"tenants\": [ \"\" ] }", 1);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"andy\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"andy\", \"bob\", \"cid\", \"something\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"andy\", \"bob\", \"cid\" ], \"tenants\": [ \"\" ] }", 3);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"strange:,-!+=;~/\", \"andy\", \"bob\" ], \"tenants\": [ \"\" ] }", 2);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"strange:,-!+=;~/\", \"andy\", \"something\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"authorities\": [ \"strange:,-!+=;~/\", \"bob\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"anyDenyDenies\":false, \"authorities\": [ \"something\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 16);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"anyDenyDenies\":false, \"authorities\": [ \"andy\", \"bob\", \"cid\", \"something\" ], \"tenants\": [ \"\" ] }", 3);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"anyDenyDenies\":false, \"authorities\": [ \"something\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"anyDenyDenies\":true, \"authorities\": [ \"something\", \"GROUP_EVERYONE\" ], \"tenants\": [ \"\" ] }", 0);
        this.assertAQueryHasNumOfDocsWithJson("PATH:\"//.\"", "{ \"anyDenyDenies\":false, \"authorities\": [ \"strange:,-!+=;~/\", \"andy\", \"bob\", \"cid\", \"something\" ], \"tenants\": [ \"\" ] }", 3);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:andy", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:bob", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:cid", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:dave", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:eoin", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:fred", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:gail", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:hal", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:ian", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:eoin", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:jake", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:kara", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:loon", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:mike", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:noodle", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:ood", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:GROUP_EVERYONE", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHORITY:andy |AUTHORITY:bob |AUTHORITY:cid", 3);
        this.assertResponseCardinality("PATH", "\"//.\"", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":andy\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":bob\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":cid\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":dave\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":eoin\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":fred\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":gail\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":hal\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":ian\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":jake\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":kara\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":loon\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":mike\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":noodle\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":ood\"", 1);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":GROUP_EVERYONE\"", 16);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":andy\" |AUTHSET:\":bob\" |AUTHSET:\":cid\"", 3);
        this.assertResponseCardinality("PATH", "\"//.\"", "{!afts}|AUTHSET:\":andy:bob:cid\"", 3);
    }

    @Test
    public void crossLanguageSupportWithTokenisation() {
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English", "locale", Locale.ENGLISH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English123", "locale", Locale.ENGLISH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French", "locale", Locale.ENGLISH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French123", "locale", Locale.ENGLISH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:123", "locale", Locale.ENGLISH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English", "locale", Locale.FRENCH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English123", "locale", Locale.FRENCH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French", "locale", Locale.FRENCH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French123", "locale", Locale.FRENCH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:123", "locale", Locale.FRENCH.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English", "locale", Locale.GERMAN.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:English123", "locale", Locale.GERMAN.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French", "locale", Locale.GERMAN.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:French123", "locale", Locale.GERMAN.toString()), null), "*[count(//doc)=1]");
        AFTSRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AFTSRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", "title:123", "locale", Locale.GERMAN.toString()), null), "*[count(//doc)=1]");
    }

    @Test
    public void checkAncestor() {
        this.assertResponseCardinality("APATH:0*", 15);
        this.assertResponseCardinality("APATH:0/" + TEST_ROOT_NODEREF.getId(), 15);
        this.assertResponseCardinality("APATH:F/" + TEST_ROOT_NODEREF.getId(), 4);
        this.assertResponseCardinality("APATH:0/" + TEST_ROOT_NODEREF.getId() + "*", 15);
        this.assertResponseCardinality("APATH:0/" + TEST_ROOT_NODEREF.getId() + "/*", 0);
        this.assertResponseCardinality("APATH:1/" + TEST_ROOT_NODEREF.getId() + "/*", 11);
        this.assertResponseCardinality("APATH:2/" + TEST_ROOT_NODEREF.getId() + "/*", 8);
        this.assertResponseCardinality("APATH:3/" + TEST_ROOT_NODEREF.getId() + "/*", 4);
        this.assertResponseCardinality("APATH:4/" + TEST_ROOT_NODEREF.getId() + "/*", 4);
        this.assertResponseCardinality("APATH:5/" + TEST_ROOT_NODEREF.getId() + "/*", 1);
        this.assertResponseCardinality("APATH:6/" + TEST_ROOT_NODEREF.getId() + "/*", 0);
        this.assertResponseCardinality("APATH:1/" + TEST_ROOT_NODEREF.getId() + "/" + DATASETS_PROVIDER.getNode01().getId(), 9);
        this.assertResponseCardinality("APATH:1/" + TEST_ROOT_NODEREF.getId() + "/" + DATASETS_PROVIDER.getNode01().getId(), 9);
        this.assertResponseCardinality("ANAME:0/" + TEST_ROOT_NODEREF.getId(), 4);
        this.assertResponseCardinality("ANAME:F/" + TEST_ROOT_NODEREF.getId(), 4);
        this.assertResponseCardinality("ANAME:1/" + TEST_ROOT_NODEREF.getId() + "/*", 5);
        this.assertResponseCardinality("ANAME:2/" + TEST_ROOT_NODEREF.getId() + "/*", 4);
        this.assertResponseCardinality("ANAME:3/" + TEST_ROOT_NODEREF.getId() + "/*", 1);
        this.assertResponseCardinality("ANAME:4/" + TEST_ROOT_NODEREF.getId() + "/*", 3);
        this.assertResponseCardinality("ANAME:5/" + TEST_ROOT_NODEREF.getId() + "/*", 1);
        this.assertResponseCardinality("ANAME:5/" + TEST_ROOT_NODEREF.getId() + "/*", 1);
        this.assertResponseCardinality("ANAME:6/" + TEST_ROOT_NODEREF.getId() + "/*", 0);
        this.assertResponseCardinality("ANAME:0/" + DATASETS_PROVIDER.getNode01().getId(), 2);
        this.assertResponseCardinality("ANAME:0/" + DATASETS_PROVIDER.getNode02().getId(), 3);
        this.assertResponseCardinality("ANAME:0/" + DATASETS_PROVIDER.getNode03().getId(), 0);
        this.assertResponseCardinality("ANAME:1/" + TEST_ROOT_NODEREF.getId() + "/" + DATASETS_PROVIDER.getNode01().getId(), 2);
    }
}

