/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.requestHandler.AbstractRequestHandlerIT;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AFTSDefaultTextQueryIT
extends AbstractRequestHandlerIT {
    private HashSet<QName> oldCrossLocaleProperties;
    private HashSet<QName> oldCrossLocaleTypes;
    static TestDataProvider dataProvider;

    @BeforeClass
    public static void beforeClass() throws Exception {
        dataProvider = new TestDataProvider(h);
        List<Map> data = Arrays.asList(ImmutableMap.of((Object)"name", (Object)"test1", (Object)"description", (Object)"description of test 1", (Object)"content", (Object)"test", (Object)"title", (Object)"TITLE1", (Object)"creator", (Object)"Luca"), ImmutableMap.of((Object)"name", (Object)"test2", (Object)"description", (Object)"description 2", (Object)"content", (Object)"content of test 2", (Object)"title", (Object)"Other Title", (Object)"creator", (Object)"Mario"), ImmutableMap.of((Object)"name", (Object)"file3", (Object)"description", (Object)"this is not a description of test 1 and 2", (Object)"content", (Object)"other content here ", (Object)"title", (Object)"Third", (Object)"creator", (Object)"Giovanni"), ImmutableMap.of((Object)"name", (Object)"name of record 4", (Object)"description", (Object)"other description right here", (Object)"content", (Object)"content of file number 4", (Object)"title", (Object)"Forth", (Object)"creator", (Object)"Giuseppe"));
        TEST_ROOT_NODEREF = dataProvider.getRootNode();
        IntStream.range(0, data.size()).forEach(dbId -> {
            Map record = (Map)data.get(dbId);
            String name = (String)record.get("name");
            String description = (String)record.get("description");
            String content = (String)record.get("content");
            String title = (String)record.get("title");
            String creator = (String)record.get("creator");
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue(name));
            properties.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)new MLTextPropertyValue(Map.of(Locale.getDefault(), description)));
            properties.put(ContentModel.PROP_TITLE, (PropertyValue)new MLTextPropertyValue(Map.of(Locale.getDefault(), title)));
            properties.put(ContentModel.PROP_CREATOR, (PropertyValue)new StringPropertyValue(creator));
            Map<QName, String> contents = Map.of(ContentModel.PROP_CONTENT, content);
            AlfrescoSolrUtils.addNode(AFTSDefaultTextQueryIT.getCore(), dataModel, 1, dbId, 1, ContentModel.TYPE_CONTENT, null, properties, contents, "the_owner_of_this_node_is" + name, null, new NodeRef[]{TEST_ROOT_NODEREF}, new String[]{"/" + String.valueOf(dataProvider.qName("a_qname_for_node_" + name))}, dataProvider.newNodeRef(), true);
        });
    }

    private void prepareExactSearchData() throws Exception {
        TestDataProvider dataProvider = AFTSDefaultTextQueryIT.dataProvider;
        List<Map> exactSearchData = Arrays.asList(ImmutableMap.of((Object)"name", (Object)"Running", (Object)"description", (Object)"Running is a sport is a nice activity", (Object)"content", (Object)"when you are running you are doing an amazing sport", (Object)"title", (Object)"Running jumping", (Object)"creator", (Object)"Alex"), ImmutableMap.of((Object)"name", (Object)"Run", (Object)"description", (Object)"you are supposed to run jump", (Object)"content", (Object)"after many runs you are tired and if you jump it happens the same", (Object)"title", (Object)"Run : a philosophy", (Object)"creator", (Object)"Alex"), ImmutableMap.of((Object)"name", (Object)"Poetry", (Object)"description", (Object)"a document about poetry and jumpers", (Object)"content", (Object)"poetry is unrelated to sport", (Object)"title", (Object)"Running jumping twice jumpers", (Object)"creator", (Object)"Alex"), ImmutableMap.of((Object)"name", (Object)"Jump", (Object)"description", (Object)"a document about jumps", (Object)"content", (Object)"runnings jumpings", (Object)"title", (Object)"Running", (Object)"creator", (Object)"Alex"), ImmutableMap.of((Object)"name", (Object)"Running jumping", (Object)"description", (Object)"runners jumpers runs everywhere", (Object)"content", (Object)"run is Good as jump", (Object)"title", (Object)"Running the art of jumping", (Object)"creator", (Object)"Alex"));
        IntStream.range(0, exactSearchData.size()).forEach(dbId -> {
            Map record = (Map)exactSearchData.get(dbId);
            String name = (String)record.get("name");
            String description = (String)record.get("description");
            String content = (String)record.get("content");
            String title = (String)record.get("title");
            String creator = (String)record.get("creator");
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue(name));
            properties.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)new MLTextPropertyValue(Map.of(Locale.getDefault(), description)));
            properties.put(ContentModel.PROP_TITLE, (PropertyValue)new MLTextPropertyValue(Map.of(Locale.getDefault(), title)));
            properties.put(ContentModel.PROP_CREATOR, (PropertyValue)new StringPropertyValue(creator));
            properties.put(ContentModel.PROP_RATING_SCHEME, (PropertyValue)new StringPropertyValue(title));
            Map<QName, String> contents = Map.of(ContentModel.PROP_CONTENT, content);
            AlfrescoSolrUtils.addNode(AFTSDefaultTextQueryIT.getCore(), dataModel, 2, dbId + 10, 1, ContentModel.TYPE_CONTENT, null, properties, contents, "the_owner_of_this_node_is" + name, null, new NodeRef[]{TEST_ROOT_NODEREF}, new String[]{"/" + String.valueOf(dataProvider.qName("a_qname_for_node_" + name))}, dataProvider.newNodeRef(), true);
        });
    }

    private void changeCrossLocaleEnabledFields() throws NoSuchFieldException, IllegalAccessException {
        Field crossLocalePropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchProperties");
        crossLocalePropertiesField.setAccessible(true);
        Field crossLocaleTypesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchDataTypes");
        crossLocaleTypesField.setAccessible(true);
        HashSet crossLocaleProperties = (HashSet)crossLocalePropertiesField.get(AlfrescoSolrDataModel.getInstance());
        HashSet crossLocaleTypes = (HashSet)crossLocaleTypesField.get(AlfrescoSolrDataModel.getInstance());
        this.oldCrossLocaleTypes = (HashSet)crossLocaleTypes.clone();
        this.oldCrossLocaleProperties = (HashSet)crossLocaleProperties.clone();
        crossLocaleTypes.clear();
        crossLocaleProperties.clear();
        crossLocaleProperties.add(ContentModel.PROP_TITLE);
    }

    @After
    public void restoreAlfrescoSolrDataModel() throws NoSuchFieldException, IllegalAccessException {
        if (this.oldCrossLocaleTypes != null) {
            Field crossLocaleTypesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchDataTypes");
            crossLocaleTypesField.setAccessible(true);
            crossLocaleTypesField.set(AlfrescoSolrDataModel.getInstance(), this.oldCrossLocaleTypes);
        }
        if (this.oldCrossLocaleProperties != null) {
            Field crossLocalePropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchProperties");
            crossLocalePropertiesField.setAccessible(true);
            crossLocalePropertiesField.set(AlfrescoSolrDataModel.getInstance(), this.oldCrossLocaleProperties);
        }
    }

    @Test
    public void exactSearch_singleTerm_shouldReturnResultsContainingExactTerm() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=run", 2);
        this.assertResponseCardinality("=runner", 0);
        this.assertResponseCardinality("runner", 1);
        this.assertResponseCardinality("=running", 4);
    }

    @Test
    public void exactSearch_singleTermInFieldWithNoCrossLocaleEnabled_shouldReturnException() throws Exception {
        this.changeCrossLocaleEnabledFields();
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_title:run", 1);
        this.assertResponseException("=content:run", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}content> for cross locale search");
        this.assertResponseException("=cm_description:run", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}description> for cross locale search");
        this.assertResponseCardinality("=run", 1);
        this.restoreAlfrescoSolrDataModel();
    }

    @Test
    public void exactSearch_singleTermInFieldWithOnlyUnTokenizedAnalysis_shouldReturnFullFieldValueMatch() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_ratingScheme:running", 0);
        this.assertResponseCardinality("=cm_title:running", 4);
        this.assertResponseCardinality("=cm_ratingScheme:Running", 1);
        this.assertResponseCardinality("=cm_title:Running", 4);
        this.assertResponseCardinality("=cm_ratingScheme:Run", 0);
        this.assertResponseCardinality("=cm_title:Run", 1);
    }

    @Test
    public void exactSearch_multiTerm_shouldReturnResultsContainingExactTerm() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=run =jump", 3);
        this.assertResponseCardinality("=runner =jumper", 0);
        this.assertResponseCardinality("runner jumper", 2);
        this.assertResponseCardinality("=running =jumping", 4);
    }

    @Test
    public void exactSearch_multiTermInFieldWithNoCrossLocaleEnabled_shouldReturnException() throws Exception {
        this.changeCrossLocaleEnabledFields();
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_title:run =cm_title:jump", 1);
        this.assertResponseException("=content:run =content:jump", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}content> for cross locale search");
        this.assertResponseException("=cm_description:run =cm_description:jump", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}description> for cross locale search");
        this.assertResponseCardinality("=run =jump", 1);
        this.restoreAlfrescoSolrDataModel();
    }

    @Test
    public void exactSearch_multiTermInFieldWithOnlyUnTokenizedAnalysis_shouldReturnFullFieldValueMatch() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_ratingScheme:running =cm_ratingScheme:jumpers", 0);
        this.assertResponseCardinality("=cm_title:running =cm_title:jumpers", 4);
    }

    @Test
    public void exactSearch_exactPhrase_shouldReturnResultsContainingExactPhrase() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=\"run jump\"", 1);
        this.assertResponseCardinality("=\"runner jumper\"", 0);
        this.assertResponseCardinality("\"runner jumper\"", 1);
        this.assertResponseCardinality("=\"running jumping\"", 3);
        this.assertResponseCardinality("\"running jumping\"", 5);
    }

    @Test
    public void exactSearch_phraseInFieldWithNoCrossLocaleEnabled_shouldReturnException() throws Exception {
        this.changeCrossLocaleEnabledFields();
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_title:\"running jumping\"", 2);
        this.assertResponseException("=content:\"running jumping\"", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}content> for cross locale search");
        this.assertResponseException("=cm_description:\"running jumping\"", "Exact Term search is not supported unless you configure the field <{http://www.alfresco.org/model/content/1.0}description> for cross locale search");
        this.assertResponseCardinality("=\"running jumping\"", 2);
        this.restoreAlfrescoSolrDataModel();
    }

    @Test
    public void exactSearch_phraseInFieldWithOnlyUnTokenizedAnalysis_shouldReturnFullFieldValueMatch() throws Exception {
        this.prepareExactSearchData();
        this.assertResponseCardinality("=cm_ratingScheme:\"running jumping\"", 0);
        this.assertResponseCardinality("=cm_title:\"running jumping\"", 2);
        this.assertResponseCardinality("=cm_ratingScheme:\"Running jumping\"", 1);
        this.assertResponseCardinality("=cm_title:\"Running jumping\"", 2);
        this.assertResponseCardinality("=cm_ratingScheme:\"Running jumping twice\"", 0);
        this.assertResponseCardinality("=cm_title:\"Running jumping twice\"", 1);
    }

    @Test
    public void defaultRangeQueryTest() {
        this.assertResponseCardinality("[te to test]", 3);
        this.assertResponseCardinality("[other to otherz]", 3);
    }

    @Test
    public void defaultWildCardQueryTest() {
        this.assertResponseCardinality("?est", 3);
        this.assertResponseCardinality("?ther", 3);
    }

    @Test
    public void defaultSpanQueryTest() {
        this.assertResponseCardinality("Other *(0) title", 1);
        this.assertResponseCardinality("description *(1) test ", 2);
        this.assertResponseCardinality("description *(0) test ", 0);
        this.assertResponseCardinality("name *(1) record ", 1);
        this.assertResponseCardinality("other *(1) here ", 1);
    }

    @Test
    public void defaultPrefixQueryTest() {
        this.assertResponseCardinality("te*", 3);
        this.assertResponseCardinality("fil*", 2);
        this.assertResponseCardinality("oth*", 3);
    }
}

