/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class CMISDataCreatorTest
extends TestCase {
    private static Session getSession(String user, String pwd) {
        String url = "http://localhost:8080/alfresco/api/-default-/public/cmis/versions/1.1/atom";
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.user", user);
        parameter.put("org.apache.chemistry.opencmis.password", pwd);
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        List repositories = factory.getRepositories(parameter);
        Session session = ((Repository)repositories.get(0)).createSession();
        return session;
    }

    private String getRootFolderName() {
        return "CMIS-Data-Creator-Test-" + System.currentTimeMillis();
    }

    private String getUniqueName() {
        return "CMIS-Data-Creator-Test-" + GUID.generate();
    }

    public void testCreate() {
        Session session = CMISDataCreatorTest.getSession("admin", "admin");
        String folderName = this.getRootFolderName();
        Folder root = session.getRootFolder();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", folderName);
        Folder newFolder = root.createFolder(properties);
        for (int i = 0; i < 50; ++i) {
            AccessControlPrincipalDataImpl principal = new AccessControlPrincipalDataImpl("user" + i);
            ArrayList<String> permissions = new ArrayList<String>(1);
            permissions.add("cmis:read");
            ArrayList<AccessControlEntryImpl> addAces = new ArrayList<AccessControlEntryImpl>(1);
            addAces.add(new AccessControlEntryImpl((Principal)principal, permissions));
            newFolder.addAcl(addAces, AclPropagation.PROPAGATE);
            HashMap<String, CallSite> updateProperties = new HashMap<String, CallSite>();
            updateProperties.put("cm:title", (CallSite)((Object)("Update title " + i)));
            newFolder.updateProperties(properties);
            if (i % 10 != 0) continue;
            System.out.println("@ " + i);
        }
        ItemIterable result = session.query("select * from cmis:folder", false);
        CMISDataCreatorTest.assertTrue((result.getTotalNumItems() > 0L ? 1 : 0) != 0);
        result = session.query("select * from cmis:folder where cmis:name = '" + folderName + "'", false);
        CMISDataCreatorTest.assertTrue((result.getTotalNumItems() > 0L ? 1 : 0) != 0);
    }

    public void testCreateLots() throws Exception {
        ItemIterable result;
        Session session = CMISDataCreatorTest.getSession("admin", "admin");
        Folder root = session.getRootFolder();
        String folderNameBase = this.getRootFolderName();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", folderNameBase);
        Folder base = root.createFolder(properties);
        for (int i = 0; i < 10; ++i) {
            AccessControlPrincipalDataImpl principal = new AccessControlPrincipalDataImpl("" + i + i + i);
            ArrayList<String> permissions = new ArrayList<String>(1);
            permissions.add("cmis:all");
            ArrayList<AccessControlEntryImpl> addAces = new ArrayList<AccessControlEntryImpl>(1);
            addAces.add(new AccessControlEntryImpl((Principal)principal, permissions));
            base.addAcl(addAces, AclPropagation.PROPAGATE);
        }
        Thread last = null;
        for (int i = 0; i < 10; ++i) {
            Creator creator = new Creator(base.getPath(), i);
            Thread thread = new Thread(creator);
            thread.start();
            last = thread;
        }
        if (last != null) {
            last.join();
        }
        CMISDataCreatorTest.assertTrue(((result = session.query("select * from cmis:folder", false)).getTotalNumItems() > 0L ? 1 : 0) != 0);
    }

    public void testQueryFolderProperties() {
        Session session = CMISDataCreatorTest.getSession("admin", "admin");
        String folderName = this.getRootFolderName();
        Folder root = session.getRootFolder();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", folderName);
        Folder newFolder = root.createFolder(properties);
        ItemIterable result = session.query("select * from cmis:folder where cmis:name = '" + folderName + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        String uniqueName = this.getUniqueName();
        HashMap<String, String> uProperties = new HashMap<String, String>();
        uProperties.put("cmis:objectTypeId", "cmis:folder");
        uProperties.put("cmis:name", uniqueName);
        Folder uniqueFolder = newFolder.createFolder(uProperties);
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND IN_FOLDER('" + uniqueFolder.getParentId() + "')", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where IN_FOLDER('" + uniqueFolder.getParentId() + "')", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:createdBy = '" + uniqueFolder.getCreatedBy() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:objectId = '" + uniqueFolder.getId() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:lastModifiedBy = '" + uniqueFolder.getLastModifiedBy() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueFolder.getName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        String creationDate = ISO8601DateFormat.format((Date)uniqueFolder.getCreationDate().getTime());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:creationDate = '" + creationDate + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        String modificationDate = ISO8601DateFormat.format((Date)uniqueFolder.getLastModificationDate().getTime());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:lastModificationDate = '" + modificationDate + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:objectTypeId = '" + uniqueFolder.getType().getQueryName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:folder where cmis:name = '" + uniqueName + "' AND cmis:baseTypeId = '" + uniqueFolder.getBaseType().getQueryName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
    }

    public void testQueryDocumentProperties() throws Exception {
        Session session = CMISDataCreatorTest.getSession("admin", "admin");
        String folderName = this.getRootFolderName();
        Folder root = session.getRootFolder();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", folderName);
        Folder newFolder = root.createFolder(properties);
        ItemIterable result = session.query("select * from cmis:folder where cmis:name = '" + folderName + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        Document uniqueDocument = this.createUniqueDocument(newFolder);
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND IN_FOLDER('" + newFolder.getId() + "')", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where IN_FOLDER('" + newFolder.getId() + "')", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:createdBy = '" + uniqueDocument.getCreatedBy() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:objectId = '" + uniqueDocument.getId() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:lastModifiedBy = '" + uniqueDocument.getLastModifiedBy() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        String creationDate = ISO8601DateFormat.format((Date)uniqueDocument.getCreationDate().getTime());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:creationDate = '" + creationDate + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        String modificationDate = ISO8601DateFormat.format((Date)uniqueDocument.getLastModificationDate().getTime());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:lastModificationDate = '" + modificationDate + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:objectTypeId = '" + uniqueDocument.getType().getQueryName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:baseTypeId = '" + uniqueDocument.getBaseType().getQueryName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:contentStreamFileName = '" + uniqueDocument.getContentStreamFileName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:contentStreamLength = '" + uniqueDocument.getContentStreamLength() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + uniqueDocument.getName() + "' AND cmis:contentStreamMimeType = '" + uniqueDocument.getContentStreamMimeType() + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
    }

    public void testQueryForMultipleDocumentProperties() throws Exception {
        Session session = CMISDataCreatorTest.getSession("admin", "admin");
        String folderName = this.getRootFolderName();
        Folder root = session.getRootFolder();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", folderName);
        Folder newFolder = root.createFolder(properties);
        ItemIterable result = session.query("select * from cmis:folder where cmis:name = '" + folderName + "'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        Document document1 = this.createUniqueDocument(newFolder);
        Document document2 = this.createUniqueDocument(newFolder);
        result = session.query("SELECT * FROM cmis:document d join exif:exif t on  d.cmis:objectId = t.cmis:objectId", false);
        long count = result.getTotalNumItems();
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("exif:focalLength", Double.valueOf(10.33));
        ArrayList<String> aspects = new ArrayList<String>();
        aspects.add("P:exif:exif");
        props.put("cmis:secondaryObjectTypeIds", aspects);
        document1.updateProperties(props);
        result = session.query("SELECT * FROM cmis:document d join exif:exif t on  d.cmis:objectId = t.cmis:objectId", false);
        CMISDataCreatorTest.assertEquals((long)(count + 1L), (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + document1.getName() + "' OR  cmis:name = '" + document2.getName() + "'", false);
        CMISDataCreatorTest.assertEquals((long)2L, (long)result.getTotalNumItems());
        result = session.query("select * from cmis:document where cmis:name = '" + document1.getName() + "' AND cmis:contentStreamLength = 5 AND cmis:contentStreamMimeType = 'text/plain'", false);
        CMISDataCreatorTest.assertEquals((long)1L, (long)result.getTotalNumItems());
        result = session.query("SELECT * FROM cmis:document", false);
        long docCount = result.getTotalNumItems();
        result = session.query("SELECT * FROM cmis:document d left outer join exif:exif t on  d.cmis:objectId = t.cmis:objectId", false);
        CMISDataCreatorTest.assertEquals((long)docCount, (long)result.getTotalNumItems());
    }

    private Document createUniqueDocument(Folder newFolder) throws UnsupportedEncodingException {
        String uniqueName = this.getUniqueName();
        HashMap<String, String> uProperties = new HashMap<String, String>();
        uProperties.put("cmis:objectTypeId", "cmis:document");
        uProperties.put("cmis:name", uniqueName);
        ContentStreamImpl contentStream = new ContentStreamImpl();
        contentStream.setFileName("bob");
        String shortString = "short";
        contentStream.setStream((InputStream)new ByteArrayInputStream(shortString.getBytes("UTF-8")));
        contentStream.setLength(new BigInteger("5"));
        contentStream.setMimeType("text/plain");
        Document uniqueDocument = newFolder.createDocument(uProperties, (ContentStream)contentStream, VersioningState.MAJOR);
        return uniqueDocument;
    }

    private static class Creator
    implements Runnable {
        int id;
        String path;

        Creator(String path, int id) {
            this.path = path;
            this.id = id;
        }

        @Override
        public void run() {
            Session session = CMISDataCreatorTest.getSession("" + this.id + this.id + this.id, "" + this.id + this.id + this.id);
            CmisObject object = session.getObjectByPath(this.path);
            HashMap<String, Object> baseProps = new HashMap<String, Object>();
            baseProps.put("cmis:objectTypeId", "cmis:folder");
            baseProps.put("cmis:name", "Thread" + this.id);
            ObjectId base = session.createFolder(baseProps, (ObjectId)object);
            for (int i = 0; i < 100; ++i) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("cmis:objectTypeId", "cmis:folder");
                properties.put("cmis:name", "Folder-" + i);
                ObjectId folder = session.createFolder(properties, base);
                System.out.println("Thread " + this.id + "   @Folder " + i);
                for (int j = 0; j < 1000; ++j) {
                    HashMap<String, Object> folderProps = new HashMap<String, Object>();
                    folderProps.put("cmis:objectTypeId", "cmis:folder");
                    folderProps.put("cmis:name", "Folder-" + i);
                    ObjectId child = session.createFolder(folderProps, folder);
                    if (j % 20 != 0) continue;
                    System.out.println(this.id + "    @ " + j);
                }
            }
        }
    }
}

