/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.PropertyRouter;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AlfrescoCoreAdminHandlerIT {
    private static final String TXREPORT = "TXREPORT";
    private static final String TX_ID = "123";
    private static final String CORE_NAME = "CORE_NAME";
    @InjectMocks
    private AlfrescoCoreAdminHandler alfrescoCoreAdminHandler;
    @Mock
    private TrackerRegistry trackerRegistry;
    @Mock
    private AclTracker aclTracker;
    @Mock
    private MetadataTracker metadataTracker;
    @Mock
    private IndexHealthReport indexHealthReport;
    @Mock
    private IndexHealthReport metaReport;
    @Mock
    private IOpenBitSet iOpenBitSet;
    @Mock
    private TrackerState trackerState;
    @Mock
    private InformationServer informationServer;
    @Mock
    private SolrQueryRequest req;
    @Mock
    private SolrQueryResponse rsp;
    @Mock
    private SolrParams params;

    @Before
    public void setUp() {
        this.alfrescoCoreAdminHandler.setTrackerRegistry(this.trackerRegistry);
        this.alfrescoCoreAdminHandler.getInformationServers().put(CORE_NAME, this.informationServer);
        Mockito.when((Object)this.req.getParams()).thenReturn((Object)this.params);
    }

    @Test
    public void extractShardsWithEmptyParameter_shouldReturnAnEmptyList() {
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.extractShards("", Integer.MAX_VALUE).isEmpty());
    }

    @Test
    public void extractShardsWithNullParameter_shouldReturnAnEmptyList() {
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.extractShards(null, Integer.MAX_VALUE).isEmpty());
    }

    @Test
    public void extractShardsWithOneInvalidShard_shouldReturnAnEmptyList() {
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.extractShards("This is an invalid shard id", Integer.MAX_VALUE).isEmpty());
    }

    @Test
    public void extractShardsWithOneShards_shouldReturnSingletonList() {
        Assert.assertEquals(Collections.singletonList(1), (Object)this.alfrescoCoreAdminHandler.extractShards("1", Integer.MAX_VALUE));
    }

    @Test
    public void extractShardsWithSeveralValidShards_shouldReturnAllOfThemInTheList() {
        Assert.assertEquals(Arrays.asList(1, 5, 6, 11, 23), (Object)this.alfrescoCoreAdminHandler.extractShards("1,5,6,11,23", Integer.MAX_VALUE));
    }

    @Test
    public void extractShardsWithSeveralValidShards_shouldReturnOnlyValidIdentifiers() {
        Assert.assertEquals(Arrays.asList(1, 5, 6, 11, 23), (Object)this.alfrescoCoreAdminHandler.extractShards("1,5,A,6,xyz,11,BB,23,o01z", Integer.MAX_VALUE));
    }

    @Test
    public void extractShardsWithSeveralValidShardsAndLimit_shouldConsiderOnlyShardsLesserThanLimit() {
        Assert.assertEquals(Arrays.asList(1, 5, 6, 11, 12), (Object)this.alfrescoCoreAdminHandler.extractShards("1,5,6,11,23,25,99,223,12", 23));
    }

    @Test
    public void hasAlfrescoCoreWhenInputIsNull_shouldReturnFalse() {
        Assert.assertFalse((boolean)this.alfrescoCoreAdminHandler.hasAlfrescoCore(null));
    }

    @Test
    public void hasAlfrescoCoreWhenWeHaveNoCore_shouldReturnFalse() {
        Assert.assertFalse((boolean)this.alfrescoCoreAdminHandler.hasAlfrescoCore(Collections.emptyList()));
    }

    @Test
    public void hasAlfrescoCoreWhenDoesntHaveAnyTracker_shouldReturnFalse() {
        Assert.assertFalse((boolean)this.alfrescoCoreAdminHandler.hasAlfrescoCore(Collections.emptyList()));
    }

    @Test
    public void hasAlfrescoCoreWithRegisteredTrackers_shouldReturnTrue() {
        Mockito.when((Object)this.trackerRegistry.hasTrackersForCore("CoreD")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.hasAlfrescoCore(Arrays.asList(this.dummyCore("CoreA"), this.dummyCore("CoreB"), this.dummyCore("CoreC"), this.dummyCore("CoreD"))));
    }

    @Test
    public void trackerRegistryHasNoCoreNames_itShouldReturnAnEmptyList() {
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.coreNames().isEmpty());
    }

    @Test
    public void coreDetectedAsMasterOrStandalone() {
        MetadataTracker coreStatePublisher = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        Mockito.when((Object)((MetadataTracker)this.trackerRegistry.getTrackerForCore(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(MetadataTracker.class)))).thenReturn((Object)coreStatePublisher);
        Assert.assertTrue((boolean)this.alfrescoCoreAdminHandler.isMasterOrStandalone("ThisIsTheCoreName"));
    }

    @Test
    public void coreDetectedAsSlave() {
        Mockito.when((Object)((MetadataTracker)this.trackerRegistry.getTrackerForCore(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(MetadataTracker.class)))).thenReturn(null);
        Assert.assertFalse((boolean)this.alfrescoCoreAdminHandler.isMasterOrStandalone("ThisIsTheCoreName"));
    }

    @Test
    public void coreIsMaster_thenCoreStatePublisherInstanceCorrespondsToShardStatePublisher() {
        ShardStatePublisher coreStatePublisher = (ShardStatePublisher)Mockito.mock(ShardStatePublisher.class);
        Mockito.when((Object)((ShardStatePublisher)this.trackerRegistry.getTrackerForCore(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(ShardStatePublisher.class)))).thenReturn((Object)coreStatePublisher);
        Assert.assertSame((Object)coreStatePublisher, (Object)this.alfrescoCoreAdminHandler.nodeStatusChecker("ThisIsTheCoreName"));
    }

    @Test
    public void coreIsSlave_thenCoreStatePublisherInstanceCorrespondsToShardStatePublisher() {
        ShardStatePublisher coreStateTracker = (ShardStatePublisher)Mockito.mock(ShardStatePublisher.class);
        Mockito.when((Object)((ShardStatePublisher)this.trackerRegistry.getTrackerForCore(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(ShardStatePublisher.class)))).thenReturn((Object)coreStateTracker);
        Assert.assertSame((Object)coreStateTracker, (Object)this.alfrescoCoreAdminHandler.nodeStatusChecker("ThisIsTheCoreName"));
    }

    @Test
    public void coreIsSlave_thenDocRouterIsNull() {
        String coreName = "aCore";
        Mockito.when((Object)((MetadataTracker)this.trackerRegistry.getTrackerForCore((String)ArgumentMatchers.eq((Object)coreName), (Class)ArgumentMatchers.eq(MetadataTracker.class)))).thenReturn(null);
        Assert.assertNull((Object)this.alfrescoCoreAdminHandler.getDocRouter("aCore"));
    }

    @Test
    public void coreIsMaster_thenDocRouterIsProperlyReturned() {
        PropertyRouter expectedRouter = new PropertyRouter("someProperty_.{1,35}");
        MetadataTracker coreStatePublisher = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        Mockito.when((Object)coreStatePublisher.getDocRouter()).thenReturn((Object)expectedRouter);
        Mockito.when((Object)((MetadataTracker)this.trackerRegistry.getTrackerForCore(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(MetadataTracker.class)))).thenReturn((Object)coreStatePublisher);
        Assert.assertSame((Object)expectedRouter, (Object)this.alfrescoCoreAdminHandler.getDocRouter("aCore"));
    }

    @Test
    public void targetCoreNameCanBeSpecifiedInSeveralWays() {
        String coreName = "ThisIsTheCoreName";
        ModifiableSolrParams params = new ModifiableSolrParams();
        Assert.assertNull((Object)this.alfrescoCoreAdminHandler.coreName((SolrParams)params));
        params.set("core", new String[]{coreName});
        Assert.assertEquals((Object)coreName, (Object)this.alfrescoCoreAdminHandler.coreName((SolrParams)params));
        params.remove("core");
        Assert.assertNull((Object)this.alfrescoCoreAdminHandler.coreName((SolrParams)params));
        params.set("coreName", new String[]{coreName});
        Assert.assertEquals((Object)coreName, (Object)this.alfrescoCoreAdminHandler.coreName((SolrParams)params));
        Assert.assertEquals((Object)coreName, (Object)this.alfrescoCoreAdminHandler.coreName((SolrParams)params));
    }

    private SolrCore dummyCore(String name) {
        SolrCore core = (SolrCore)Mockito.mock(SolrCore.class);
        Mockito.when((Object)core.getName()).thenReturn((Object)name);
        return core;
    }

    @Test
    public void handleCustomActionTXReportSuccess() throws Exception {
        Mockito.when((Object)this.params.get("action")).thenReturn((Object)TXREPORT);
        Mockito.when((Object)this.params.get("core")).thenReturn((Object)CORE_NAME);
        Mockito.when((Object)this.params.get("txid")).thenReturn((Object)TX_ID);
        this.alfrescoCoreAdminHandler.handleCustomAction(this.req, this.rsp);
        ((SolrQueryResponse)Mockito.verify((Object)this.rsp)).add((String)ArgumentMatchers.eq((Object)"report"), ArgumentMatchers.any(NamedList.class));
    }

    @Test
    public void handleCustomActionTXReportMissingTXId() {
        Mockito.when((Object)this.params.get("action")).thenReturn((Object)TXREPORT);
        this.alfrescoCoreAdminHandler.handleCustomAction(this.req, this.rsp);
        ((SolrQueryResponse)Mockito.verify((Object)this.rsp)).add((String)ArgumentMatchers.eq((Object)"report"), ArgumentMatchers.any(NamedList.class));
    }

    @Test
    public void handleCustomActionTXReportMissingCoreName() {
        Mockito.when((Object)this.params.get("action")).thenReturn((Object)TXREPORT);
        Mockito.when((Object)this.params.get("core")).thenReturn(null);
        this.alfrescoCoreAdminHandler.handleCustomAction(this.req, this.rsp);
        ((SolrQueryResponse)Mockito.verify((Object)this.rsp)).add((String)ArgumentMatchers.eq((Object)"report"), ArgumentMatchers.any(NamedList.class));
    }

    @Test(expected=SolrException.class)
    public void handleCustomActionUnknownAction() {
        Mockito.when((Object)this.params.get("action")).thenReturn((Object)"Unknown");
        this.alfrescoCoreAdminHandler.handleCustomAction(this.req, this.rsp);
        ((SolrQueryResponse)Mockito.verify((Object)this.rsp, (VerificationMode)Mockito.never())).add(ArgumentMatchers.anyString(), ArgumentMatchers.any());
    }

    @Test(expected=SolrException.class)
    public void handleCustomActionMissingAction() {
        Mockito.when((Object)this.params.get("action")).thenReturn(null);
        this.alfrescoCoreAdminHandler.handleCustomAction(this.req, this.rsp);
        ((SolrQueryResponse)Mockito.verify((Object)this.rsp, (VerificationMode)Mockito.never())).add(ArgumentMatchers.anyString(), ArgumentMatchers.any());
    }

    @Test
    public void invalidCoreNameInRequest() {
        AlfrescoCoreAdminHandler spy = (AlfrescoCoreAdminHandler)Mockito.spy((Object)this.alfrescoCoreAdminHandler);
        List<String> invalidNames = AlfrescoCoreAdminHandler.STORE_REF_MAP.keySet().stream().map(coreName -> coreName + System.currentTimeMillis()).collect(Collectors.toList());
        invalidNames.forEach(arg_0 -> ((AlfrescoCoreAdminHandler)spy).setupNewDefaultCores(arg_0));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).newCore((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (String)ArgumentMatchers.any(), (Properties)ArgumentMatchers.any());
        Mockito.reset((Object[])new AlfrescoCoreAdminHandler[]{spy});
        String commaSeparatedNames = String.join((CharSequence)",", invalidNames);
        spy.setupNewDefaultCores(commaSeparatedNames);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).newCore((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (String)ArgumentMatchers.any(), (Properties)ArgumentMatchers.any());
    }

    @Test
    public void coreNamesAreTrimmed_oneCoreNameAtTime() {
        AlfrescoCoreAdminHandler spy = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler(){

            protected NamedList<Object> newCore(String coreName, int numShards, StoreRef storeRef, String templateName, int replicationFactor, int nodeInstance, int numNodes, String shardIds, Properties extraProperties) {
                return new SimpleOrderedMap();
            }
        });
        List<String> coreNames = Arrays.asList("archive  ", "\t alfresco", "   version  \t", "   \t");
        coreNames.forEach(arg_0 -> ((AlfrescoCoreAdminHandler)spy).setupNewDefaultCores(arg_0));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"archive"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("archive"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"alfresco"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("alfresco"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"version"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("version"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
    }

    @Test
    public void validAndInvalidCoreNames() {
        AlfrescoCoreAdminHandler spy = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler(){

            protected NamedList<Object> newCore(String coreName, int numShards, StoreRef storeRef, String templateName, int replicationFactor, int nodeInstance, int numNodes, String shardIds, Properties extraProperties) {
                return new SimpleOrderedMap();
            }
        });
        List<String> coreNames = Arrays.asList("archive  ", "\t alfresco", "   version  \t", "   \t");
        String commaSeparatedNames = String.join((CharSequence)",", coreNames);
        spy.setupNewDefaultCores(commaSeparatedNames);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"archive"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("archive"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"alfresco"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("alfresco"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)spy)).newCore((String)ArgumentMatchers.eq((Object)"version"), ArgumentMatchers.eq((int)1), (StoreRef)ArgumentMatchers.eq((Object)((StoreRef)AlfrescoCoreAdminHandler.STORE_REF_MAP.get("version"))), ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq(null), (Properties)ArgumentMatchers.eq(null));
    }
}

