/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static <T> Collection<T> notNullOrEmpty(Collection<T> values) {
        return values != null ? values : Collections.emptyList();
    }

    public static <T> List<T> notNullOrEmpty(List<T> values) {
        return values != null ? values : Collections.emptyList();
    }

    public static <T> T[] notNullOrEmpty(T[] values) {
        return values != null ? values : Collections.emptyList().toArray(values);
    }

    public static Integer toIntOrNull(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static void silentyClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException ignore) {
            LOGGER.warn("Unable to properly close the resource instance {}. See the stacktrace below for further details.", (Object)resource, (Object)ignore);
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotNullAndNotEmpty(String value) {
        return value != null && value.trim().length() != 0;
    }

    public static boolean startsWithLanguageMarker(String value) {
        return Optional.ofNullable(value).map(v -> v.charAt(0) == '\u0000').orElse(false);
    }

    public static Double doubleOrNull(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            LOGGER.error("Input string >{}< cannot be converted in a valid double ", (Object)value);
            return null;
        }
    }
}

