/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;

public class DocRouterWithFallback
implements DocRouter {
    private final DocRouter primaryStrategy;
    private final DocRouter fallbackStrategy;

    public DocRouterWithFallback(DocRouter primaryStrategy, DocRouter fallbackStrategy) {
        this.primaryStrategy = Objects.requireNonNull(primaryStrategy);
        this.fallbackStrategy = Objects.requireNonNull(fallbackStrategy);
    }

    @Override
    public Boolean routeAcl(int shardCount, int shardInstance, Acl acl) {
        return this.primaryStrategy.routeAcl(shardCount, shardInstance, acl);
    }

    @Override
    public Boolean routeNode(int shardCount, int shardInstance, Node node) {
        return Optional.ofNullable(this.primaryStrategy.routeNode(shardCount, shardInstance, node)).orElseGet(() -> Optional.ofNullable(this.fallbackStrategy.routeNode(shardCount, shardInstance, node)).orElse(false));
    }

    @Override
    public Map<String, String> getProperties(Optional<QName> shardProperty) {
        return this.primaryStrategy.getProperties(shardProperty);
    }
}

