/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.Tracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitTracker
extends AbstractTracker {
    private long lastCommit;
    private long lastSearcherOpened;
    private long commitInterval;
    private long newSearcherInterval;
    private MetadataTracker metadataTracker;
    private AclTracker aclTracker;
    private ContentTracker contentTracker;
    private Optional<CascadeTracker> cascadeTracker = Optional.empty();
    private AtomicInteger rollbackCount = new AtomicInteger(0);
    protected static final Logger LOGGER = LoggerFactory.getLogger(CommitTracker.class);
    private static Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    CommitTracker() {
        super(Tracker.Type.COMMIT);
    }

    public CommitTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer, List<Tracker> trackers) {
        super(p, client, coreName, informationServer, Tracker.Type.COMMIT);
        for (Tracker tracker : trackers) {
            if (tracker instanceof MetadataTracker) {
                this.metadataTracker = (MetadataTracker)tracker;
                continue;
            }
            if (tracker instanceof AclTracker) {
                this.aclTracker = (AclTracker)tracker;
                continue;
            }
            if (tracker instanceof ContentTracker) {
                this.contentTracker = (ContentTracker)tracker;
                continue;
            }
            if (!(tracker instanceof CascadeTracker)) continue;
            this.cascadeTracker = Optional.ofNullable((CascadeTracker)tracker);
        }
        this.commitInterval = Long.parseLong(p.getProperty("alfresco.commitInterval", "60000"));
        this.newSearcherInterval = Integer.parseInt(p.getProperty("alfresco.newSearcherInterval", "120000"));
        this.lastSearcherOpened = this.lastCommit = System.currentTimeMillis();
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
    }

    @Override
    public boolean hasMaintenance() {
        return this.metadataTracker.hasMaintenance() || this.aclTracker.hasMaintenance();
    }

    public int getRollbackCount() {
        return this.rollbackCount.get();
    }

    @Override
    public void maintenance() throws Exception {
        this.metadataTracker.maintenance();
        this.aclTracker.maintenance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTrack(String iterationId) throws Throwable {
        long currentTime = System.currentTimeMillis();
        boolean commitNeeded = false;
        boolean openSearcherNeeded = false;
        boolean hasMaintenance = this.hasMaintenance();
        if (currentTime - this.lastCommit > this.commitInterval || hasMaintenance) {
            commitNeeded = true;
        }
        if (!commitNeeded) {
            return;
        }
        if (currentTime - this.lastSearcherOpened > this.newSearcherInterval) {
            openSearcherNeeded = true;
        }
        try {
            this.metadataTracker.getWriteLock().acquire();
            assert (this.metadataTracker.getWriteLock().availablePermits() == 0);
            this.aclTracker.getWriteLock().acquire();
            assert (this.aclTracker.getWriteLock().availablePermits() == 0);
            if (this.metadataTracker.getRollback() || this.aclTracker.getRollback()) {
                this.doRollback();
                return;
            }
            if (hasMaintenance) {
                this.maintenance();
            }
            if (this.metadataTracker.isEnabled() && this.aclTracker.isEnabled()) {
                boolean searcherOpened = this.infoSrv.commit(openSearcherNeeded);
                this.lastCommit = currentTime;
                if (searcherOpened) {
                    this.lastSearcherOpened = currentTime;
                }
            } else {
                this.doRollback();
            }
        }
        finally {
            this.metadataTracker.getWriteLock().release();
            this.aclTracker.getWriteLock().release();
        }
    }

    protected void doRollback() {
        try {
            this.contentTracker.getWriteLock().acquire();
            assert (this.contentTracker.getWriteLock().availablePermits() == 0);
            if (this.cascadeTracker.isPresent()) {
                this.cascadeTracker.get().getWriteLock().acquire();
                assert (this.cascadeTracker.get().getWriteLock().availablePermits() == 0);
            }
            this.infoSrv.rollback();
            if (this.aclTracker.getRollbackCausedBy() != null) {
                LOGGER.warn("Rollback performed due to ACL Tracker error", this.aclTracker.getRollbackCausedBy());
            }
            if (this.metadataTracker.getRollbackCausedBy() != null) {
                LOGGER.warn("Rollback performed due to Metadata Tracker error", this.metadataTracker.getRollbackCausedBy());
            }
        }
        catch (Exception e) {
            LOGGER.error("Rollback failed", (Throwable)e);
        }
        finally {
            this.aclTracker.setRollback(false, null);
            this.aclTracker.invalidateState();
            this.metadataTracker.setRollback(false, null);
            this.metadataTracker.invalidateState();
            this.contentTracker.setRollback(false, null);
            this.contentTracker.invalidateState();
            this.cascadeTracker.ifPresent(c -> c.setRollback(false, null));
            this.cascadeTracker.ifPresent(c -> this.invalidateState());
            this.contentTracker.getWriteLock().release();
            this.cascadeTracker.ifPresent(c -> c.getWriteLock().release());
            this.rollbackCount.incrementAndGet();
        }
    }
}

