/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.StructuredFieldPosition;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class SolrContainerScorer
extends Scorer {
    SolrContainerScorerDocIdSetIterator iterator;

    public SolrContainerScorer(Weight weight, PostingsEnum root, StructuredFieldPosition[] positions) {
        super(weight);
        this.iterator = new SolrContainerScorerDocIdSetIterator(root, positions);
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public int freq() throws IOException {
        return 1;
    }

    public int docID() {
        return this.iterator.docID();
    }

    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    private static class SolrContainerScorerDocIdSetIterator
    extends DocIdSetIterator {
        PostingsEnum root;
        StructuredFieldPosition[] positions;
        int min = -1;
        int max = -1;
        int rootDoc = -1;
        boolean more = true;

        SolrContainerScorerDocIdSetIterator(PostingsEnum root, StructuredFieldPosition[] positions) {
            this.positions = positions;
            this.root = root;
        }

        private boolean next() throws IOException {
            if (this.root == null) {
                return false;
            }
            if (!this.more) {
                return false;
            }
            if (this.max == -1) {
                this.doNextOnAll();
                if (this.found()) {
                    return true;
                }
            }
            return this.findNext();
        }

        private boolean findNext() throws IOException {
            if (this.root == null) {
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return false;
            }
            while (this.more) {
                this.move();
                if (!this.found()) continue;
                return true;
            }
            return false;
        }

        private boolean found() throws IOException {
            if (this.positions.length == 0) {
                return true;
            }
            if (!this.more) {
                return false;
            }
            if (this.min != this.max) {
                return false;
            }
            if (this.rootDoc != this.max) {
                return false;
            }
            int count = this.root.freq();
            int start = 0;
            int end = -1;
            for (int i = 0; i < count; ++i) {
                if (i == 0) {
                    start = 0;
                    end = this.root.nextPosition();
                } else {
                    start = end + 1;
                    end = this.root.nextPosition();
                }
                if (!this.check(start, end)) continue;
                return true;
            }
            return false;
        }

        private boolean check(int start, int end) throws IOException {
            int offset = this.checkTail(start, end, 0, 0, true);
            return offset != -1;
        }

        private int checkTail(int start, int end, int currentPosition, int currentOffset, boolean checkLastMatch) throws IOException {
            StructuredFieldPosition last;
            if (checkLastMatch && end - start > 1 && (last = this.getLastPositionNotSelfCheck()) != null && last.matches(start, end, end - start - 2) == -1) {
                return -1;
            }
            int offset = currentOffset;
            int l = this.positions.length;
            for (int i = currentPosition; i < l; ++i) {
                if ((offset = this.positions[i].matches(start, end, offset)) == -1) {
                    return -1;
                }
                if (!this.positions[i].isDescendant()) continue;
                for (int j = offset; j < end - start; j += 2) {
                    int newOffset = this.checkTail(start, end, i + 1, j, false);
                    if (newOffset == -1) continue;
                    return newOffset;
                }
                return -1;
            }
            if (start + offset + 1 == end) {
                return offset;
            }
            return -1;
        }

        private StructuredFieldPosition getLastPositionNotSelfCheck() {
            for (int i = this.positions.length - 1; i >= 0; --i) {
                if (this.positions[i].linkSelf()) continue;
                return this.positions[i];
            }
            return null;
        }

        private void move() throws IOException {
            if (this.min == this.max) {
                this.doNextOnAll();
            } else {
                this.skipToMax();
            }
        }

        private void doNextOnAll() throws IOException {
            if (this.root == null) {
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return;
            }
            boolean first = true;
            int l = this.positions.length;
            for (int i = 0; i < l; ++i) {
                if (this.positions[i].getCachingTermPositions() == null) continue;
                if (this.positions[i].getCachingTermPositions().nextDoc() != Integer.MAX_VALUE) {
                    int current = this.positions[i].getCachingTermPositions().docID();
                    this.adjustMinMax(current, first);
                    first = false;
                    continue;
                }
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return;
            }
            if (this.root.nextDoc() != Integer.MAX_VALUE) {
                this.rootDoc = this.root.docID();
                if (first) {
                    this.adjustMinMax(this.rootDoc, first);
                }
            } else {
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return;
            }
            if (this.root.docID() < this.max) {
                if (this.root.advance(this.max) != Integer.MAX_VALUE) {
                    this.rootDoc = this.root.docID();
                } else {
                    this.more = false;
                    this.max = Integer.MAX_VALUE;
                    return;
                }
            }
        }

        private void skipToMax() throws IOException {
            int l = this.positions.length;
            for (int i = 0; i < l; ++i) {
                if (i == 0) {
                    this.min = this.max;
                }
                if (this.positions[i].getCachingTermPositions() == null || this.positions[i].getCachingTermPositions().docID() >= this.max) continue;
                if (this.positions[i].getCachingTermPositions().advance(this.max) != Integer.MAX_VALUE) {
                    int current = this.positions[i].getCachingTermPositions().docID();
                    this.adjustMinMax(current, false);
                    continue;
                }
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return;
            }
            if (this.root.docID() < this.max) {
                if (this.root.advance(this.max) != Integer.MAX_VALUE) {
                    this.rootDoc = this.root.docID();
                } else {
                    this.more = false;
                    this.max = Integer.MAX_VALUE;
                    return;
                }
            }
        }

        private void adjustMinMax(int doc, boolean setMin) {
            if (this.max < doc) {
                this.max = doc;
            }
            if (setMin) {
                this.min = doc;
            } else if (this.min > doc) {
                this.min = doc;
            }
        }

        public int docID() {
            return this.max;
        }

        public int nextDoc() throws IOException {
            boolean found = this.next();
            if (found) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            if (target == Integer.MAX_VALUE) {
                this.more = false;
                this.max = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.max = target;
            boolean found = this.findNext();
            if (found) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        public long cost() {
            return 1L;
        }
    }
}

