/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.repo.search.impl.QueryParserUtils;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoAnalyzerWrapper;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.AlfrescoDefaultTextFields;
import org.alfresco.solr.query.SolrAuthoritySetQuery;
import org.alfresco.solr.query.SolrCachingPathQuery;
import org.alfresco.solr.query.SolrDeniedQuery;
import org.alfresco.solr.query.SolrDenySetQuery;
import org.alfresco.solr.query.SolrOwnerQuery;
import org.alfresco.solr.query.SolrOwnerSetQuery;
import org.alfresco.solr.query.SolrPathQuery;
import org.alfresco.solr.query.SolrReaderQuery;
import org.alfresco.solr.query.SolrReaderSetQuery;
import org.alfresco.solr.query.SolrXPathHandler;
import org.alfresco.solr.utils.ThrowingFunction;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchLanguageConversion;
import org.antlr.misc.OrderedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilterFactory;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.base.XPathReader;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class Solr4QueryParser
extends QueryParser
implements QueryConstants {
    private static final String CMIS_REQUEST_HANDLER = "cmis";
    private FTSQueryParser.RerankPhase rerankPhase;
    private SolrParams solrParams;
    private ShardHandlerFactory shardHandlerFactory;
    private SolrQueryRequest request;
    IndexSchema schema;
    @SuppressWarnings(value={"unused"})
    private static Log logger = LogFactory.getLog(Solr4QueryParser.class);
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    private TenantService tenantService;
    private SearchParameters searchParameters;
    private MLAnalysisMode mlAnalysisMode = MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    private int internalSlop = 0;
    int topTermSpanRewriteLimit = 1000;

    public Solr4QueryParser(SolrQueryRequest req, Version matchVersion, String f, Analyzer a, FTSQueryParser.RerankPhase rerankPhase) {
        super(f, a);
        this.setAllowLeadingWildcard(true);
        this.setAnalyzeRangeTerms(true);
        this.rerankPhase = rerankPhase;
        this.schema = req.getSchema();
        this.solrParams = req.getParams();
        SolrCore core = req.getCore();
        if (core != null) {
            this.shardHandlerFactory = core.getCoreContainer().getShardHandlerFactory();
        }
        this.request = req;
    }

    public void setTopTermSpanRewriteLimit(int topTermSpanRewriteLimit) {
        this.topTermSpanRewriteLimit = topTermSpanRewriteLimit;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, int slop, LuceneFunction luceneFunction) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    public Query getLikeQuery(String field, String sqlLikeClause, AnalysisMode analysisMode) throws ParseException {
        String luceneWildCardExpression = this.translate(sqlLikeClause);
        return this.getWildcardQuery(field, luceneWildCardExpression, AnalysisMode.LIKE);
    }

    private String translate(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                builder.append(c);
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (c == '%') {
                builder.append('*');
                continue;
            }
            if (c == '_') {
                builder.append('?');
                continue;
            }
            if (c == '*') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            if (c == '?') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (lastWasEscape) {
            throw new FTSQueryException("Escape character at end of string " + string);
        }
        return builder.toString();
    }

    public Query getDoesNotMatchFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        MatchAllDocsQuery allQuery = new MatchAllDocsQuery();
        Query matchQuery = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
        if (matchQuery == null) {
            throw new UnsupportedOperationException();
        }
        query.add((Query)allQuery, BooleanClause.Occur.MUST);
        query.add(matchQuery, BooleanClause.Occur.MUST_NOT);
        return query.build();
    }

    public Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    public Query getSpanQuery(String field, String first, String last, int slop, boolean inOrder) throws ParseException {
        if (field.equals("PATH")) {
            throw new UnsupportedOperationException("Span is not supported for PATH");
        }
        if (field.equals("PATHWITHREPEATS")) {
            throw new UnsupportedOperationException("Span is not supported for PATHWITHREPEATS");
        }
        if (field.equals("TEXT")) {
            return this.createDefaultTextQuery(textField -> this.getSpanQuery((String)textField, first, last, slop, inOrder));
        }
        if (field.equals("CLASS")) {
            throw new UnsupportedOperationException("Span is not supported for CLASS");
        }
        if (field.equals("TYPE")) {
            throw new UnsupportedOperationException("Span is not supported for TYPE");
        }
        if (field.equals("EXACTTYPE")) {
            throw new UnsupportedOperationException("Span is not supported for EXACTTYPE");
        }
        if (field.equals("ASPECT")) {
            throw new UnsupportedOperationException("Span is not supported for ASPECT");
        }
        if (field.equals("EXACTASPECT")) {
            throw new UnsupportedOperationException("Span is not supported for EXACTASPECT");
        }
        if (this.isPropertyField(field)) {
            return this.spanQueryBuilder(field, first, last, slop, inOrder);
        }
        if (field.equals("ALL")) {
            Set all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (QName qname : contentAttributes) {
                    Query part = this.getSpanQuery("@" + qname.toString(), first, last, slop, inOrder);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String fieldName : all) {
                Query part = this.getSpanQuery(fieldName, first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("ISUNSET")) {
            throw new UnsupportedOperationException("Span is not supported for ISUNSET");
        }
        if (field.equals("ISNULL")) {
            throw new UnsupportedOperationException("Span is not supported for ISNULL");
        }
        if (field.equals("ISNOTNULL")) {
            throw new UnsupportedOperationException("Span is not supported for ISNOTNULL");
        }
        if (field.equals("EXISTS")) {
            throw new UnsupportedOperationException("Span is not supported for EXISTS");
        }
        if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
            Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (QName qname : contentAttributes) {
                Query part = this.getSpanQuery("@" + qname.toString(), first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("FTSSTATUS")) {
            throw new UnsupportedOperationException("Span is not supported for FTSSTATUS");
        }
        if (field.equals("TAG")) {
            return null;
        }
        if (this.isPropertyField(field)) {
            return this.spanQueryBuilder(field, first, last, slop, inOrder);
        }
        BytesRef firstBytes = this.analyzeMultitermTerm(field, first);
        BytesRef lastBytes = this.analyzeMultitermTerm(field, last);
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, firstBytes));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, lastBytes));
        return new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        return this.getFieldQuery(field, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    @SuppressWarnings(value={"deprecation"})
    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        try {
            if (field.equals("PATH")) {
                return this.createPathQuery(queryText, false);
            }
            if (field.equals("PATHWITHREPEATS")) {
                return this.createPathQuery(queryText, true);
            }
            if (field.equals("TEXT")) {
                return this.createTextQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals("ID")) {
                return this.createIdQuery(queryText);
            }
            if (field.equals("id")) {
                return this.createSolr4IdQuery(queryText);
            }
            if (field.equals("DBID")) {
                return this.createDbidQuery(queryText);
            }
            if (field.equals("ACLID")) {
                return this.createAclIdQuery(queryText);
            }
            if (field.equals("OWNER")) {
                return this.createOwnerQuery(queryText);
            }
            if (field.equals("OWNERSET")) {
                return this.createOwnerSetQuery(queryText);
            }
            if (field.equals("READER")) {
                return this.createReaderQuery(queryText);
            }
            if (field.equals("READERSET")) {
                return this.createReaderSetQuery(queryText);
            }
            if (field.equals("AUTHORITY")) {
                return this.createAuthorityQuery(queryText);
            }
            if (field.equals("AUTHSET")) {
                return this.createAuthoritySetQuery(queryText);
            }
            if (field.equals("DENIED")) {
                return this.createDeniedQuery(queryText);
            }
            if (field.equals("DENYSET")) {
                return this.createDenySetQuery(queryText);
            }
            if (field.equals("ISROOT")) {
                return this.createIsRootQuery(queryText);
            }
            if (field.equals("ISCONTAINER")) {
                return this.createIsContainerQuery(queryText);
            }
            if (field.equals("ISNODE")) {
                return this.createIsNodeQuery(queryText);
            }
            if (field.equals("TX")) {
                return this.createTransactionQuery(queryText);
            }
            if (field.equals("INTXID")) {
                return this.createInTxIdQuery(queryText);
            }
            if (field.equals("INACLTXID")) {
                return this.createInAclTxIdQuery(queryText);
            }
            if (field.equals("PARENT")) {
                return this.createParentQuery(queryText);
            }
            if (field.equals("PRIMARYPARENT")) {
                return this.createPrimaryParentQuery(queryText);
            }
            if (field.equals("QNAME")) {
                return this.createQNameQuery(queryText);
            }
            if (field.equals("PRIMARYASSOCQNAME")) {
                return this.createPrimaryAssocQNameQuery(queryText);
            }
            if (field.equals("PRIMARYASSOCTYPEQNAME")) {
                return this.createPrimaryAssocTypeQNameQuery(queryText);
            }
            if (field.equals("ASSOCTYPEQNAME")) {
                return this.createAssocTypeQNameQuery(queryText);
            }
            if (field.equals("CLASS")) {
                ClassDefinition target = QueryParserUtils.matchClassDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
                if (target == null) {
                    return new TermQuery(new Term("TYPE", "_unknown_"));
                }
                return this.getFieldQuery(target.isAspect() ? "ASPECT" : "TYPE", queryText, analysisMode, luceneFunction);
            }
            if (field.equals("TYPE")) {
                return this.createTypeQuery(queryText, false);
            }
            if (field.equals("EXACTTYPE")) {
                return this.createTypeQuery(queryText, true);
            }
            if (field.equals("ASPECT")) {
                return this.createAspectQuery(queryText, false);
            }
            if (field.equals("EXACTASPECT")) {
                return this.createAspectQuery(queryText, true);
            }
            if (this.isPropertyField(field)) {
                Query query = this.attributeQueryBuilder(field, queryText, new FieldQuery(), analysisMode, luceneFunction);
                return query;
            }
            if (field.equals("ALL")) {
                return this.createAllQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals("ISUNSET")) {
                return this.createIsUnsetQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals("ISNULL")) {
                return this.createIsNullQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals("ISNOTNULL")) {
                return this.createIsNotNull(queryText, analysisMode, luceneFunction);
            }
            if (field.equals("EXISTS")) {
                return this.createExistsQuery(queryText, analysisMode, luceneFunction);
            }
            if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
                return this.createDataTypeDefinitionQuery(field, queryText, analysisMode, luceneFunction);
            }
            if (field.equals("TXID")) {
                return this.createTxIdQuery(queryText);
            }
            if (field.equals("ACLTXID")) {
                return this.createAclTxIdQuery(queryText);
            }
            if (field.equals("TXCOMMITTIME")) {
                return this.createTxCommitTimeQuery(queryText);
            }
            if (field.equals("ACLTXCOMMITTIME")) {
                return this.createAclTxCommitTimeQuery(queryText);
            }
            if (field.equals("TAG")) {
                return this.createTagQuery(queryText);
            }
            if (field.equals("SITE")) {
                return this.createSiteQuery(queryText);
            }
            if (field.equals("PNAME")) {
                return this.createPNameQuery(queryText);
            }
            if (field.equals("NPATH")) {
                return this.createNPathQuery(queryText);
            }
            if (field.equals("TENANT")) {
                return this.createTenantQuery(queryText);
            }
            if (field.equals("ANCESTOR")) {
                return this.createAncestorQuery(queryText);
            }
            if (field.equals("FINGERPRINT")) {
                String[] parts = queryText.split("_");
                ArrayList<String> values = null;
                String nodeId = parts[0];
                JSONObject json = (JSONObject)this.request.getContext().get("ALFRESCO_JSON");
                String fingerPrint = null;
                if (json != null) {
                    String fingerPrintKey = "fingerprint." + nodeId;
                    if (json.has(fingerPrintKey) && (fingerPrint = (String)json.get("fingerprint." + nodeId)) != null) {
                        String[] hashes;
                        ArrayList<String> l = new ArrayList<String>();
                        for (String hash : hashes = fingerPrint.split(" ")) {
                            l.add(hash);
                        }
                        values = l;
                    }
                } else {
                    json = new JSONObject();
                }
                if (values == null) {
                    values = this.fetchMinHash(nodeId);
                }
                String shards = this.solrParams.get("shards");
                if (values == null && shards != null) {
                    values = this.fetchFingerPrint(shards, nodeId);
                }
                if (values != null && shards != null && fingerPrint == null) {
                    ModifiableSolrParams newParams = new ModifiableSolrParams();
                    newParams.add(this.solrParams);
                    this.solrParams = newParams;
                    json.put("fingerprint." + nodeId, (Object)this.join(values, " "));
                    String jsonString = json.toString();
                    newParams.add("ALFRESCO_JSON", new String[]{jsonString});
                    this.request.getContext().put("ALFRESCO_JSON", json);
                    this.request.setParams((SolrParams)newParams);
                }
                return this.createFingerPrintQuery(field, queryText, values, analysisMode, luceneFunction);
            }
            return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
        }
        catch (SAXPathException e) {
            throw new ParseException("Failed to parse XPath...\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new ParseException("IO: " + e.getMessage());
        }
    }

    private boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String join(Collection col, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (Object o : col) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(o.toString());
        }
        return builder.toString();
    }

    private Collection fetchMinHash(String id) throws IOException {
        LegacyNumericRangeQuery q;
        SolrIndexSearcher searcher = this.request.getSearcher();
        if (this.isNumber(id)) {
            long dbid = Long.parseLong(id);
            q = LegacyNumericRangeQuery.newLongRange((String)"DBID", (Long)dbid, (Long)(dbid + 1L), (boolean)true, (boolean)false);
        } else {
            Object query = id.startsWith("workspace") ? id : "workspace://SpacesStore/" + id;
            q = new TermQuery(new Term("LID", (String)query));
        }
        TopDocs docs = searcher.search((Query)q, 1);
        HashSet<String> fields = new HashSet<String>();
        fields.add("FINGERPRINT");
        if (docs.totalHits == 1) {
            IndexableField[] minHashes;
            ScoreDoc scoreDoc = docs.scoreDocs[0];
            Document doc = searcher.doc(scoreDoc.doc, fields);
            ArrayList<Object> values = new ArrayList<Object>();
            for (IndexableField minHash : minHashes = doc.getFields("MINHASH")) {
                SchemaField sf = this.schema.getFieldOrNull(minHash.name());
                Object value = DocsStreamer.getValue((SchemaField)sf, (IndexableField)minHash);
                values.add(value);
            }
            return values;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection fetchFingerPrint(String shards, String nodeId) {
        shards = shards.replace(",", "|");
        List urls = ((HttpShardHandlerFactory)this.shardHandlerFactory).buildURLList(shards);
        ExecutorService executorService = null;
        ArrayList<Future<Collection>> futures = new ArrayList<Future<Collection>>();
        Collection fingerPrint = null;
        try {
            executorService = Executors.newCachedThreadPool();
            for (String string : urls) {
                futures.add(executorService.submit(new FingerPrintFetchTask(string, nodeId)));
            }
            for (Future future : futures) {
                Collection col = (Collection)future.get();
                if (col == null) continue;
                fingerPrint = col;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        return fingerPrint;
    }

    private Query createFingerPrintQuery(String field, String queryText, Collection values, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws IOException, ParseException {
        String[] parts = queryText.split("_");
        if (parts.length == 0) {
            return this.createIsNodeQuery("T");
        }
        if (values != null) {
            TermQuery tq;
            int bandSize = 1;
            float fraction = -1.0f;
            float truePositive = 1.0f;
            if (parts.length > 1 && (fraction = Float.parseFloat(parts[1])) > 1.0f) {
                fraction /= 100.0f;
            }
            if (parts.length > 2) {
                truePositive = Float.parseFloat(parts[2]);
                if (truePositive > 1.0f) {
                    truePositive /= 100.0f;
                }
                bandSize = this.computeBandSize(values.size(), fraction, truePositive);
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            BooleanQuery.Builder childBuilder = new BooleanQuery.Builder();
            int rowInBand = 0;
            for (Object token : values) {
                tq = new TermQuery(new Term("MINHASH", token.toString()));
                if (bandSize == 1) {
                    builder.add((Query)new ConstantScoreQuery((Query)tq), BooleanClause.Occur.SHOULD);
                    continue;
                }
                childBuilder.add((Query)new ConstantScoreQuery((Query)tq), BooleanClause.Occur.MUST);
                if (++rowInBand != bandSize) continue;
                builder.add((Query)new ConstantScoreQuery((Query)childBuilder.setDisableCoord(true).build()), BooleanClause.Occur.SHOULD);
                childBuilder = new BooleanQuery.Builder();
                rowInBand = 0;
            }
            if (childBuilder.build().clauses().size() > 0) {
                for (Object token : values) {
                    tq = new TermQuery(new Term("MINHASH", token.toString()));
                    childBuilder.add((Query)new ConstantScoreQuery((Query)tq), BooleanClause.Occur.MUST);
                    if (++rowInBand != bandSize) continue;
                    builder.add((Query)new ConstantScoreQuery((Query)childBuilder.setDisableCoord(true).build()), BooleanClause.Occur.SHOULD);
                    break;
                }
            }
            builder.setDisableCoord(true);
            if (parts.length == 2) {
                builder.setMinimumNumberShouldMatch((int)Math.ceil((float)values.size() * fraction));
            }
            BooleanQuery q = builder.build();
            return q;
        }
        return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
    }

    private int computeBandSize(int numHash, double sim, double expectedTruePositive) {
        for (int bands = 1; bands <= numHash; ++bands) {
            int rowsInBand = numHash / bands;
            double truePositive = 1.0 - Math.pow(1.0 - Math.pow(sim, rowsInBand), bands);
            if (!(truePositive > expectedTruePositive)) continue;
            return rowsInBand;
        }
        return 1;
    }

    private ArrayList<String> getTokens(IndexableField indexableField) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream ts = indexableField.tokenStream(this.schema.getIndexAnalyzer(), null);
        CharTermAttribute termAttribute = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            String token = new String(termAttribute.buffer(), 0, termAttribute.length());
            tokens.add(token);
        }
        ts.end();
        ts.close();
        return tokens;
    }

    private Query createNPathQuery(String queryText) {
        return this.createTermQuery("NPATH", queryText);
    }

    private Query createPNameQuery(String queryText) {
        return this.createTermQuery("PNAME", queryText);
    }

    private Query createSiteQuery(String queryText) {
        if (queryText.equals("_EVERYTHING_")) {
            return this.createTermQuery("ISNODE", "T");
        }
        if (queryText.equals("_ALL_SITES_")) {
            BooleanQuery.Builder invertedRepositoryQuery = new BooleanQuery.Builder();
            invertedRepositoryQuery.add(this.createTermQuery("ISNODE", "T"), BooleanClause.Occur.MUST);
            invertedRepositoryQuery.add(this.createTermQuery("SITE", "_REPOSITORY_"), BooleanClause.Occur.MUST_NOT);
            return invertedRepositoryQuery.build();
        }
        return this.createTermQuery("SITE", queryText);
    }

    private boolean isPropertyField(String field) {
        if (field.startsWith("@")) {
            return true;
        }
        int index = field.lastIndexOf(64);
        if (index > -1) {
            PropertyDefinition pDef = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field.substring(index + 1));
            if (pDef != null) {
                AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getIndexedFieldNamesForProperty(pDef.getName());
                for (AlfrescoSolrDataModel.FieldInstance instance : indexedField.getFields()) {
                    if (!instance.getField().equals(field)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected Query createTenantQuery(String queryText) throws ParseException {
        if (queryText.length() > 0) {
            return this.getFieldQueryImplWithIOExceptionWrapped("TENANT", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        return this.getFieldQueryImplWithIOExceptionWrapped("TENANT", "_DEFAULT_", AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAncestorQuery(String queryText) throws ParseException {
        return this.createNodeRefQuery("ANCESTOR", queryText);
    }

    protected Query createTagQuery(String tag) throws ParseException {
        return this.createTermQuery("TAG", tag.toLowerCase());
    }

    private Query getFieldQueryImplWithIOExceptionWrapped(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        try {
            return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
        }
        catch (IOException e) {
            throw new ParseException("IO: " + e.getMessage());
        }
    }

    protected Query createDbidQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("DBID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("TXID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAclTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("ACLTXID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createTxCommitTimeQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("TXCOMMITTIME", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAclTxCommitTimeQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("ACLTXCOMMITTIME", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createDataTypeDefinitionQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (QName qname : contentAttributes) {
            Query part = this.getFieldQuery("@" + qname.toString(), queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }

    protected Query createIsNotNull(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (pd != null) {
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            query.add(this.createTermQuery("PROPERTIES", pd.getName().toString()), BooleanClause.Occur.MUST);
            query.add(this.createTermQuery("NULLPROPERTIES", pd.getName().toString()), BooleanClause.Occur.MUST_NOT);
            return query.build();
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        Query presenceQuery = this.getWildcardQuery(queryText, "*");
        if (presenceQuery != null) {
            query.add(presenceQuery, BooleanClause.Occur.MUST);
        }
        return query.build();
    }

    protected Query createIsNullQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (pd != null) {
            return this.createTermQuery("NULLPROPERTIES", pd.getName().toString());
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        Query presenceQuery = this.getWildcardQuery(queryText, "*");
        if (presenceQuery != null) {
            query.add(this.createIsNodeQuery("T"), BooleanClause.Occur.MUST);
            query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
        }
        return query.build();
    }

    protected Query createIsUnsetQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (pd != null) {
            ClassDefinition containerClass = pd.getContainerClass();
            QName container = containerClass.getName();
            String classType = containerClass.isAspect() ? "ASPECT" : "TYPE";
            Query typeQuery = this.getFieldQuery(classType, container.toString(), analysisMode, luceneFunction);
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            Query presenceQuery = this.createTermQuery("PROPERTIES", pd.getName().toString());
            if (presenceQuery != null) {
                query.add(typeQuery, BooleanClause.Occur.MUST);
                query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
            }
            return query.build();
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        Query presenceQuery = this.getWildcardQuery(queryText, "*");
        if (presenceQuery != null) {
            query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
        }
        return query.build();
    }

    protected Query createExistsQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (pd != null) {
            return this.createTermQuery("PROPERTIES", pd.getName().toString());
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        Query presenceQuery = this.getWildcardQuery(queryText, "*");
        if (presenceQuery != null) {
            query.add(this.createIsNodeQuery("T"), BooleanClause.Occur.MUST);
            query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
        }
        return query.build();
    }

    protected Query createAllQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query createAspectQuery(String queryText, boolean exactOnly) {
        AspectDefinition target = QueryParserUtils.matchAspectDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (target == null) {
            return new TermQuery(new Term("ASPECT", "_unknown_"));
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term("ASPECT", targetQName.toString()));
            return termQuery;
        }
        Collection subclasses = this.dictionaryService.getSubAspects(target.getName(), true);
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            AspectDefinition current = this.dictionaryService.getAspect(qname);
            if (!target.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term("ASPECT", qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }

    protected Query createTypeQuery(String queryText, boolean exactOnly) throws ParseException {
        TypeDefinition target = QueryParserUtils.matchTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)queryText);
        if (target == null) {
            return new TermQuery(new Term("TYPE", "_unknown_"));
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term("TYPE", targetQName.toString()));
            return termQuery;
        }
        Collection subclasses = this.dictionaryService.getSubTypes(target.getName(), true);
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            TypeDefinition current = this.dictionaryService.getType(qname);
            if (!target.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term("TYPE", qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }

    protected Query createInTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("INTXID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createInAclTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("INACLTXID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    @SuppressWarnings(value={"deprecation"})
    protected Query createTransactionQuery(String queryText) {
        return this.createTermQuery("TX", queryText);
    }

    protected Query createIsNodeQuery(String queryText) {
        return this.createTermQuery("ISNODE", queryText);
    }

    protected Query createIsContainerQuery(String queryText) {
        return this.createTermQuery("ISCONTAINER", queryText);
    }

    protected Query createIsRootQuery(String queryText) {
        return this.createTermQuery("ISROOT", queryText);
    }

    protected Query createTermQuery(String field, String queryText) {
        TermQuery termQuery = new TermQuery(new Term(field, queryText));
        return termQuery;
    }

    protected Query createPrimaryParentQuery(String queryText) {
        return this.createNodeRefQuery("PRIMARYPARENT", queryText);
    }

    protected Query createParentQuery(String queryText) {
        return this.createNodeRefQuery("PARENT", queryText);
    }

    protected Query createNodeRefQuery(String field, String queryText) {
        if (this.tenantService.isTenantUser() && queryText.contains("://")) {
            queryText = this.tenantService.getName(new NodeRef(queryText)).toString();
        }
        return this.createTermQuery(field, queryText);
    }

    protected Query createDefaultTextQuery(ThrowingFunction<String, Query, ParseException> getQuery) throws ParseException {
        Set text = this.searchParameters.getTextAttributes();
        if (text == null || text.isEmpty()) {
            text = Stream.of(AlfrescoDefaultTextFields.values()).map(t -> "@" + t.getFieldName()).collect(Collectors.toSet());
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (String fieldName : text) {
            try {
                Query part = getQuery.apply(fieldName);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            catch (UnsupportedOperationException e) {
                logger.warn((Object)e);
            }
        }
        return query.build();
    }

    protected Query createTextQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.createDefaultTextQuery(textField -> this.getFieldQuery((String)textField, queryText, analysisMode, luceneFunction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressWarnings(value={"unchecked"})
    protected Query getFieldQueryImpl(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException, IOException {
        int n;
        TermQuery termQuery;
        org.apache.lucene.search.WildcardQuery wildQuery;
        Term term;
        Object and;
        boolean forceConjuncion;
        AlfrescoAnalyzerWrapper analyzerWrapper;
        TokenizerChain tokenizerChain;
        String termText;
        Object replace;
        int position;
        SchemaField schemaField = this.schema.getFieldOrNull(field);
        if (schemaField == null || schemaField.getType() == null) {
            return new TermQuery(new Term("_dummy_", "_miss_"));
        }
        NumberType schemaFieldNumberType = schemaField.getType().getNumberType();
        if (this.isNonParsableNumberType(schemaFieldNumberType, queryText)) {
            return new TermQuery(new Term("_dummy_", "_miss_"));
        }
        if (luceneFunction != LuceneFunction.FIELD) {
            throw new UnsupportedOperationException("Field queries are not supported on lucene functions (UPPER, LOWER, etc)");
        }
        String localePrefix = "";
        String toTokenise = queryText;
        if (queryText.startsWith("{") && (position = queryText.indexOf("}")) > 0) {
            String language = queryText.substring(0, position + 1);
            Locale locale = new Locale(queryText.substring(1, position));
            String token = queryText.substring(position + 1);
            boolean found = false;
            for (Locale current : Locale.getAvailableLocales()) {
                if (!current.toString().equalsIgnoreCase(locale.toString())) continue;
                found = true;
                break;
            }
            if (found) {
                localePrefix = language;
                toTokenise = token;
            }
        }
        String testText = toTokenise;
        boolean requiresMLTokenDuplication = false;
        String localeString = null;
        if (this.isPropertyField(field) && localePrefix.length() == 0 && queryText.length() > 0 && queryText.charAt(0) == '\u0000') {
            int position2 = queryText.indexOf("\u0000", 1);
            testText = queryText.substring(position2 + 1);
            requiresMLTokenDuplication = true;
            localeString = queryText.substring(1, position2);
        }
        Set<Integer> wildcardPoistions = this.getWildcardPositions(testText);
        TokenStream source = null;
        ArrayList<PackedTokenAttributeImpl> list = new ArrayList<PackedTokenAttributeImpl>();
        boolean severalTokensAtSamePosition = false;
        int positionCount = 0;
        try {
            source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(toTokenise));
            source.reset();
            while (source.incrementToken()) {
                CharTermAttribute cta = (CharTermAttribute)source.getAttribute(CharTermAttribute.class);
                OffsetAttribute offsetAtt = (OffsetAttribute)source.getAttribute(OffsetAttribute.class);
                TypeAttribute typeAtt = null;
                if (source.hasAttribute(TypeAttribute.class)) {
                    typeAtt = (TypeAttribute)source.getAttribute(TypeAttribute.class);
                }
                PositionIncrementAttribute posIncAtt = null;
                if (source.hasAttribute(PositionIncrementAttribute.class)) {
                    posIncAtt = (PositionIncrementAttribute)source.getAttribute(PositionIncrementAttribute.class);
                }
                PackedTokenAttributeImpl nextToken = new PackedTokenAttributeImpl();
                nextToken.setEmpty().copyBuffer(cta.buffer(), 0, cta.length());
                nextToken.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
                if (typeAtt != null) {
                    nextToken.setType(typeAtt.type());
                }
                if (posIncAtt != null) {
                    nextToken.setPositionIncrement(posIncAtt.getPositionIncrement());
                }
                list.add(nextToken);
                if (nextToken.getPositionIncrement() != 0) {
                    positionCount += nextToken.getPositionIncrement();
                    continue;
                }
                severalTokensAtSamePosition = true;
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException cta) {}
        }
        for (int index = 0; index < testText.length(); ++index) {
            char c;
            int count;
            char current = testText.charAt(index);
            if (current != '*' && current != '?' || !wildcardPoistions.contains(index)) continue;
            StringBuilder pre = new StringBuilder(10);
            if (index == 0) {
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    PackedTokenAttributeImpl test = (PackedTokenAttributeImpl)list.get(j);
                    if (test.startOffset() > 0 || 0 >= test.endOffset()) continue;
                    found = true;
                    break;
                }
                if (!found && list.size() == 0) {
                    PackedTokenAttributeImpl newToken = new PackedTokenAttributeImpl();
                    newToken.setEmpty().append((CharSequence)"", 0, 0);
                    newToken.setType("ALPHANUM");
                    if (requiresMLTokenDuplication) {
                        Locale locale = I18NUtil.parseLocale((String)localeString);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, MLAnalysisMode.EXACT_LANGUAGE);
                        Iterator<PackedTokenAttributeImpl> iterator = duplicator.buildIterator(newToken);
                        if (iterator != null) {
                            count = 0;
                            while (iterator.hasNext()) {
                                list.add(iterator.next());
                                if (++count <= 1) continue;
                                severalTokensAtSamePosition = true;
                            }
                        }
                    } else {
                        list.add(newToken);
                    }
                }
            } else if (index > 0) {
                boolean tokenFound = false;
                for (int j = 0; j < list.size(); ++j) {
                    PackedTokenAttributeImpl test = (PackedTokenAttributeImpl)list.get(j);
                    if (test.startOffset() > index || index >= test.endOffset()) continue;
                    if (requiresMLTokenDuplication) {
                        String termText2 = test.toString();
                        int n2 = termText2.indexOf("}");
                        String language = termText2.substring(0, n2 + 1);
                        String token = termText2.substring(n2 + 1);
                        if (index >= test.startOffset() + token.length()) {
                            test.setEmpty();
                            test.append(language + token + current);
                        }
                    } else if (index >= test.startOffset() + test.length()) {
                        test.setEmpty();
                        test.append(test.toString() + current);
                    }
                    tokenFound = true;
                    break;
                }
                if (!tokenFound) {
                    char c2;
                    for (int i = index - 1; i >= 0 && Character.isLetterOrDigit(c2 = testText.charAt(i)); --i) {
                        boolean found = false;
                        for (int j = 0; j < list.size(); ++j) {
                            PackedTokenAttributeImpl test = (PackedTokenAttributeImpl)list.get(j);
                            if (test.startOffset() > i || i >= test.endOffset()) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                        pre.insert(0, c2);
                    }
                    if (pre.length() > 0) {
                        PackedTokenAttributeImpl newToken = new PackedTokenAttributeImpl();
                        newToken.setEmpty().append(pre.toString());
                        newToken.setOffset(index - pre.length(), index);
                        newToken.setType("ALPHANUM");
                        if (requiresMLTokenDuplication) {
                            Locale locale = I18NUtil.parseLocale((String)localeString);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, MLAnalysisMode.EXACT_LANGUAGE);
                            Iterator<PackedTokenAttributeImpl> iterator = duplicator.buildIterator(newToken);
                            if (iterator != null) {
                                int count2 = 0;
                                while (iterator.hasNext()) {
                                    list.add(iterator.next());
                                    if (++count2 <= 1) continue;
                                    severalTokensAtSamePosition = true;
                                }
                            }
                        } else {
                            list.add(newToken);
                        }
                    }
                }
            }
            StringBuilder post = new StringBuilder(10);
            if (index <= 0) continue;
            for (int i = index + 1; i < testText.length() && Character.isLetterOrDigit(c = testText.charAt(i)); ++i) {
                void var25_76;
                boolean found = false;
                boolean bl = false;
                while (var25_76 < list.size()) {
                    PackedTokenAttributeImpl test = (PackedTokenAttributeImpl)list.get((int)var25_76);
                    if (test.startOffset() <= i && i < test.endOffset()) {
                        found = true;
                        break;
                    }
                    ++var25_76;
                }
                if (found) break;
                post.append(c);
            }
            if (post.length() <= 0) continue;
            PackedTokenAttributeImpl newToken = new PackedTokenAttributeImpl();
            newToken.setEmpty().append(post.toString());
            newToken.setOffset(index + 1, index + 1 + post.length());
            newToken.setType("ALPHANUM");
            if (requiresMLTokenDuplication) {
                Locale locale = I18NUtil.parseLocale((String)localeString);
                MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, MLAnalysisMode.EXACT_LANGUAGE);
                Iterator<PackedTokenAttributeImpl> iterator = duplicator.buildIterator(newToken);
                if (iterator == null) continue;
                count = 0;
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                    if (++count <= 1) continue;
                    severalTokensAtSamePosition = true;
                }
                continue;
            }
            list.add(newToken);
        }
        int curentIncrement = -1;
        for (PackedTokenAttributeImpl c : list) {
            if (curentIncrement == -1) {
                curentIncrement = c.getPositionIncrement();
                continue;
            }
            if (c.getPositionIncrement() > 0) {
                curentIncrement = c.getPositionIncrement();
                continue;
            }
            c.setPositionIncrement(curentIncrement);
        }
        boolean lastWasWild = false;
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = ((PackedTokenAttributeImpl)list.get(i)).endOffset() + 1; j < ((PackedTokenAttributeImpl)list.get(i + 1)).startOffset() - 1; ++j) {
                if (wildcardPoistions.contains(j)) {
                    if (!lastWasWild) {
                        ((PackedTokenAttributeImpl)list.get(i + 1)).setPositionIncrement(((PackedTokenAttributeImpl)list.get(i + 1)).getPositionIncrement() + 1);
                    }
                    lastWasWild = true;
                    continue;
                }
                lastWasWild = false;
            }
        }
        Collections.sort(list, new Comparator<PackedTokenAttributeImpl>(){

            @Override
            public int compare(PackedTokenAttributeImpl o1, PackedTokenAttributeImpl o2) {
                int dif = o1.startOffset() - o2.startOffset();
                return dif;
            }
        });
        LinkedList tokensByPosition = new LinkedList();
        LinkedList<PackedTokenAttributeImpl> currentList = null;
        int lastStart = 0;
        for (PackedTokenAttributeImpl c : list) {
            if (c.startOffset() == lastStart) {
                if (currentList == null) {
                    currentList = new LinkedList();
                    tokensByPosition.add(currentList);
                }
                currentList.add(c);
            } else {
                currentList = new LinkedList<PackedTokenAttributeImpl>();
                tokensByPosition.add(currentList);
                currentList.add(c);
            }
            lastStart = c.startOffset();
        }
        OrderedHashSet allTokenSequencesSet = new OrderedHashSet();
        for (LinkedList linkedList : tokensByPosition) {
            OrderedHashSet positionalSynonymSequencesSet = new OrderedHashSet();
            OrderedHashSet newAllTokenSequencesSet = new OrderedHashSet();
            for (PackedTokenAttributeImpl t : linkedList) {
                PackedTokenAttributeImpl newToken;
                LinkedList<Object> newEntry;
                replace = new PackedTokenAttributeImpl();
                replace.setEmpty().append((CharTermAttribute)t);
                replace.setOffset(t.startOffset(), t.endOffset());
                replace.setType(t.type());
                replace.setPositionIncrement(t.getPositionIncrement());
                boolean tokenFoundSequence = false;
                for (LinkedList tokenSequence : allTokenSequencesSet) {
                    newEntry = new LinkedList<Object>();
                    newEntry.addAll(tokenSequence);
                    if (((PackedTokenAttributeImpl)newEntry.getLast()).endOffset() == replace.endOffset() && replace.type().equals("SYNONYM")) {
                        if (((PackedTokenAttributeImpl)newEntry.getLast()).startOffset() == replace.startOffset() && ((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("SYNONYM")) {
                            positionalSynonymSequencesSet.add((Object)tokenSequence);
                            newEntry.add(replace);
                            tokenFoundSequence = true;
                        } else if (((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("gram")) {
                            if (newEntry.toString().endsWith(replace.toString())) {
                                positionalSynonymSequencesSet.add((Object)tokenSequence);
                                tokenFoundSequence = true;
                            } else {
                                tokenFoundSequence = true;
                                StringBuffer stringBuffer = new StringBuffer(((PackedTokenAttributeImpl)newEntry.getLast()).toString());
                                stringBuffer.replace(replace.startOffset() - ((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), replace.endOffset() - ((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), replace.toString());
                                newToken = new PackedTokenAttributeImpl();
                                newToken.setEmpty().append(stringBuffer.toString());
                                newToken.setOffset(((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), ((PackedTokenAttributeImpl)newEntry.getLast()).endOffset());
                                newEntry.removeLast();
                                newEntry.add(newToken);
                            }
                        }
                    } else if (((PackedTokenAttributeImpl)newEntry.getLast()).startOffset() < replace.startOffset() && ((PackedTokenAttributeImpl)newEntry.getLast()).endOffset() < replace.endOffset()) {
                        if (((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("SYNONYM") && replace.type().equals("SYNONYM")) {
                            positionalSynonymSequencesSet.add((Object)tokenSequence);
                        }
                        newEntry.add(replace);
                        tokenFoundSequence = true;
                    }
                    newAllTokenSequencesSet.add(newEntry);
                }
                if (!tokenFoundSequence) {
                    for (LinkedList tokenSequence : newAllTokenSequencesSet) {
                        newEntry = new LinkedList();
                        newEntry.addAll(tokenSequence);
                        if (((PackedTokenAttributeImpl)newEntry.getLast()).endOffset() == replace.endOffset() && replace.type().equals("SYNONYM")) {
                            if (((PackedTokenAttributeImpl)newEntry.getLast()).startOffset() == replace.startOffset() && ((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("SYNONYM")) {
                                positionalSynonymSequencesSet.add((Object)tokenSequence);
                                newEntry.add(replace);
                                tokenFoundSequence = true;
                                continue;
                            }
                            if (!((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("gram")) continue;
                            if (newEntry.toString().endsWith(replace.toString())) {
                                positionalSynonymSequencesSet.add((Object)tokenSequence);
                                tokenFoundSequence = true;
                                continue;
                            }
                            tokenFoundSequence = true;
                            StringBuffer stringBuffer = new StringBuffer(((PackedTokenAttributeImpl)newEntry.getLast()).toString());
                            stringBuffer.replace(replace.startOffset() - ((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), replace.endOffset() - ((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), replace.toString());
                            newToken = new PackedTokenAttributeImpl();
                            newToken.setEmpty().append(stringBuffer.toString());
                            newToken.setOffset(((PackedTokenAttributeImpl)newEntry.getLast()).startOffset(), ((PackedTokenAttributeImpl)newEntry.getLast()).endOffset());
                            newEntry.removeLast();
                            newEntry.add(newToken);
                            positionalSynonymSequencesSet.add(newEntry);
                            continue;
                        }
                        if (((PackedTokenAttributeImpl)newEntry.getLast()).startOffset() >= replace.startOffset() || ((PackedTokenAttributeImpl)newEntry.getLast()).endOffset() >= replace.endOffset() || !((PackedTokenAttributeImpl)newEntry.getLast()).type().equals("SYNONYM") || !replace.type().equals("SYNONYM")) continue;
                        positionalSynonymSequencesSet.add((Object)tokenSequence);
                        newEntry.add(replace);
                        tokenFoundSequence = true;
                    }
                }
                if (!tokenFoundSequence) {
                    LinkedList<Object> newEntry2 = new LinkedList<Object>();
                    newEntry2.add(replace);
                    newAllTokenSequencesSet.add(newEntry2);
                }
                if (newAllTokenSequencesSet.size() <= 64) continue;
                break;
            }
            allTokenSequencesSet = newAllTokenSequencesSet;
            allTokenSequencesSet.addAll((Collection)positionalSynonymSequencesSet);
        }
        LinkedList allTokenSequences = new LinkedList(allTokenSequencesSet);
        LinkedList<LinkedList<PackedTokenAttributeImpl>> linkedList = new LinkedList<LinkedList<PackedTokenAttributeImpl>>();
        for (Object tokenSequence : allTokenSequences) {
            LinkedList<PackedTokenAttributeImpl> linkedList2 = new LinkedList<PackedTokenAttributeImpl>();
            linkedList.add(linkedList2);
            PackedTokenAttributeImpl replace2 = null;
            replace = ((AbstractSequentialList)tokenSequence).iterator();
            while (replace.hasNext()) {
                String token;
                String language;
                void var35_133;
                StringBuilder prefix;
                PackedTokenAttributeImpl c = (PackedTokenAttributeImpl)replace.next();
                if (replace2 == null) {
                    char test;
                    prefix = new StringBuilder();
                    for (int i = c.startOffset() - 1; i >= 0 && ((test = testText.charAt(i)) == '*' || test == '?') && wildcardPoistions.contains(i); --i) {
                        prefix.insert(0, test);
                    }
                    String pre = prefix.toString();
                    if (requiresMLTokenDuplication) {
                        String termText3 = c.toString();
                        int n3 = termText3.indexOf("}");
                        String language2 = termText3.substring(0, n3 + 1);
                        String token2 = termText3.substring(n3 + 1);
                        replace2 = new PackedTokenAttributeImpl();
                        replace2.setEmpty().append(language2 + pre + token2);
                        replace2.setOffset(c.startOffset() - pre.length(), c.endOffset());
                        replace2.setType(c.type());
                        replace2.setPositionIncrement(c.getPositionIncrement());
                        continue;
                    }
                    String termText2 = c.toString();
                    replace2 = new PackedTokenAttributeImpl();
                    replace2.setEmpty().append(pre + termText2);
                    replace2.setOffset(c.startOffset() - pre.length(), c.endOffset());
                    replace2.setType(c.type());
                    replace2.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                prefix = new StringBuilder();
                StringBuilder postfix = new StringBuilder();
                StringBuilder builder = prefix;
                int n4 = c.startOffset() - 1;
                while (var35_133 >= replace2.endOffset()) {
                    char test = testText.charAt((int)var35_133);
                    if ((test == '*' || test == '?') && wildcardPoistions.contains((int)var35_133)) {
                        builder.insert(0, test);
                    } else {
                        builder = postfix;
                        postfix.setLength(0);
                    }
                    --var35_133;
                }
                String string = prefix.toString();
                String post = postfix.toString();
                if (string.length() > 0 && replace2.endOffset() + string.length() == c.startOffset()) {
                    termText = c.toString();
                    if (requiresMLTokenDuplication) {
                        int position5 = termText.indexOf("}");
                        language = termText.substring(0, position5 + 1);
                        token = termText.substring(position5 + 1);
                        int oldPositionIncrement = replace2.getPositionIncrement();
                        String replaceTermText = replace2.toString();
                        replace2 = new PackedTokenAttributeImpl();
                        replace2.setEmpty().append(replaceTermText + string + token);
                        replace2.setOffset(replace2.startOffset(), c.endOffset());
                        replace2.setType(replace2.type());
                        replace2.setPositionIncrement(oldPositionIncrement);
                        continue;
                    }
                    int oldPositionIncrement = replace2.getPositionIncrement();
                    String replaceTermText = replace2.toString();
                    replace2 = new PackedTokenAttributeImpl();
                    replace2.setEmpty().append(replaceTermText + string + termText);
                    replace2.setOffset(replace2.startOffset(), c.endOffset());
                    replace2.setType(replace2.type());
                    replace2.setPositionIncrement(oldPositionIncrement);
                    continue;
                }
                termText = c.toString();
                if (requiresMLTokenDuplication) {
                    int position6 = termText.indexOf("}");
                    language = termText.substring(0, position6 + 1);
                    token = termText.substring(position6 + 1);
                    String replaceTermText = replace2.toString();
                    PackedTokenAttributeImpl last = new PackedTokenAttributeImpl();
                    last.setEmpty().append(replaceTermText + post);
                    last.setOffset(replace2.startOffset(), replace2.endOffset() + post.length());
                    last.setType(replace2.type());
                    last.setPositionIncrement(replace2.getPositionIncrement());
                    linkedList2.add(last);
                    replace2 = new PackedTokenAttributeImpl();
                    replace2.setEmpty().append(language + string + token);
                    replace2.setOffset(c.startOffset() - string.length(), c.endOffset());
                    replace2.setType(c.type());
                    replace2.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                String replaceTermText = replace2.toString();
                PackedTokenAttributeImpl last = new PackedTokenAttributeImpl();
                last.setEmpty().append(replaceTermText + post);
                last.setOffset(replace2.startOffset(), replace2.endOffset() + post.length());
                last.setType(replace2.type());
                last.setPositionIncrement(replace2.getPositionIncrement());
                linkedList2.add(last);
                replace2 = new PackedTokenAttributeImpl();
                replace2.setEmpty().append(string + termText);
                replace2.setOffset(c.startOffset() - string.length(), c.endOffset());
                replace2.setType(c.type());
                replace2.setPositionIncrement(c.getPositionIncrement());
            }
            if (replace2 == null) continue;
            StringBuilder postfix = new StringBuilder();
            if (replace2.endOffset() >= 0 && replace2.endOffset() < testText.length()) {
                char test;
                for (int i = replace2.endOffset(); i < testText.length() && ((test = testText.charAt(i)) == '*' || test == '?') && wildcardPoistions.contains(i); ++i) {
                    postfix.append(test);
                }
            }
            String post = postfix.toString();
            int oldPositionIncrement = replace2.getPositionIncrement();
            String replaceTermText = replace2.toString();
            PackedTokenAttributeImpl terminal = new PackedTokenAttributeImpl();
            terminal.setEmpty().append(replaceTermText + post);
            terminal.setOffset(replace2.startOffset(), replace2.endOffset() + post.length());
            terminal.setType(replace2.type());
            terminal.setPositionIncrement(oldPositionIncrement);
            linkedList2.add(terminal);
        }
        ArrayList<PackedTokenAttributeImpl> fixed = new ArrayList<PackedTokenAttributeImpl>();
        for (LinkedList linkedList3 : linkedList) {
            for (PackedTokenAttributeImpl token : linkedList3) {
                fixed.add(token);
            }
        }
        Collections.sort(fixed, new Comparator<PackedTokenAttributeImpl>(){

            @Override
            public int compare(PackedTokenAttributeImpl o1, PackedTokenAttributeImpl o2) {
                int dif = o1.startOffset() - o2.startOffset();
                if (dif != 0) {
                    return dif;
                }
                return o1.getPositionIncrement() - o2.getPositionIncrement();
            }
        });
        OrderedHashSet unique = new OrderedHashSet();
        unique.addAll(fixed);
        fixed = new ArrayList(unique);
        list = fixed;
        if (localePrefix.length() > 0) {
            void var28_94;
            boolean bl = false;
            while (var28_94 < list.size()) {
                PackedTokenAttributeImpl currentToken = (PackedTokenAttributeImpl)list.get((int)var28_94);
                String termText4 = currentToken.toString();
                currentToken.setEmpty();
                currentToken.append(localePrefix + termText4);
                ++var28_94;
            }
        }
        SchemaField schemaField2 = this.schema.getField(field);
        boolean isShingled = false;
        TokenizerChain tokenizerChain2 = tokenizerChain = schemaField2.getType().getQueryAnalyzer() instanceof TokenizerChain ? (TokenizerChain)schemaField2.getType().getQueryAnalyzer() : null;
        if (tokenizerChain != null) {
            for (TokenFilterFactory factory : tokenizerChain.getTokenFilterFactories()) {
                if (!(factory instanceof ShingleFilterFactory)) continue;
                isShingled = true;
                break;
            }
        }
        AlfrescoAnalyzerWrapper alfrescoAnalyzerWrapper = analyzerWrapper = schemaField2.getType().getQueryAnalyzer() instanceof AlfrescoAnalyzerWrapper ? (AlfrescoAnalyzerWrapper)schemaField2.getType().getQueryAnalyzer() : null;
        if (analyzerWrapper != null) {
            isShingled = true;
        }
        boolean bl = forceConjuncion = this.rerankPhase == FTSQueryParser.RerankPhase.QUERY_PHASE && !this.isExactTermSearch(analysisMode);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            boolean isNotNumberType;
            PackedTokenAttributeImpl nextToken = (PackedTokenAttributeImpl)list.get(0);
            String termText5 = nextToken.toString();
            boolean bl2 = isNotNumberType = schemaFieldNumberType == null;
            if (isNotNumberType && (termText5.contains("*") || termText5.contains("?"))) {
                return this.newWildcardQuery(new Term(field, termText5));
            }
            return this.newTermQuery(new Term(field, termText5));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery.Builder q = this.newBooleanQuery();
                for (int i = 0; i < list.size(); ++i) {
                    void var35_137;
                    PackedTokenAttributeImpl nextToken = list.get(i);
                    String termText6 = nextToken.toString();
                    if (termText6.contains("*") || termText6.contains("?")) {
                        Query query = this.newWildcardQuery(new Term(field, termText6));
                    } else {
                        Query query = this.newTermQuery(new Term(field, termText6));
                    }
                    q.add((Query)var35_137, BooleanClause.Occur.SHOULD);
                }
                return q.build();
            }
            if (forceConjuncion) {
                BooleanQuery.Builder or = new BooleanQuery.Builder();
                for (LinkedList linkedList4 : linkedList) {
                    and = new BooleanQuery.Builder();
                    for (int i = 0; i < linkedList4.size(); ++i) {
                        PackedTokenAttributeImpl nextToken = (PackedTokenAttributeImpl)linkedList4.get(i);
                        String termText7 = nextToken.toString();
                        term = new Term(field, termText7);
                        if (termText7 != null && (termText7.contains("*") || termText7.contains("?"))) {
                            wildQuery = new org.apache.lucene.search.WildcardQuery(term);
                            and.add((Query)wildQuery, BooleanClause.Occur.MUST);
                            continue;
                        }
                        termQuery = new TermQuery(term);
                        and.add((Query)termQuery, BooleanClause.Occur.MUST);
                    }
                    if (and.build().clauses().size() <= 0) continue;
                    or.add((Query)and.build(), BooleanClause.Occur.SHOULD);
                }
                return or.build();
            }
            if (schemaField2.omitPositions() && isShingled) {
                ArrayList<PackedTokenAttributeImpl> nonContained = this.getNonContained(list);
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (PackedTokenAttributeImpl shingleToken : nonContained) {
                    String termText8 = shingleToken.toString();
                    term = new Term(field, termText8);
                    Object currentQuery = termText8 != null && (termText8.contains("*") || termText8.contains("?")) ? new org.apache.lucene.search.WildcardQuery(term) : new TermQuery(term);
                    builder.add((Query)currentQuery, BooleanClause.Occur.MUST);
                }
                return builder.build();
            }
            return this.generateSpanOrQuery(field, linkedList);
        }
        if (forceConjuncion) {
            BooleanQuery.Builder or = new BooleanQuery.Builder();
            for (LinkedList linkedList5 : linkedList) {
                and = new BooleanQuery.Builder();
                for (int i = 0; i < linkedList5.size(); ++i) {
                    PackedTokenAttributeImpl nextToken = (PackedTokenAttributeImpl)linkedList5.get(i);
                    String termText9 = nextToken.toString();
                    term = new Term(field, termText9);
                    if (termText9 != null && (termText9.contains("*") || termText9.contains("?"))) {
                        wildQuery = new org.apache.lucene.search.WildcardQuery(term);
                        and.add((Query)wildQuery, BooleanClause.Occur.MUST);
                        continue;
                    }
                    termQuery = new TermQuery(term);
                    and.add((Query)termQuery, BooleanClause.Occur.MUST);
                }
                if (and.build().clauses().size() <= 0) continue;
                or.add((Query)and.build(), BooleanClause.Occur.SHOULD);
            }
            return or.build();
        }
        Object spanQuery = null;
        ArrayList<SpanTermQuery> atSamePositionSpanOrQueryParts = new ArrayList<SpanTermQuery>();
        boolean bl3 = false;
        for (int i = 0; i < list.size(); ++i) {
            SpanTermQuery nextSpanQuery;
            SpanMultiTermQueryWrapper wrapper;
            PackedTokenAttributeImpl nextToken = list.get(i);
            termText = nextToken.toString();
            Term term2 = new Term(field, termText);
            if (this.getEnablePositionIncrements()) {
                if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                    wildQuery = new org.apache.lucene.search.WildcardQuery(term2);
                    wrapper = new SpanMultiTermQueryWrapper((MultiTermQuery)wildQuery);
                    wrapper.setRewriteMethod((SpanMultiTermQueryWrapper.SpanRewriteMethod)new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(this.topTermSpanRewriteLimit));
                    nextSpanQuery = wrapper;
                } else {
                    nextSpanQuery = new SpanTermQuery(term2);
                }
                if (n == 0) {
                    atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                } else if (atSamePositionSpanOrQueryParts.size() == 0) {
                    spanQuery = spanQuery == null ? nextSpanQuery : new SpanNearQuery(new SpanQuery[]{spanQuery, nextSpanQuery}, n - 1 + this.internalSlop, this.internalSlop < 2);
                    atSamePositionSpanOrQueryParts = new ArrayList();
                } else if (atSamePositionSpanOrQueryParts.size() == 1) {
                    spanQuery = spanQuery == null ? (SpanQuery)atSamePositionSpanOrQueryParts.get(0) : new SpanNearQuery(new SpanQuery[]{spanQuery, (SpanQuery)atSamePositionSpanOrQueryParts.get(0)}, n - 1 + this.internalSlop, this.internalSlop < 2);
                    atSamePositionSpanOrQueryParts = new ArrayList();
                    atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                } else {
                    spanQuery = spanQuery == null ? new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0])) : new SpanNearQuery(new SpanQuery[]{spanQuery, new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0]))}, n - 1 + this.internalSlop, this.internalSlop < 2);
                    atSamePositionSpanOrQueryParts = new ArrayList();
                    atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                }
                n = nextToken.getPositionIncrement();
                continue;
            }
            if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                wildQuery = new org.apache.lucene.search.WildcardQuery(term2);
                wrapper = new SpanMultiTermQueryWrapper((MultiTermQuery)wildQuery);
                wrapper.setRewriteMethod((SpanMultiTermQueryWrapper.SpanRewriteMethod)new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(this.topTermSpanRewriteLimit));
                nextSpanQuery = wrapper;
            } else {
                nextSpanQuery = new SpanTermQuery(term2);
            }
            spanQuery = spanQuery == null ? new SpanOrQuery(new SpanQuery[]{nextSpanQuery}) : new SpanOrQuery(new SpanQuery[]{spanQuery, nextSpanQuery});
        }
        if (atSamePositionSpanOrQueryParts.size() == 0) {
            return spanQuery;
        }
        if (atSamePositionSpanOrQueryParts.size() == 1) {
            spanQuery = spanQuery == null ? (SpanQuery)atSamePositionSpanOrQueryParts.get(0) : new SpanNearQuery(new SpanQuery[]{spanQuery, (SpanQuery)atSamePositionSpanOrQueryParts.get(0)}, (int)(n - true + this.internalSlop), this.internalSlop < 2);
            return spanQuery;
        }
        spanQuery = spanQuery == null ? new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0])) : new SpanNearQuery(new SpanQuery[]{spanQuery, new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0]))}, (int)(n - true + this.internalSlop), this.internalSlop < 2);
        return spanQuery;
    }

    private boolean isNonParsableNumberType(NumberType schemaFieldNumberType, String queryText) {
        boolean isNotDate;
        boolean isNumberType = schemaFieldNumberType != null;
        boolean bl = isNotDate = schemaFieldNumberType != NumberType.DATE;
        if (isNumberType && isNotDate) {
            try {
                Double.parseDouble(queryText);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    private ArrayList<PackedTokenAttributeImpl> getNonContained(ArrayList<PackedTokenAttributeImpl> list) {
        ArrayList<PackedTokenAttributeImpl> nonContained = new ArrayList<PackedTokenAttributeImpl>();
        block0: for (PackedTokenAttributeImpl candidate : list) {
            for (PackedTokenAttributeImpl test : list) {
                if (candidate == test || test.startOffset() == candidate.startOffset() && candidate.endOffset() == test.endOffset() && test.toString().equals(candidate.toString()) || test.startOffset() > candidate.startOffset() || candidate.endOffset() > test.endOffset() || !test.toString().contains(candidate.toString())) continue;
                continue block0;
            }
            nonContained.add(candidate);
        }
        return nonContained;
    }

    protected SpanQuery generateSpanOrQuery(String field, LinkedList<LinkedList<PackedTokenAttributeImpl>> fixedTokenSequences) {
        ArrayList<SpanQuery> spanOrQueryParts = new ArrayList<SpanQuery>();
        for (LinkedList linkedList : fixedTokenSequences) {
            int gap = 1;
            Object spanQuery = null;
            ArrayList<SpanQuery> atSamePositionSpanOrQueryParts = new ArrayList<SpanQuery>();
            if (this.getEnablePositionIncrements() && this.isAllTokensSequentiallyShifted(linkedList)) {
                ArrayList<SpanQuery> wildWrappedList = new ArrayList<SpanQuery>(linkedList.size());
                for (PackedTokenAttributeImpl token : linkedList) {
                    String termText = token.toString();
                    Term term = new Term(field, termText);
                    SpanQuery nextSpanQuery = this.wrapWildcardTerms(term);
                    wildWrappedList.add(nextSpanQuery);
                }
                spanQuery = wildWrappedList.size() == 1 ? (SpanQuery)wildWrappedList.get(0) : new SpanNearQuery(wildWrappedList.toArray(new SpanQuery[wildWrappedList.size()]), 0, true);
            } else {
                for (int i = 0; i < linkedList.size(); ++i) {
                    SpanQuery nextSpanQuery;
                    PackedTokenAttributeImpl nextToken = (PackedTokenAttributeImpl)linkedList.get(i);
                    String termText = nextToken.toString();
                    Term term = new Term(field, termText);
                    if (this.getEnablePositionIncrements()) {
                        nextSpanQuery = this.wrapWildcardTerms(term);
                        if (gap == 0) {
                            atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                        } else if (atSamePositionSpanOrQueryParts.size() == 0) {
                            spanQuery = spanQuery == null ? nextSpanQuery : new SpanNearQuery(new SpanQuery[]{spanQuery, nextSpanQuery}, gap - 1 + this.internalSlop, this.internalSlop < 2);
                            atSamePositionSpanOrQueryParts = new ArrayList();
                        } else if (atSamePositionSpanOrQueryParts.size() == 1) {
                            spanQuery = spanQuery == null ? (SpanQuery)atSamePositionSpanOrQueryParts.get(0) : new SpanNearQuery(new SpanQuery[]{spanQuery, (SpanQuery)atSamePositionSpanOrQueryParts.get(0)}, gap - 1 + this.internalSlop, this.internalSlop < 2);
                            atSamePositionSpanOrQueryParts = new ArrayList();
                            atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                        } else {
                            spanQuery = spanQuery == null ? new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0])) : new SpanNearQuery(new SpanQuery[]{spanQuery, spanQuery = new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0]))}, gap - 1 + this.internalSlop, this.internalSlop < 2);
                            atSamePositionSpanOrQueryParts = new ArrayList();
                            atSamePositionSpanOrQueryParts.add(nextSpanQuery);
                        }
                        gap = nextToken.getPositionIncrement();
                        continue;
                    }
                    if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                        org.apache.lucene.search.WildcardQuery wildQuery = new org.apache.lucene.search.WildcardQuery(term);
                        SpanMultiTermQueryWrapper wrapper = new SpanMultiTermQueryWrapper((MultiTermQuery)wildQuery);
                        wrapper.setRewriteMethod((SpanMultiTermQueryWrapper.SpanRewriteMethod)new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(this.topTermSpanRewriteLimit));
                        nextSpanQuery = wrapper;
                    } else {
                        nextSpanQuery = new SpanTermQuery(term);
                    }
                    spanQuery = spanQuery == null ? new SpanOrQuery(new SpanQuery[]{nextSpanQuery}) : new SpanOrQuery(new SpanQuery[]{spanQuery, nextSpanQuery});
                }
            }
            if (atSamePositionSpanOrQueryParts.size() == 0) {
                spanOrQueryParts.add((SpanQuery)spanQuery);
                continue;
            }
            if (atSamePositionSpanOrQueryParts.size() == 1) {
                spanQuery = spanQuery == null ? (SpanQuery)atSamePositionSpanOrQueryParts.get(0) : new SpanNearQuery(new SpanQuery[]{spanQuery, (SpanQuery)atSamePositionSpanOrQueryParts.get(0)}, gap - 1 + this.internalSlop, this.internalSlop < 2);
                atSamePositionSpanOrQueryParts = new ArrayList();
                spanOrQueryParts.add((SpanQuery)spanQuery);
                continue;
            }
            spanQuery = spanQuery == null ? new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0])) : new SpanNearQuery(new SpanQuery[]{spanQuery, new SpanOrQuery(atSamePositionSpanOrQueryParts.toArray(new SpanQuery[0]))}, gap - 1 + this.internalSlop, this.internalSlop < 2);
            atSamePositionSpanOrQueryParts = new ArrayList();
            spanOrQueryParts.add((SpanQuery)spanQuery);
        }
        if (spanOrQueryParts.size() == 1) {
            return (SpanQuery)spanOrQueryParts.get(0);
        }
        return new SpanOrQuery(spanOrQueryParts.toArray(new SpanQuery[0]));
    }

    private SpanQuery wrapWildcardTerms(Term term) {
        SpanTermQuery nextSpanQuery;
        String termText = term.text();
        if (termText != null && (termText.contains("*") || termText.contains("?"))) {
            org.apache.lucene.search.WildcardQuery wildQuery = new org.apache.lucene.search.WildcardQuery(term);
            SpanMultiTermQueryWrapper wrapper = new SpanMultiTermQueryWrapper((MultiTermQuery)wildQuery);
            wrapper.setRewriteMethod((SpanMultiTermQueryWrapper.SpanRewriteMethod)new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(this.topTermSpanRewriteLimit));
            nextSpanQuery = wrapper;
        } else {
            nextSpanQuery = new SpanTermQuery(term);
        }
        return nextSpanQuery;
    }

    protected boolean isAllTokensSequentiallyShifted(List<PackedTokenAttributeImpl> tokenSequence) {
        if (0 == this.internalSlop) {
            for (PackedTokenAttributeImpl tokenToCheck : tokenSequence) {
                if (1 == tokenToCheck.getPositionIncrement()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Integer> getWildcardPositions(String string) {
        HashSet<Integer> wildcardPositions = new HashSet<Integer>();
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (c == '*') {
                wildcardPositions.add(i);
                continue;
            }
            if (c != '?') continue;
            wildcardPositions.add(i);
        }
        return wildcardPositions;
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, startInclusive, endInclusive, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, inclusive, inclusive, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
    }

    public Query getRangeQuery(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        if (field.equals("PATH")) {
            throw new UnsupportedOperationException("Range Queries are not support for PATH");
        }
        if (field.equals("PATHWITHREPEATS")) {
            throw new UnsupportedOperationException("Range Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals("TEXT")) {
            return this.createDefaultTextQuery(textField -> this.getRangeQuery((String)textField, part1, part2, includeLower, includeUpper, analysisMode, luceneFunction));
        }
        if (field.equals("CASCADETX")) {
            SchemaField sf = this.schema.getField("CASCADETX");
            if (sf != null) {
                String start = null;
                try {
                    this.analyzeMultitermTerm("CASCADETX", part1);
                    start = part1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String end = null;
                try {
                    this.analyzeMultitermTerm("CASCADETX", part2);
                    end = part2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return sf.getType().getRangeQuery(null, sf, start, end, includeLower, includeUpper);
            }
            throw new UnsupportedOperationException();
        }
        if (this.isPropertyField(field)) {
            Pair fieldNameAndEnding = QueryParserUtils.extractFieldNameAndEnding((String)field);
            String expandedFieldName = null;
            PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)((String)fieldNameAndEnding.getFirst()));
            IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
            if (propertyDef != null) {
                tokenisationMode = propertyDef.getIndexTokenisationMode();
                if (tokenisationMode == null) {
                    tokenisationMode = IndexTokenisationMode.TRUE;
                }
            } else {
                expandedFieldName = this.expandAttributeFieldName(field);
            }
            if (propertyDef != null) {
                if (luceneFunction != LuceneFunction.FIELD) {
                    if (!(luceneFunction != LuceneFunction.LOWER || part1.toLowerCase().equals(part1) && part2.toLowerCase().equals(part2))) {
                        return this.createNoMatchQuery();
                    }
                    if (!(luceneFunction != LuceneFunction.UPPER || part1.toUpperCase().equals(part1) && part2.toUpperCase().equals(part2))) {
                        return this.createNoMatchQuery();
                    }
                    if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                        List locales = this.searchParameters.getLocales();
                        ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
                        for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                            expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
                        }
                        for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                            this.addLocaleSpecificUntokenisedTextRangeFunction(expandedFieldName, propertyDef, part1, part2, includeLower, includeUpper, luceneFunction, booleanQuery, locale, tokenisationMode);
                        }
                        return booleanQuery.build();
                    }
                    throw new UnsupportedOperationException("Lucene Function");
                }
                if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                    return this.buildTextMLTextOrContentRange(field, part1, part2, includeLower, includeUpper, analysisMode, expandedFieldName, propertyDef, tokenisationMode);
                }
                if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                    String solrField = null;
                    switch ((String)fieldNameAndEnding.getSecond()) {
                        case ".size": {
                            solrField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_SIZE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField();
                            break;
                        }
                        case ".mimetype": {
                            solrField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_MIMETYPE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField();
                            break;
                        }
                        case ".encoding": {
                            solrField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_ENCODING, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField();
                            break;
                        }
                        case ".locale": {
                            solrField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_LOCALE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField();
                        }
                    }
                    if (solrField != null) {
                        String start = null;
                        try {
                            this.analyzeMultitermTerm(solrField, part1);
                            start = part1;
                        }
                        catch (Exception expandedLocales) {
                            // empty catch block
                        }
                        String end = null;
                        try {
                            this.analyzeMultitermTerm(solrField, part2);
                            end = part2;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SchemaField sf = this.schema.getField(solrField);
                        return sf.getType().getRangeQuery(null, sf, start, end, includeLower, includeUpper);
                    }
                    return this.buildTextMLTextOrContentRange(field, part1, part2, includeLower, includeUpper, analysisMode, expandedFieldName, propertyDef, tokenisationMode);
                }
                if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                    return this.buildTextMLTextOrContentRange(field, part1, part2, includeLower, includeUpper, analysisMode, expandedFieldName, propertyDef, tokenisationMode);
                }
                if ((propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATE)) && !AlfrescoSolrDataModel.getInstance().isDerivedDateField((String)fieldNameAndEnding.getSecond())) {
                    Pair<Date, Integer> dateAndResolution1 = this.parseDateString(part1);
                    Pair<Date, Integer> dateAndResolution2 = this.parseDateString(part2);
                    BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
                    AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), null, AlfrescoSolrDataModel.FieldUse.ID);
                    for (AlfrescoSolrDataModel.FieldInstance instance : indexedField.getFields()) {
                        SchemaField sf;
                        Query query;
                        String end;
                        String start;
                        String string = dateAndResolution1 == null ? part1 : (start = includeLower ? this.getDateStart(dateAndResolution1) : this.getDateEnd(dateAndResolution1));
                        String string2 = dateAndResolution2 == null ? part2 : (end = includeUpper ? this.getDateEnd(dateAndResolution2) : this.getDateStart(dateAndResolution2));
                        if (start.equals("*")) {
                            start = null;
                        }
                        if (end.equals("*")) {
                            end = null;
                        }
                        if ((query = (sf = this.schema.getField(instance.getField())).getType().getRangeQuery(null, sf, start, end, includeLower, includeUpper)) == null) continue;
                        bQuery.add(query, BooleanClause.Occur.SHOULD);
                    }
                    return bQuery.build();
                }
                String solrField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), AlfrescoSolrDataModel.getInstance().getTextField((String)fieldNameAndEnding.getSecond()), AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField();
                String start = null;
                try {
                    this.analyzeMultitermTerm(solrField, part1);
                    start = part1;
                }
                catch (Exception bQuery) {
                    // empty catch block
                }
                String end = null;
                try {
                    this.analyzeMultitermTerm(solrField, part2);
                    end = part2;
                }
                catch (Exception indexedField) {
                    // empty catch block
                }
                SchemaField sf = this.schema.getField(solrField);
                return sf.getType().getRangeQuery(null, sf, start, end, includeLower, includeUpper);
            }
            throw new UnsupportedOperationException();
        }
        if (field.equals("ALL")) {
            Set all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (QName qname : contentAttributes) {
                    Query part = this.getRangeQuery("@" + qname.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String fieldName : all) {
                Query part = this.getRangeQuery(fieldName, part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
            Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (QName qname : contentAttributes) {
                Query part = this.getRangeQuery("@" + qname.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("TAG")) {
            throw new UnsupportedOperationException("Range Queries are not support for TAG");
        }
        throw new UnsupportedOperationException();
    }

    private Query buildTextMLTextOrContentRange(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode) throws ParseException {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        List locales = this.searchParameters.getLocales();
        ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
        for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
            expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
        }
        for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
            try {
                this.addTextRange(field, propertyDef, part1, part2, includeLower, includeUpper, analysisMode, expandedFieldName, propertyDef, tokenisationMode, booleanQuery, locale);
            }
            catch (IOException e) {
                throw new ParseException("Failed to tokenise: <" + part1 + "> or <" + part2 + ">   for " + String.valueOf(propertyDef.getName()));
            }
        }
        return booleanQuery.build();
    }

    private String expandAttributeFieldName(String field) {
        return "@" + QueryParserUtils.expandQName((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (String)field.substring(1));
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected String getToken(String field, String value, AnalysisMode analysisMode) throws ParseException {
        String string;
        block13: {
            TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(value));
            try {
                String tokenised = null;
                while (source.incrementToken()) {
                    CharTermAttribute cta = (CharTermAttribute)source.getAttribute(CharTermAttribute.class);
                    OffsetAttribute offsetAtt = (OffsetAttribute)source.getAttribute(OffsetAttribute.class);
                    TypeAttribute typeAtt = null;
                    if (source.hasAttribute(TypeAttribute.class)) {
                        typeAtt = (TypeAttribute)source.getAttribute(TypeAttribute.class);
                    }
                    PositionIncrementAttribute posIncAtt = null;
                    if (source.hasAttribute(PositionIncrementAttribute.class)) {
                        posIncAtt = (PositionIncrementAttribute)source.getAttribute(PositionIncrementAttribute.class);
                    }
                    PackedTokenAttributeImpl token = new PackedTokenAttributeImpl();
                    token.setEmpty().copyBuffer(cta.buffer(), 0, cta.length());
                    token.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
                    if (typeAtt != null) {
                        token.setType(typeAtt.type());
                    }
                    if (posIncAtt != null) {
                        token.setPositionIncrement(posIncAtt.getPositionIncrement());
                    }
                    tokenised = token.toString();
                }
                string = tokenised;
                if (source == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ParseException("IO" + e.getMessage());
                }
            }
            source.close();
        }
        return string;
    }

    public Query getPrefixQuery(String field, String termStr) throws ParseException {
        return this.getPrefixQuery(field, termStr, AnalysisMode.PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"deprecation"})
    public Query getPrefixQuery(String field, String termStr, AnalysisMode analysisMode) throws ParseException {
        if (field.equals("PATH")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for PATH");
        }
        if (field.equals("PATHWITHREPEATS")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals("TEXT")) {
            return this.createDefaultTextQuery(textField -> this.getPrefixQuery((String)textField, termStr, analysisMode));
        }
        if (field.equals("ID")) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getPrefixQuery("LID", termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals("DBID") || field.equals("ISROOT") || field.equals("ISCONTAINER") || field.equals("ISNODE") || field.equals("TX") || field.equals("PARENT") || field.equals("PRIMARYPARENT") || field.equals("QNAME") || field.equals("PRIMARYASSOCTYPEQNAME") || field.equals("ASSOCTYPEQNAME")) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getPrefixQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals("CLASS")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("TYPE")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("EXACTTYPE")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("ASPECT")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("EXACTASPECT")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (this.isPropertyField(field)) {
            return this.attributeQueryBuilder(field, termStr, new PrefixQuery(), analysisMode, LuceneFunction.FIELD);
        }
        if (field.equals("ALL")) {
            Set all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (QName qname : contentAttributes) {
                    Query part = this.getPrefixQuery("@" + qname.toString(), termStr, analysisMode);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String fieldName : all) {
                Query part = this.getPrefixQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("ISUNSET")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISUNSET");
        }
        if (field.equals("ISNULL")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISNULL");
        }
        if (field.equals("ISNOTNULL")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISNOTNULL");
        }
        if (field.equals("EXISTS")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for EXISTS");
        }
        if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
            Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (QName qname : contentAttributes) {
                Query part = this.getPrefixQuery("@" + qname.toString(), termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("FTSSTATUS")) {
            throw new UnsupportedOperationException("Prefix Queries are not support for FTSSTATUS");
        }
        if (field.equals("TAG")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("SITE")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("NPATH")) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals("PNAME")) {
            return super.getPrefixQuery(field, termStr);
        }
        return super.getPrefixQuery(field, termStr);
    }

    public Query getWildcardQuery(String field, String termStr) throws ParseException {
        return this.getWildcardQuery(field, termStr, AnalysisMode.WILD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"deprecation"})
    public Query getWildcardQuery(String field, String termStr, AnalysisMode analysisMode) throws ParseException {
        if (field.equals("PATH")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for PATH");
        }
        if (field.equals("PATHWITHREPEATS")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals("TEXT")) {
            return this.createDefaultTextQuery(textField -> this.getWildcardQuery((String)textField, termStr, analysisMode));
        }
        if (field.equals("ID")) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getWildcardQuery("LID", termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals("DBID") || field.equals("ISROOT") || field.equals("ISCONTAINER") || field.equals("ISNODE") || field.equals("TX") || field.equals("PARENT") || field.equals("PRIMARYPARENT") || field.equals("QNAME") || field.equals("PRIMARYASSOCTYPEQNAME") || field.equals("ASSOCTYPEQNAME")) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getWildcardQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals("CLASS")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("TYPE")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("EXACTTYPE")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("ASPECT")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("EXACTASPECT")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (this.isPropertyField(field)) {
            return this.attributeQueryBuilder(field, termStr, new WildcardQuery(), analysisMode, LuceneFunction.FIELD);
        }
        if (field.equals("ALL")) {
            Set all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (QName qname : contentAttributes) {
                    Query part = this.getWildcardQuery("@" + qname.toString(), termStr, analysisMode);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String fieldName : all) {
                Query part = this.getWildcardQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("ISUNSET")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISUNSET");
        }
        if (field.equals("ISNULL")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISNULL");
        }
        if (field.equals("ISNOTNULL")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISNOTNULL");
        }
        if (field.equals("EXISTS")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for EXISTS");
        }
        if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
            Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (QName qname : contentAttributes) {
                Query part = this.getWildcardQuery("@" + qname.toString(), termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("FTSSTATUS")) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for FTSSTATUS");
        }
        if (field.equals("TAG")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("SITE")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("PNAME")) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals("NPATH")) {
            return super.getWildcardQuery(field, termStr);
        }
        return super.getWildcardQuery(field, termStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"deprecation"})
    public Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field.equals("PATH")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for PATH");
        }
        if (field.equals("PATHWITHREPEATS")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals("TEXT")) {
            return this.createDefaultTextQuery(textField -> this.getFuzzyQuery((String)textField, termStr, minSimilarity));
        }
        if (field.equals("ID") || field.equals("DBID") || field.equals("ISROOT") || field.equals("ISCONTAINER") || field.equals("ISNODE") || field.equals("TX") || field.equals("PARENT") || field.equals("PRIMARYPARENT") || field.equals("QNAME") || field.equals("PRIMARYASSOCTYPEQNAME") || field.equals("ASSOCTYPEQNAME")) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getFuzzyQuery(field, termStr, minSimilarity);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals("CLASS")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for CLASS");
        }
        if (field.equals("TYPE")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for TYPE");
        }
        if (field.equals("EXACTTYPE")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for EXACTTYPE");
        }
        if (field.equals("ASPECT")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ASPECT");
        }
        if (field.equals("EXACTASPECT")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for EXACTASPECT");
        }
        if (this.isPropertyField(field)) {
            return this.attributeQueryBuilder(field, termStr, new FuzzyQuery(minSimilarity), AnalysisMode.FUZZY, LuceneFunction.FIELD);
        }
        if (field.equals("ALL")) {
            Set all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (QName qname : contentAttributes) {
                    Query part = this.getFuzzyQuery("@" + qname.toString(), termStr, minSimilarity);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String fieldName : all) {
                Query part = this.getFuzzyQuery(fieldName, termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("ISUNSET")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISUNSET");
        }
        if (field.equals("ISNULL")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISNULL");
        }
        if (field.equals("ISNOTNULL")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISNOTNULL");
        }
        if (field.equals("EXISTS")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for EXISTS");
        }
        if (QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field) != null) {
            Collection contentAttributes = this.dictionaryService.getAllProperties(QueryParserUtils.matchDataTypeDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)field).getName());
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (QName qname : contentAttributes) {
                Query part = this.getFuzzyQuery("@" + qname.toString(), termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
        if (field.equals("FTSSTATUS")) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for FTSSTATUS");
        }
        if (field.equals("TAG")) {
            return super.getFuzzyQuery(field, termStr, minSimilarity);
        }
        if (field.equals("SITE")) {
            return super.getFuzzyQuery(field, termStr, minSimilarity);
        }
        if (field.equals("PNAME")) {
            return super.getFuzzyQuery(field, termStr, minSimilarity);
        }
        if (field.equals("NPATH")) {
            return super.getFuzzyQuery(field, termStr, minSimilarity);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Query getSuperFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped(field, queryText, analysisMode, luceneFunction);
    }

    public Query getSuperFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public Query getSuperPrefixQuery(String field, String termStr) throws ParseException {
        return super.getPrefixQuery(field, termStr);
    }

    public Query getSuperWildcardQuery(String field, String termStr) throws ParseException {
        return super.getWildcardQuery(field, termStr);
    }

    protected Query newWildcardQuery(Term t) {
        if (t.text().equals("*")) {
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            bQuery.add(this.createTermQuery("FIELDS", t.field()), BooleanClause.Occur.SHOULD);
            bQuery.add(this.createTermQuery("PROPERTIES", t.field()), BooleanClause.Occur.SHOULD);
            return bQuery.build();
        }
        if (t.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_REGEX, (String)t.text());
            return new RegexpQuery(new Term(t.field(), regexp));
        }
        org.apache.lucene.search.WildcardQuery query = new org.apache.lucene.search.WildcardQuery(t);
        query.setRewriteMethod((MultiTermQuery.RewriteMethod)new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(this.topTermSpanRewriteLimit));
        return query;
    }

    protected Query newPrefixQuery(Term prefix) {
        if (prefix.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_REGEX, (String)prefix.text());
            return new RegexpQuery(new Term(prefix.field(), regexp));
        }
        return super.newPrefixQuery(prefix);
    }

    private String translateLocale(String localised) {
        if (localised.startsWith("\u0000")) {
            if (localised.startsWith("\u0000\u0000")) {
                if (localised.length() < 3) {
                    return "";
                }
                return localised.substring(2);
            }
            int end = localised.indexOf(0, 1);
            if (end == -1) {
                return localised;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            buffer.append(localised.substring(1, end));
            buffer.append("}");
            buffer.append(localised.substring(end + 1));
            return buffer.toString();
        }
        return localised;
    }

    private Query spanQueryBuilder(String field, String first, String last, int slop, boolean inOrder) throws ParseException {
        String propertyFieldName = field.substring(1);
        String expandedFieldName = null;
        PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)propertyFieldName);
        IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
        if (propertyDef != null) {
            tokenisationMode = propertyDef.getIndexTokenisationMode();
            if (tokenisationMode == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
        } else {
            expandedFieldName = this.expandAttributeFieldName(field);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addMLTextSpanQuery(field, propertyDef, first, last, slop, inOrder, expandedFieldName, propertyDef, tokenisationMode, booleanQuery, locale);
            }
            return booleanQuery.build();
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)this.addContentCrossLocaleWildcards()));
            }
            return this.addContentSpanQuery(field, propertyDef, first, last, slop, inOrder, expandedFieldName, expandedLocales);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addTextSpanQuery(field, propertyDef, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, locale);
            }
            return booleanQuery.build();
        }
        throw new UnsupportedOperationException("Span queries are only supported for d:text, d:mltext and d:content data types");
    }

    private Query attributeQueryBuilder(String field, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        QName propertyQName;
        Pair fieldNameAndEnding = QueryParserUtils.extractFieldNameAndEnding((String)field);
        String expandedFieldName = null;
        PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)this.searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespacePrefixResolver, (DictionaryService)this.dictionaryService, (String)((String)fieldNameAndEnding.getFirst()));
        IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
        if (propertyDef != null) {
            tokenisationMode = propertyDef.getIndexTokenisationMode();
            if (tokenisationMode == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            propertyQName = propertyDef.getName();
        } else {
            expandedFieldName = this.expandAttributeFieldName(field);
            propertyQName = QName.createQName((String)((String)fieldNameAndEnding.getFirst()));
        }
        if (this.isAllStar(queryText)) {
            return this.createTermQuery("PROPERTIES", propertyQName.toString());
        }
        if (luceneFunction != LuceneFunction.FIELD && (tokenisationMode == IndexTokenisationMode.FALSE || tokenisationMode == IndexTokenisationMode.BOTH)) {
            if (luceneFunction == LuceneFunction.LOWER && !queryText.toLowerCase().equals(queryText)) {
                return this.createNoMatchQuery();
            }
            if (luceneFunction == LuceneFunction.UPPER && !queryText.toUpperCase().equals(queryText)) {
                return this.createNoMatchQuery();
            }
            return this.functionQueryBuilder(expandedFieldName, (String)fieldNameAndEnding.getSecond(), propertyQName, propertyDef, tokenisationMode, queryText, luceneFunction);
        }
        if (((String)fieldNameAndEnding.getSecond()).equals(".mimetype")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_MIMETYPE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".size")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_SIZE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".locale")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_LOCALE, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".encoding")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_ENCODING, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".transformationStatus")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_STATUS, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".transformationTime")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_TIME, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (((String)fieldNameAndEnding.getSecond()).equals(".transformationException")) {
            if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_EXCEPTION, AlfrescoSolrDataModel.FieldUse.ID).getFields().get(0).getField(), queryText, analysisMode, luceneFunction);
            }
        } else if (AlfrescoSolrDataModel.getInstance().isDerivedDateField((String)fieldNameAndEnding.getSecond()) && propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATE) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME))) {
            return subQueryBuilder.getQuery(AlfrescoSolrDataModel.getInstance().getDateDerivedField(propertyQName, (String)fieldNameAndEnding.getSecond()), queryText, analysisMode, luceneFunction);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addMLTextAttributeQuery(field, propertyDef, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, propertyDef, tokenisationMode, booleanQuery, locale);
            }
            return this.getNonEmptyBooleanQuery(booleanQuery.build());
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)this.addContentCrossLocaleWildcards()));
            }
            return this.addContentAttributeQuery(propertyDef, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, expandedLocales);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
            boolean withWildCards = propertyQName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_AUTHORITY_NAME);
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)withWildCards));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                Locale fixedLocale = locale;
                if (fixedLocale.getLanguage().equals("*")) {
                    fixedLocale = new Locale("??");
                }
                this.addTextAttributeQuery(field, propertyDef, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, fixedLocale);
            }
            return this.getNonEmptyBooleanQuery(booleanQuery.build());
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) && analysisMode == AnalysisMode.LIKE) {
            throw new UnsupportedOperationException("Wild cards are not supported for the datetime type");
        }
        if (propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATE))) {
            Pair<Date, Integer> dateAndResolution = this.parseDateString(queryText);
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
            for (AlfrescoSolrDataModel.FieldInstance instance : indexedField.getFields()) {
                Query query;
                if (dateAndResolution != null) {
                    query = this.newRangeQuery(instance.getField(), this.getDateStart(dateAndResolution), this.getDateEnd(dateAndResolution), true, true);
                    if (query == null) continue;
                    bQuery.add(query, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query = subQueryBuilder.getQuery(instance.getField(), queryText, AnalysisMode.DEFAULT, luceneFunction);
                if (query == null) continue;
                bQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            if (bQuery.build().clauses().size() > 0) {
                return bQuery.build();
            }
            return this.createNoMatchQuery();
        }
        if (propertyDef != null && this.tenantService.isTenantUser() && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) && queryText.contains("://")) {
            queryText = this.tenantService.getName(new NodeRef(queryText)).toString();
        }
        if (propertyDef != null) {
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
            for (AlfrescoSolrDataModel.FieldInstance instance : indexedField.getFields()) {
                Query query = subQueryBuilder.getQuery(instance.getField(), queryText, AnalysisMode.DEFAULT, luceneFunction);
                if (query == null) continue;
                bQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            if (bQuery.build().clauses().size() > 0) {
                return bQuery.build();
            }
            return this.createNoMatchQuery();
        }
        Query query = subQueryBuilder.getQuery(expandedFieldName, queryText, AnalysisMode.DEFAULT, luceneFunction);
        if (query != null) {
            return query;
        }
        return this.createNoMatchQuery();
    }

    private boolean isAllStar(String queryText) {
        if (queryText == null || queryText.length() == 0) {
            return false;
        }
        for (char c : queryText.toCharArray()) {
            if (c == '*') continue;
            return false;
        }
        return true;
    }

    private String getDateEnd(Pair<Date, Integer> dateAndResolution) {
        Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
        cal.setTime((Date)dateAndResolution.getFirst());
        switch ((Integer)dateAndResolution.getSecond()) {
            case 1: {
                cal.set(2, cal.getActualMaximum(2));
            }
            case 2: {
                cal.set(5, cal.getActualMaximum(5));
            }
            case 5: {
                cal.set(11, cal.getActualMaximum(11));
            }
            case 11: {
                cal.set(12, cal.getActualMaximum(12));
            }
            case 12: {
                cal.set(13, cal.getActualMaximum(13));
            }
            case 13: {
                cal.set(14, cal.getActualMaximum(14));
            }
        }
        SimpleDateFormat formatter = CachingDateFormat.getSolrDatetimeFormat();
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(cal.getTime());
    }

    private String getDateStart(Pair<Date, Integer> dateAndResolution) {
        Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
        cal.setTime((Date)dateAndResolution.getFirst());
        switch ((Integer)dateAndResolution.getSecond()) {
            case 1: {
                cal.set(2, cal.getActualMinimum(2));
            }
            case 2: {
                cal.set(5, cal.getActualMinimum(5));
            }
            case 5: {
                cal.set(11, cal.getActualMinimum(11));
            }
            case 11: {
                cal.set(12, cal.getActualMinimum(12));
            }
            case 12: {
                cal.set(13, cal.getActualMinimum(13));
            }
            case 13: {
                cal.set(14, cal.getActualMinimum(14));
            }
        }
        return CachingDateFormat.getSolrDatetimeFormat().format(cal.getTime());
    }

    private Pair<Date, Integer> parseDateString(String dateString) {
        try {
            return CachingDateFormat.lenientParse((String)dateString, (int)1);
        }
        catch (java.text.ParseException e) {
            SimpleDateFormat oldDf = CachingDateFormat.getDateFormat();
            oldDf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                Date date = oldDf.parse(dateString);
                return new Pair((Object)date, (Object)13);
            }
            catch (java.text.ParseException ee) {
                if (dateString.equalsIgnoreCase("min")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.set(1, cal.getMinimum(1));
                    cal.set(6, cal.getMinimum(6));
                    cal.set(11, cal.getMinimum(11));
                    cal.set(12, cal.getMinimum(12));
                    cal.set(13, cal.getMinimum(13));
                    cal.set(14, cal.getMinimum(14));
                    return new Pair((Object)cal.getTime(), (Object)14);
                }
                if (dateString.equalsIgnoreCase("now")) {
                    return new Pair((Object)new Date(), (Object)14);
                }
                if (dateString.equalsIgnoreCase("today")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.setTime(new Date());
                    cal.set(11, cal.getMinimum(11));
                    cal.set(12, cal.getMinimum(12));
                    cal.set(13, cal.getMinimum(13));
                    cal.set(14, cal.getMinimum(14));
                    return new Pair((Object)cal.getTime(), (Object)5);
                }
                if (dateString.equalsIgnoreCase("max")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.set(1, cal.getMaximum(1));
                    cal.set(6, cal.getMaximum(6));
                    cal.set(11, cal.getMaximum(11));
                    cal.set(12, cal.getMaximum(12));
                    cal.set(13, cal.getMaximum(13));
                    cal.set(14, cal.getMaximum(14));
                    return new Pair((Object)cal.getTime(), (Object)14);
                }
                return null;
            }
        }
    }

    protected Query functionQueryBuilder(String expandedFieldName, String ending, QName propertyQName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, String queryText, LuceneFunction luceneFunction) throws ParseException {
        if (ending.equals(".mimetype") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals(".size") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals(".locale") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals(".encoding") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals("contentDocId") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals(".transformationException") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : (ending.equals(".transformationTime") ? propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) : ending.equals(".transformationStatus") && propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)))))))) {
            throw new UnsupportedOperationException("Lucene Function");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, propertyDef, queryText, luceneFunction, booleanQuery, locale, tokenisationMode);
            }
            return booleanQuery.build();
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            throw new UnsupportedOperationException("Lucene functions not supported for content");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
            if (propertyQName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_AUTHORITY_NAME)) {
                throw new UnsupportedOperationException("Functions are not supported agaisnt special text fields");
            }
            boolean withWildCards = propertyQName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_AUTHORITY_NAME);
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            List locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)this.mlAnalysisMode, (Locale)locale, (boolean)withWildCards));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, propertyDef, queryText, luceneFunction, booleanQuery, locale, tokenisationMode);
            }
            return booleanQuery.build();
        }
        throw new UnsupportedOperationException("Lucene Function");
    }

    protected TermQuery createNoMatchQuery() {
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    protected BooleanQuery getNonEmptyBooleanQuery(BooleanQuery booleanQuery) {
        if (booleanQuery.clauses().size() > 0) {
            return booleanQuery;
        }
        return null;
    }

    protected Query createSolr4IdQuery(String queryText) {
        return this.createTermQuery("id", queryText);
    }

    protected Query createIdQuery(String queryText) {
        if (NodeRef.isNodeRef((String)queryText)) {
            return this.createNodeRefQuery("LID", queryText);
        }
        return this.createNodeRefQuery("ID", queryText);
    }

    protected Query createPathQuery(String queryText, boolean withRepeats) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setRepeats(withRepeats);
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createPrimaryAssocQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setPathField("PRIMARYASSOCQNAME");
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createPrimaryAssocTypeQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setPathField("PRIMARYASSOCTYPEQNAME");
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createAssocTypeQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setPathField("ASSOCTYPEQNAME");
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createAclIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImplWithIOExceptionWrapped("ACLID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createOwnerQuery(String queryText) throws ParseException {
        return new SolrOwnerQuery(queryText);
    }

    protected Query createReaderQuery(String queryText) throws ParseException {
        return new SolrReaderQuery(queryText);
    }

    protected Query createAuthorityQuery(String queryText) throws ParseException {
        return new SolrAuthoritySetQuery("," + queryText);
    }

    protected Query addContentAttributeQuery(PropertyDefinition pDef, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, List<Locale> expandedLocales) throws ParseException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
        if (this.isExactTermSearch(analysisMode)) {
            for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                Query subQuery;
                if (field.isLocalised() || (subQuery = subQueryBuilder.getQuery(field.getField(), queryText, analysisMode, luceneFunction)) == null) continue;
                booleanQueryBuilder.add(subQuery, BooleanClause.Occur.SHOULD);
            }
            if (booleanQueryBuilder.build().clauses().size() == 0) {
                throw new UnsupportedOperationException("Exact Term search is not supported unless you configure the field <" + String.valueOf(pDef.getName()) + "> for cross locale search");
            }
        } else {
            for (Locale locale : expandedLocales) {
                boolean localisedSearch;
                boolean bl = localisedSearch = locale.toString().length() != 0;
                if (localisedSearch) {
                    StringBuilder builder = new StringBuilder(queryText.length() + 10);
                    builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
                }
                for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                    Query subQuery;
                    if ((localisedSearch || field.isLocalised()) && (!localisedSearch || !field.isLocalised()) || (subQuery = subQueryBuilder.getQuery(field.getField(), queryText, analysisMode, luceneFunction)) == null) continue;
                    booleanQueryBuilder.add(subQuery, BooleanClause.Occur.SHOULD);
                }
            }
        }
        return this.getNonEmptyBooleanQuery(booleanQueryBuilder.build());
    }

    protected void addLocaleSpecificUntokenisedMLOrTextFunction(String expandedFieldName, PropertyDefinition pDef, String queryText, LuceneFunction luceneFunction, BooleanQuery.Builder booleanQuery, Locale locale, IndexTokenisationMode tokenisationMode) {
        throw new UnsupportedOperationException();
    }

    private AlfrescoSolrDataModel.FieldInstance getFieldInstance(String baseFieldName, PropertyDefinition pDef, Locale locale, IndexTokenisationMode preferredIndexTokenisationMode, AnalysisMode analysisMode) {
        if (pDef != null) {
            switch (preferredIndexTokenisationMode) {
                case BOTH: {
                    throw new IllegalStateException("Preferred mode can not be BOTH");
                }
                case FALSE: {
                    if (locale.toString().length() == 0) {
                        AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.ID);
                        for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                            if (field.isLocalised()) continue;
                            return field;
                        }
                    } else {
                        AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.ID);
                        for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                            if (!field.isLocalised()) continue;
                            return field;
                        }
                    }
                    break;
                }
                case TRUE: {
                    AlfrescoSolrDataModel.IndexedField indexedField = this.isExactTermSearch(analysisMode) ? AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.EXACT) : AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
                    if (locale.toString().length() == 0) {
                        for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                            if (field.isLocalised()) continue;
                            return field;
                        }
                    } else {
                        for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                            if (!field.isLocalised()) continue;
                            return field;
                        }
                    }
                    break;
                }
            }
            return null;
        }
        return new AlfrescoSolrDataModel.FieldInstance(baseFieldName, false, false);
    }

    private boolean isExactTermSearch(AnalysisMode analysisMode) {
        return analysisMode == AnalysisMode.IDENTIFIER && !this.solrParams.get("defType").equals(CMIS_REQUEST_HANDLER);
    }

    protected void addLocaleSpecificUntokenisedTextRangeFunction(String expandedFieldName, PropertyDefinition pDef, String lower, String upper, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction, BooleanQuery.Builder booleanQuery, Locale locale, IndexTokenisationMode tokenisationMode) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected void addMLTextAttributeQuery(String field, PropertyDefinition pDef, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) throws ParseException {
        this.addMLTextOrTextAttributeQuery(field, pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMLTextOrTextAttributeQuery(String field, PropertyDefinition pDef, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) throws ParseException {
        boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
        try {
            switch (tokenisationMode) {
                case BOTH: {
                    switch (analysisMode) {
                        default: {
                            this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                            if (!ContentModel.PROP_NAME.equals((Object)pDef.getName())) return;
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                            return;
                        }
                        case TOKENISE: {
                            this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                            return;
                        }
                        case IDENTIFIER: {
                            this.setLowercaseExpandedTerms(false);
                            if (this.isExactTermSearch(analysisMode)) {
                                this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                                return;
                            }
                            this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                            return;
                        }
                        case FUZZY: 
                        case PREFIX: 
                        case WILD: 
                        case LIKE: {
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                            return;
                        }
                    }
                }
                case FALSE: {
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                    return;
                }
                default: {
                    this.addLocaleSpecificMLOrTextAttribute(pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                    return;
                }
            }
        }
        finally {
            this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
        }
    }

    protected void addTextAttributeQuery(String field, PropertyDefinition pDef, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) throws ParseException {
        this.addMLTextOrTextAttributeQuery(field, pDef, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, locale);
    }

    private void addLocaleSpecificMLOrTextAttribute(PropertyDefinition pDef, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery.Builder booleanQuery, Locale locale, String textFieldName, IndexTokenisationMode tokenisationMode, IndexTokenisationMode preferredTokenisationMode) throws ParseException {
        AlfrescoSolrDataModel.FieldInstance fieldInstance = this.getFieldInstance(textFieldName, pDef, locale, preferredTokenisationMode, analysisMode);
        if (fieldInstance != null) {
            StringBuilder builder = new StringBuilder(queryText.length() + 10);
            if (fieldInstance.isLocalised()) {
                builder.append("\u0000").append(locale.toString()).append("\u0000");
            }
            builder.append(queryText);
            Query subQuery = subQueryBuilder.getQuery(fieldInstance.getField(), builder.toString(), analysisMode, luceneFunction);
            if (subQuery != null) {
                booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
            }
        }
    }

    protected void addTextRange(String field, PropertyDefinition pDef, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String fieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) throws ParseException, IOException {
        block0 : switch (tokenisationMode) {
            case BOTH: {
                switch (analysisMode) {
                    case DEFAULT: 
                    case TOKENISE: {
                        this.addLocaleSpecificTextRange(fieldName, pDef, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.TRUE);
                        break block0;
                    }
                    case IDENTIFIER: {
                        this.addLocaleSpecificTextRange(fieldName, pDef, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.FALSE);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case FALSE: {
                this.addLocaleSpecificTextRange(fieldName, pDef, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.FALSE);
                break;
            }
            case TRUE: {
                this.addLocaleSpecificTextRange(fieldName, pDef, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.TRUE);
                break;
            }
        }
    }

    private void addLocaleSpecificTextRange(String expandedFieldName, PropertyDefinition pDef, String part1, String part2, boolean includeLower, boolean includeUpper, BooleanQuery.Builder booleanQuery, Locale locale, AnalysisMode analysisMode, IndexTokenisationMode tokenisationMode, IndexTokenisationMode preferredTokenisationMode) throws ParseException, IOException {
        AlfrescoSolrDataModel.FieldInstance fieldInstance = this.getFieldInstance(expandedFieldName, pDef, locale, preferredTokenisationMode, analysisMode);
        if (fieldInstance != null) {
            Object firstString = null;
            if (part1 != null && !part1.equals("\u0000")) {
                if (fieldInstance.isLocalised()) {
                    firstString = this.getFirstTokenForRange(this.getLocalePrefixedText(part1, locale), fieldInstance);
                    if (firstString == null) {
                        firstString = "{" + locale.getLanguage() + "}";
                    }
                } else {
                    firstString = this.getFirstTokenForRange(part1, fieldInstance);
                }
            } else {
                firstString = fieldInstance.isLocalised() ? "{" + locale.getLanguage() + "}" : null;
            }
            Object lastString = null;
            if (part2 != null && !part2.equals("\uffff")) {
                if (fieldInstance.isLocalised()) {
                    lastString = this.getFirstTokenForRange(this.getLocalePrefixedText(part2, locale), fieldInstance);
                    if (lastString == null) {
                        lastString = "{" + locale.getLanguage() + "}\uffff";
                    }
                } else {
                    lastString = this.getFirstTokenForRange(part2, fieldInstance);
                }
            } else {
                lastString = fieldInstance.isLocalised() ? "{" + locale.getLanguage() + "}\uffff" : null;
            }
            if (firstString != null && ((String)firstString).equals("*")) {
                firstString = null;
            }
            if (lastString != null && ((String)lastString).equals("*")) {
                lastString = null;
            }
            TermRangeQuery query = new TermRangeQuery(fieldInstance.getField(), firstString == null ? null : new BytesRef((CharSequence)firstString), lastString == null ? null : new BytesRef((CharSequence)lastString), includeLower, includeUpper);
            booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFirstTokenForRange(String string, AlfrescoSolrDataModel.FieldInstance field) throws IOException {
        TokenStream source = null;
        try {
            source = this.getAnalyzer().tokenStream(field.getField(), (Reader)new StringReader(string));
            source.reset();
            if (source.incrementToken()) {
                CharTermAttribute cta = (CharTermAttribute)source.getAttribute(CharTermAttribute.class);
                OffsetAttribute offsetAtt = (OffsetAttribute)source.getAttribute(OffsetAttribute.class);
                TypeAttribute typeAtt = null;
                if (source.hasAttribute(TypeAttribute.class)) {
                    typeAtt = (TypeAttribute)source.getAttribute(TypeAttribute.class);
                }
                PositionIncrementAttribute posIncAtt = null;
                if (source.hasAttribute(PositionIncrementAttribute.class)) {
                    posIncAtt = (PositionIncrementAttribute)source.getAttribute(PositionIncrementAttribute.class);
                }
                PackedTokenAttributeImpl nextToken = new PackedTokenAttributeImpl();
                nextToken.setEmpty().copyBuffer(cta.buffer(), 0, cta.length());
                nextToken.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
                if (typeAtt != null) {
                    nextToken.setType(typeAtt.type());
                }
                if (posIncAtt != null) {
                    nextToken.setPositionIncrement(posIncAtt.getPositionIncrement());
                }
                String string2 = nextToken.toString();
                return string2;
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected void addTextSpanQuery(String field, PropertyDefinition pDef, String first, String last, int slop, boolean inOrder, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) {
        this.addMLTextOrTextSpanQuery(field, pDef, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, locale);
    }

    protected Query addContentSpanQuery(String afield, PropertyDefinition pDef, String first, String last, int slop, boolean inOrder, String expandedFieldName, List<Locale> expandedLocales) {
        try {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            for (Locale locale : expandedLocales) {
                SpanNearQuery result;
                SpanQuery lastQuery;
                SpanQuery firstQuery;
                AlfrescoSolrDataModel.IndexedField indexedField;
                if (locale.toString().length() == 0) {
                    indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
                    for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                        if (field.isLocalised()) continue;
                        firstQuery = this.buildSpanOrQuery(first, field);
                        lastQuery = this.buildSpanOrQuery(last, field);
                        result = new SpanNearQuery(new SpanQuery[]{firstQuery, lastQuery}, slop, inOrder);
                        booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
                    }
                    continue;
                }
                indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
                for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                    if (!field.isLocalised()) continue;
                    firstQuery = this.buildSpanOrQuery(this.getLocalePrefixedText(first, locale), field);
                    lastQuery = this.buildSpanOrQuery(this.getLocalePrefixedText(last, locale), field);
                    result = new SpanNearQuery(new SpanQuery[]{firstQuery, lastQuery}, slop, inOrder);
                    booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
                }
            }
            return this.getNonEmptyBooleanQuery(booleanQuery.build());
        }
        catch (IOException ioe) {
            return this.createNoMatchQuery();
        }
    }

    private String getLocalePrefixedText(String text, Locale locale) {
        StringBuilder builder = new StringBuilder(text.length() + 10);
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(text);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpanQuery buildSpanOrQuery(String first, AlfrescoSolrDataModel.FieldInstance field) throws IOException {
        ArrayList<SpanTermQuery> spanOrQueryParts = new ArrayList<SpanTermQuery>();
        TokenStream source = null;
        try {
            source = this.getAnalyzer().tokenStream(field.getField(), (Reader)new StringReader(first));
            source.reset();
            while (source.incrementToken()) {
                CharTermAttribute cta = (CharTermAttribute)source.getAttribute(CharTermAttribute.class);
                OffsetAttribute offsetAtt = (OffsetAttribute)source.getAttribute(OffsetAttribute.class);
                TypeAttribute typeAtt = null;
                if (source.hasAttribute(TypeAttribute.class)) {
                    typeAtt = (TypeAttribute)source.getAttribute(TypeAttribute.class);
                }
                PositionIncrementAttribute posIncAtt = null;
                if (source.hasAttribute(PositionIncrementAttribute.class)) {
                    posIncAtt = (PositionIncrementAttribute)source.getAttribute(PositionIncrementAttribute.class);
                }
                PackedTokenAttributeImpl nextToken = new PackedTokenAttributeImpl();
                nextToken.setEmpty().copyBuffer(cta.buffer(), 0, cta.length());
                nextToken.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
                if (typeAtt != null) {
                    nextToken.setType(typeAtt.type());
                }
                if (posIncAtt != null) {
                    nextToken.setPositionIncrement(posIncAtt.getPositionIncrement());
                }
                SpanTermQuery termQuery = new SpanTermQuery(new Term(field.getField(), nextToken.toString()));
                spanOrQueryParts.add(termQuery);
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (spanOrQueryParts.size() == 1) {
            return (SpanQuery)spanOrQueryParts.get(0);
        }
        return new SpanOrQuery(spanOrQueryParts.toArray(new SpanQuery[0]));
    }

    protected void addMLTextSpanQuery(String field, PropertyDefinition pDef, String first, String last, int slop, boolean inOrder, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) {
        this.addMLTextOrTextSpanQuery(field, pDef, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, locale);
    }

    private void addMLTextOrTextSpanQuery(String afield, PropertyDefinition pDef, String first, String last, int slop, boolean inOrder, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery.Builder booleanQuery, Locale locale) {
        try {
            if (locale.toString().length() == 0) {
                AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
                for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                    if (field.isLocalised()) continue;
                    SpanQuery firstQuery = this.buildSpanOrQuery(first, field);
                    SpanQuery lastQuery = this.buildSpanOrQuery(last, field);
                    SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstQuery, lastQuery}, slop, inOrder);
                    booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
                }
            } else {
                AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getQueryableFields(pDef.getName(), null, AlfrescoSolrDataModel.FieldUse.FTS);
                for (AlfrescoSolrDataModel.FieldInstance field : indexedField.getFields()) {
                    if (!field.isLocalised()) continue;
                    SpanQuery firstQuery = this.buildSpanOrQuery(this.getLocalePrefixedText(first, locale), field);
                    SpanQuery lastQuery = this.buildSpanOrQuery(this.getLocalePrefixedText(last, locale), field);
                    SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstQuery, lastQuery}, slop, inOrder);
                    booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addContentCrossLocaleWildcards() {
        return false;
    }

    protected Query createOwnerSetQuery(String queryText) throws ParseException {
        return new SolrOwnerSetQuery(queryText);
    }

    protected Query createReaderSetQuery(String queryText) throws ParseException {
        return new SolrReaderSetQuery(queryText);
    }

    protected Query createAuthoritySetQuery(String queryText) throws ParseException {
        return new SolrAuthoritySetQuery(queryText);
    }

    protected Query createDeniedQuery(String queryText) throws ParseException {
        return new SolrDeniedQuery(queryText);
    }

    protected Query createDenySetQuery(String queryText) throws ParseException {
        return new SolrDenySetQuery(queryText);
    }

    private BytesRef analyzeMultitermTerm(String field, String part) {
        return this.analyzeMultitermTerm(field, part, this.getAnalyzer());
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected BytesRef analyzeMultitermTerm(String field, String part, Analyzer analyzerIn) {
        BytesRef bytesRef;
        block11: {
            if (analyzerIn == null) {
                analyzerIn = this.getAnalyzer();
            }
            TokenStream source = analyzerIn.tokenStream(field, part);
            try {
                source.reset();
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
                if (!source.incrementToken()) {
                    throw new IllegalArgumentException("analyzer returned no terms for multiTerm term: " + part);
                }
                BytesRef bytes = BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef());
                if (source.incrementToken()) {
                    throw new IllegalArgumentException("analyzer returned too many terms for multiTerm term: " + part);
                }
                source.end();
                bytesRef = bytes;
                if (source == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error analyzing multiTerm term: " + part, e);
                }
            }
            source.close();
        }
        return bytesRef;
    }

    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        BytesRef start;
        if (part1 == null) {
            start = null;
        } else {
            BytesRef bytesRef = start = this.getAnalyzeRangeTerms() ? this.analyzeMultitermTerm(field, part1) : new BytesRef((CharSequence)part1);
        }
        BytesRef end = part2 == null ? null : (this.getAnalyzeRangeTerms() ? this.analyzeMultitermTerm(field, part2) : new BytesRef((CharSequence)part2));
        TermRangeQuery query = new TermRangeQuery(field, start, end, startInclusive, endInclusive);
        query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
        return query;
    }

    class FieldQuery
    implements SubQuery {
        FieldQuery() {
        }

        @Override
        public Query getQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return Solr4QueryParser.this.getSuperFieldQuery(field, queryText, analysisMode, luceneFunction);
        }
    }

    public static interface SubQuery {
        public Query getQuery(String var1, String var2, AnalysisMode var3, LuceneFunction var4) throws ParseException;
    }

    private class FingerPrintFetchTask
    implements Callable<Collection> {
        private String url;
        private String id;

        public FingerPrintFetchTask(String url, String id) {
            this.url = url;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection call() throws Exception {
            HttpSolrClient solrClient = null;
            CloseableHttpClient closeableHttpClient = null;
            try {
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.add("fingerprint", new String[]{"true"});
                params.add("id", new String[]{this.id});
                params.add("qt", new String[]{"/fingerprint"});
                closeableHttpClient = HttpClientUtil.createClient((SolrParams)this.getClientParams());
                solrClient = new HttpSolrClient.Builder(this.url).withHttpClient((HttpClient)closeableHttpClient).build();
                QueryRequest request = new QueryRequest((SolrParams)params, SolrRequest.METHOD.POST);
                QueryResponse response = (QueryResponse)request.process((SolrClient)solrClient);
                NamedList dataResponse = response.getResponse();
                NamedList fingerprint = (NamedList)dataResponse.get("fingerprint");
                Collection collection = (Collection)fingerprint.get("MINHASH");
                return collection;
            }
            finally {
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
                if (solrClient != null) {
                    solrClient.close();
                }
            }
        }

        protected ModifiableSolrParams getClientParams() {
            ModifiableSolrParams clientParams = new ModifiableSolrParams();
            clientParams.set("socketTimeout", 600000);
            clientParams.set("connTimeout", 60000);
            return clientParams;
        }
    }

    class PrefixQuery
    implements SubQuery {
        PrefixQuery() {
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            StringBuilder builder = new StringBuilder(termStr.length() + 1);
            builder.append(termStr);
            builder.append("*");
            return Solr4QueryParser.this.getSuperFieldQuery(field, builder.toString(), analysisMode, luceneFunction);
        }
    }

    class WildcardQuery
    implements SubQuery {
        WildcardQuery() {
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return Solr4QueryParser.this.getSuperFieldQuery(field, termStr, analysisMode, luceneFunction);
        }
    }

    class FuzzyQuery
    implements SubQuery {
        float minSimilarity;

        FuzzyQuery(float minSimilarity) {
            this.minSimilarity = minSimilarity;
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return Solr4QueryParser.this.getSuperFuzzyQuery(field, Solr4QueryParser.this.translateLocale(termStr), this.minSimilarity);
        }
    }
}

