/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.adaptor.QueryParserExpressionAdaptor;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.query.Solr4QueryParser;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;

public class Lucene4QueryParserAdaptor
implements QueryParserAdaptor<Query, Sort, ParseException> {
    private Solr4QueryParser lqp;

    public Lucene4QueryParserAdaptor(Solr4QueryParser lqp) {
        this.lqp = lqp;
    }

    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.lqp.getFieldQuery(field, queryText, analysisMode, luceneFunction);
    }

    public Query getRangeQuery(String field, String lower, String upper, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.lqp.getRangeQuery(field, lower, upper, includeLower, includeUpper, analysisMode, luceneFunction);
    }

    public Query getMatchAllQuery() throws ParseException {
        return new MatchAllDocsQuery();
    }

    public Query getMatchNoneQuery() throws ParseException {
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    public Query getLikeQuery(String field, String sqlLikeClause, AnalysisMode analysisMode) throws ParseException {
        return this.lqp.getLikeQuery(field, sqlLikeClause, analysisMode);
    }

    public SearchParameters getSearchParameters() {
        return this.lqp.getSearchParameters();
    }

    public String getSortField(String field) throws ParseException {
        throw new UnsupportedOperationException();
    }

    public Query getIdentifierQuery(String field, String stringValue, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        String[] split = stringValue.split(";");
        if (split.length == 1) {
            return this.lqp.getFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
        }
        if (split[1].equalsIgnoreCase("PWC")) {
            return this.getMatchNoneQuery();
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        BooleanQuery.Builder part1 = new BooleanQuery.Builder();
        part1.add(this.lqp.getFieldQuery(field, split[0], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
        part1.add(this.lqp.getFieldQuery("@" + ContentModel.PROP_VERSION_LABEL.toString(), split[1], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
        query.add((Query)part1.build(), BooleanClause.Occur.SHOULD);
        if (split[1].equals("1.0")) {
            BooleanQuery.Builder part2 = new BooleanQuery.Builder();
            part2.add(this.lqp.getFieldQuery(field, split[0], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
            part2.add(this.lqp.getFieldQuery("ASPECT", ContentModel.ASPECT_VERSIONABLE.toString(), AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST_NOT);
            query.add((Query)part2.build(), BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }

    public Query getIdentifieLikeQuery(String field, String sqlLikeClause, AnalysisMode analysisMode) throws ParseException {
        return this.getLikeQuery(field, sqlLikeClause, analysisMode);
    }

    public boolean sortFieldExists(String noLocalField) {
        throw new UnsupportedOperationException();
    }

    public Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.lqp.getFieldQuery(field, queryText);
    }

    public Sort buildSort(List<Ordering> list, FunctionEvaluationContext functionContext) throws ParseException {
        throw new UnsupportedOperationException();
    }

    public Query getFuzzyQuery(String luceneFieldName, String term, Float minSimilarity) throws ParseException {
        return this.lqp.getFuzzyQuery(luceneFieldName, term, minSimilarity.floatValue());
    }

    public String getField() {
        return this.lqp.getField();
    }

    public int getPhraseSlop() {
        return this.lqp.getPhraseSlop();
    }

    public Query getFieldQuery(String luceneFieldName, String term, AnalysisMode analysisMode, Integer slop, LuceneFunction luceneFunction) throws ParseException {
        return this.lqp.getFieldQuery(luceneFieldName, term, analysisMode, slop, luceneFunction);
    }

    public Query getPrefixQuery(String luceneFieldName, String term, AnalysisMode analysisMode) throws ParseException {
        return this.lqp.getPrefixQuery(luceneFieldName, term, analysisMode);
    }

    public Query getSpanQuery(String field, String first, String last, int slop, boolean inOrder) throws ParseException {
        return this.lqp.getSpanQuery(field, first, last, slop, inOrder);
    }

    public Query getWildcardQuery(String luceneFieldName, String term, AnalysisMode analysisMode) throws ParseException {
        return this.lqp.getWildcardQuery(luceneFieldName, term, analysisMode);
    }

    public Query getNegatedQuery(Query query) throws ParseException {
        QueryParserExpressionAdaptor<Query, ParseException> expressionAdaptor = this.getExpressionAdaptor();
        expressionAdaptor.addRequired((Object)this.getMatchAllQuery());
        expressionAdaptor.addExcluded((Object)query);
        return (Query)expressionAdaptor.getQuery();
    }

    public QueryParserExpressionAdaptor<Query, ParseException> getExpressionAdaptor() {
        return new Lucene4QueryParserExpressionAdaptor();
    }

    public Query getMatchAllNodesQuery() {
        return new TermQuery(new Term("ISNODE", "T"));
    }

    public String getDatetimeSortField(String field, PropertyDefinition propertyDef) {
        throw new UnsupportedOperationException();
    }

    private class Lucene4QueryParserExpressionAdaptor
    implements QueryParserExpressionAdaptor<Query, ParseException> {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();

        private Lucene4QueryParserExpressionAdaptor() {
        }

        public void addRequired(Query q) {
            this.booleanQuery.add(q, BooleanClause.Occur.MUST);
        }

        public void addExcluded(Query q) {
            this.booleanQuery.add(q, BooleanClause.Occur.MUST_NOT);
        }

        public void addOptional(Query q) {
            this.booleanQuery.add(q, BooleanClause.Occur.SHOULD);
        }

        public Query getQuery() throws ParseException {
            BooleanQuery query = this.booleanQuery.build();
            if (query.clauses().size() == 0) {
                return Lucene4QueryParserAdaptor.this.getMatchNoneQuery();
            }
            if (query.clauses().size() == 1) {
                BooleanClause clause = (BooleanClause)query.clauses().get(0);
                if (clause.isProhibited()) {
                    this.booleanQuery.add(Lucene4QueryParserAdaptor.this.getMatchAllQuery(), BooleanClause.Occur.MUST);
                    return this.booleanQuery.build();
                }
                return clause.getQuery();
            }
            return query;
        }

        public Query getNegatedQuery() throws ParseException {
            BooleanQuery query = this.booleanQuery.build();
            if (query.clauses().size() == 0) {
                return Lucene4QueryParserAdaptor.this.getMatchAllQuery();
            }
            if (query.clauses().size() == 1) {
                BooleanClause clause = (BooleanClause)query.clauses().get(0);
                if (clause.isProhibited()) {
                    return clause.getQuery();
                }
                return Lucene4QueryParserAdaptor.this.getNegatedQuery(this.getQuery());
            }
            return Lucene4QueryParserAdaptor.this.getNegatedQuery(this.getQuery());
        }

        public void addRequired(Query q, float boost) throws ParseException {
            this.addRequired((Query)new BoostQuery(q, boost));
        }

        public void addExcluded(Query q, float boost) throws ParseException {
            this.addExcluded((Query)new BoostQuery(q, boost));
        }

        public void addOptional(Query q, float boost) throws ParseException {
            this.addOptional((Query)new BoostQuery(q, boost));
        }
    }
}

