/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.util.Pair;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SortSpecParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.update.processor.LangDetectLanguageIdentifierUpdateProcessor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractQParser
extends QParser
implements QueryConstants {
    private static char[] SEPARATORS = new char[]{':', ',', '-', '!', '+', '=', ';', '~', '/'};
    protected static final Logger log = LoggerFactory.getLogger(AbstractQParser.class);
    protected boolean authset;
    public static final String ALFRESCO_JSON = "ALFRESCO_JSON";
    private static final String AUTHORITY_FILTER_FROM_JSON = "AUTHORITY_FILTER_FROM_JSON";
    private static final String TENANT_FILTER_FROM_JSON = "TENANT_FILTER_FROM_JSON";
    private static final String RERANK_QUERY_FROM_CONTEXT = "RERANK_QUERY_FROM_CONTEXT";
    static final String[] languages = new String[]{"af", "ar", "bg", "bn", "cs", "da", "de", "el", "en", "es", "et", "fa", "fi", "fr", "gu", "he", "hi", "hr", "hu", "id", "it", "ja", "kn", "ko", "lt", "lv", "mk", "ml", "mr", "ne", "nl", "no", "pa", "pl", "pt", "ro", "ru", "sk", "sl", "so", "sq", "sv", "sw", "ta", "te", "th", "tl", "tr", "uk", "ur", "vi", "zh-cn", "zh-tw"};
    private boolean autoDetectQueryLocale = false;
    private HashSet<String> autoDetectQueryLocales = new HashSet();
    private HashSet<String> fixedQueryLocales = new HashSet();

    public AbstractQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args) {
        super(qstr, localParams, params, req);
        if (args != null) {
            String mappedLanguage;
            String[] locales;
            Object arg = args.get("autoDetectQueryLocale");
            if (arg != null) {
                this.autoDetectQueryLocale = Boolean.parseBoolean(arg.toString());
            }
            if ((arg = args.get("autoDetectQueryLocales")) != null) {
                for (String locale : locales = arg.toString().split(",")) {
                    mappedLanguage = this.isKnownLocale(locale);
                    if (mappedLanguage == null) continue;
                    this.autoDetectQueryLocales.add(mappedLanguage);
                }
            }
            if ((arg = args.get("fixedQueryLocales")) != null) {
                for (String locale : locales = arg.toString().split(",")) {
                    mappedLanguage = this.isKnownLocale(locale);
                    if (mappedLanguage == null) continue;
                    this.fixedQueryLocales.add(mappedLanguage);
                }
            }
        }
    }

    private String isKnownLocale(String locale) {
        for (String test : languages) {
            if (!locale.equalsIgnoreCase(test)) continue;
            return test;
        }
        return null;
    }

    protected Pair<SearchParameters, Boolean> getSearchParameters() {
        String searchTerm;
        String defaultField;
        SearchParameters searchParameters = new SearchParameters();
        Boolean isFilter = Boolean.FALSE;
        Iterable streams = this.req.getContentStreams();
        JSONObject json = (JSONObject)this.req.getContext().get(ALFRESCO_JSON);
        if (json == null && streams != null) {
            try {
                BufferedReader reader = null;
                for (ContentStream stream : streams) {
                    reader = new BufferedReader(new InputStreamReader(stream.getStream(), "UTF-8"));
                }
                if (reader != null) {
                    json = new JSONObject(new JSONTokener(reader));
                    this.req.getContext().put(ALFRESCO_JSON, json);
                }
            }
            catch (JSONException reader) {
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("IO Error parsing query parameters", (Throwable)e);
            }
        }
        if (json != null) {
            try {
                int i;
                if (this.getString() != null) {
                    Object tenantString;
                    JSONArray tenants;
                    ArrayList<String> tenantList;
                    if (this.getString().equals(AUTHORITY_FILTER_FROM_JSON)) {
                        isFilter = Boolean.TRUE;
                        tenantList = new ArrayList<String>(1);
                        tenants = json.getJSONArray("tenants");
                        for (int i2 = 0; i2 < tenants.length(); ++i2) {
                            tenantString = tenants.getString(i2);
                            tenantList.add((String)tenantString);
                        }
                        ArrayList<String> authorityList = new ArrayList<String>(1);
                        JSONArray authorities = json.getJSONArray("authorities");
                        for (i = 0; i < authorities.length(); ++i) {
                            String authorityString = authorities.getString(i);
                            authorityList.add(authorityString);
                        }
                        char separator = this.getSeparator(authorityList);
                        StringBuilder authQuery = new StringBuilder();
                        StringBuilder denyQuery = new StringBuilder();
                        for (String tenant : tenantList) {
                            block17: for (String authority : authorityList) {
                                if (separator == '\u0000') {
                                    if (authQuery.length() > 0) {
                                        authQuery.append(" ");
                                        denyQuery.append(" ");
                                    }
                                    switch (AuthorityType.getAuthorityType((String)authority)) {
                                        case USER: {
                                            authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                            denyQuery.append("|DENIED:\"").append(authority).append("\"");
                                            continue block17;
                                        }
                                        case GROUP: 
                                        case EVERYONE: 
                                        case GUEST: {
                                            if (tenant.length() == 0) {
                                                authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                                denyQuery.append("|DENIED:\"").append(authority).append("\"");
                                                continue block17;
                                            }
                                            authQuery.append("|AUTHORITY:\"").append(authority).append("@").append(tenant).append("\"");
                                            denyQuery.append("|DENIED:\"").append(authority).append("@").append(tenant).append("\"");
                                            continue block17;
                                        }
                                    }
                                    authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                    denyQuery.append("|DENIED:\"").append(authority).append("\"");
                                    continue;
                                }
                                if (authQuery.length() == 0) {
                                    this.authset = true;
                                    authQuery.append("|AUTHSET:\"");
                                    denyQuery.append("|DENYSET:\"");
                                }
                                switch (AuthorityType.getAuthorityType((String)authority)) {
                                    case USER: {
                                        authQuery.append(separator).append(authority);
                                        denyQuery.append(separator).append(authority);
                                        continue block17;
                                    }
                                    case GROUP: 
                                    case EVERYONE: 
                                    case GUEST: {
                                        if (tenant.length() == 0) {
                                            authQuery.append(separator).append(authority);
                                            denyQuery.append(separator).append(authority);
                                            continue block17;
                                        }
                                        authQuery.append(separator).append(authority).append("@").append(tenant);
                                        denyQuery.append(separator).append(authority).append("@").append(tenant);
                                        continue block17;
                                    }
                                }
                                authQuery.append(separator).append(authority);
                                denyQuery.append(separator).append(authority);
                            }
                        }
                        if (separator != '\u0000') {
                            authQuery.append("\"");
                            denyQuery.append("\"");
                        }
                        if (authQuery.length() > 0) {
                            boolean anyDenyDenies = json.optBoolean("anyDenyDenies", true);
                            if (anyDenyDenies) {
                                authQuery.insert(0, "(").append(") AND NOT (").append((CharSequence)denyQuery).append(")");
                                this.req.getContext().put("processedDenies", Boolean.TRUE);
                            }
                            searchParameters.setQuery(authQuery.toString());
                        }
                    } else if (this.getString().equals(TENANT_FILTER_FROM_JSON)) {
                        isFilter = Boolean.TRUE;
                        tenantList = new ArrayList(1);
                        tenants = json.getJSONArray("tenants");
                        for (int i3 = 0; i3 < tenants.length(); ++i3) {
                            tenantString = tenants.getString(i3);
                            tenantList.add((String)tenantString);
                        }
                        StringBuilder tenantQuery = new StringBuilder();
                        for (String tenant : tenantList) {
                            if (tenantQuery.length() > 0) {
                                tenantQuery.append(" ");
                            }
                            if (tenant.length() > 0) {
                                tenantQuery.append("|TENANT:\"").append(tenant).append("\"");
                                continue;
                            }
                            tenantQuery.append("|TENANT:\"").append("_DEFAULT_").append("\"");
                        }
                        searchParameters.setQuery(tenantQuery.toString());
                    } else if (this.getString().equals(RERANK_QUERY_FROM_CONTEXT)) {
                        String searchTerm2 = this.getParam("spellcheck.q");
                        searchParameters.setQuery(searchTerm2);
                    }
                } else {
                    String query = json.getString("query");
                    if (query != null) {
                        searchParameters.setQuery(query);
                    }
                }
                JSONArray locales = json.getJSONArray("locales");
                for (int i4 = 0; i4 < locales.length(); ++i4) {
                    String localeString = locales.getString(i4);
                    Locale locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeString);
                    searchParameters.addLocale(locale);
                }
                JSONArray templates = json.getJSONArray("templates");
                for (int i5 = 0; i5 < templates.length(); ++i5) {
                    JSONObject template = templates.getJSONObject(i5);
                    String name = template.getString("name");
                    String queryTemplate = template.getString("template");
                    searchParameters.addQueryTemplate(name, queryTemplate);
                }
                JSONArray allAttributes = json.getJSONArray("allAttributes");
                for (int i6 = 0; i6 < allAttributes.length(); ++i6) {
                    String allAttribute = allAttributes.getString(i6);
                    searchParameters.addAllAttribute(allAttribute);
                }
                searchParameters.setDefaultFTSOperator(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSOperator")));
                searchParameters.setDefaultFTSFieldConnective(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSFieldOperator")));
                if (json.has("mlAnalaysisMode")) {
                    searchParameters.setMlAnalaysisMode(MLAnalysisMode.valueOf((String)json.getString("mlAnalaysisMode")));
                }
                searchParameters.setNamespace(json.getString("defaultNamespace"));
                JSONArray textAttributes = json.getJSONArray("textAttributes");
                for (i = 0; i < textAttributes.length(); ++i) {
                    String textAttribute = textAttributes.getString(i);
                    searchParameters.addTextAttribute(textAttribute);
                }
                searchParameters.setQueryConsistency(QueryConsistency.valueOf((String)json.getString("queryConsistency")));
            }
            catch (JSONException locales) {
                // empty catch block
            }
        }
        if (json != null && log.isDebugEnabled()) {
            log.debug(json.toString());
        }
        if (searchParameters.getQuery() == null) {
            searchParameters.setQuery(this.getString());
        }
        if (searchParameters.getLocales().size() == 0) {
            searchParameters.addLocale(I18NUtil.getLocale());
        }
        if ((defaultField = this.getParam("df")) != null) {
            searchParameters.setDefaultFieldName(defaultField);
        }
        if (this.autoDetectQueryLocale && (searchTerm = this.getParam("spellcheck.q")) != null) {
            Locale detectedLocale;
            searchParameters.setSearchTerm(searchTerm);
            List<DetectedLanguage> detetcted = this.detectLanguage(searchTerm);
            if (detetcted != null && detetcted.size() > 0 && this.localeIsNotIncluded(searchParameters, detectedLocale = Locale.forLanguageTag(detetcted.get(0).getLangCode()))) {
                searchParameters.addLocale(Locale.forLanguageTag(detectedLocale.getLanguage()));
            }
        }
        if (this.fixedQueryLocales.size() > 0) {
            for (String locale : this.fixedQueryLocales) {
                searchParameters.addLocale(Locale.forLanguageTag(locale));
            }
        }
        searchParameters.setNamespace("http://www.alfresco.org/model/content/1.0");
        return new Pair((Object)searchParameters, (Object)isFilter);
    }

    private boolean localeIsNotIncluded(SearchParameters searchParameters, Locale detectedLocale) {
        for (Locale locale : searchParameters.getLocales()) {
            if (!locale.getLanguage().equals(detectedLocale.getLanguage())) continue;
            return false;
        }
        return true;
    }

    private char getSeparator(ArrayList<String> authorityList) {
        StringBuilder builder = new StringBuilder();
        for (String auth : authorityList) {
            builder.append(auth);
        }
        String test = builder.toString();
        for (int i = 0; i < SEPARATORS.length; ++i) {
            if (test.indexOf(SEPARATORS[i]) != -1) continue;
            return SEPARATORS[i];
        }
        return '\u0000';
    }

    public SortSpec getSortSpec(boolean useGlobalParams) throws SyntaxError {
        int rows;
        this.getQuery();
        String sortStr = null;
        String startS = null;
        String rowsS = null;
        if (this.localParams != null) {
            sortStr = this.localParams.get("sort");
            startS = this.localParams.get("start");
            rowsS = this.localParams.get("rows");
            if (sortStr != null || startS != null || rowsS != null) {
                useGlobalParams = false;
            }
        }
        if (useGlobalParams) {
            if (sortStr == null) {
                sortStr = this.params.get("sort");
            }
            if (startS == null) {
                startS = this.params.get("start");
            }
            if (rowsS == null) {
                rowsS = this.params.get("rows");
            }
        }
        int start = startS != null ? Integer.parseInt(startS) : 0;
        int n = rows = rowsS != null ? Integer.parseInt(rowsS) : 10;
        if (sortStr != null) {
            StringBuilder builder = new StringBuilder();
            StringBuilder propertyBuilder = null;
            for (int i = 0; i < sortStr.length(); ++i) {
                char c = sortStr.charAt(i);
                if (propertyBuilder == null) {
                    if (!Character.isWhitespace(c) && c != ',') {
                        propertyBuilder = new StringBuilder();
                        propertyBuilder.append(c);
                        continue;
                    }
                    builder.append(c);
                    continue;
                }
                if (Character.isWhitespace(c) || c == ',') {
                    String toAppend = AlfrescoSolrDataModel.getInstance().mapProperty(propertyBuilder.toString(), AlfrescoSolrDataModel.FieldUse.SORT, this.getReq());
                    builder.append(toAppend);
                    builder.append(c);
                    propertyBuilder = null;
                    continue;
                }
                propertyBuilder.append(c);
            }
            if (propertyBuilder != null) {
                String toAppend = AlfrescoSolrDataModel.getInstance().mapProperty(propertyBuilder.toString(), AlfrescoSolrDataModel.FieldUse.SORT, this.getReq());
                builder.append(toAppend);
            }
            sortStr = builder.toString();
        }
        if (sortStr != null) {
            sortStr = sortStr.replaceAll("^ID(\\s)", "id$1");
            sortStr = sortStr.replaceAll("(\\s)ID(\\s)", "$1id$2");
        }
        SortSpec sort = SortSpecParsing.parseSortSpec((String)sortStr, (SolrQueryRequest)this.req);
        sort.setOffset(start);
        sort.setCount(rows);
        return sort;
    }

    private List<DetectedLanguage> detectLanguage(String content) {
        if (content.trim().length() == 0) {
            log.debug("No input text to detect language from, returning empty list");
            return Collections.emptyList();
        }
        try {
            Detector detector = DetectorFactory.create();
            detector.append(content);
            ArrayList langlist = detector.getProbabilities();
            ArrayList<DetectedLanguage> solrLangList = new ArrayList<DetectedLanguage>();
            for (Language l : langlist) {
                if (this.autoDetectQueryLocales.size() != 0 && !this.autoDetectQueryLocales.contains(l.lang)) continue;
                solrLangList.add(new DetectedLanguage(l.lang, l.prob));
            }
            return solrLangList;
        }
        catch (LangDetectException e) {
            log.debug("Could not determine language, returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static {
        try {
            ArrayList<String> profileData = new ArrayList<String>();
            for (String language : languages) {
                InputStream stream = LangDetectLanguageIdentifierUpdateProcessor.class.getResourceAsStream("langdetect-profiles/" + language);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                profileData.add(new String(IOUtils.toCharArray((Reader)reader)));
                reader.close();
            }
            DetectorFactory.loadProfile(profileData);
            DetectorFactory.setSeed((long)0L);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load profile data, will return empty languages always!", e);
        }
    }

    public class DetectedLanguage {
        private final String langCode;
        private final Double certainty;

        DetectedLanguage(String lang, Double certainty) {
            this.langCode = lang;
            this.certainty = certainty;
        }

        public String getLangCode() {
            return this.langCode;
        }

        public Double getCertainty() {
            return this.certainty;
        }
    }
}

