/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongToIntFunction;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.HandlerOfResources;
import org.alfresco.solr.HandlerReportHelper;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.InterceptorRegistry;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.client.SOLRAPIClientFactory;
import org.alfresco.solr.config.ConfigUtil;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.DBIDRangeRouter;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.alfresco.solr.tracker.SolrTrackerScheduler;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.alfresco.solr.utils.Utils;
import org.alfresco.util.Pair;
import org.alfresco.util.shard.ExplicitShardingPolicy;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoCoreAdminHandler
extends CoreAdminHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AlfrescoCoreAdminHandler.class);
    private static final String REPORT = "report";
    private static final String SUMMARY = "Summary";
    static final String ARG_ACLTXID = "acltxid";
    static final String ARG_TXID = "txid";
    static final String ARG_ACLID = "aclid";
    static final String ARG_NODEID = "nodeid";
    private static final String ARG_QUERY = "query";
    private static final String DATA_DIR_ROOT = "data.dir.root";
    public static final String ALFRESCO_DEFAULTS = "create.alfresco.defaults";
    private static final String NUM_SHARDS = "num.shards";
    private static final String SHARD_IDS = "shard.ids";
    static final String DEFAULT_TEMPLATE = "rerank";
    static final String ALFRESCO_CORE_NAME = "alfresco";
    static final String ARCHIVE_CORE_NAME = "archive";
    static final String VERSION_CORE_NAME = "version";
    static final Map<String, StoreRef> STORE_REF_MAP = ImmutableMap.of((Object)"alfresco", (Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (Object)"archive", (Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, (Object)"version", (Object)new StoreRef("workspace", "version2Store"));
    private static final String ACTION_STATUS_SUCCESS = "success";
    private static final String ACTION_STATUS_ERROR = "error";
    static final String ACTION_STATUS_SCHEDULED = "scheduled";
    static final String ACTION_STATUS_NOT_SCHEDULED = "notScheduled";
    static final String ADDITIONAL_INFO = "additionalInfo";
    static final String WARNING = "WARNING";
    static final String DRY_RUN_PARAMETER_NAME = "dryRun";
    static final String FROM_TX_COMMIT_TIME_PARAMETER_NAME = "fromTxCommitTime";
    static final String TO_TX_COMMIT_TIME_PARAMETER_NAME = "toTxCommitTime";
    static final String MAX_TRANSACTIONS_TO_SCHEDULE_PARAMETER_NAME = "maxScheduledTransactions";
    static final String MAX_TRANSACTIONS_TO_SCHEDULE_CONF_PROPERTY_NAME = "alfresco.admin.fix.maxScheduledTransactions";
    static final String TX_IN_INDEX_NOT_IN_DB = "txInIndexNotInDb";
    static final String DUPLICATED_TX_IN_INDEX = "duplicatedTxInIndex";
    static final String MISSING_TX_IN_INDEX = "missingTxInIndex";
    static final String ACL_TX_IN_INDEX_NOT_IN_DB = "aclTxInIndexNotInDb";
    static final String DUPLICATED_ACL_TX_IN_INDEX = "duplicatedAclTxInIndex";
    static final String MISSING_ACL_TX_IN_INDEX = "missingAclTxInIndex";
    private static final String ACTION_LABEL = "action";
    static final String ACTION_STATUS_LABEL = "status";
    static final String ACTION_ERROR_MESSAGE_LABEL = "errorMessage";
    static final String UNKNOWN_CORE_MESSAGE = "Unknown core:";
    static final String UNPROCESSABLE_REQUEST_ON_SLAVE_NODES = "Requested action cannot be performed on slave nodes.";
    private static final String ACTION_TX_TO_REINDEX = "txToReindex";
    private static final String ACTION_ACL_CHANGE_SET_TO_REINDEX = "aclChangeSetToReindex";
    private SolrTrackerScheduler scheduler;
    TrackerRegistry trackerRegistry;
    ConcurrentHashMap<String, InformationServer> informationServers;
    static final List<String> CORE_PARAMETER_NAMES = Arrays.asList("core", "coreName", "index");

    public AlfrescoCoreAdminHandler() {
    }

    public AlfrescoCoreAdminHandler(CoreContainer coreContainer) {
        super(coreContainer);
        LOGGER.info("Starting Alfresco Core Administration Services");
        this.trackerRegistry = new TrackerRegistry();
        this.informationServers = new ConcurrentHashMap();
        this.scheduler = new SolrTrackerScheduler(this);
        String createDefaultCores = ConfigUtil.locateProperty(ALFRESCO_DEFAULTS, "");
        int numShards = Integer.parseInt(ConfigUtil.locateProperty(NUM_SHARDS, "1"));
        String shardIds = ConfigUtil.locateProperty(SHARD_IDS, null);
        InterceptorRegistry.registerSolrClientInterceptors();
        if (createDefaultCores != null && !createDefaultCores.isEmpty()) {
            Thread thread = new Thread(() -> {
                this.waitForTenSeconds();
                this.setupNewDefaultCores(createDefaultCores, numShards, 1, 1, 1, shardIds);
            });
            thread.start();
        }
    }

    void setupNewDefaultCores(String names) {
        this.setupNewDefaultCores(names, 1, 1, 1, 1, null);
    }

    private NamedList<Object> setupNewDefaultCores(String names, int numShards, int replicationFactor, int nodeInstance, int numNodes, String shardIds) {
        var wrapper = new Object(){
            NamedList<Object> response = new SimpleOrderedMap();
        };
        try {
            List coreNames = Optional.ofNullable(names).map(String::toLowerCase).map(parameter -> parameter.split(",")).map(Arrays::asList).orElse(Collections.emptyList());
            coreNames.stream().map(String::trim).filter(coreName -> !coreName.isEmpty()).forEach(coreName -> {
                LOGGER.info("Attempting to create default alfresco core: {}", coreName);
                if (!STORE_REF_MAP.containsKey(coreName)) {
                    throw new AlfrescoRuntimeException("Invalid 'create.alfresco.defaults' permitted values are " + String.valueOf(STORE_REF_MAP.keySet()));
                }
                StoreRef storeRef = STORE_REF_MAP.get(coreName);
                wrapper.response.addAll(this.newCore((String)coreName, numShards, storeRef, DEFAULT_TEMPLATE, replicationFactor, nodeInstance, numNodes, shardIds, null));
            });
        }
        catch (Exception exception) {
            LOGGER.error("Failed to create default alfresco cores (workspace/archive stores)", (Throwable)exception);
            wrapper.response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            wrapper.response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)exception.getMessage());
            return wrapper.response;
        }
        wrapper.response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        return wrapper.response;
    }

    public void shutdown() {
        super.shutdown();
        try {
            LOGGER.info("Shutting down Alfresco core container services");
            AlfrescoSolrDataModel.getInstance().close();
            SOLRAPIClientFactory.close();
            this.coreNames().forEach(this.trackerRegistry::removeTrackersForCore);
            this.informationServers.clear();
            if (!this.scheduler.isShutdown()) {
                this.scheduler.pauseAll();
                if (this.trackerRegistry.getModelTracker() != null) {
                    this.trackerRegistry.getModelTracker().shutdown();
                }
                this.trackerRegistry.setModelTracker(null);
                this.scheduler.shutdown();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to properly shut down Alfresco core container services. See the exception below for further details.", (Throwable)exception);
        }
    }

    private NamedList<Object> initResourceBasedLogging(String resource) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.PropertyConfigurator");
            Method method = clazz.getMethod("configure", Properties.class);
            InputStream is = HandlerOfResources.openResource(this.coreContainer.getSolrHome() + "/../logs", resource);
            Properties p = new Properties();
            p.load(is);
            method.invoke(null, p);
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        }
        catch (ClassNotFoundException e) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)"ClassNotFoundException: org.apache.log4j.PropertyConfigurator");
            return response;
        }
        catch (Exception e) {
            LOGGER.info("Failed to load " + resource, (Throwable)e);
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)e.getMessage());
            return response;
        }
        return response;
    }

    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String action = Optional.ofNullable(params.get(ACTION_LABEL)).map(String::trim).map(String::toUpperCase).orElse("");
        String coreName = this.coreName(params);
        LOGGER.info("Running action {} for core {} with params {}", new Object[]{action, coreName, params});
        try {
            switch (action) {
                case "NEWCORE": 
                case "NEWINDEX": {
                    rsp.add(ACTION_LABEL, this.newCore(req));
                    break;
                }
                case "UPDATECORE": 
                case "UPDATEINDEX": {
                    rsp.add(ACTION_LABEL, this.updateCore(req));
                    break;
                }
                case "UPDATESHARED": {
                    rsp.add(ACTION_LABEL, this.updateShared(req));
                    break;
                }
                case "REMOVECORE": {
                    rsp.add(ACTION_LABEL, this.removeCore(req));
                    break;
                }
                case "NEWDEFAULTINDEX": 
                case "NEWDEFAULTCORE": {
                    rsp.add(ACTION_LABEL, this.newDefaultCore(req));
                    break;
                }
                case "CHECK": {
                    rsp.add(ACTION_LABEL, this.actionCHECK(coreName));
                    break;
                }
                case "NODEREPORT": {
                    rsp.add(REPORT, this.actionNODEREPORTS(params));
                    break;
                }
                case "ACLREPORT": {
                    rsp.add(REPORT, this.actionACLREPORT(params));
                    break;
                }
                case "TXREPORT": {
                    rsp.add(REPORT, this.actionTXREPORT(params));
                    break;
                }
                case "ACLTXREPORT": {
                    rsp.add(REPORT, this.actionACLTXREPORT(params));
                    break;
                }
                case "RANGECHECK": {
                    rsp.getValues().addAll(this.rangeCheck(params));
                    break;
                }
                case "EXPAND": {
                    rsp.getValues().addAll(this.expand(params));
                    break;
                }
                case "REPORT": {
                    rsp.add(REPORT, this.actionREPORT(params));
                    break;
                }
                case "PURGE": {
                    rsp.add(ACTION_LABEL, this.actionPURGE(params));
                    break;
                }
                case "REINDEX": {
                    rsp.add(ACTION_LABEL, this.actionREINDEX(params));
                    break;
                }
                case "RETRY": {
                    rsp.add(ACTION_LABEL, this.actionRETRY(params));
                    break;
                }
                case "INDEX": {
                    rsp.add(ACTION_LABEL, this.actionINDEX(params));
                    break;
                }
                case "FIX": {
                    rsp.add(ACTION_LABEL, this.actionFIX(params));
                    break;
                }
                case "SUMMARY": {
                    rsp.add(SUMMARY, this.actionSUMMARY(params));
                    break;
                }
                case "LOG4J": {
                    rsp.add(ACTION_LABEL, this.initResourceBasedLogging(Optional.ofNullable(params.get("resource")).orElse("log4j.properties")));
                    break;
                }
                case "ENABLE-INDEXING": 
                case "ENABLEINDEXING": {
                    rsp.add(ACTION_LABEL, this.actionEnableIndexing(params));
                    break;
                }
                case "DISABLE-INDEXING": 
                case "DISABLEINDEXING": {
                    rsp.add(ACTION_LABEL, this.actionDisableIndexing(params));
                    break;
                }
                default: {
                    super.handleCustomAction(req, rsp);
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error executing implementation of admin request " + action, (Throwable)ex);
        }
    }

    private NamedList<Object> newCore(SolrQueryRequest req) {
        String shardIds;
        SolrParams params = req.getParams();
        req.getContext();
        NamedList<Object> response = new NamedList<Object>();
        int numShards = params.getInt("numShards", 1);
        String store = params.get("storeRef");
        if (store == null || store.trim().length() == 0) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + this.coreName(params) + " has NOT been created as storeRef param is required"));
            return response;
        }
        StoreRef storeRef = new StoreRef(store);
        String templateName = Optional.ofNullable(params.get("template")).orElse("vanilla");
        int replicationFactor = params.getInt("replicationFactor", 1);
        int nodeInstance = params.getInt("nodeInstance", -1);
        int numNodes = params.getInt("numNodes", 1);
        String coreName = this.coreName(params);
        response = this.newCore(coreName, numShards, storeRef, templateName, replicationFactor, nodeInstance, numNodes, shardIds = params.get("shardIds"), HandlerOfResources.extractCustomProperties(params));
        if (!Objects.equals(response.get(ACTION_STATUS_LABEL), ACTION_STATUS_ERROR)) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        }
        return response;
    }

    private NamedList<Object> newDefaultCore(SolrQueryRequest req) {
        NamedList<Object> response = new NamedList<Object>();
        SolrParams params = req.getParams();
        String coreName = Optional.ofNullable(this.coreName(params)).orElse(ALFRESCO_CORE_NAME);
        String templateName = params.get("template") != null ? params.get("template") : DEFAULT_TEMPLATE;
        Properties extraProperties = HandlerOfResources.extractCustomProperties(params);
        response = this.newDefaultCore(coreName, Optional.ofNullable(params.get("storeRef")).map(StoreRef::new).orElse(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), templateName, extraProperties);
        if (!Objects.equals(response.get(ACTION_STATUS_LABEL), ACTION_STATUS_ERROR)) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        }
        return response;
    }

    private NamedList<Object> newDefaultCore(String coreName, StoreRef storeRef, String templateName, Properties extraProperties) {
        return this.newCore(coreName, 1, storeRef, templateName, 1, 1, 1, null, extraProperties);
    }

    protected NamedList<Object> newCore(String coreName, int numShards, StoreRef storeRef, String templateName, int replicationFactor, int nodeInstance, int numNodes, String shardIds, Properties extraProperties) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        try {
            File solrHome = new File(this.coreContainer.getSolrHome());
            File templates = new File(solrHome, "templates");
            File template = new File(templates, templateName);
            if (numShards > 1) {
                List shards;
                String collectionName = templateName + "--" + storeRef.getProtocol() + "-" + storeRef.getIdentifier() + "--shards--" + numShards + "-x-" + replicationFactor + "--node--" + nodeInstance + "-of-" + numNodes;
                String coreBase = storeRef.getProtocol() + "-" + storeRef.getIdentifier() + "-";
                if (coreName != null) {
                    collectionName = templateName + "--" + (String)coreName + "--shards--" + numShards + "-x-" + replicationFactor + "--node--" + nodeInstance + "-of-" + numNodes;
                    coreBase = (String)coreName + "-";
                }
                File baseDirectory = new File(solrHome, collectionName);
                if (nodeInstance == -1) {
                    response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
                    response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + (String)coreName + " has NOT been created as nodeInstance param is required"));
                    return response;
                }
                if (shardIds != null) {
                    shards = this.extractShards(shardIds, numShards);
                } else {
                    ExplicitShardingPolicy policy = new ExplicitShardingPolicy(numShards, replicationFactor, numNodes);
                    if (!policy.configurationIsValid()) {
                        response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
                        response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + (String)coreName + " has NOT been created as explicit Sharding policy is not valid"));
                        return response;
                    }
                    shards = policy.getShardIdsForNode(nodeInstance);
                }
                ArrayList<Object> coresNotCreated = new ArrayList<Object>();
                for (Integer shard : shards) {
                    coreName = coreBase + shard;
                    File newCore = new File(baseDirectory, (String)coreName);
                    response.addAll(this.createAndRegisterNewCore(extraProperties, storeRef, template, (String)coreName, newCore, numShards, shard, templateName));
                    if (!Objects.equals(response.get(ACTION_STATUS_LABEL), ACTION_STATUS_ERROR)) continue;
                    coresNotCreated.add(coreName);
                }
                if (coresNotCreated.size() > 0) {
                    response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
                    response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Following cores have not been created: " + String.valueOf(coresNotCreated)));
                    return response;
                }
                response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
                return response;
            }
            if (coreName == null) {
                coreName = storeRef.getProtocol() + "-" + storeRef.getIdentifier();
            }
            File newCore = new File(solrHome, (String)coreName);
            return this.createAndRegisterNewCore(extraProperties, storeRef, template, (String)coreName, newCore, 0, 0, templateName);
        }
        catch (IOException exception) {
            LOGGER.error("I/O Failure detected while creating the new core (name={}, numShard={}, storeRef={}, template={}, replication factor={}, node instance={}, num nodes={}, shard ids={})", new Object[]{coreName, numShards, storeRef, templateName, replicationFactor, nodeInstance, numNodes, shardIds, exception});
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + (String)coreName + " has NOT been created. Check the log to find out the reason."));
            return response;
        }
    }

    List<Integer> extractShards(String shardIds, int excludeFromShardId) {
        return Arrays.stream(Objects.requireNonNullElse(shardIds, "").split(",")).map(String::trim).map(Utils::toIntOrNull).filter(Objects::nonNull).filter(shard -> shard < excludeFromShardId).collect(Collectors.toList());
    }

    private NamedList<Object> createAndRegisterNewCore(Properties extraProperties, StoreRef storeRef, File template, String coreName, File newCore, int shardCount, int shardInstance, String templateName) throws IOException {
        SimpleOrderedMap response = new SimpleOrderedMap();
        if (this.coreContainer.getLoadedCoreNames().contains(coreName)) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("core " + coreName + " already exists, not creating again."));
            return response;
        }
        FileUtils.copyDirectory((File)template, (File)newCore, (boolean)false);
        File config = new File(newCore, "conf/solrcore.properties");
        Properties properties = new Properties();
        String defaultRoot = newCore.getCanonicalPath();
        if (defaultRoot.endsWith(coreName)) {
            defaultRoot = defaultRoot.substring(0, defaultRoot.length() - coreName.length());
        }
        properties.setProperty(DATA_DIR_ROOT, defaultRoot);
        properties.setProperty("data.dir.store", coreName);
        properties.setProperty("alfresco.stores", storeRef.toString());
        try (FileInputStream fileInputStream = new FileInputStream(config);){
            properties.load(fileInputStream);
        }
        properties.setProperty("alfresco.template", templateName);
        if (shardCount > 0) {
            properties.setProperty("shard.count", "" + shardCount);
            properties.setProperty("shard.instance", "" + shardInstance);
        }
        properties.setProperty(DATA_DIR_ROOT, ConfigUtil.locateProperty(DATA_DIR_ROOT, properties.getProperty(DATA_DIR_ROOT)));
        if (extraProperties != null && !extraProperties.isEmpty()) {
            properties.putAll((Map<?, ?>)extraProperties);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(config);){
            properties.store(fileOutputStream, null);
        }
        SolrCore core = this.coreContainer.create(coreName, newCore.toPath(), new HashMap(), false);
        response.add("core", (Object)core.getName());
        return response;
    }

    boolean hasAlfrescoCore(Collection<SolrCore> cores) {
        return Utils.notNullOrEmpty(cores).stream().map(SolrCore::getName).anyMatch(this.trackerRegistry::hasTrackersForCore);
    }

    private NamedList<Object> updateShared(SolrQueryRequest req) {
        SolrParams params = req.getParams();
        SimpleOrderedMap response = new SimpleOrderedMap();
        try {
            File config = new File(AlfrescoSolrDataModel.getResourceDirectory(), "shared.properties");
            HandlerOfResources.updateSharedProperties(params, config, this.hasAlfrescoCore(this.coreContainer.getCores()));
            this.coreContainer.getCores().stream().map(SolrCore::getName).forEach(arg_0 -> ((CoreContainer)this.coreContainer).reload(arg_0));
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        }
        catch (IOException e) {
            LOGGER.error("Failed to update Shared properties ", (Throwable)e);
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)"Shared properties couldn't be reloaded for some core. Check the log to find out the reason.");
            return response;
        }
        return response;
    }

    private NamedList<Object> updateCore(SolrQueryRequest req) {
        var wrapper = new Object(){
            NamedList<Object> response = new SimpleOrderedMap();
        };
        Optional.ofNullable(this.coreName(req.getParams())).map(String::trim).filter(coreName -> !coreName.isEmpty()).ifPresentOrElse(coreName -> {
            try (SolrCore core = this.coreContainer.getCore(coreName);){
                if (core == null) {
                    wrapper.response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
                    wrapper.response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + coreName + " has NOT been updated as it doesn't exist"));
                } else {
                    String configLocaltion = core.getResourceLoader().getConfigDir();
                    File config = new File(configLocaltion, "solrcore.properties");
                    HandlerOfResources.updatePropertiesFile(req.getParams(), config, null);
                    this.coreContainer.reload(coreName);
                    wrapper.response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
                }
            }
        }, () -> {
            wrapper.response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            wrapper.response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)"Core has NOT been updated as coreName param is required");
        });
        return wrapper.response;
    }

    private NamedList<Object> removeCore(SolrQueryRequest req) {
        String store = "";
        SolrParams params = req.getParams();
        SimpleOrderedMap response = new SimpleOrderedMap();
        if (params.get("storeRef") != null) {
            store = params.get("storeRef");
        }
        if (store == null || store.length() == 0) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + params.get("coreName") + " has NOT been removed as storeRef param is required"));
            return response;
        }
        StoreRef storeRef = new StoreRef(store);
        String coreName = Optional.ofNullable(this.coreName(req.getParams())).orElse(storeRef.getProtocol() + "-" + storeRef.getIdentifier());
        SolrCore core = this.coreContainer.getCore(coreName);
        if (core == null) {
            response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
            response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)("Core " + params.get("coreName") + " has NOT been removed as it doesn't exist"));
            return response;
        }
        while (core.getOpenCount() > 1) {
            core.close();
        }
        this.coreContainer.unload(coreName, true, true, true);
        response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        return response;
    }

    private NamedList<Object> actionCHECK(String cname) {
        this.coreNames().stream().filter(coreName -> cname == null || coreName.equals(cname)).map(this.trackerRegistry::getTrackersForCore).flatMap(Collection::stream).map(Tracker::getTrackerState).forEach(state -> state.setCheck(true));
        SimpleOrderedMap response = new SimpleOrderedMap();
        response.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SUCCESS);
        return response;
    }

    private NamedList<Object> actionNODEREPORTS(SolrParams params) throws JSONException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        if (params.get(ARG_NODEID) == null) {
            report.add(ACTION_STATUS_ERROR, (Object)"No nodeid parameter set.");
            return report;
        }
        Long nodeid = Long.valueOf(params.get(ARG_NODEID));
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this.trackerRegistry::hasTrackersForCore).map(coreName -> new Pair(coreName, (Object)this.nodeStatusChecker((String)coreName))).filter(coreNameAndNodeChecker -> coreNameAndNodeChecker.getSecond() != null).forEach(arg_0 -> AlfrescoCoreAdminHandler.lambda$actionNODEREPORTS$13((NamedList)report, nodeid, arg_0));
        return report;
    }

    private NamedList<Object> actionACLREPORT(SolrParams params) throws JSONException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        if (params.get(ARG_ACLID) == null) {
            report.add(ACTION_STATUS_ERROR, (Object)"No aclid parameter set.");
            return report;
        }
        Long aclid = Long.valueOf(params.get(ARG_ACLID));
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).map(coreName -> new Pair(coreName, (Object)this.trackerRegistry.getTrackerForCore((String)coreName, AclTracker.class))).filter(coreNameAndAclTracker -> coreNameAndAclTracker.getSecond() != null).forEach(arg_0 -> AlfrescoCoreAdminHandler.lambda$actionACLREPORT$17((NamedList)report, aclid, arg_0));
        if (report.size() == 0) {
            this.addAlertMessage((NamedList<Object>)report);
        }
        return report;
    }

    private NamedList<Object> actionTXREPORT(SolrParams params) throws JSONException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        if (params.get(ARG_TXID) == null) {
            report.add(ACTION_STATUS_ERROR, (Object)"No txid parameter set.");
            return report;
        }
        Long txid = Long.valueOf(params.get(ARG_TXID));
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).map(coreName -> new Pair(coreName, (Object)this.trackerRegistry.getTrackerForCore((String)coreName, MetadataTracker.class))).filter(coreNameAndMetadataTracker -> coreNameAndMetadataTracker.getSecond() != null).forEach(arg_0 -> this.lambda$actionTXREPORT$21((NamedList)report, txid, arg_0));
        if (report.size() == 0) {
            this.addAlertMessage((NamedList<Object>)report);
        }
        return report;
    }

    private NamedList<Object> actionACLTXREPORT(SolrParams params) throws JSONException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        if (params.get(ARG_ACLTXID) == null) {
            report.add(ACTION_STATUS_ERROR, (Object)"No acltxid parameter set.");
            return report;
        }
        Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).map(coreName -> new Pair(coreName, (Object)this.trackerRegistry.getTrackerForCore((String)coreName, AclTracker.class))).filter(coreNameAndAclTracker -> coreNameAndAclTracker.getSecond() != null).forEach(arg_0 -> this.lambda$actionACLTXREPORT$25((NamedList)report, acltxid, arg_0));
        if (report.size() == 0) {
            this.addAlertMessage((NamedList<Object>)report);
        }
        return report;
    }

    private NamedList<Object> rangeCheck(SolrParams params) throws IOException {
        SimpleOrderedMap response = new SimpleOrderedMap();
        String coreName = this.coreName(params);
        if (coreName == null) {
            response.add(ACTION_STATUS_ERROR, (Object)"No core parameter set.");
            return response;
        }
        if (this.isMasterOrStandalone(coreName)) {
            InformationServer informationServer = this.informationServers.get(coreName);
            DocRouter docRouter = this.getDocRouter(coreName);
            if (docRouter instanceof DBIDRangeRouter) {
                DBIDRangeRouter dbidRangeRouter = (DBIDRangeRouter)docRouter;
                if (!dbidRangeRouter.getInitialized()) {
                    response.add("expand", (Object)0);
                    response.add("exception", (Object)"DBIDRangeRouter not initialized yet.");
                    return response;
                }
                long startRange = dbidRangeRouter.getStartRange();
                long endRange = dbidRangeRouter.getEndRange();
                long maxNodeId = informationServer.maxNodeId();
                long minNodeId = informationServer.minNodeId();
                long nodeCount = informationServer.nodeCount();
                long bestGuess = -1L;
                long range = endRange - startRange;
                long midpoint = startRange + (long)((double)range * 0.5);
                long safe = startRange + (long)((double)range * 0.75);
                long offset = maxNodeId - startRange;
                double density = 0.0;
                if (offset > 0L) {
                    density = (double)nodeCount / (double)offset;
                }
                if (!dbidRangeRouter.getExpanded() && maxNodeId <= safe) {
                    if (maxNodeId >= midpoint) {
                        if (density >= 1.0 || density == 0.0) {
                            bestGuess = 0L;
                        } else {
                            double multiplier = 1.0 / density;
                            bestGuess = (long)((double)range * multiplier) - range;
                        }
                    } else {
                        bestGuess = 0L;
                    }
                }
                response.add("start", (Object)startRange);
                response.add("end", (Object)endRange);
                response.add("nodeCount", (Object)nodeCount);
                response.add("minDbid", (Object)minNodeId);
                response.add("maxDbid", (Object)maxNodeId);
                response.add("density", (Object)Math.abs(density));
                response.add("expand", (Object)bestGuess);
                response.add("expanded", (Object)dbidRangeRouter.getExpanded());
            } else {
                response.add("expand", (Object)-1);
                response.add("exception", (Object)("ERROR: Wrong document router type:" + docRouter.getClass().getSimpleName()));
            }
        } else {
            this.addAlertMessage((NamedList<Object>)response);
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized NamedList<Object> expand(SolrParams params) throws IOException {
        long range;
        long safe;
        SimpleOrderedMap response = new SimpleOrderedMap();
        String coreName = this.coreName(params);
        if (coreName == null) {
            response.add(ACTION_STATUS_ERROR, (Object)"No core parameter set.");
            return response;
        }
        if (!this.isMasterOrStandalone(coreName)) {
            this.addAlertMessage((NamedList<Object>)response);
            return response;
        }
        InformationServer informationServer = this.informationServers.get(coreName);
        DocRouter docRouter = this.getDocRouter(coreName);
        if (!(docRouter instanceof DBIDRangeRouter)) {
            response.add("expand", (Object)-1);
            response.add("exception", (Object)("Wrong document router type:" + docRouter.getClass().getSimpleName()));
            return response;
        }
        long expansion = Long.parseLong(params.get("add"));
        DBIDRangeRouter dbidRangeRouter = (DBIDRangeRouter)docRouter;
        if (!dbidRangeRouter.getInitialized()) {
            response.add("expand", (Object)-1);
            response.add("exception", (Object)"DBIDRangeRouter not initialized yet.");
            return response;
        }
        if (dbidRangeRouter.getExpanded()) {
            response.add("expand", (Object)-1);
            response.add("exception", (Object)"dbid range has already been expanded.");
            return response;
        }
        long currentEndRange = dbidRangeRouter.getEndRange();
        long startRange = dbidRangeRouter.getStartRange();
        long maxNodeId = informationServer.maxNodeId();
        if (maxNodeId > (safe = startRange + (long)((double)(range = currentEndRange - startRange) * 0.75))) {
            response.add("expand", (Object)-1);
            response.add("exception", (Object)"Expansion cannot occur if max DBID in the index is more then 75% of range.");
            return response;
        }
        long newEndRange = expansion + dbidRangeRouter.getEndRange();
        try {
            informationServer.capIndex(newEndRange);
            informationServer.hardCommit();
            dbidRangeRouter.setEndRange(newEndRange);
            dbidRangeRouter.setExpanded(true);
            assert (newEndRange == dbidRangeRouter.getEndRange());
            response.add("expand", (Object)dbidRangeRouter.getEndRange());
            return response;
        }
        catch (Throwable t) {
            response.add("expand", (Object)-1);
            response.add("exception", (Object)t.getMessage());
            LOGGER.error("exception expanding", t);
            return response;
        }
    }

    private NamedList<Object> actionREPORT(SolrParams params) throws JSONException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        Long fromTime = HandlerOfResources.getSafeLong(params, "fromTime");
        Long toTime = HandlerOfResources.getSafeLong(params, "toTime");
        Long fromTx = HandlerOfResources.getSafeLong(params, "fromTx");
        Long toTx = HandlerOfResources.getSafeLong(params, "toTx");
        Long fromAclTx = HandlerOfResources.getSafeLong(params, "fromAclTx");
        Long toAclTx = HandlerOfResources.getSafeLong(params, "toAclTx");
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this.trackerRegistry::hasTrackersForCore).filter(this::isMasterOrStandalone).forEach(arg_0 -> this.lambda$actionREPORT$27((NamedList)report, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime, arg_0));
        if (report.size() == 0) {
            this.addAlertMessage((NamedList<Object>)report);
        }
        return report;
    }

    NamedList<Object> actionPURGE(SolrParams params) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        Consumer<String> purgeOnSpecificCore = arg_0 -> this.lambda$actionPURGE$28(params, (NamedList)response, arg_0);
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(purgeOnSpecificCore);
        if (response.size() == 0) {
            this.addAlertMessage((NamedList<Object>)response);
        }
        return response;
    }

    NamedList<Object> actionREINDEX(SolrParams params) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        Consumer<String> reindexOnSpecificCore = arg_0 -> this.lambda$actionREINDEX$30(params, (NamedList)response, arg_0);
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(reindexOnSpecificCore);
        if (response.size() == 0) {
            this.addAlertMessage((NamedList<Object>)response);
        }
        return response;
    }

    NamedList<Object> actionRETRY(SolrParams params) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        Consumer<String> retryOnSpecificCore = arg_0 -> this.lambda$actionRETRY$32((NamedList)response, arg_0);
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(retryOnSpecificCore);
        if (response.size() == 0) {
            this.addAlertMessage((NamedList<Object>)response);
        }
        return response;
    }

    NamedList<Object> actionINDEX(SolrParams params) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        Consumer<String> indexOnSpecificCore = arg_0 -> this.lambda$actionINDEX$34(params, (NamedList)response, arg_0);
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(indexOnSpecificCore);
        if (response.size() == 0) {
            this.addAlertMessage((NamedList<Object>)response);
        }
        return response;
    }

    NamedList<Object> actionDisableIndexing(SolrParams params) throws JSONException {
        return this.executeTrackerSubsystemLifecycleAction(params, this::disableIndexingOnSpecificCore);
    }

    NamedList<Object> actionEnableIndexing(SolrParams params) throws JSONException {
        return this.executeTrackerSubsystemLifecycleAction(params, this::enableIndexingOnSpecificCore);
    }

    NamedList<Object> actionFIX(SolrParams params) throws JSONException {
        String requestedCoreName = this.coreName(params);
        var wrapper = new Object(){
            final NamedList<Object> response = new SimpleOrderedMap();
        };
        if (Utils.isNullOrEmpty(requestedCoreName)) {
            return wrapper.response;
        }
        if (!this.coreNames().contains(requestedCoreName)) {
            wrapper.response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)(UNKNOWN_CORE_MESSAGE + requestedCoreName));
            return wrapper.response;
        }
        if (!this.isMasterOrStandalone(requestedCoreName)) {
            wrapper.response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)UNPROCESSABLE_REQUEST_ON_SLAVE_NODES);
            return wrapper.response;
        }
        Long fromTxCommitTime = params.getLong(FROM_TX_COMMIT_TIME_PARAMETER_NAME);
        Long toTxCommitTime = params.getLong(TO_TX_COMMIT_TIME_PARAMETER_NAME);
        boolean dryRun = params.getBool(DRY_RUN_PARAMETER_NAME, true);
        int maxTransactionsToSchedule = this.getMaxTransactionToSchedule(params);
        MetadataTracker metadataTracker = this.trackerRegistry.getTrackerForCore(requestedCoreName, MetadataTracker.class);
        AclTracker aclTracker = this.trackerRegistry.getTrackerForCore(requestedCoreName, AclTracker.class);
        boolean actualDryRun = dryRun | (metadataTracker == null || metadataTracker.isDisabled()) || aclTracker == null || aclTracker.isDisabled();
        LOGGER.debug("FIX Admin request on core {}, parameters: fromTxCommitTime = {}, toTxCommitTime = {}, dryRun = {}, actualDryRun = {} maxScheduledTransactions = {}", new Object[]{requestedCoreName, Optional.ofNullable(fromTxCommitTime).map(Object::toString).orElse("N.A."), Optional.ofNullable(toTxCommitTime).map(Object::toString).orElse("N.A."), dryRun, actualDryRun, maxTransactionsToSchedule});
        this.coreNames().stream().filter(coreName -> coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(coreName -> wrapper.response.add(coreName, this.fixOnSpecificCore((String)coreName, fromTxCommitTime, toTxCommitTime, actualDryRun, maxTransactionsToSchedule)));
        if (wrapper.response.size() > 0) {
            wrapper.response.add(DRY_RUN_PARAMETER_NAME, (Object)dryRun);
            Optional.ofNullable(fromTxCommitTime).ifPresent(value -> wrapper.response.add(FROM_TX_COMMIT_TIME_PARAMETER_NAME, value));
            Optional.ofNullable(toTxCommitTime).ifPresent(value -> wrapper.response.add(TO_TX_COMMIT_TIME_PARAMETER_NAME, value));
            wrapper.response.add(MAX_TRANSACTIONS_TO_SCHEDULE_PARAMETER_NAME, (Object)maxTransactionsToSchedule);
            wrapper.response.add(ACTION_STATUS_LABEL, (Object)(actualDryRun ? ACTION_STATUS_NOT_SCHEDULED : ACTION_STATUS_SCHEDULED));
            if (!dryRun && actualDryRun) {
                wrapper.response.add(ADDITIONAL_INFO, (Object)"Trackers are disabled: a (dryRun = true) has been forced. As consequence of that nothing has been scheduled.");
            }
        }
        return wrapper.response;
    }

    NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
        try {
            MetadataTracker metadataTracker = this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
            AclTracker aclTracker = this.trackerRegistry.getTrackerForCore(coreName, AclTracker.class);
            IndexHealthReport metadataTrackerIndexHealthReport = metadataTracker.checkIndex(null, fromTxCommitTime, toTxCommitTime);
            LOGGER.debug("FIX Admin action built the MetadataTracker Index Health Report on core {}, parameters: fromTxCommitTime = {}, toTxCommitTime = {}, dryRun = {}, maxScheduledTransactions = {}", new Object[]{coreName, Optional.ofNullable(fromTxCommitTime).map(Object::toString).orElse("N.A."), Optional.ofNullable(toTxCommitTime).map(Object::toString).orElse("N.A."), dryRun, maxTransactionsToSchedule});
            IndexHealthReport aclTrackerIndexHealthReport = aclTracker.checkIndex(null, fromTxCommitTime, toTxCommitTime);
            LOGGER.debug("FIX Admin action built the AclTracker Index Health Report on core {}, parameters: fromTxCommitTime = {}, toTxCommitTime = {}, dryRun = {}, maxScheduledTransactions = {}", new Object[]{coreName, Optional.ofNullable(fromTxCommitTime).map(Object::toString).orElse("N.A."), Optional.ofNullable(toTxCommitTime).map(Object::toString).orElse("N.A."), dryRun, maxTransactionsToSchedule});
            SimpleOrderedMap response = new SimpleOrderedMap();
            response.add(ACTION_TX_TO_REINDEX, this.txToReindex(coreName, metadataTracker, metadataTrackerIndexHealthReport, dryRun ? txid -> {} : metadataTracker::addTransactionToReindex, maxTransactionsToSchedule));
            response.add(ACTION_ACL_CHANGE_SET_TO_REINDEX, this.aclTxToReindex(coreName, aclTracker, aclTrackerIndexHealthReport, dryRun ? txid -> {} : aclTracker::addAclChangeSetToReindex, maxTransactionsToSchedule));
            return response;
        }
        catch (Exception exception) {
            throw new AlfrescoRuntimeException("", (Throwable)exception);
        }
    }

    NamedList<Object> txToReindex(String coreName, MetadataTracker tracker, IndexHealthReport report, Consumer<Long> scheduler, int maxTransactionsToSchedule) {
        AtomicInteger globalLimit = new AtomicInteger(maxTransactionsToSchedule);
        LongToIntFunction retrieveTransactionRelatedNodesCountFromRepository = txid -> Utils.notNullOrEmpty(tracker.getFullNodesForDbTransaction(txid)).size();
        LongToIntFunction retrieveTransactionRelatedNodesCountFromIndex = txid -> Optional.of(this.getInformationServers().get(coreName)).map(SolrInformationServer.class::cast).map(server -> server.getDocListSize("INTXID:" + txid)).orElse(0);
        SimpleOrderedMap txToReindex = new SimpleOrderedMap();
        txToReindex.add(TX_IN_INDEX_NOT_IN_DB, this.manageTransactionsToBeFixed(report.getTxInIndexButNotInDb(), retrieveTransactionRelatedNodesCountFromIndex, scheduler, globalLimit));
        txToReindex.add(DUPLICATED_TX_IN_INDEX, this.manageTransactionsToBeFixed(report.getDuplicatedTxInIndex(), retrieveTransactionRelatedNodesCountFromIndex, scheduler, globalLimit));
        txToReindex.add(MISSING_TX_IN_INDEX, this.manageTransactionsToBeFixed(report.getMissingTxFromIndex(), retrieveTransactionRelatedNodesCountFromRepository, scheduler, globalLimit));
        return txToReindex;
    }

    NamedList<Object> aclTxToReindex(String coreName, AclTracker tracker, IndexHealthReport report, Consumer<Long> scheduler, int maxTransactionsToSchedule) {
        AtomicInteger globalLimit = new AtomicInteger(maxTransactionsToSchedule);
        LongToIntFunction retrieveAclTransactionRelatedNodesCountFromRepository = txid -> Utils.notNullOrEmpty(tracker.getAclsForDbAclTransaction(txid)).size();
        LongToIntFunction retrieveAclTransactionRelatedNodesCountFromIndex = txid -> Optional.of(this.getInformationServers().get(coreName)).map(SolrInformationServer.class::cast).map(server -> server.getDocListSize("INACLTXID:" + txid)).orElse(0);
        SimpleOrderedMap aclTxToReindex = new SimpleOrderedMap();
        aclTxToReindex.add(ACL_TX_IN_INDEX_NOT_IN_DB, this.manageTransactionsToBeFixed(report.getAclTxInIndexButNotInDb(), retrieveAclTransactionRelatedNodesCountFromIndex, scheduler, globalLimit));
        aclTxToReindex.add(DUPLICATED_ACL_TX_IN_INDEX, this.manageTransactionsToBeFixed(report.getDuplicatedAclTxInIndex(), retrieveAclTransactionRelatedNodesCountFromIndex, scheduler, globalLimit));
        aclTxToReindex.add(MISSING_ACL_TX_IN_INDEX, this.manageTransactionsToBeFixed(report.getMissingAclTxFromIndex(), retrieveAclTransactionRelatedNodesCountFromRepository, scheduler, globalLimit));
        return aclTxToReindex;
    }

    NamedList<Object> manageTransactionsToBeFixed(IOpenBitSet transactions, LongToIntFunction nodesCounter, Consumer<Long> scheduler, AtomicInteger limit) {
        SimpleOrderedMap transactionsList = new SimpleOrderedMap();
        long txid = -1L;
        while ((txid = transactions.nextSetBit(txid + 1L)) != -1L && limit.decrementAndGet() >= 0) {
            transactionsList.add(String.valueOf(txid), (Object)nodesCounter.applyAsInt(txid));
            scheduler.accept(txid);
        }
        return transactionsList;
    }

    private NamedList<Object> actionSUMMARY(SolrParams params) {
        SimpleOrderedMap report = new SimpleOrderedMap();
        String requestedCoreName = this.coreName(params);
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).forEach(arg_0 -> this.lambda$actionSUMMARY$49(params, (NamedList)report, arg_0));
        return report;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void coreSummary(SolrParams params, NamedList<Object> report, String coreName) {
        boolean detail = HandlerOfResources.getSafeBoolean(params, "detail");
        boolean hist = HandlerOfResources.getSafeBoolean(params, "hist");
        boolean values = HandlerOfResources.getSafeBoolean(params, "values");
        boolean reset = HandlerOfResources.getSafeBoolean(params, "reset");
        InformationServer srv = this.informationServers.get(coreName);
        if (srv != null) {
            try {
                if (this.isMasterOrStandalone(coreName)) {
                    HandlerReportHelper.addMasterOrStandaloneCoreSummary(this.trackerRegistry, coreName, detail, hist, values, srv, report);
                    if (!reset) return;
                    srv.getTrackerStats().reset();
                    return;
                }
                HandlerReportHelper.addSlaveCoreSummary(this.trackerRegistry, coreName, detail, hist, values, srv, report);
                return;
            }
            catch (Exception exception) {
                throw new AlfrescoRuntimeException("", (Throwable)exception);
            }
        } else {
            report.add(coreName, (Object)"Core unknown");
        }
    }

    DocRouter getDocRouter(String cname) {
        return Optional.ofNullable(this.trackerRegistry.getTrackerForCore(cname, MetadataTracker.class)).map(AbstractTracker::getDocRouter).orElse(null);
    }

    public ConcurrentHashMap<String, InformationServer> getInformationServers() {
        return this.informationServers;
    }

    public TrackerRegistry getTrackerRegistry() {
        return this.trackerRegistry;
    }

    void setTrackerRegistry(TrackerRegistry trackerRegistry) {
        this.trackerRegistry = trackerRegistry;
    }

    public SolrTrackerScheduler getScheduler() {
        return this.scheduler;
    }

    private void waitForTenSeconds() {
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    AbstractTracker nodeStatusChecker(String coreName) {
        return this.isMasterOrStandalone(coreName) ? (AbstractTracker)this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class) : (AbstractTracker)this.trackerRegistry.getTrackerForCore(coreName, ShardStatePublisher.class);
    }

    boolean isMasterOrStandalone(String coreName) {
        return this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class) != null;
    }

    private void addAlertMessage(NamedList<Object> report) {
        report.add(WARNING, (Object)"The requested endpoint is not available on the slave. Please re-submit the same request to the corresponding Master");
    }

    Collection<String> coreNames() {
        return Utils.notNullOrEmpty(this.trackerRegistry.getCoreNames());
    }

    private void apply(SolrParams params, String parameterName, Consumer<Long> executeSideEffectAction) {
        Optional.ofNullable(params.get(parameterName)).map(Long::valueOf).ifPresent(executeSideEffectAction);
    }

    String coreName(SolrParams params) {
        return CORE_PARAMETER_NAMES.stream().map(arg_0 -> ((SolrParams)params).get(arg_0)).filter(Objects::nonNull).map(String::trim).findFirst().orElse(null);
    }

    int getMaxTransactionToSchedule(SolrParams params) {
        String requestedCoreName = this.coreName(params);
        return Optional.ofNullable(params.getInt(MAX_TRANSACTIONS_TO_SCHEDULE_PARAMETER_NAME)).orElseGet(() -> Optional.ofNullable(this.coreContainer).map(container -> container.getCore(requestedCoreName)).map(SolrCore::getResourceLoader).map(SolrResourceLoader::getCoreProperties).map(conf -> conf.getProperty(MAX_TRANSACTIONS_TO_SCHEDULE_CONF_PROPERTY_NAME)).map(Integer::parseInt).orElse(Integer.MAX_VALUE));
    }

    NamedList<Object> disableIndexingOnSpecificCore(String coreName) {
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        this.trackerRegistry.getTrackersForCore(coreName).stream().filter(tracker -> tracker instanceof ActivatableTracker).map(ActivatableTracker.class::cast).peek(ActivatableTracker::disable).forEach(arg_0 -> AlfrescoCoreAdminHandler.lambda$disableIndexingOnSpecificCore$54((NamedList)coreResponse, arg_0));
        return coreResponse;
    }

    NamedList<Object> enableIndexingOnSpecificCore(String coreName) {
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        this.trackerRegistry.getTrackersForCore(coreName).stream().filter(tracker -> tracker instanceof ActivatableTracker).map(ActivatableTracker.class::cast).peek(ActivatableTracker::enable).forEach(arg_0 -> AlfrescoCoreAdminHandler.lambda$enableIndexingOnSpecificCore$56((NamedList)coreResponse, arg_0));
        return coreResponse;
    }

    private NamedList<Object> executeTrackerSubsystemLifecycleAction(SolrParams params, Function<String, NamedList<Object>> action) throws JSONException {
        String requestedCoreName = this.coreName(params);
        SimpleOrderedMap response = new SimpleOrderedMap();
        if (Utils.isNotNullAndNotEmpty(requestedCoreName)) {
            if (!this.coreNames().contains(requestedCoreName)) {
                response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)(UNKNOWN_CORE_MESSAGE + requestedCoreName));
                return response;
            }
            if (!this.isMasterOrStandalone(requestedCoreName)) {
                response.add(ACTION_ERROR_MESSAGE_LABEL, (Object)UNPROCESSABLE_REQUEST_ON_SLAVE_NODES);
                return response;
            }
        }
        this.coreNames().stream().filter(coreName -> requestedCoreName == null || coreName.equals(requestedCoreName)).filter(this::isMasterOrStandalone).forEach(arg_0 -> AlfrescoCoreAdminHandler.lambda$executeTrackerSubsystemLifecycleAction$58((NamedList)response, action, arg_0));
        return response;
    }

    private static /* synthetic */ void lambda$executeTrackerSubsystemLifecycleAction$58(NamedList response, Function action, String coreName) {
        response.add(coreName, action.apply(coreName));
    }

    private static /* synthetic */ void lambda$enableIndexingOnSpecificCore$56(NamedList coreResponse, ActivatableTracker tracker) {
        coreResponse.add(tracker.getType().toString(), (Object)tracker.isEnabled());
    }

    private static /* synthetic */ void lambda$disableIndexingOnSpecificCore$54(NamedList coreResponse, ActivatableTracker tracker) {
        coreResponse.add(tracker.getType().toString(), (Object)tracker.isEnabled());
    }

    private /* synthetic */ void lambda$actionSUMMARY$49(SolrParams params, NamedList report, String coreName) {
        this.coreSummary(params, (NamedList<Object>)report, coreName);
    }

    private /* synthetic */ void lambda$actionINDEX$34(SolrParams params, NamedList response, String coreName) {
        MetadataTracker metadataTracker = this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
        AclTracker aclTracker = this.trackerRegistry.getTrackerForCore(coreName, AclTracker.class);
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        if (metadataTracker.isEnabled() & aclTracker.isEnabled()) {
            this.apply(params, ARG_TXID, metadataTracker::addTransactionToIndex);
            this.apply(params, ARG_ACLTXID, aclTracker::addAclChangeSetToIndex);
            this.apply(params, ARG_NODEID, metadataTracker::addNodeToIndex);
            this.apply(params, ARG_ACLID, aclTracker::addAclToIndex);
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SCHEDULED);
        } else {
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_NOT_SCHEDULED);
            coreResponse.add(ADDITIONAL_INFO, (Object)"Trackers have been disabled: the INDEX request cannot be executed; please enable indexing and then resubmit this command.");
        }
        response.add(coreName, (Object)coreResponse);
    }

    private /* synthetic */ void lambda$actionRETRY$32(NamedList response, String coreName) {
        MetadataTracker tracker = this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
        InformationServer srv = this.informationServers.get(coreName);
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        if (tracker.isEnabled()) {
            try {
                for (Long nodeid : srv.getErrorDocIds()) {
                    tracker.addNodeToReindex(nodeid);
                }
                coreResponse.add("Error Nodes", srv.getErrorDocIds());
                coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SCHEDULED);
            }
            catch (Exception exception) {
                LOGGER.error("I/O Exception while adding Node to reindex.", (Throwable)exception);
                coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_ERROR);
                coreResponse.add(ACTION_ERROR_MESSAGE_LABEL, (Object)exception.getMessage());
                coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_NOT_SCHEDULED);
            }
        } else {
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_NOT_SCHEDULED);
            coreResponse.add(ADDITIONAL_INFO, (Object)"Trackers have been disabled: the RETRY request cannot be executed; please enable indexing and then resubmit this command.");
        }
        response.add(coreName, (Object)coreResponse);
    }

    private /* synthetic */ void lambda$actionREINDEX$30(SolrParams params, NamedList response, String coreName) {
        MetadataTracker metadataTracker = this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
        AclTracker aclTracker = this.trackerRegistry.getTrackerForCore(coreName, AclTracker.class);
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        if (metadataTracker.isEnabled() & aclTracker.isEnabled()) {
            this.apply(params, ARG_TXID, metadataTracker::addTransactionToReindex);
            this.apply(params, ARG_ACLTXID, aclTracker::addAclChangeSetToReindex);
            this.apply(params, ARG_NODEID, metadataTracker::addNodeToReindex);
            this.apply(params, ARG_ACLID, aclTracker::addAclToReindex);
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SCHEDULED);
            Optional.ofNullable(params.get(ARG_QUERY)).ifPresent(metadataTracker::addQueryToReindex);
        } else {
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_NOT_SCHEDULED);
            coreResponse.add(ADDITIONAL_INFO, (Object)"Trackers have been disabled: the REINDEX request cannot be executed; please enable indexing and then resubmit this command.");
        }
        response.add(coreName, (Object)coreResponse);
    }

    private /* synthetic */ void lambda$actionPURGE$28(SolrParams params, NamedList response, String coreName) {
        MetadataTracker metadataTracker = this.trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
        AclTracker aclTracker = this.trackerRegistry.getTrackerForCore(coreName, AclTracker.class);
        SimpleOrderedMap coreResponse = new SimpleOrderedMap();
        if (metadataTracker.isEnabled() & aclTracker.isEnabled()) {
            this.apply(params, ARG_TXID, metadataTracker::addTransactionToPurge);
            this.apply(params, ARG_ACLTXID, aclTracker::addAclChangeSetToPurge);
            this.apply(params, ARG_NODEID, metadataTracker::addNodeToPurge);
            this.apply(params, ARG_ACLID, aclTracker::addAclToPurge);
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_SCHEDULED);
        } else {
            coreResponse.add(ACTION_STATUS_LABEL, (Object)ACTION_STATUS_NOT_SCHEDULED);
            coreResponse.add(ADDITIONAL_INFO, (Object)"Trackers have been disabled: the purge request cannot be executed; please enable indexing and then resubmit this command.");
        }
        response.add(coreName, (Object)coreResponse);
    }

    private /* synthetic */ void lambda$actionREPORT$27(NamedList report, Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime, String coreName) {
        report.add(coreName, HandlerReportHelper.buildTrackerReport(this.trackerRegistry, this.informationServers.get(coreName), coreName, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime));
    }

    private /* synthetic */ void lambda$actionACLTXREPORT$25(NamedList report, Long acltxid, Pair coreNameAndAclTracker) {
        report.add((String)coreNameAndAclTracker.getFirst(), HandlerReportHelper.buildAclTxReport(this.trackerRegistry, this.informationServers.get(coreNameAndAclTracker.getFirst()), (String)coreNameAndAclTracker.getFirst(), (AclTracker)coreNameAndAclTracker.getSecond(), acltxid));
    }

    private /* synthetic */ void lambda$actionTXREPORT$21(NamedList report, Long txid, Pair coreNameAndMetadataTracker) {
        report.add((String)coreNameAndMetadataTracker.getFirst(), HandlerReportHelper.buildTxReport(this.trackerRegistry, this.informationServers.get(coreNameAndMetadataTracker.getFirst()), (String)coreNameAndMetadataTracker.getFirst(), (MetadataTracker)coreNameAndMetadataTracker.getSecond(), txid));
    }

    private static /* synthetic */ void lambda$actionACLREPORT$17(NamedList report, Long aclid, Pair coreNameAndAclTracker) {
        report.add((String)coreNameAndAclTracker.getFirst(), HandlerReportHelper.buildAclReport((AclTracker)coreNameAndAclTracker.getSecond(), aclid));
    }

    private static /* synthetic */ void lambda$actionNODEREPORTS$13(NamedList report, Long nodeid, Pair coreNameAndNodeChecker) {
        report.add((String)coreNameAndNodeChecker.getFirst(), HandlerReportHelper.buildNodeReport((AbstractTracker)coreNameAndNodeChecker.getSecond(), nodeid));
    }
}

