/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker.pool;

import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.solr.tracker.pool.DefaultTrackerPoolFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTrackerPoolFactoryTest {
    private DefaultTrackerPoolFactory poolFactory;
    private Properties properties;
    ThreadPoolExecutor tpe;

    @Before
    public void setup() {
        this.poolFactory = null;
        this.properties = new Properties();
    }

    @After
    public void teardown() {
        this.tpe.shutdownNow();
        this.tpe = null;
    }

    @Test
    public void testDefaults() {
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "TrackerName");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)4L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)4L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)120L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testNonDefaultProperties() {
        this.properties.put("alfresco.corePoolSize", "30");
        this.properties.put("alfresco.maximumPoolSize", "40");
        this.properties.put("alfresco.keepAliveTime", "200");
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "TrackerName");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)30L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)40L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)200L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testAclDefaultProperties() {
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "AclTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)4L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)4L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)120L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testAclProperties() {
        this.properties.put("alfresco.acl.tracker.corePoolSize", "30");
        this.properties.put("alfresco.acl.tracker.maximumPoolSize", "40");
        this.properties.put("alfresco.acl.tracker.keepAliveTime", "200");
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "AclTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)30L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)40L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)200L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testContentDefaultProperties() {
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "ContentTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)4L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)4L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)120L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testContentProperties() {
        this.properties.put("alfresco.content.tracker.corePoolSize", "100");
        this.properties.put("alfresco.content.tracker.maximumPoolSize", "140");
        this.properties.put("alfresco.content.tracker.keepAliveTime", "201");
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "ContentTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)100L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)140L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)201L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testMetaDataDefaultProperties() {
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "MetadataTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)4L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)4L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)120L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }

    @Test
    public void testMetaDataProperties() {
        this.properties.put("alfresco.metadata.tracker.corePoolSize", "100");
        this.properties.put("alfresco.metadata.tracker.maximumPoolSize", "140");
        this.properties.put("alfresco.metadata.tracker.keepAliveTime", "201");
        this.poolFactory = new DefaultTrackerPoolFactory(this.properties, "TheCore", "MetadataTracker");
        this.tpe = this.poolFactory.create();
        Assert.assertEquals((long)100L, (long)this.tpe.getCorePoolSize());
        Assert.assertEquals((long)140L, (long)this.tpe.getMaximumPoolSize());
        Assert.assertEquals((long)201L, (long)this.tpe.getKeepAliveTime(TimeUnit.SECONDS));
    }
}

