/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DBIDRouter;
import org.alfresco.solr.tracker.PropertyRouter;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PropertyRouterIT {
    private PropertyRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;
    @Mock
    private DBIDRouter fallback;

    @Before
    public void setUp() {
        this.router = new PropertyRouter(null);
        this.router.fallback = this.fallback;
    }

    @Test
    public void negativeShardCount_shouldAlwaysReturnTrue() {
        int negativeShardCount = -14;
        Assert.assertTrue((boolean)this.router.routeAcl(negativeShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(negativeShardCount, 1, this.node));
    }

    @Test
    public void zeroShardCount_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void oneShardInTheCluster_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void aclsAreReplicatedAcrossShards() {
        IntStream.range(0, 100).forEach(index -> Assert.assertTrue((boolean)this.router.routeAcl(AlfrescoSolrUtils.randomShardCountGreaterThanOne(), AlfrescoSolrUtils.randomPositiveInteger(), this.acl)));
    }

    @Test
    public void ifPropertyAndPatternAreNull_shouldFallbackToDbId() {
        Assert.assertNull((Object)this.router.pattern);
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn(null);
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        this.router.routeNode(shardCount, shardInstance, this.node);
        ((DBIDRouter)Mockito.verify((Object)this.fallback)).routeNode(shardCount, shardInstance, this.node);
    }

    @Test
    public void propertyDoesntMatchPattern_shouldFallbackToDbId() {
        this.router = new PropertyRouter("([0-9]*)_");
        this.router.fallback = this.fallback;
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn((Object)"This value doesn't contain any number");
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        this.router.routeNode(shardCount, shardInstance, this.node);
        ((DBIDRouter)Mockito.verify((Object)this.fallback)).routeNode(shardCount, shardInstance, this.node);
    }

    @Test
    public void propertyMatchesPatternButDoesntProduceAnyMatching_shouldFallbackToDbId() {
        this.router = new PropertyRouter("(0-9)*_.*");
        this.router.fallback = this.fallback;
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn((Object)"pippo_pluto");
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        this.router.routeNode(shardCount, shardInstance, this.node);
        ((DBIDRouter)Mockito.verify((Object)this.fallback)).routeNode(shardCount, shardInstance, this.node);
    }

    @Test
    public void propertyIsNullAndPatternIsEmpty_shouldFallbackToDbId() {
        String[] tests = new String[]{"", "    ", "\t\t\t", "\n\n"};
        Arrays.stream(tests).forEach(test -> {
            this.router = new PropertyRouter(test);
            this.router.fallback = this.fallback;
            Assert.assertNull((Object)this.router.pattern);
            Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn(null);
            int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
            int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
            this.router.routeNode(shardCount, shardInstance, this.node);
            ((DBIDRouter)Mockito.verify((Object)this.fallback)).routeNode(shardCount, shardInstance, this.node);
            Mockito.reset((Object[])new Object[]{this.node, this.fallback});
        });
    }

    @Test
    public void onlyPatternIsNull_shouldBalanceNodesOnShardProperty() {
        int[] shardIdentifiers = IntStream.range(0, 15).toArray();
        int shardCount = shardIdentifiers.length;
        int howManyDocumentsPerShard = 10000;
        HashMap nodeDistributionMap = new HashMap();
        IntStream.range(0, shardCount * howManyDocumentsPerShard).mapToLong(Long::valueOf).forEach(id -> {
            Node node = new Node();
            node.setShardPropertyValue(String.valueOf(id));
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeNode(shardCount, shardId, node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
        });
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        StandardDeviation sd = new StandardDeviation();
        double deviation = sd.evaluate(nodeDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        double norm = deviation / (double)howManyDocumentsPerShard * 100.0;
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        Assert.assertTrue((String)(nodeDistributionMap.values().toString() + ", SD = " + deviation + ", SD_NORM = " + norm + "%"), (norm < 30.0 ? 1 : 0) != 0);
    }

    @Test
    public void propertyAndPatternArentNull_shouldBalanceNodesOnShardProperty() {
        int[] shardIdentifiers = IntStream.range(0, 15).toArray();
        int shardCount = shardIdentifiers.length;
        int howManyDocumentsPerShard = 100000;
        HashMap nodeDistributionMap = new HashMap();
        this.router = new PropertyRouter("([0-9]*)(_)");
        this.router.fallback = this.fallback;
        IntStream.range(0, shardCount * howManyDocumentsPerShard).mapToLong(Long::valueOf).forEach(id -> {
            Node node = new Node();
            node.setShardPropertyValue(id + "_ignoreThisPart");
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeNode(shardCount, shardId, node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
        });
        StandardDeviation sd = new StandardDeviation();
        double deviation = sd.evaluate(nodeDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        double norm = deviation / (double)howManyDocumentsPerShard * 100.0;
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        Assert.assertTrue((String)(nodeDistributionMap.values().toString() + ", SD = " + deviation + ", SD_NORM = " + norm + "%"), (norm < 30.0 ? 1 : 0) != 0);
    }
}

