/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrJsonIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrJsonIT.initSolrServers(2, DistributedAlfrescoSolrJsonIT.getSimpleClassName(), null);
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrJsonIT.dismissSolrServers();
    }

    @Test
    public void testTracker() throws Exception {
        NodeMetaData nodeMetaData;
        Node node;
        int i;
        AlfrescoSolrUtils.TestActChanges testActChanges = new AlfrescoSolrUtils.TestActChanges().createBasicTestData();
        AclChangeSet aclChangeSet = testActChanges.getChangeSet();
        Acl acl1 = testActChanges.getFirstAcl();
        Acl acl2 = testActChanges.getSecondAcl();
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrJsonIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        DistributedAlfrescoSolrJsonIT.putHandleDefaults();
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i = 0; i < 500; ++i) {
            node = AlfrescoSolrUtils.getNode(bigTxn, acl1, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, acl1, "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        for (i = 0; i < 500; ++i) {
            node = AlfrescoSolrUtils.getNode(bigTxn, acl2, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, acl2, "steve", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedAlfrescoSolrJsonIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedAlfrescoSolrJsonIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrJsonIT.getDefaultTestClient(), true, "{\"authorities\": [ \"jim\", \"joel\" ], \"tenants\": [ \"\" ], \"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}", DistributedAlfrescoSolrJsonIT.params((String[])new String[]{"q", "t1:world", "qt", "/afts", "fq", "{!afts}AUTHORITY_FILTER_FROM_JSON", "shards.qt", "/afts", "start", "0", "rows", "1000", "sort", "id asc"}));
        DistributedAlfrescoSolrJsonIT.assertEquals((long)queryResponse.getResults().getNumFound(), (long)1000L);
        queryResponse = this.query(DistributedAlfrescoSolrJsonIT.getDefaultTestClient(), true, null, DistributedAlfrescoSolrJsonIT.params((String[])new String[]{"q", "t1:world", "ALFRESCO_JSON", "{\"authorities\": [ \"jim\" ], \"tenants\": [ \"\" ], \"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}", "qt", "/afts", "fq", "{!afts}AUTHORITY_FILTER_FROM_JSON", "shards.qt", "/afts", "start", "0", "rows", "100", "sort", "id asc"}));
        DistributedAlfrescoSolrJsonIT.assertEquals((long)queryResponse.getResults().getNumFound(), (long)500L);
    }
}

