/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.util.NamedList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrSpellcheckerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrSpellcheckerIT.initSolrServers(2, DistributedAlfrescoSolrSpellcheckerIT.getSimpleClassName(), null);
        DistributedAlfrescoSolrSpellcheckerIT.initSolrIndex();
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrSpellcheckerIT.dismissSolrServers();
    }

    @Test
    public void testSpellcheckerOutputFormat() throws Exception {
        DistributedAlfrescoSolrSpellcheckerIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "{\"query\":\"(YYYYY BBBBB AND (id:(1 2 3 4 5 6)))\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrSpellcheckerIT.params((String[])new String[]{"spellcheck.q", "YYYYY BBBBB", "qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "100", "spellcheck", "true"}));
        NamedList res = response.getResponse();
        NamedList spellcheck = (NamedList)res.get("spellcheck");
        NamedList suggestions = (NamedList)spellcheck.get("suggestions");
        NamedList collation = (NamedList)suggestions.getVal(2);
        String collationQuery = (String)collation.get("collationQuery");
        String collationQueryString = (String)collation.get("collationQueryString");
        int hits = (Integer)collation.get("hits");
        DistributedAlfrescoSolrSpellcheckerIT.assertTrue((hits == 3 ? 1 : 0) != 0);
        DistributedAlfrescoSolrSpellcheckerIT.assertTrue((boolean)collationQuery.equals("(yyyyyyy bbbbbbb AND (id:(1 2 3 4 5 6)))"));
        DistributedAlfrescoSolrSpellcheckerIT.assertTrue((boolean)collationQueryString.equals("yyyyyyy bbbbbbb"));
    }

    private static void initSolrIndex() throws Exception {
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "1", "suggest", "YYYYYYY BBBBBBB", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYYYYY BBBBBBB");
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "2", "suggest", "AAAAAAAA", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "AAAAAAAA");
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "3", "suggest", "BBBBBBB", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "BBBBBBB");
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "4", "suggest", "CCCC", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "CCCC");
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "5", "suggest", "YYYYYYY", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYYYYY BBBBBBB");
        DistributedAlfrescoSolrSpellcheckerIT.index(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true, "id", "6", "suggest", "EEEE", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "EEEE");
        DistributedAlfrescoSolrSpellcheckerIT.commit(DistributedAlfrescoSolrSpellcheckerIT.getDefaultTestClient(), true);
    }
}

