/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.alfresco.model.ContentModel;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrFingerPrintIT
extends AbstractAlfrescoDistributedIT {
    private static long MAX_WAIT_TIME = 80000L;
    private static Node[] NODES = new Node[4];
    private static NodeMetaData[] NODES_METADATA = new NodeMetaData[4];
    private static Acl ACL;

    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrFingerPrintIT.initSolrServers(2, DistributedAlfrescoSolrFingerPrintIT.getSimpleClassName(), null);
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        ACL = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, ACL, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(ACL, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 4);
        DistributedAlfrescoSolrFingerPrintIT.NODES[0] = AlfrescoSolrUtils.getNode(txn, ACL, Node.SolrApiNodeStatus.UPDATED);
        DistributedAlfrescoSolrFingerPrintIT.NODES[1] = AlfrescoSolrUtils.getNode(txn, ACL, Node.SolrApiNodeStatus.UPDATED);
        DistributedAlfrescoSolrFingerPrintIT.NODES[2] = AlfrescoSolrUtils.getNode(txn, ACL, Node.SolrApiNodeStatus.UPDATED);
        DistributedAlfrescoSolrFingerPrintIT.NODES[3] = AlfrescoSolrUtils.getNode(txn, ACL, Node.SolrApiNodeStatus.UPDATED);
        DistributedAlfrescoSolrFingerPrintIT.NODES_METADATA[0] = AlfrescoSolrUtils.getNodeMetaData(NODES[0], txn, ACL, "mike", null, false);
        DistributedAlfrescoSolrFingerPrintIT.NODES_METADATA[1] = AlfrescoSolrUtils.getNodeMetaData(NODES[1], txn, ACL, "mike", null, false);
        DistributedAlfrescoSolrFingerPrintIT.NODES_METADATA[2] = AlfrescoSolrUtils.getNodeMetaData(NODES[2], txn, ACL, "mike", null, false);
        DistributedAlfrescoSolrFingerPrintIT.NODES_METADATA[3] = AlfrescoSolrUtils.getNodeMetaData(NODES[3], txn, ACL, "mike", null, false);
        ArrayList<String> content = new ArrayList<String>();
        int[] sizes = new int[]{2000, 1000, 1500, 750};
        Random r = new Random(1L);
        String token1 = Integer.toString(Math.abs(r.nextInt()));
        for (int i = 0; i < 4; ++i) {
            Random rand = new Random(1L);
            StringBuilder buf = new StringBuilder();
            int size = sizes[i];
            for (int s = 0; s < size; ++s) {
                if (s > 0) {
                    buf.append(" ");
                }
                buf.append(Math.abs(rand.nextInt()));
            }
            content.add(buf.toString());
        }
        DistributedAlfrescoSolrFingerPrintIT.indexTransaction(txn, Arrays.asList(NODES[0], NODES[1], NODES[2], NODES[3]), Arrays.asList(NODES_METADATA[0], NODES_METADATA[1], NODES_METADATA[2], NODES_METADATA[3]), content);
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)txn.getId(), (Long)(txn.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        waitForQuery = builder.build();
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCountAllCores((Query)new TermQuery(new Term("READER", "jim")), 1, 80000L);
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", token1)), 4, 80000L);
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrFingerPrintIT.dismissSolrServers();
    }

    @Test
    public void testFingerPrint() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES[0].getId(), "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)4L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
        SolrDocument doc2 = (SolrDocument)docs.get(2);
        long dbid2 = (Long)doc2.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid2, (long)NODES[1].getId());
        SolrDocument doc3 = (SolrDocument)docs.get(3);
        long dbid3 = (Long)doc3.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid3, (long)NODES[3].getId());
    }

    @Test
    public void testFingerPrint2() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES[0].getId() + "_70", "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)2L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
    }

    @Test
    public void testFingerPrint3() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES[0].getId() + "_45", "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)3L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
        SolrDocument doc2 = (SolrDocument)docs.get(2);
        long dbid2 = (Long)doc2.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid2, (long)NODES[1].getId());
    }

    @Test
    public void testFingerPrint4() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES_METADATA[0].getNodeRef().getId(), "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)4L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
        SolrDocument doc2 = (SolrDocument)docs.get(2);
        long dbid2 = (Long)doc2.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid2, (long)NODES[1].getId());
        SolrDocument doc3 = (SolrDocument)docs.get(3);
        long dbid3 = (Long)doc3.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid3, (long)NODES[3].getId());
    }

    @Test
    public void testFingerPrint5() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES_METADATA[0].getNodeRef().getId() + "_70", "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)2L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
    }

    @Test
    public void testFingerPrint6() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + NODES_METADATA[0].getNodeRef().getId() + "_45", "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)3L, (long)docs.getNumFound());
        SolrDocument doc0 = (SolrDocument)docs.get(0);
        long dbid0 = (Long)doc0.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid0, (long)NODES[0].getId());
        SolrDocument doc1 = (SolrDocument)docs.get(1);
        long dbid1 = (Long)doc1.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid1, (long)NODES[2].getId());
        SolrDocument doc2 = (SolrDocument)docs.get(2);
        long dbid2 = (Long)doc2.getFieldValue("DBID");
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)dbid2, (long)NODES[1].getId());
    }

    @Test
    public void testFingerprintStillExistsAfterNodeMetadataUpdate() throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.putHandleDefaults();
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 1);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, ACL, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, ACL, "mike", null, false);
        DistributedAlfrescoSolrFingerPrintIT.indexTransaction(txn, Collections.singletonList(fileNode), Collections.singletonList(fileMetaData), Collections.singletonList("This is a text content which is longer than the default hello world " + fileNode.getId() + " returned by the Mock SOLRAPIQueueClient. This is needed because the \"min_hash\" field type definition in Solr doesn't take in account fields which produce less than 5 tokens (see the ShingleFilter settings)."));
        this.makeSureContentNodeHasBeenIndexed(fileNode, "mike", "longer");
        QueryResponse response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + fileMetaData.getNodeRef().getId(), "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        SolrDocumentList docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)1L, (long)docs.getNumFound());
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((Object)fileNode.getId(), (Object)((SolrDocument)docs.iterator().next()).getFieldValue("DBID"));
        fileMetaData.setOwner("Andrea");
        fileMetaData.getProperties().put(ContentModel.PROP_TITLE, new StringPropertyValue("This is the new file \"title\" metadata attribute."));
        txn = AlfrescoSolrUtils.getTransaction(0, 1);
        DistributedAlfrescoSolrFingerPrintIT.indexTransaction(txn, Collections.singletonList(fileNode), Collections.singletonList(fileMetaData));
        this.makeSureContentNodeHasBeenIndexed(fileNode, "Andrea", "longer");
        response = this.query(DistributedAlfrescoSolrFingerPrintIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", DistributedAlfrescoSolrFingerPrintIT.params((String[])new String[]{"q", "FINGERPRINT:" + fileMetaData.getNodeRef().getId(), "qt", "/afts", "shards.qt", "/afts", "start", "0", "fl", "DBID,score", "rows", "100"}));
        docs = response.getResults();
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((long)1L, (long)docs.getNumFound());
        DistributedAlfrescoSolrFingerPrintIT.assertEquals((Object)fileNode.getId(), (Object)((SolrDocument)docs.iterator().next()).getFieldValue("DBID"));
    }

    private void makeSureContentNodeHasBeenIndexed(Node node, String owner, String testTerm) throws Exception {
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 1, MAX_WAIT_TIME);
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), 1, MAX_WAIT_TIME);
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(node.getId()))), 1, MAX_WAIT_TIME);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", owner)), BooleanClause.Occur.MUST));
        DistributedAlfrescoSolrFingerPrintIT.waitForDocCount((Query)builder.build(), 1, MAX_WAIT_TIME);
    }
}

