/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.io.interceptor;

import java.util.stream.IntStream;
import org.alfresco.solr.io.interceptor.SharedSecretRequestInterceptor;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.message.BasicHttpRequest;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SharedSecretRequestInterceptorTest {
    private static final String SECRET_HEADER_PROPERTY = "alfresco.secureComms.secret.header";
    private static final String SECRET_HEADER_VALUE = "X-My-Secret-Header";
    private static final String SECRET_PROPERTY = "alfresco.secureComms.secret";
    private static final String SECRET_VALUE = "my-secret";

    @Before
    public void setUp() {
        System.clearProperty(SECRET_HEADER_PROPERTY);
        System.clearProperty(SECRET_PROPERTY);
    }

    @Test
    public void theInterceptor_shouldBeSingleton() {
        SharedSecretRequestInterceptor interceptor1 = SharedSecretRequestInterceptor.getInstance();
        SharedSecretRequestInterceptor interceptor2 = SharedSecretRequestInterceptor.getInstance();
        Assert.assertSame((String)"There should only be one instance of the interceptor.", (Object)interceptor1, (Object)interceptor2);
    }

    @Test
    public void registeringTheInterceptor_shouldAddOneInterceptor() {
        SharedSecretRequestInterceptor.register();
        SystemDefaultHttpClient client = (SystemDefaultHttpClient)HttpClientUtil.createClient(null);
        long sharedSecretInterceptorsCount = SharedSecretRequestInterceptorTest.getSharedSecretInterceptorsCount(client);
        Assert.assertEquals((String)"There should be one Shared Secret request interceptor.", (long)1L, (long)sharedSecretInterceptorsCount);
    }

    @Test
    public void registeringTheInterceptorMultipleTimes_shouldAddOnlyOneInterceptor() {
        IntStream.range(0, 5).forEach(i -> SharedSecretRequestInterceptor.register());
        SystemDefaultHttpClient client = (SystemDefaultHttpClient)HttpClientUtil.createClient(null);
        long sharedSecretInterceptorsCount = SharedSecretRequestInterceptorTest.getSharedSecretInterceptorsCount(client);
        Assert.assertEquals((String)"There should be only one Shared Secret request interceptor.", (long)1L, (long)sharedSecretInterceptorsCount);
    }

    @Test
    public void requestProcessing_shouldAddDefaultSecretHeaderToOutgoingRequests() throws Exception {
        System.setProperty(SECRET_PROPERTY, SECRET_VALUE);
        BasicHttpRequest httpRequest = new BasicHttpRequest("", "");
        SharedSecretRequestInterceptor.getInstance().process((HttpRequest)httpRequest, null);
        Header[] headers = httpRequest.getHeaders("X-Alfresco-Search-Secret");
        Assert.assertEquals((String)"There should be only one secret header.", (long)1L, (long)headers.length);
        Assert.assertEquals((String)"The secret header should have the expected value.", (Object)SECRET_VALUE, (Object)headers[0].getValue());
    }

    @Test
    public void requestProcessing_shouldAddCustomSecretHeaderToOutgoingRequests() throws Exception {
        System.setProperty(SECRET_HEADER_PROPERTY, SECRET_HEADER_VALUE);
        System.setProperty(SECRET_PROPERTY, SECRET_VALUE);
        BasicHttpRequest httpRequest = new BasicHttpRequest("", "");
        SharedSecretRequestInterceptor.getInstance().process((HttpRequest)httpRequest, null);
        Header[] headers = httpRequest.getHeaders(SECRET_HEADER_VALUE);
        Assert.assertEquals((String)"There should be only one secret header.", (long)1L, (long)headers.length);
        Assert.assertEquals((String)"The secret header should have the expected value.", (Object)SECRET_VALUE, (Object)headers[0].getValue());
    }

    @Test(expected=RuntimeException.class)
    public void requestProcessing_shouldFailWhenMissingSecretValue() throws Exception {
        BasicHttpRequest httpRequest = new BasicHttpRequest("", "");
        SharedSecretRequestInterceptor.getInstance().process((HttpRequest)httpRequest, null);
    }

    private static long getSharedSecretInterceptorsCount(SystemDefaultHttpClient client) {
        return IntStream.range(0, client.getRequestInterceptorCount()).mapToObj(arg_0 -> ((SystemDefaultHttpClient)client).getRequestInterceptor(arg_0)).map(Object::getClass).filter(clazz -> clazz == SharedSecretRequestInterceptor.class).count();
    }
}

