/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.dataload;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrConstants;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.util.ISO9075;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.TestHarness;

public class TestDataProvider
implements AlfrescoSolrConstants {
    private final String complexLocalName = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_";
    private final String numericLocalName = "12Woof12";
    private static String[] ORDER_NAMES = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen"};
    private static String[] ORDER_LOCALISED_NAMES = new String[]{"chalina", "curioso", "llama", "luz", "peach", "p\u00e9ch\u00e9", "p\u00eache", "sin", "\u00e4pple", "banan", "p\u00e4ron", "orange", "rock", "r\u00f4le", "rose", "filler"};
    private static String[] ORDER_LOCALISED_MLTEXT_DE = new String[]{"Arg", "\u00c4rgerlich", "Arm", "Assistent", "A\u00dflar", "Assoziation", "Udet", "\u00dcbelacker", "Uell", "\u00dclle", "Ueve", "\u00dcxk\u00fcll", "Uffenbach", "apple", "and", "aardvark"};
    private static String[] ORDER_LOCALISED_MLTEXT_FR = new String[]{"cote", "c\u00f4te", "cot\u00e9", "c\u00f4t\u00e9", "rock", "lemur", "lemonade", "lemon", "kale", "guava", "cheese", "beans", "bananana", "apple", "and", "aardvark"};
    private static String[] ORDER_LOCALISED_MLTEXT_EN = new String[]{"zebra", "tiger", "rose", "r\u00f4le", "rock", "lemur", "lemonade", "lemon", "kale", "guava", "cheese", "beans", "bananana", "apple", "and", "aardvark"};
    private static String[] ORDER_LOCALISED_MLTEXT_ES = new String[]{"radio", "r\u00e1faga", "rana", "r\u00e1pido", "rastrillo", "arroz", "campo", "chihuahua", "ciudad", "limonada", "llaves", "luna", "bananana", "apple", "and", "aardvark"};
    private int orderTextCount;
    private Date orderDate = new Date();
    private NodeRef n01NodeRef;
    private NodeRef n02NodeRef;
    private NodeRef n03NodeRef;
    private NodeRef rootNodeRef;
    private NodeRef testNodeRef;
    private Date ftsTestDate = new Date(System.currentTimeMillis() - 10000L);
    private final SolrCore core;
    private final AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();

    public TestDataProvider(TestHarness testHarness) throws Exception {
        this.core = testHarness.getCore();
        this.dataModel.getNamespaceDAO().removePrefix("");
        this.dataModel.setCMDefaultUri();
        this.rootNodeRef = this.newNodeRef();
        AlfrescoSolrUtils.addStoreRoot(this.core, this.dataModel, this.rootNodeRef, 1, 1, 1, 1);
    }

    public NodeRef getTestNodeRef() {
        return this.testNodeRef;
    }

    public NodeRef getNode01() {
        return this.n01NodeRef;
    }

    public NodeRef getNode02() {
        return this.n02NodeRef;
    }

    public NodeRef getNode03() {
        return this.n03NodeRef;
    }

    public NodeRef getRootNode() {
        return this.rootNodeRef;
    }

    public Date getFtsTestDate() {
        return this.ftsTestDate;
    }

    public String getComplexLocalName() {
        return " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_";
    }

    public String getNumericLocalName() {
        return "12Woof12";
    }

    public void loadTestDataset() {
        int i;
        this.n01NodeRef = this.newNodeRef();
        QName n01QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"one");
        ChildAssociationRef n01CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, n01QName, this.n01NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 2, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n01QName.toString()}, this.n01NodeRef, true);
        this.testNodeRef = this.n01NodeRef;
        this.n02NodeRef = this.newNodeRef();
        QName n02QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"two");
        ChildAssociationRef n02CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, n02QName, this.n02NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 3, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "bob", new ChildAssociationRef[]{n02CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n02QName.toString()}, this.n02NodeRef, true);
        this.n03NodeRef = this.newNodeRef();
        QName n03QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"three");
        ChildAssociationRef n03CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, n03QName, this.n03NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 4, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "cid", new ChildAssociationRef[]{n03CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n03QName.toString()}, this.n03NodeRef, true);
        HashMap<QName, String> content04 = new HashMap<QName, String>();
        HashMap<QName, PropertyValue> properties04 = new HashMap<QName, PropertyValue>(this.getOrderProperties());
        properties04.put(this.qName("text-indexed-stored-tokenised-atomic"), (PropertyValue)this.value("TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYONE"));
        properties04.put(this.qName("text-indexed-unstored-tokenised-atomic"), (PropertyValue)this.value("TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYUNSTORED"));
        properties04.put(this.qName("text-indexed-stored-tokenised-nonatomic"), (PropertyValue)this.value("TEXT THAT IS INDEXED STORED AND TOKENISED BUT NOT ATOMICALLY KEYTWO"));
        properties04.put(this.qName("int-ista"), (PropertyValue)this.value("1"));
        properties04.put(this.qName("long-ista"), (PropertyValue)this.value("2"));
        properties04.put(this.qName("float-ista"), (PropertyValue)this.value("3.4"));
        properties04.put(this.qName("double-ista"), (PropertyValue)this.value("5.6"));
        properties04.put(this.qName("date-ista"), (PropertyValue)this.value(this.ftsTestDate));
        properties04.put(this.qName("datetime-ista"), (PropertyValue)this.value(this.ftsTestDate));
        properties04.put(this.qName("boolean-ista"), (PropertyValue)this.value(Boolean.TRUE));
        properties04.put(this.qName("qname-ista"), (PropertyValue)this.value(QName.createQName((String)"{wibble}wobble")));
        properties04.put(this.qName("category-ista"), (PropertyValue)this.value(new NodeRef(new StoreRef("proto", "id"), "CategoryId")));
        properties04.put(this.qName("noderef-ista"), (PropertyValue)this.value(this.n01NodeRef));
        properties04.put(this.qName("path-ista"), (PropertyValue)this.value("/" + n03QName.toString()));
        properties04.put(this.qName("locale-ista"), (PropertyValue)this.value(Locale.UK));
        properties04.put(this.qName("period-ista"), (PropertyValue)this.value(new Period("period|12")));
        properties04.put(this.qName("null"), null);
        properties04.put(this.qName("list"), (PropertyValue)new MultiPropertyValue(Arrays.asList(this.value("one"), this.value("two"))));
        MLTextPropertyValue mlText = new MLTextPropertyValue();
        mlText.addValue(Locale.ENGLISH, "banana");
        mlText.addValue(Locale.FRENCH, "banane");
        mlText.addValue(Locale.CHINESE, "\u9999\u8549");
        mlText.addValue(new Locale("nl"), "banaan");
        mlText.addValue(Locale.GERMAN, "banane");
        mlText.addValue(new Locale("el"), "\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1");
        mlText.addValue(Locale.ITALIAN, "banana");
        mlText.addValue(new Locale("ja"), "\u30d0\u30ca\u30ca");
        mlText.addValue(new Locale("ko"), "\ubc14\ub098\ub098");
        mlText.addValue(new Locale("pt"), "banana");
        mlText.addValue(new Locale("ru"), "\u0431\u0430\u043d\u0430\u043d");
        mlText.addValue(new Locale("es"), "pl\u00e1tano");
        properties04.put(this.qName("ml"), (PropertyValue)mlText);
        properties04.put(this.qName("any-many-ista"), (PropertyValue)new MultiPropertyValue(Arrays.asList(this.value("100"), this.value("anyValueAsString"))));
        MultiPropertyValue list_2 = new MultiPropertyValue(Collections.singletonList(new ContentPropertyValue(Locale.ENGLISH, 12L, "UTF-16", "text/plain", null)));
        properties04.put(this.qName("content-many-ista"), (PropertyValue)list_2);
        content04.put(this.qName("content-many-ista"), "multicontent");
        MLTextPropertyValue mlText1 = new MLTextPropertyValue();
        mlText1.addValue(Locale.ENGLISH, "cabbage");
        mlText1.addValue(Locale.FRENCH, "chou");
        MLTextPropertyValue mlText2 = new MLTextPropertyValue();
        mlText2.addValue(Locale.ENGLISH, "lemur");
        mlText2.addValue(new Locale("ru"), "\u043b\u0435\u043c\u0443\u0440");
        properties04.put(this.qName("mltext-many-ista"), (PropertyValue)new MultiPropertyValue(Arrays.asList(mlText1, mlText2)));
        properties04.put(this.qName("nullist"), (PropertyValue)new MultiPropertyValue(Collections.singletonList(this.value(null))));
        NodeRef n04NodeRef = this.newNodeRef();
        QName n04QName = this.qName("http://www.alfresco.org/model/content/1.0", "four");
        ChildAssociationRef n04CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, n04QName, n04NodeRef, true, 0);
        properties04.put(this.qName("aspectProperty"), (PropertyValue)this.value(""));
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 5, 1, TEST_TYPE, new QName[]{TEST_ASPECT}, properties04, content04, "dave", new ChildAssociationRef[]{n04CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n04QName.toString()}, n04NodeRef, true);
        NodeRef n05NodeRef = this.newNodeRef();
        QName n05QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"five");
        ChildAssociationRef n05CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n01NodeRef, n05QName, n05NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 6, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "eoin", new ChildAssociationRef[]{n05CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString()}, n05NodeRef, true);
        NodeRef n06NodeRef = this.newNodeRef();
        QName n06QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"six");
        ChildAssociationRef n06CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n01NodeRef, n06QName, n06NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 7, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "fred", new ChildAssociationRef[]{n06CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n06QName.toString()}, n06NodeRef, true);
        NodeRef n07NodeRef = this.newNodeRef();
        QName n07QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"seven");
        ChildAssociationRef n07CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n02NodeRef, n07QName, n07NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 8, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "gail", new ChildAssociationRef[]{n07CAR}, new NodeRef[]{this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + n02QName.toString() + "/" + n07QName.toString()}, n07NodeRef, true);
        NodeRef n08NodeRef = this.newNodeRef();
        QName n08QName_0 = this.qName("http://www.alfresco.org/model/content/1.0", "eight-0");
        QName n08QName_1 = this.qName("http://www.alfresco.org/model/content/1.0", "eight-1");
        QName n08QName_2 = this.qName("http://www.alfresco.org/model/content/1.0", "eight-2");
        ChildAssociationRef n08CAR_0 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, n08QName_0, n08NodeRef, false, 2);
        ChildAssociationRef n08CAR_1 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n01NodeRef, n08QName_1, n08NodeRef, false, 1);
        ChildAssociationRef n08CAR_2 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n02NodeRef, n08QName_2, n08NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 9, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "hal", new ChildAssociationRef[]{n08CAR_0, n08CAR_1, n08CAR_2}, new NodeRef[]{this.rootNodeRef, this.rootNodeRef, this.n01NodeRef, this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + String.valueOf(n08QName_0), "/" + n01QName.toString() + "/" + n08QName_1.toString(), "/" + n02QName.toString() + "/" + n08QName_2.toString()}, n08NodeRef, true);
        NodeRef n09NodeRef = this.newNodeRef();
        QName n09QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"nine");
        ChildAssociationRef n09CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n09QName, n09NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 10, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "ian", new ChildAssociationRef[]{n09CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n09QName)}, n09NodeRef, true);
        NodeRef n10NodeRef = this.newNodeRef();
        QName n10QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"ten");
        ChildAssociationRef n10CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n10QName, n10NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 11, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "jake", new ChildAssociationRef[]{n10CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n10QName)}, n10NodeRef, true);
        NodeRef n11NodeRef = this.newNodeRef();
        QName n11QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"eleven");
        ChildAssociationRef n11CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n11QName, n11NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 12, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "kara", new ChildAssociationRef[]{n11CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n11QName)}, n11NodeRef, true);
        NodeRef n12NodeRef = this.newNodeRef();
        QName n12QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twelve");
        ChildAssociationRef n12CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n12QName, n12NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 13, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "loon", new ChildAssociationRef[]{n12CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName)}, n12NodeRef, true);
        NodeRef n13NodeRef = this.newNodeRef();
        QName n13QName = this.qName("http://www.alfresco.org/model/content/1.0", "thirteen");
        QName n13QNameLink = this.qName("http://www.alfresco.org/model/content/1.0", "link");
        ChildAssociationRef n13CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n12NodeRef, n13QName, n13NodeRef, true, 0);
        ChildAssociationRef n13CARLink = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n02NodeRef, n13QName, n13NodeRef, false, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 14, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "mike", new ChildAssociationRef[]{n13CAR, n13CARLink}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink)}, n13NodeRef, true);
        HashMap<QName, PropertyValue> properties14 = new HashMap<QName, PropertyValue>(this.getOrderProperties());
        HashMap<QName, String> content14 = new HashMap<QName, String>();
        MLTextPropertyValue desc1 = new MLTextPropertyValue();
        desc1.addValue(Locale.ENGLISH, "Alfresco tutorial");
        desc1.addValue(Locale.US, "Alfresco tutorial");
        Date explicitCreatedDate = new Date();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        properties14.put(ContentModel.PROP_CONTENT, (PropertyValue)new ContentPropertyValue(Locale.UK, 298L, "UTF-8", "text/plain", null));
        content14.put(ContentModel.PROP_CONTENT, "The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
        properties14.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)desc1);
        properties14.put(ContentModel.PROP_CREATED, (PropertyValue)this.value(explicitCreatedDate));
        properties14.put(ContentModel.PROP_MODIFIED, (PropertyValue)this.value(explicitCreatedDate));
        MLTextPropertyValue title = new MLTextPropertyValue();
        title.addValue(Locale.ENGLISH, "English123");
        title.addValue(Locale.FRENCH, "French123");
        properties14.put(ContentModel.PROP_TITLE, (PropertyValue)title);
        NodeRef n14NodeRef = this.newNodeRef();
        QName n14QName = this.qName("http://www.alfresco.org/model/content/1.0", "fourteen");
        QName n14QNameCommon = this.qName("http://www.alfresco.org/model/content/1.0", "common");
        ChildAssociationRef n14CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n14QName, n14NodeRef, true, 0);
        ChildAssociationRef n14CAR_1 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n01NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        ChildAssociationRef n14CAR_2 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.n02NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        ChildAssociationRef n14CAR_5 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        ChildAssociationRef n14CAR_6 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n06NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        ChildAssociationRef n14CAR_12 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n12NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        ChildAssociationRef n14CAR_13 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n14QNameCommon, n14NodeRef, false, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 15, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, properties14, content14, "noodle", new ChildAssociationRef[]{n14CAR, n14CAR_1, n14CAR_2, n14CAR_5, n14CAR_6, n14CAR_12, n14CAR_13}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n14QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink) + "/" + String.valueOf(n14QName), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n02QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n06QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n14QNameCommon)}, n14NodeRef, true);
        HashMap<QName, PropertyValue> properties15 = new HashMap<QName, PropertyValue>(this.getOrderProperties());
        properties15.put(ContentModel.PROP_MODIFIED, (PropertyValue)this.value(explicitCreatedDate));
        HashMap<QName, String> content15 = new HashMap<QName, String>();
        content15.put(ContentModel.PROP_CONTENT, "          ");
        NodeRef n15NodeRef = this.newNodeRef();
        QName n15QName = this.qName("http://www.alfresco.org/model/content/1.0", "fifteen");
        ChildAssociationRef n15CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n15QName, n15NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 16, 1, ContentModel.TYPE_THUMBNAIL, null, properties15, content15, "ood", new ChildAssociationRef[]{n15CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n15QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink) + "/" + String.valueOf(n14QName)}, n15NodeRef, true);
        for (i = 0; i < 100; ++i) {
            this.orderDate = new Date();
            this.orderTextCount = 0;
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 2, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n01QName.toString()}, this.n01NodeRef, true);
        }
        for (i = 0; i < 10; ++i) {
            this.orderDate = new Date();
            this.orderTextCount = 0;
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 2, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n01QName.toString()}, this.n01NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 3, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "bob", new ChildAssociationRef[]{n02CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n02QName.toString()}, this.n02NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 4, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "cid", new ChildAssociationRef[]{n03CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n03QName.toString()}, this.n03NodeRef, true);
            properties04.putAll(this.getOrderProperties());
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 5, 1, TEST_TYPE, new QName[]{TEST_ASPECT}, properties04, content04, "dave", new ChildAssociationRef[]{n04CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n04QName.toString()}, n04NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 6, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "eoin", new ChildAssociationRef[]{n05CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString()}, n05NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 7, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "fred", new ChildAssociationRef[]{n06CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n06QName.toString()}, n06NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 8, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "gail", new ChildAssociationRef[]{n07CAR}, new NodeRef[]{this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + n02QName.toString() + "/" + n07QName.toString()}, n07NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 9, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "hal", new ChildAssociationRef[]{n08CAR_0, n08CAR_1, n08CAR_2}, new NodeRef[]{this.rootNodeRef, this.rootNodeRef, this.n01NodeRef, this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + String.valueOf(n08QName_0), "/" + n01QName.toString() + "/" + n08QName_1.toString(), "/" + n02QName.toString() + "/" + n08QName_2.toString()}, n08NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 10, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "ian", new ChildAssociationRef[]{n09CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n09QName)}, n09NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 11, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "jake", new ChildAssociationRef[]{n10CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n10QName)}, n10NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 12, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "kara", new ChildAssociationRef[]{n11CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n11QName)}, n11NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 13, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "loon", new ChildAssociationRef[]{n12CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName)}, n12NodeRef, true);
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 14, 1, TEST_SUPER_TYPE, null, this.getOrderProperties(), null, "mike", new ChildAssociationRef[]{n13CAR, n13CARLink}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, this.rootNodeRef, this.n02NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink)}, n13NodeRef, true);
            properties14.putAll(this.getOrderProperties());
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 15, 1, ContentModel.TYPE_CONTENT, null, properties14, content14, "noodle", new ChildAssociationRef[]{n14CAR, n14CAR_1, n14CAR_2, n14CAR_5, n14CAR_6, n14CAR_12, n14CAR_13}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n14QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink) + "/" + String.valueOf(n14QName), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n02QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n06QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n14QNameCommon), "/" + String.valueOf(n01QName) + "/" + String.valueOf(n05QName) + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n14QNameCommon)}, n14NodeRef, true);
            properties14.putAll(this.getOrderProperties());
            AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 16, 1, ContentModel.TYPE_THUMBNAIL, null, properties15, content15, "ood", new ChildAssociationRef[]{n15CAR}, new NodeRef[]{this.rootNodeRef, this.n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + String.valueOf(n12QName) + "/" + String.valueOf(n13QName) + "/" + String.valueOf(n15QName), "/" + n02QName.toString() + "/" + String.valueOf(n13QNameLink) + "/" + String.valueOf(n14QName)}, n15NodeRef, true);
        }
    }

    public void loadEscapingTestData() {
        NodeRef childNameEscapingNodeRef = this.newNodeRef();
        QName childNameEscapingQName = this.qName("http://www.alfresco.org/model/content/1.0", " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_");
        QName pathChildNameEscapingQName = this.qName("http://www.alfresco.org/model/content/1.0", ISO9075.encode((String)" `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_"));
        ChildAssociationRef complexCAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, childNameEscapingQName, childNameEscapingNodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 17, 1, TEST_SUPER_TYPE, null, null, null, "system", new ChildAssociationRef[]{complexCAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + pathChildNameEscapingQName.toString()}, childNameEscapingNodeRef, true);
        NodeRef numericNameEscapingNodeRef = this.newNodeRef();
        QName numericNameEscapingQName = this.qName("http://www.alfresco.org/model/content/1.0", "12Woof12");
        QName pathNumericNameEscapingQName = this.qName("http://www.alfresco.org/model/content/1.0", ISO9075.encode((String)"12Woof12"));
        ChildAssociationRef numericCAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, numericNameEscapingQName, numericNameEscapingNodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 18, 1, TEST_SUPER_TYPE, null, null, null, "system", new ChildAssociationRef[]{numericCAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + pathNumericNameEscapingQName.toString()}, numericNameEscapingNodeRef, true);
    }

    public void loadMntTestData() {
        HashMap<QName, PropertyValue> properties19 = new HashMap<QName, PropertyValue>();
        properties19.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Test.hello.txt"));
        NodeRef n19NodeRef = this.newNodeRef();
        QName n19QName = this.qName("http://www.alfresco.org/model/content/1.0", "nineteen");
        ChildAssociationRef n19CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n19QName, n19NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 19, 1, ContentModel.TYPE_CONTENT, null, properties19, null, "system", new ChildAssociationRef[]{n19CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n19QName.toString()}, n19NodeRef, true);
        HashMap<QName, PropertyValue> properties20 = new HashMap<QName, PropertyValue>();
        properties20.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Test1.hello.txt"));
        NodeRef n20NodeRef = this.newNodeRef();
        QName n20QName = this.qName("http://www.alfresco.org/model/content/1.0", "twenty");
        ChildAssociationRef n20CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n20QName, n20NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 20, 1, ContentModel.TYPE_CONTENT, null, properties20, null, "system", new ChildAssociationRef[]{n20CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n20QName.toString()}, n20NodeRef, true);
        HashMap<QName, PropertyValue> properties21 = new HashMap<QName, PropertyValue>();
        properties21.put(ContentModel.PROP_NAME, (PropertyValue)this.value("one_two_three.txt"));
        NodeRef n21NodeRef = this.newNodeRef();
        QName n21QName = this.qName("http://www.alfresco.org/model/content/1.0", "twentyone");
        ChildAssociationRef n21CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n21QName, n21NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 21, 1, ContentModel.TYPE_CONTENT, null, properties21, null, "system", new ChildAssociationRef[]{n21CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n21QName.toString()}, n21NodeRef, true);
        HashMap<QName, PropertyValue> properties22 = new HashMap<QName, PropertyValue>();
        properties22.put(ContentModel.PROP_NAME, (PropertyValue)this.value("one_two_four.txt"));
        NodeRef n22NodeRef = this.newNodeRef();
        QName n22QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twnetytwo");
        ChildAssociationRef n22CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n22QName, n22NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 22, 1, ContentModel.TYPE_CONTENT, null, properties22, null, "system", new ChildAssociationRef[]{n22CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n22QName.toString()}, n22NodeRef, true);
        HashMap<QName, PropertyValue> properties23 = new HashMap<QName, PropertyValue>();
        properties23.put(ContentModel.PROP_NAME, (PropertyValue)this.value("one_two.txt"));
        NodeRef n23NodeRef = this.newNodeRef();
        QName n23QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentythree");
        ChildAssociationRef n23CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n23QName, n23NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 23, 1, ContentModel.TYPE_CONTENT, null, properties23, null, "system", new ChildAssociationRef[]{n23CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n23QName.toString()}, n23NodeRef, true);
        HashMap<QName, PropertyValue> properties24 = new HashMap<QName, PropertyValue>();
        properties24.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Print-Toolkit-3204-The-Print-Toolkit-has-a-new-look-565022.html"));
        NodeRef n24NodeRef = this.newNodeRef();
        QName n24QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentyfour");
        ChildAssociationRef n24CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n24QName, n24NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 24, 1, ContentModel.TYPE_CONTENT, null, properties24, null, "system", new ChildAssociationRef[]{n24CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n24QName.toString()}, n24NodeRef, true);
        HashMap<QName, PropertyValue> properties25 = new HashMap<QName, PropertyValue>();
        properties25.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Print-Toolkitf-3204-The-Print-Toolkit-has-a-new-look-565022.html"));
        NodeRef n25NodeRef = this.newNodeRef();
        QName n25QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentyfive");
        ChildAssociationRef n25CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n25QName, n25NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 25, 1, ContentModel.TYPE_CONTENT, null, properties25, null, "system", new ChildAssociationRef[]{n25CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n25QName.toString()}, n25NodeRef, true);
        HashMap<QName, PropertyValue> properties26 = new HashMap<QName, PropertyValue>();
        properties26.put(ContentModel.PROP_NAME, (PropertyValue)this.value("apple pear peach 20150911100000.txt"));
        NodeRef n26NodeRef = this.newNodeRef();
        QName n26QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentysix");
        ChildAssociationRef n26CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n26QName, n26NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 26, 1, ContentModel.TYPE_CONTENT, null, properties26, null, "system", new ChildAssociationRef[]{n26CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n26QName.toString()}, n26NodeRef, true);
        HashMap<QName, PropertyValue> properties27 = new HashMap<QName, PropertyValue>();
        properties27.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Craig.txt"));
        properties27.put(ContentModel.PROP_CONTENT, (PropertyValue)new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain", null));
        HashMap<QName, String> content27 = new HashMap<QName, String>();
        content27.put(ContentModel.PROP_CONTENT, "AnalystName Craig");
        NodeRef n27NodeRef = this.newNodeRef();
        QName n27QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentyseven");
        ChildAssociationRef n27CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n27QName, n27NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 27, 1, ContentModel.TYPE_CONTENT, null, properties27, content27, "system", new ChildAssociationRef[]{n27CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n27QName.toString()}, n27NodeRef, true);
        HashMap<QName, PropertyValue> properties28 = new HashMap<QName, PropertyValue>();
        properties28.put(ContentModel.PROP_NAME, (PropertyValue)this.value("Scott.txt"));
        properties28.put(ContentModel.PROP_CONTENT, (PropertyValue)new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain", null));
        HashMap<QName, String> content28 = new HashMap<QName, String>();
        content28.put(ContentModel.PROP_CONTENT, "AnalystName Scott \n Craig");
        NodeRef n28NodeRef = this.newNodeRef();
        QName n28QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentyeight");
        ChildAssociationRef n28CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n28QName, n28NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 28, 1, ContentModel.TYPE_CONTENT, null, properties28, content28, "system", new ChildAssociationRef[]{n28CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n28QName.toString()}, n28NodeRef, true);
        HashMap<QName, PropertyValue> properties29 = new HashMap<QName, PropertyValue>();
        properties29.put(ContentModel.PROP_NAME, (PropertyValue)this.value("BASF_2016.txt"));
        NodeRef n29NodeRef = this.newNodeRef();
        QName n29QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twentynine");
        ChildAssociationRef n29CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n29QName, n29NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 29, 1, ContentModel.TYPE_CONTENT, null, properties29, null, "system", new ChildAssociationRef[]{n29CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n29QName.toString()}, n29NodeRef, true);
        HashMap<QName, PropertyValue> properties30 = new HashMap<QName, PropertyValue>();
        properties30.put(ContentModel.PROP_NAME, (PropertyValue)this.value("BASF_2016(GMT0800).txt"));
        NodeRef n30NodeRef = this.newNodeRef();
        QName n30QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"thirty");
        ChildAssociationRef n30CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n30QName, n30NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 30, 1, ContentModel.TYPE_CONTENT, null, properties30, null, "system", new ChildAssociationRef[]{n30CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n30QName.toString()}, n30NodeRef, true);
        HashMap<QName, PropertyValue> properties31 = new HashMap<QName, PropertyValue>();
        properties31.put(ContentModel.PROP_NAME, (PropertyValue)this.value("BASF_2016-03-08-10-42-19.txt"));
        NodeRef n31NodeRef = this.newNodeRef();
        QName n31QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"thirtyone");
        ChildAssociationRef n31CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n31QName, n31NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 31, 1, ContentModel.TYPE_CONTENT, null, properties31, null, "system", new ChildAssociationRef[]{n31CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n31QName.toString()}, n31NodeRef, true);
        HashMap<QName, PropertyValue> properties32 = new HashMap<QName, PropertyValue>();
        properties32.put(ContentModel.PROP_NAME, (PropertyValue)this.value("BASF_2016 GMT 0800.txt"));
        NodeRef n32NodeRef = this.newNodeRef();
        QName n32QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"thirtytwo");
        ChildAssociationRef n32CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n32QName, n32NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 32, 1, ContentModel.TYPE_CONTENT, null, properties32, null, "system", new ChildAssociationRef[]{n32CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n32QName.toString()}, n32NodeRef, true);
        String acmeNamespaceURI = "http://www.acme.org/model/content/1.0";
        QName propertyQname = QName.createQName((String)acmeNamespaceURI, (String)"date");
        QName acmeDocumentQName = QName.createQName((String)acmeNamespaceURI, (String)"document");
        HashMap<QName, PropertyValue> properties33 = new HashMap<QName, PropertyValue>();
        String todayStartOfDay = LocalDate.now().atStartOfDay().toInstant(ZoneOffset.UTC).toString();
        properties33.put(propertyQname, (PropertyValue)this.value(todayStartOfDay));
        NodeRef n33NodeRef = this.newNodeRef();
        QName n33QName = QName.createQName((String)acmeNamespaceURI, (String)"thirtythree");
        ChildAssociationRef n33CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n33QName, n33NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 33, 1, acmeDocumentQName, null, properties33, null, "system", new ChildAssociationRef[]{n33CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n33QName.toString()}, n33NodeRef, true);
        HashMap<QName, PropertyValue> properties34 = new HashMap<QName, PropertyValue>();
        String yesterdayStartOfDay = LocalDate.now().atStartOfDay().minusDays(1L).toInstant(ZoneOffset.UTC).toString();
        properties34.put(propertyQname, (PropertyValue)this.value(yesterdayStartOfDay));
        NodeRef n34NodeRef = this.newNodeRef();
        QName n34QName = QName.createQName((String)acmeNamespaceURI, (String)"thirtyfour");
        ChildAssociationRef n34CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rootNodeRef, n34QName, n34NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(this.core, this.dataModel, 1, 34, 1, acmeDocumentQName, null, properties34, null, "system", new ChildAssociationRef[]{n34CAR}, new NodeRef[]{this.rootNodeRef}, new String[]{"/" + n34QName.toString()}, n34NodeRef, true);
    }

    private Map<QName, PropertyValue> getOrderProperties() {
        double orderDoubleCount = -0.11 + (double)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 0.1 : -0.1);
        float orderFloatCount = -3.5556f + (float)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 0.82f : -0.82f);
        long orderLongCount = -1999999999999999L + (long)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 299999999999999L : -299999999999999L);
        int orderIntCount = -45764576 + this.orderTextCount * (this.orderTextCount % 2 == 0 ? 8576457 : -8576457);
        HashMap<QName, PropertyValue> testProperties = new HashMap<QName, PropertyValue>();
        testProperties.put(CREATED_DATE, (PropertyValue)this.value(this.orderDate));
        testProperties.put(CREATED_TIME, (PropertyValue)this.value(this.orderDate));
        testProperties.put(ORDER_DOUBLE, (PropertyValue)this.value(orderDoubleCount));
        testProperties.put(ORDER_FLOAT, (PropertyValue)this.value(Float.valueOf(orderFloatCount)));
        testProperties.put(ORDER_LONG, (PropertyValue)this.value(orderLongCount));
        testProperties.put(ORDER_INT, (PropertyValue)this.value(orderIntCount));
        testProperties.put(ORDER_TEXT, (PropertyValue)this.value(new String(new char[]{(char)(108 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " cabbage"));
        testProperties.put(ContentModel.PROP_NAME, (PropertyValue)this.value(ORDER_NAMES[this.orderTextCount]));
        testProperties.put(ORDER_LOCALISED_TEXT, (PropertyValue)this.value(ORDER_LOCALISED_NAMES[this.orderTextCount]));
        MLTextPropertyValue mlTextPropLocalisedOrder = new MLTextPropertyValue();
        if (ORDER_LOCALISED_MLTEXT_EN[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.ENGLISH, ORDER_LOCALISED_MLTEXT_EN[this.orderTextCount]);
        }
        if (ORDER_LOCALISED_MLTEXT_FR[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.FRENCH, ORDER_LOCALISED_MLTEXT_FR[this.orderTextCount]);
        }
        if (ORDER_LOCALISED_MLTEXT_ES[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(new Locale("es"), ORDER_LOCALISED_MLTEXT_ES[this.orderTextCount]);
        }
        if (ORDER_LOCALISED_MLTEXT_DE[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.GERMAN, ORDER_LOCALISED_MLTEXT_DE[this.orderTextCount]);
        }
        testProperties.put(ORDER_LOCALISED_ML_TEXT, (PropertyValue)mlTextPropLocalisedOrder);
        MLTextPropertyValue mlTextPropVal = new MLTextPropertyValue();
        mlTextPropVal.addValue(Locale.ENGLISH, new String(new char[]{(char)(108 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " banana");
        mlTextPropVal.addValue(Locale.FRENCH, new String(new char[]{(char)(76 + (this.orderTextCount % 2 == 0 ? -this.orderTextCount : this.orderTextCount))}) + " banane");
        mlTextPropVal.addValue(Locale.CHINESE, new String(new char[]{(char)(39321 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " \u9999\u8549");
        testProperties.put(ORDER_ML_TEXT, (PropertyValue)mlTextPropVal);
        this.orderDate = Duration.subtract((Date)this.orderDate, (Duration)new Duration("P1D"));
        ++this.orderTextCount;
        return testProperties;
    }

    public static Map.Entry<List<Node>, List<NodeMetaData>> nSampleNodesWithSampleContent(Acl acl, Transaction txn, int howManyNodes) {
        List nodes = IntStream.range(0, howManyNodes).mapToObj(index -> AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED)).collect(Collectors.toList());
        List metadata = nodes.stream().map(node -> AlfrescoSolrUtils.getNodeMetaData(node, txn, acl, "mike", null, false)).collect(Collectors.toList());
        return new AbstractMap.SimpleImmutableEntry<List<Node>, List<NodeMetaData>>(nodes, metadata);
    }

    public NodeRef newNodeRef() {
        return new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
    }

    public QName qName(String localName) {
        return this.qName("http://www.alfresco.org/test/solrtest", localName);
    }

    private QName qName(String namespace, String localName) {
        return QName.createQName((String)namespace, (String)localName);
    }

    private StringPropertyValue value(Object value) {
        return new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, value));
    }

    private StringPropertyValue value(String value) {
        return new StringPropertyValue(value);
    }
}

