/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.config;

import org.alfresco.solr.config.ConfigUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConfigUtilTest {
    @Test
    public void locateProperty() throws Exception {
        Assert.assertEquals((Object)"king", (Object)ConfigUtil.locateProperty((String)"find.me", (String)"king"));
        System.setProperty("solr.find.me", "iamfound");
        Assert.assertEquals((Object)"iamfound", (Object)ConfigUtil.locateProperty((String)"find.me", (String)"king"));
        System.clearProperty("solr.find.me");
        Assert.assertEquals((Object)"king", (Object)ConfigUtil.locateProperty((String)"find.me", (String)"king"));
        System.setProperty("find.me", "iamfoundagain");
        Assert.assertEquals((Object)"iamfoundagain", (Object)ConfigUtil.locateProperty((String)"find.me", (String)"king"));
        System.clearProperty("find.me");
    }

    @Test
    public void convertPropertyNameToJNDIPath() throws Exception {
        Assert.assertEquals((Object)"java:comp/env/gethin", (Object)ConfigUtil.convertPropertyNameToJNDIPath((String)"gethin"));
        Assert.assertEquals((Object)"java:comp/env/solr/content/dir", (Object)ConfigUtil.convertPropertyNameToJNDIPath((String)"solr.content.dir"));
        Assert.assertEquals((Object)"java:comp/env/solr/model/dir", (Object)ConfigUtil.convertPropertyNameToJNDIPath((String)"solr.model.dir"));
        Assert.assertEquals((Object)"java:comp/env/", (Object)ConfigUtil.convertPropertyNameToJNDIPath((String)""));
        Assert.assertEquals((Object)"java:comp/env/", (Object)ConfigUtil.convertPropertyNameToJNDIPath(null));
    }

    @Test
    public void convertPropertyNameToEnvironmentParam() throws Exception {
        Assert.assertEquals((Object)"SOLR_GETHIN", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"gethin"));
        Assert.assertEquals((Object)"SOLR_SOLR_CONTENT_DIR", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"solr.content.dir"));
        Assert.assertEquals((Object)"SOLR_SOLR_MODEL_DIR", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"solr.model.dir"));
        Assert.assertEquals((Object)"SOLR_CREATE_ALFRESCO_DEFAULTS", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"create.alfresco.defaults"));
        Assert.assertEquals((Object)"SOLR_SOLR_HOST", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"solr.host"));
        Assert.assertEquals((Object)"SOLR_SOLR_PORT", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"solr.port"));
        Assert.assertEquals((Object)"SOLR_SOLR_BASEURL", (Object)ConfigUtil.convertPropertyNameToEnvironmentParam((String)"solr.baseurl"));
    }
}

