/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import com.google.common.collect.ImmutableMap;
import com.sun.xml.xsom.impl.scd.Iterators;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.solr.component.RewriteFacetParametersComponent;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
@SolrTestCaseJ4.SuppressSSL
public class RewriteFacetParametersComponentTest {
    @InjectMocks
    RewriteFacetParametersComponent rewriteFacetParametersComponent;
    @Mock
    SolrParams mockParams;
    @Mock
    SolrQueryRequest mockRequest;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockRequest.getParams()).thenReturn((Object)this.mockParams);
    }

    @Test
    public void parseFacetField() {
        String a = "created,modified";
        String b = "cm:created,modified";
        String c = "modified";
        String d = "{crazy}created,modified,updated";
        String e = "{bob:\"fred\"}created,modified,updated";
        String f = "{perc=\"3,4,5\"}created,modified";
        String g = "{perc='3,4,5'}created,modified";
        Assert.assertEquals((long)2L, (long)RewriteFacetParametersComponent.parseFacetField((String)a).length);
        Assert.assertEquals((long)2L, (long)RewriteFacetParametersComponent.parseFacetField((String)b).length);
        Assert.assertEquals((long)1L, (long)RewriteFacetParametersComponent.parseFacetField((String)c).length);
        Assert.assertEquals((long)3L, (long)RewriteFacetParametersComponent.parseFacetField((String)d).length);
        Assert.assertEquals((long)3L, (long)RewriteFacetParametersComponent.parseFacetField((String)e).length);
        Assert.assertEquals((long)2L, (long)RewriteFacetParametersComponent.parseFacetField((String)f).length);
        Assert.assertEquals((long)2L, (long)RewriteFacetParametersComponent.parseFacetField((String)g).length);
    }

    @Test(expected=RuntimeException.class)
    public void parseEmpty() {
        RewriteFacetParametersComponent.parseFacetField((String)"");
    }

    @Test(expected=RuntimeException.class)
    public void parseNull() {
        RewriteFacetParametersComponent.parseFacetField(null);
    }

    @Test
    public void rewriteMincountFacetFieldOption_mincountMissing_shouldSetGenericMinCountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn((Object)Iterators.empty());
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", fieldMappings, this.mockRequest);
        String actual = fixed.get("facet.mincount");
        Assert.assertEquals((String)"Expected the existing mincount to be preserved.", (Object)"1", (Object)actual);
    }

    @Test
    public void rewriteMincountFacetFieldOption_mincountSetZero_shouldSetMincountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.get("facet.mincount")).thenReturn((Object)"0");
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", fieldMappings, this.mockRequest);
        String actualCount = fixed.get("facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualCount);
    }

    @Test
    public void rewriteShardedRequestParameters_mincountSetZero_shouldKeepMincountToZero() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.get("facet.mincount")).thenReturn((Object)"0");
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn((Object)String.valueOf(16));
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", fieldMappings, this.mockRequest);
        String actualCount = fixed.get("facet.mincount");
        Assert.assertEquals((String)"Expected no fixed value", null, (Object)actualCount);
    }

    @Test
    public void rewriteMincountFacetFieldOption_mincountSetTwo_shouldKeepIt() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.get("facet.mincount")).thenReturn((Object)"2");
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", fieldMappings, this.mockRequest);
        String actualCount = fixed.get("facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 2.", (Object)"2", (Object)actualCount);
    }

    @Test
    public void rewriteMincountFacetFieldOption_perFieldMincountSetZero_shouldSetPerFieldMincountAndMincountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("f.NAME.facet.mincount", "f.CONTENT.facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.getParams("f.NAME.facet.mincount")).thenReturn((Object)new String[]{"0"});
        Mockito.when((Object)this.mockParams.getParams("f.CONTENT.facet.mincount")).thenReturn((Object)new String[]{"0"});
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        ImmutableMap fieldMappings = ImmutableMap.of((Object)"NAME", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name", (Object)"CONTENT", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content");
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", (Map)fieldMappings, this.mockRequest);
        String actualNameCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualNameCount);
        String actualContentCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualContentCount);
        String actualCount = fixed.get("facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualCount);
    }

    @Test
    public void rewriteMincountFacetFieldOption_perFieldMincountSetZero_shouldSetPerFieldMincountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("f.NAME.facet.mincount", "f.CONTENT.facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.getParams("f.NAME.facet.mincount")).thenReturn((Object)new String[]{"0"});
        Mockito.when((Object)this.mockParams.getParams("f.CONTENT.facet.mincount")).thenReturn((Object)new String[]{"0"});
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        ImmutableMap fieldMappings = ImmutableMap.of((Object)"NAME", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name", (Object)"CONTENT", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content");
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", (Map)fieldMappings, this.mockRequest);
        String actualNameCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualNameCount);
        String actualContentCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualContentCount);
    }

    @Test
    public void rewriteMincountFacetFieldOption_perFieldMincountSetTwo_shouldKeepIt() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("f.NAME.facet.mincount", "f.CONTENT.facet.mincount").iterator());
        Mockito.when((Object)this.mockParams.getParams("f.NAME.facet.mincount")).thenReturn((Object)new String[]{"2"});
        Mockito.when((Object)this.mockParams.getParams("f.CONTENT.facet.mincount")).thenReturn((Object)new String[]{"0"});
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        ImmutableMap fieldMappings = ImmutableMap.of((Object)"NAME", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name", (Object)"CONTENT", (Object)"{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content");
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.mincount", (Map)fieldMappings, this.mockRequest);
        String actualNameCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}name.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 2.", (Object)"2", (Object)actualNameCount);
        String actualContentCount = fixed.get("f.{!afts key=SEARCH.FACET_FIELDS.LOCATION}text@s____@{http://www.alfresco.org/model/content/1.0}content.facet.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualContentCount);
    }

    @Test
    public void rewriteMincountFacetPivotOption_mincountMissing_shouldSetPivotMinCountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn((Object)Iterators.empty());
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.pivot.mincount", fieldMappings, this.mockRequest);
        String actual = fixed.get("facet.pivot.mincount");
        Assert.assertEquals((String)"Expected the existing mincount to be preserved.", (Object)"1", (Object)actual);
    }

    @Test
    public void rewriteMincountFacetPivotOption_mincountSetZero_shouldSetMincountToOne() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("facet.pivot.mincount").iterator());
        Mockito.when((Object)this.mockParams.get("facet.pivot.mincount")).thenReturn((Object)"0");
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.pivot.mincount", fieldMappings, this.mockRequest);
        String actualCount = fixed.get("facet.pivot.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 1.", (Object)"1", (Object)actualCount);
    }

    @Test
    public void rewriteMincountFacetPivotOption_mincountSetTwo_shouldKeepIt() {
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        Mockito.when((Object)this.mockParams.getParameterNamesIterator()).thenReturn(Arrays.asList("facet.pivot.mincount").iterator());
        Mockito.when((Object)this.mockParams.get("facet.pivot.mincount")).thenReturn((Object)"2");
        Mockito.when((Object)this.mockParams.get("shards.purpose")).thenReturn(null);
        HashMap fieldMappings = new HashMap();
        this.rewriteFacetParametersComponent.rewriteMincountFacetFieldOption(fixed, this.mockParams, "facet.pivot.mincount", fieldMappings, this.mockRequest);
        String actualCount = fixed.get("facet.pivot.mincount");
        Assert.assertEquals((String)"Expected the mincount to be 2.", (Object)"2", (Object)actualCount);
    }
}

