/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Collection;
import java.util.Properties;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.tracker.Tracker;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoTrackerRegistrationIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoTrackerRegistrationIT.initAlfrescoCore("schema.xml");
    }

    @After
    public void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    @Test
    public void checkCronOnTrackers() {
        Collection<Tracker> trackers = this.getTrackers();
        Assert.assertNotNull(trackers);
        trackers.forEach(this::checkCronOnTracker);
    }

    private void checkCronOnTracker(Tracker tracker) {
        Properties props = tracker.getProps();
        Assert.assertEquals((Object)"0/10 * * * * ? *", (Object)props.get("alfresco.tracker.acl.cron"));
        Assert.assertEquals((Object)"0/10 * * * * ? *", (Object)props.get("alfresco.tracker.content.cron"));
        Assert.assertEquals((Object)"0/10 * * * * ? *", (Object)props.get("alfresco.tracker.metadata.cron"));
    }
}

