/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoJsonQueryRequest;
import org.alfresco.solr.SolrITInitializer;
import org.alfresco.solr.basics.RandomSupplier;
import org.alfresco.solr.basics.SolrResponsesComparator;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlfrescoDistributedIT
extends SolrITInitializer {
    protected static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String[] deadServers;
    protected static SolrResponsesComparator SOLR_RESPONSE_COMPARATOR = new SolrResponsesComparator();
    protected static RandomSupplier SOLR_RANDOM_SUPPLIER;
    protected static int stress;
    protected static boolean verifyStress;
    protected static int nThreads;
    protected static String id;

    @BeforeClass
    public static void setUpSolrTestProperties() {
        SOLR_RANDOM_SUPPLIER = new RandomSupplier();
        System.setProperty("alfresco.test", "true");
        System.setProperty("solr.tests.maxIndexingThreads", "10");
        System.setProperty("solr.tests.ramBufferSizeMB", "1024");
    }

    protected static void putHandleDefaults() {
        SOLR_RESPONSE_COMPARATOR.putHandleDefaults();
    }

    public static boolean checkMinCountPerShard(Query query, int count, long waitMillis) throws SolrServerException, IOException {
        long begin = System.currentTimeMillis();
        List<SolrClient> shardedClients = AbstractAlfrescoDistributedIT.getShardedClients();
        long timeout = begin + waitMillis;
        boolean allShardCompliant = false;
        for (SolrClient singleShard : shardedClients) {
            allShardCompliant = false;
            int cycles = 1;
            while (new Date().getTime() < timeout && !allShardCompliant) {
                QueryResponse response = singleShard.query((SolrParams)AbstractAlfrescoDistributedIT.luceneToSolrQuery(query));
                int totalHits = (int)response.getResults().getNumFound();
                if ((long)totalHits >= (long)count) {
                    allShardCompliant = true;
                }
                try {
                    Thread.sleep(500 * cycles++);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return allShardCompliant;
    }

    public static void waitForShardsCount(ModifiableSolrParams query, int count, long waitMillis, long start) throws Exception {
        long timeOut = start + waitMillis;
        int totalCount = 0;
        query.set("shards", new String[]{shards});
        SolrClient clientShard = (SolrClient)clientShards.get(0);
        while (System.currentTimeMillis() < timeOut) {
            QueryResponse response = clientShard.query((SolrParams)query);
            totalCount = (int)response.getResults().getNumFound();
            if (totalCount != count) continue;
            return;
        }
        throw new Exception("Cluster:Wait error expected " + count + " found " + totalCount + " : " + query.toString());
    }

    public static void waitForDocCountAllCores(Query query, int count, long waitMillis) throws Exception {
        long begin = System.currentTimeMillis();
        for (SolrClient client : AbstractAlfrescoDistributedIT.getStandaloneAndShardedClients()) {
            AbstractAlfrescoDistributedIT.waitForDocCountCore(client, (ModifiableSolrParams)AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count, waitMillis, begin);
        }
    }

    public void waitForDocCountAllShards(Query query, int count, long waitMillis) throws Exception {
        long begin = System.currentTimeMillis();
        for (SolrClient client : AbstractAlfrescoDistributedIT.getShardedClients()) {
            AbstractAlfrescoDistributedIT.waitForDocCountCore(client, (ModifiableSolrParams)AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count, waitMillis, begin);
        }
    }

    public static void deleteByQueryAllClients(String q) throws Exception {
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getStandaloneAndShardedClients();
        for (SolrClient client : clients) {
            client.deleteByQuery(q);
        }
    }

    public static void explicitCommitOnAllClients() throws Exception {
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getStandaloneAndShardedClients();
        for (SolrClient client : clients) {
            client.commit();
        }
    }

    protected static SolrClient getDefaultTestClient() {
        return (SolrClient)solrCollectionNameToStandaloneClient.get("collection1");
    }

    protected static List<SolrClient> getShardedClients() {
        return clientShards;
    }

    public static List<SolrClient> getStandaloneAndShardedClients() {
        ArrayList<SolrClient> clients = new ArrayList<SolrClient>();
        clients.addAll(solrCollectionNameToStandaloneClient.values());
        clients.addAll(clientShards);
        return clients;
    }

    public static List<SolrClient> getStandaloneClients() {
        return new ArrayList<SolrClient>(solrCollectionNameToStandaloneClient.values());
    }

    public static void waitForDocCount(Query query, int count, long waitMillis) throws Exception {
        AbstractAlfrescoDistributedIT.waitForDocCount((ModifiableSolrParams)AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count, waitMillis);
    }

    public static void waitForDocCount(ModifiableSolrParams query, int count, long waitMillis) throws Exception {
        long begin = System.currentTimeMillis();
        SolrClient standaloneClient = AbstractAlfrescoDistributedIT.getStandaloneClients().get(0);
        AbstractAlfrescoDistributedIT.waitForDocCountCore(standaloneClient, query, count, waitMillis, begin);
        AbstractAlfrescoDistributedIT.waitForShardsCount(query, count, waitMillis, begin);
    }

    public static void assertShardCount(int shardNumber, Query query, int count) throws Exception {
        AbstractAlfrescoDistributedIT.assertShardCount(shardNumber, (ModifiableSolrParams)AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count);
    }

    public static void assertShardCount(int shardNumber, ModifiableSolrParams query, int count) throws Exception {
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getShardedClients();
        SolrClient client = clients.get(shardNumber);
        QueryResponse response = client.query((SolrParams)query);
        int totalHits = (int)response.getResults().getNumFound();
        if (count != totalHits) {
            throw new Exception("Expecting " + count + " docs on shard " + shardNumber + " , found " + totalHits);
        }
    }

    private static String escapeQueryClause(String query) {
        int i = query.lastIndexOf(":");
        if (i == -1) {
            return query + " ";
        }
        String field = query.substring(0, i);
        String value = query.substring(i + 1);
        String escapedField = AbstractAlfrescoDistributedIT.escapeQueryChars(field);
        return escapedField + ":" + value + " ";
    }

    protected static String escapeQueryChars(String query) {
        return query.replaceAll("\\:", "\\\\:").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public static SolrQuery luceneToSolrQuery(Query query) {
        String[] terms = query.toString().split(" ");
        Object escapedQuery = "";
        for (String t : terms) {
            escapedQuery = (String)escapedQuery + AbstractAlfrescoDistributedIT.escapeQueryClause(t);
        }
        return new SolrQuery("{!lucene}" + (String)escapedQuery);
    }

    public static void waitForShardsCount(Query query, int count, long waitMillis, long start) throws Exception {
        SolrQuery solrQuery = AbstractAlfrescoDistributedIT.luceneToSolrQuery(query);
        AbstractAlfrescoDistributedIT.waitForShardsCount((ModifiableSolrParams)solrQuery, count, waitMillis, start);
    }

    protected static Collection<SolrCore> getCores(Collection<JettySolrRunner> runners) {
        return ((JettySolrRunner)jettyContainers.values().iterator().next()).getCoreContainer().getCores();
    }

    protected static List<AlfrescoCoreAdminHandler> getAdminHandlers(Collection<JettySolrRunner> runners) {
        ArrayList<AlfrescoCoreAdminHandler> coreAdminHandlers = new ArrayList<AlfrescoCoreAdminHandler>();
        for (JettySolrRunner jettySolrRunner : runners) {
            CoreContainer coreContainer = jettySolrRunner.getCoreContainer();
            AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
            coreAdminHandlers.add(coreAdminHandler);
        }
        return coreAdminHandlers;
    }

    public static int assertNodesPerShardGreaterThan(int count) throws Exception {
        return AbstractAlfrescoDistributedIT.assertNodesPerShardGreaterThan(count, false);
    }

    public static int assertNodesPerShardGreaterThan(int count, boolean ignoreZero) throws Exception {
        int shardHit = 0;
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getShardedClients();
        SolrQuery query = AbstractAlfrescoDistributedIT.luceneToSolrQuery((Query)new TermQuery(new Term("DOC_TYPE", "Node")));
        StringBuilder error = new StringBuilder();
        for (SolrClient client : clients) {
            QueryResponse response = client.query((SolrParams)query);
            int totalHits = (int)response.getResults().getNumFound();
            if (totalHits > 0) {
                ++shardHit;
            }
            if (totalHits < count) {
                if (ignoreZero && totalHits == 0) {
                    log.info(String.valueOf(client) + ": have zero hits ");
                } else {
                    error.append(" " + String.valueOf(client) + ": ");
                    error.append("Expected nodes per shard greater than " + count + " found " + totalHits + " : " + query.toString());
                }
            }
            log.info(String.valueOf(client) + ": Hits " + totalHits);
        }
        if (error.length() > 0) {
            throw new Exception(error.toString());
        }
        return shardHit;
    }

    public static void assertCountAndColocation(Query query, int count) throws Exception {
        AbstractAlfrescoDistributedIT.assertCountAndColocation(AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count);
    }

    public static void assertCountAndColocation(SolrQuery query, int count) throws Exception {
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getShardedClients();
        int shardHit = 0;
        int totalCount = 0;
        for (SolrClient client : clients) {
            QueryResponse response = client.query((SolrParams)query);
            int hits = (int)response.getResults().getNumFound();
            totalCount += hits;
            if (hits <= 0) continue;
            ++shardHit;
        }
        if (totalCount != count) {
            throw new Exception(totalCount + " docs found for query: " + query.toString() + " expecting " + count);
        }
        if (shardHit > 1) {
            throw new Exception(shardHit + " shards found data for query: " + query.toString() + " expecting 1");
        }
    }

    public static void assertShardSequence(int shard, Query query, int count) throws Exception {
        AbstractAlfrescoDistributedIT.assertShardSequence(shard, AbstractAlfrescoDistributedIT.luceneToSolrQuery(query), count);
    }

    public static void assertShardSequence(int shard, SolrQuery query, int count) throws Exception {
        List<SolrClient> clients = AbstractAlfrescoDistributedIT.getShardedClients();
        SolrClient client = clients.get(shard);
        QueryResponse response = client.query((SolrParams)query);
        int totalCount = (int)response.getResults().getNumFound();
        if (totalCount != count) {
            throw new Exception(totalCount + " docs found for query: " + query.toString() + " expecting " + count);
        }
    }

    public static void waitForDocCountCore(SolrClient client, ModifiableSolrParams query, long expectedNumFound, long waitMillis, long startMillis) throws Exception {
        long timeout = startMillis + waitMillis;
        int totalHits = 0;
        int increment = 1;
        while (new Date().getTime() < timeout) {
            QueryResponse response = client.query((SolrParams)query);
            totalHits = (int)response.getResults().getNumFound();
            if ((long)totalHits == expectedNumFound) {
                return;
            }
            Thread.sleep(500 * increment++);
        }
        throw new Exception("Core:Wait error expected " + expectedNumFound + " found " + totalHits + " : " + query.toString());
    }

    protected void setDistributedParams(ModifiableSolrParams params) {
        params.set("shards", new String[]{this.getShardsString()});
    }

    protected static List<Tuple> getTuples(TupleStream tupleStream) throws IOException {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        tupleStream.open();
        try {
            while (true) {
                Tuple tuple = tupleStream.read();
                if (!tuple.EOF) {
                    tuples.add(tuple);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                tupleStream.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return tuples;
    }

    protected String getShardsString() {
        Random r = SOLR_RANDOM_SUPPLIER.getRandomGenerator();
        if (this.deadServers == null) {
            return shards;
        }
        StringBuilder sb = new StringBuilder();
        for (String shard : shardsArr) {
            int nDeadServers;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((nDeadServers = r.nextInt(this.deadServers.length + 1)) > 0) {
                ArrayList<String> replicas = new ArrayList<String>(Arrays.asList(this.deadServers));
                Collections.shuffle(replicas, r);
                replicas.add(r.nextInt(nDeadServers + 1), shard);
                for (int i = 0; i < nDeadServers + 1; ++i) {
                    if (i != 0) {
                        sb.append('|');
                    }
                    sb.append((String)replicas.get(i));
                }
                continue;
            }
            sb.append(shard);
        }
        return sb.toString();
    }

    protected static void addFields(SolrInputDocument doc, Object ... fields) {
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
    }

    protected static void index(SolrClient client, int shardId, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        AbstractAlfrescoDistributedIT.addFields(doc, fields);
        AbstractAlfrescoDistributedIT.indexDoc(client, shardId, doc);
    }

    protected static void indexDoc(SolrClient client, int shardId, SolrInputDocument doc) throws IOException, SolrServerException {
        client.add(doc);
        SolrClient clientShard = (SolrClient)clientShards.get(shardId);
        clientShard.add(doc);
    }

    protected static void index(SolrClient client, boolean andShards, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        AbstractAlfrescoDistributedIT.addFields(doc, fields);
        AbstractAlfrescoDistributedIT.indexDoc(client, andShards, doc);
    }

    protected static void indexDoc(SolrClient client, boolean andShards, SolrInputDocument doc) throws IOException, SolrServerException {
        client.add(doc);
        if (andShards) {
            int which = (doc.getField(id).toString().hashCode() & Integer.MAX_VALUE) % clientShards.size();
            SolrClient clientShard = (SolrClient)clientShards.get(which);
            clientShard.add(doc);
        }
    }

    protected static UpdateResponse add(SolrClient client, SolrParams params, SolrInputDocument ... sdocs) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (SolrInputDocument sdoc : sdocs) {
            ureq.add(sdoc);
        }
        return (UpdateResponse)ureq.process(client);
    }

    protected static void commit(SolrClient client, boolean andShards) throws Exception {
        client.commit();
        if (andShards) {
            for (SolrClient cshards : clientShards) {
                cshards.commit();
            }
        }
    }

    protected static QueryResponse queryRandomShard(ModifiableSolrParams params) throws SolrServerException, IOException {
        Random r = SOLR_RANDOM_SUPPLIER.getRandomGenerator();
        int which = r.nextInt(clientShards.size());
        SolrClient client = (SolrClient)clientShards.get(which);
        return client.query((SolrParams)params);
    }

    protected QueryResponse query(SolrClient solrClient, boolean andShards, String json, ModifiableSolrParams params) throws Exception {
        params.set("distrib", new String[]{"false"});
        QueryRequest request = AbstractAlfrescoDistributedIT.getAlfrescoRequest(json, (SolrParams)params);
        QueryResponse controlRsp = (QueryResponse)request.process(solrClient);
        SOLR_RESPONSE_COMPARATOR.validateResponse(controlRsp);
        if (andShards) {
            params.remove("distrib");
            this.setDistributedParams(params);
            QueryResponse rsp = AbstractAlfrescoDistributedIT.queryRandomShard(json, (SolrParams)params);
            SOLR_RESPONSE_COMPARATOR.compareResponses(rsp, controlRsp);
            return rsp;
        }
        return controlRsp;
    }

    protected static QueryResponse queryRandomShard(String json, SolrParams params) throws SolrServerException, IOException {
        Random r = SOLR_RANDOM_SUPPLIER.getRandomGenerator();
        int which = r.nextInt(clientShards.size());
        SolrClient client = (SolrClient)clientShards.get(which);
        QueryRequest request = AbstractAlfrescoDistributedIT.getAlfrescoRequest(json, params);
        return (QueryResponse)request.process(client);
    }

    protected static QueryRequest getAlfrescoRequest(String json, SolrParams params) {
        AlfrescoJsonQueryRequest request = new AlfrescoJsonQueryRequest(json, params);
        request.setMethod(SolrRequest.METHOD.POST);
        return request;
    }

    protected QueryResponse query(SolrClient solrClient, boolean setDistribParams, SolrParams p) throws Exception {
        Random r = SOLR_RANDOM_SUPPLIER.getRandomGenerator();
        ModifiableSolrParams params = new ModifiableSolrParams(p);
        params.set("distrib", new String[]{"false"});
        QueryResponse controlRsp = solrClient.query((SolrParams)params);
        SOLR_RESPONSE_COMPARATOR.validateResponse(controlRsp);
        params.remove("distrib");
        if (setDistribParams) {
            this.setDistributedParams(params);
        }
        QueryResponse rsp = AbstractAlfrescoDistributedIT.queryRandomShard(params);
        SOLR_RESPONSE_COMPARATOR.compareResponses(rsp, controlRsp);
        if (stress > 0) {
            log.info("starting stress...");
            Thread[] threads = new Thread[nThreads];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(() -> {
                    for (int j = 0; j < stress; ++j) {
                        int which = r.nextInt(clientShards.size());
                        SolrClient client = (SolrClient)clientShards.get(which);
                        try {
                            QueryResponse rsp1 = client.query((SolrParams)new ModifiableSolrParams((SolrParams)params));
                            if (!verifyStress) continue;
                            SOLR_RESPONSE_COMPARATOR.compareResponses(rsp1, controlRsp);
                            continue;
                        }
                        catch (IOException | SolrServerException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                threads[i].start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
        return rsp;
    }

    public static QueryResponse queryAndCompare(SolrParams params, SolrClient ... clients) throws SolrServerException, IOException {
        return AbstractAlfrescoDistributedIT.queryAndCompare(params, Arrays.asList(clients));
    }

    public static QueryResponse queryAndCompare(SolrParams params, Iterable<SolrClient> clients) throws SolrServerException, IOException {
        QueryResponse first = null;
        for (SolrClient client : clients) {
            QueryResponse rsp = client.query((SolrParams)new ModifiableSolrParams(params));
            if (first == null) {
                first = rsp;
                continue;
            }
            SOLR_RESPONSE_COMPARATOR.compareResponses(first, rsp);
        }
        return first;
    }

    public static void indexTransaction(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas) {
        nodes.stream().forEach(node -> node.setTxnId(transaction.getId()));
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    public static void indexTransaction(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas, List<String> content) {
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        int i = 0;
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
            SOLRAPIQueueClient.NODE_CONTENT_MAP.put(nodeMetaData.getId(), Map.of(ContentModel.PROP_CONTENT, content.get(i++)));
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    public static void indexTransactionWithMultipleContentFields(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas, List<Map<QName, String>> content) {
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        int i = 0;
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
            SOLRAPIQueueClient.NODE_CONTENT_MAP.put(nodeMetaData.getId(), content.get(i++));
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    protected static SolrQueryResponse callHandler(AlfrescoCoreAdminHandler coreAdminHandler, SolrCore testingCore, String action) {
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(testingCore, (SolrParams)AbstractAlfrescoDistributedIT.params((String[])new String[]{"action", action, "core", testingCore.getName()}));
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        return response;
    }

    protected static SolrQueryResponse callExpand(AlfrescoCoreAdminHandler coreAdminHandler, SolrCore testingCore, int value) {
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(testingCore, (SolrParams)AbstractAlfrescoDistributedIT.params((String[])new String[]{"action", "EXPAND", "core", testingCore.getName(), "add", Integer.toString(value)}));
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        return response;
    }

    public static SolrQueryResponse rangeCheck(int shard) throws Exception {
        int maxAttemps = 10;
        for (int attemp = 0; attemp < maxAttemps; ++attemp) {
            boolean isReady;
            Collection<SolrCore> cores = AbstractAlfrescoDistributedIT.getCores(solrShards);
            List<AlfrescoCoreAdminHandler> alfrescoCoreAdminHandlers = AbstractAlfrescoDistributedIT.getAdminHandlers(solrShards);
            SolrCore core = cores.stream().filter(solrcore -> solrcore.getName().equals("shard" + shard)).findAny().orElseThrow(RuntimeException::new);
            AlfrescoCoreAdminHandler alfrescoCoreAdminHandler = alfrescoCoreAdminHandlers.get(shard);
            SolrQueryResponse response = AbstractAlfrescoDistributedIT.callHandler(alfrescoCoreAdminHandler, core, "RANGECHECK");
            NamedList values = response.getValues();
            boolean bl = isReady = !Optional.ofNullable(values.get("report")).map(Object::toString).filter(r -> r.contains("WARNING=The requested endpoint is not available on the slave")).isPresent() && !Optional.ofNullable(values.get("exception")).map(Object::toString).filter(ex -> ex.contains("not initialized")).isPresent();
            if (isReady) {
                return response;
            }
            Thread.sleep(1000L);
        }
        throw new Exception("impossible to perform rangeChack");
    }

    public static SolrQueryResponse expand(int shard, int value) {
        Collection<SolrCore> cores = AbstractAlfrescoDistributedIT.getCores(solrShards);
        List<AlfrescoCoreAdminHandler> alfrescoCoreAdminHandlers = AbstractAlfrescoDistributedIT.getAdminHandlers(solrShards);
        SolrCore core = cores.stream().filter(solrcore -> solrcore.getName().equals("shard" + shard)).findAny().orElseThrow(RuntimeException::new);
        AlfrescoCoreAdminHandler alfrescoCoreAdminHandler = alfrescoCoreAdminHandlers.get(shard);
        return AbstractAlfrescoDistributedIT.callExpand(alfrescoCoreAdminHandler, core, value);
    }

    static {
        stress = TEST_NIGHTLY ? 2 : 0;
        verifyStress = true;
        nThreads = 3;
        id = "id";
    }

    public static class BasicAuthFilter
    implements Filter {
        public void init(FilterConfig config) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            String auth = ((HttpServletRequest)request).getHeader("Authorization");
            if (auth != null) {
                auth = auth.replace("Basic ", "");
                byte[] bytes = Base64.getDecoder().decode(auth);
                String decodedBytes = new String(bytes);
                String[] pair = decodedBytes.split(":");
                String user = pair[0];
                String password = pair[1];
                if (user.equals("test") && password.equals("pass")) {
                    filterChain.doFilter(request, response);
                } else {
                    ((HttpServletResponse)response).sendError(403);
                }
            } else {
                ((HttpServletResponse)response).sendError(403);
            }
        }

        public void destroy() {
        }
    }
}

