/*
 * #%L
 * Alfresco Search Services
 * %%
 * Copyright (C) 2005 - 2020 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.alfresco.solr.query;

import java.io.IOException;

/**
 * Elements used to test agains path and Qname
 * 
 * @author andyh
 */
public interface StructuredFieldPosition
{

    /**
     * Does this element match
     * 
     * @param start -
     *            the start postion of the paths terms
     * @param end -
     *            the end position of the paths terms
     * @param offset -
     *            the current offset in the path
     * @return returns the next match position (usually offset + 1) or -1 if it
     *         does not match.
     * @throws IOException
     */
    public int matches(int start, int end, int offset) throws IOException;

    /**
     * If this position is last in the chain and it is terminal it will ensure
     * it is an exact match for the length of the chain found. If false, it will
     * effectively allow prefix mathces for the likes of descendant-and-below
     * style queries.
     * 
     * @return boolean
     */
    public boolean isTerminal();

    /**
     * Is this an absolute element; that is, it knows its exact position.
     * 
     * @return boolean
     */
    public boolean isAbsolute();

    /**
     * This element only knows its position relative to the previous element.
     * 
     * @return boolean
     */
    public boolean isRelative();

    /**
     * Get the test to search for in the term query. This may be null if it
     * should not have a term query
     * 
     * @return String
     */
    public String getTermText();

    /**
     * If absolute return the position. If relative we could compute the
     * position knowing the previous term unless this element is preceded by a
     * descendat and below style element
     * 
     * @return int
     */
    public int getPosition();

    /**
     * A reference to the caching term positions this element uses. This may be
     * null which indicates all terms match, in that case there is no action
     * against the index
     * 
     * @param tps CachingTermPositions
     */
    public void setCachingTermPositions(CachingTermPositions tps);

    public CachingTermPositions getCachingTermPositions();

    /**
     * Normally paths would require onlt parent chaining. for some it is parent
     * and child chaining.
     * 
     * @return boolean
     */

    public boolean linkSelf();
    
    public boolean linkParent();

    public boolean allowslinkingByParent();
    
    public boolean allowsLinkingBySelf();
    
    public boolean isDescendant();
    
    public boolean matchesAll();
}
