/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrReaderSetScorer
extends AbstractSolrCachingScorer {
    SolrReaderSetScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrReaderSetScorer createReaderSetScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authorities, LeafReader reader) throws IOException {
        DocSet readableDocSet = (DocSet)searcher.cacheLookup("alfrescoReaderCache", (Object)authorities);
        if (readableDocSet == null) {
            String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
            readableDocSet = new BitDocSet(new FixedBitSet(searcher.maxDoc()));
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            for (String current : auths) {
                bQuery.add((Query)new TermQuery(new Term("READER", current)), BooleanClause.Occur.SHOULD);
            }
            DocSet aclDocs = searcher.getDocSet((Query)bQuery.build());
            BooleanQuery.Builder aQuery = new BooleanQuery.Builder();
            DocIterator it = aclDocs.iterator();
            while (it.hasNext()) {
                int docID = it.nextDoc();
                long aclID = searcher.getSlowAtomicReader().getNumericDocValues("ACLID").get(docID);
                SchemaField schemaField = searcher.getSchema().getField("ACLID");
                Query query = schemaField.getType().getFieldQuery(null, schemaField, Long.toString(aclID));
                aQuery.add(query, BooleanClause.Occur.SHOULD);
                if (aQuery.build().clauses().size() <= 999 && it.hasNext()) continue;
                DocSet docsForAclId = searcher.getDocSet((Query)aQuery.build());
                readableDocSet = readableDocSet.union(docsForAclId);
                aQuery = new BooleanQuery.Builder();
            }
            readableDocSet = readableDocSet.andNot(aclDocs);
            searcher.cacheInsert("alfrescoReaderCache", (Object)authorities, (Object)readableDocSet);
        }
        return new SolrReaderSetScorer(weight, readableDocSet, context, searcher);
    }
}

