/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.alfresco.solr.data.GlobalReaders;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrAuthoritySetQuery;
import org.alfresco.solr.query.SolrOwnerSetQuery;
import org.alfresco.solr.query.SolrReaderSetQuery;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.WrappedQuery;

public class SolrAuthoritySetScorer
extends AbstractSolrCachingScorer {
    SolrAuthoritySetScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrAuthoritySetScorer createAuthoritySetScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authorities) throws IOException {
        WrappedQuery wrapped;
        Properties p = searcher.getSchema().getResourceLoader().getCoreProperties();
        boolean doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
        SolrAuthoritySetQuery key = new SolrAuthoritySetQuery(authorities);
        DocSet answer = (DocSet)searcher.cacheLookup("alfrescoAuthorityCache", (Object)key);
        if (answer != null) {
            return new SolrAuthoritySetScorer(weight, answer, context, searcher);
        }
        String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
        boolean hasGlobalRead = false;
        HashSet<String> globalReaders = GlobalReaders.getReaders();
        for (String auth : auths) {
            if (!globalReaders.contains(auth)) continue;
            hasGlobalRead = true;
            break;
        }
        if (hasGlobalRead || !doPermissionChecks) {
            wrapped = new WrappedQuery((Query)new MatchAllDocsQuery());
            wrapped.setCache(false);
            DocSet allDocs = searcher.getDocSet((Query)wrapped);
            return new SolrAuthoritySetScorer(weight, allDocs, context, searcher);
        }
        wrapped = new WrappedQuery((Query)new SolrReaderSetQuery(authorities));
        wrapped.setCache(false);
        DocSet readableDocSet = searcher.getDocSet((Query)wrapped);
        if (globalReaders.contains("ROLE_OWNER")) {
            wrapped = new WrappedQuery((Query)new SolrOwnerSetQuery(authorities));
            wrapped.setCache(false);
            DocSet authorityOwnedDocs = searcher.getDocSet((Query)wrapped);
            DocSet toCache = readableDocSet.union(authorityOwnedDocs);
            searcher.cacheInsert("alfrescoAuthorityCache", (Object)key, (Object)toCache);
            return new SolrAuthoritySetScorer(weight, toCache, context, searcher);
        }
        wrapped = new WrappedQuery((Query)new SolrReaderSetQuery("|ROLE_OWNER"));
        wrapped.setCache(false);
        DocSet ownerReadableDocSet = searcher.getDocSet((Query)wrapped);
        wrapped = new WrappedQuery((Query)new SolrOwnerSetQuery(authorities));
        wrapped.setCache(false);
        DocSet authorityOwnedDocs = searcher.getDocSet((Query)wrapped);
        DocSet docsAuthorityOwnsAndCanRead = ownerReadableDocSet.intersection(authorityOwnedDocs);
        DocSet toCache = readableDocSet.union(docsAuthorityOwnsAndCanRead);
        searcher.cacheInsert("alfrescoAuthorityCache", (Object)key, (Object)toCache);
        return new SolrAuthoritySetScorer(weight, toCache, context, searcher);
    }
}

