/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.SolrKeyResourceLoader;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.SOLRAPIClientFactory;
import org.alfresco.solr.security.SecretSharedPropertyCollector;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.CommitTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.alfresco.solr.tracker.SolrTrackerScheduler;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptorDecorator;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCoreLoadListener
extends AbstractSolrEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrCoreLoadListener.class);

    public SolrCoreLoadListener(SolrCore core) {
        super(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        if (this.getCore().isReloaded()) {
            LOGGER.info("Solr Core {}, instance {} has been reloaded. The previous tracking subsystem will be stopped and another set of trackers will be registered on this new instance.", (Object)this.getCore().getName(), (Object)this.getCore().hashCode());
        } else {
            LOGGER.info("Solr Core {}, instance {}, has been registered for the first time.", (Object)this.getCore().getName(), (Object)this.getCore().hashCode());
        }
        CoreContainer coreContainer = this.getCore().getCoreContainer();
        AlfrescoCoreAdminHandler admin = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        SolrCore core = this.getCore();
        TrackerRegistry trackerRegistry = admin.getTrackerRegistry();
        Properties coreProperties = new CoreDescriptorDecorator(core.getCoreDescriptor()).getProperties();
        coreProperties = SecretSharedPropertyCollector.completeCoreProperties(coreProperties);
        SolrResourceLoader loader = core.getLatestSchema().getResourceLoader();
        SolrKeyResourceLoader keyResourceLoader = new SolrKeyResourceLoader(loader);
        SOLRAPIClientFactory clientFactory = new SOLRAPIClientFactory();
        SOLRAPIClient repositoryClient = clientFactory.getSOLRAPIClient(coreProperties, (KeyResourceLoader)keyResourceLoader, (DictionaryService)AlfrescoSolrDataModel.getInstance().getDictionaryService("DEFAULT_DICTIONARY"), AlfrescoSolrDataModel.getInstance().getNamespaceDAO());
        SolrInformationServer informationServer = new SolrInformationServer(admin, core, repositoryClient);
        coreProperties.putAll((Map<?, ?>)informationServer.getProps());
        admin.getInformationServers().put(core.getName(), informationServer);
        final SolrTrackerScheduler scheduler = admin.getScheduler();
        Class<SolrCoreLoadListener> clazz = SolrCoreLoadListener.class;
        synchronized (SolrCoreLoadListener.class) {
            ShardStatePublisher statePublisher;
            this.createModelTracker(core.getName(), trackerRegistry, coreProperties, coreContainer.getSolrHome(), repositoryClient, informationServer, scheduler);
            // ** MonitorExit[var14_14] (shouldn't be in output)
            final ArrayList<Tracker> trackers = new ArrayList<Tracker>();
            core.addCloseHook(new CloseHook(){

                public void preClose(SolrCore core) {
                    LOGGER.info("Solr Core instance {} with name {} is going to be closed. Tracking Subsystem shutdown callback procedure has been started.", (Object)core.hashCode(), (Object)core.getName());
                    SolrCoreLoadListener.this.shutdownTrackers(core, trackers, scheduler, false);
                }

                public void postClose(SolrCore core) {
                    LOGGER.info("Solr Core instance {} with name {} has been closed. Tracking Subsystem shutdown callback procedure has been completed.", (Object)core.hashCode(), (Object)core.getName());
                }
            });
            boolean trackersHaveBeenEnabled = Boolean.parseBoolean(coreProperties.getProperty("enable.alfresco.tracking", "true"));
            boolean owningCoreIsSlave = this.isSlaveModeEnabledFor(core);
            if (trackerRegistry.hasTrackersForCore(core.getName())) {
                LOGGER.info("Trackers (it could be only the node state publisher in case this node is a slave) for " + core.getName() + " are already registered, shutting them down.");
                Collection<Tracker> alreadyRegisteredTrackers = trackerRegistry.getTrackersForCore(core.getName());
                trackerRegistry.removeTrackersForCore(core.getName());
                this.shutdownTrackers(core, alreadyRegisteredTrackers, scheduler, core.isReloaded());
                admin.getInformationServers().remove(core.getName());
            }
            admin.getInformationServers().put(core.getName(), informationServer);
            if (!trackersHaveBeenEnabled) {
                LOGGER.info("SearchServices Core Trackers have been explicitly disabled on core \"{}\" through \"enable.alfresco.tracking\" configuration property.", (Object)core.getName());
                statePublisher = new ShardStatePublisher(false, coreProperties, repositoryClient, core.getName(), informationServer);
                trackerRegistry.register(core.getName(), statePublisher);
                scheduler.schedule(statePublisher, core.getName(), coreProperties);
                trackers.add(statePublisher);
                LOGGER.info("SearchServices Slave Node Provider have been created and scheduled for core \"{}\".", (Object)core.getName());
                return;
            }
            if (owningCoreIsSlave) {
                LOGGER.info("SearchServices Core Trackers have been disabled on core \"{}\" because it is a slave core.", (Object)core.getName());
                statePublisher = new ShardStatePublisher(false, coreProperties, repositoryClient, core.getName(), informationServer);
                trackerRegistry.register(core.getName(), statePublisher);
                scheduler.schedule(statePublisher, core.getName(), coreProperties);
                trackers.add(statePublisher);
                LOGGER.info("SearchServices Slave Node Provider have been created and scheduled for Core instance {} with name {}.", (Object)core.hashCode(), (Object)core.getName());
                return;
            }
            LOGGER.info("SearchServices Tracking Subsystem starts on Solr Core instance {} with name {}", (Object)core.hashCode(), (Object)core.getName());
            trackers.addAll(this.createAndScheduleCoreTrackers(core, trackerRegistry, coreProperties, scheduler, repositoryClient, informationServer));
            CommitTracker commitTracker = new CommitTracker(coreProperties, repositoryClient, core.getName(), (InformationServer)informationServer, trackers);
            trackerRegistry.register(core.getName(), commitTracker);
            scheduler.schedule(commitTracker, core.getName(), coreProperties);
            LOGGER.info("Tracker {}, instance {}, belonging to Core {}, instance {} has been registered and scheduled.", new Object[]{commitTracker.getClass().getSimpleName(), commitTracker.hashCode(), core.getName(), core.hashCode()});
            trackers.add(commitTracker);
            return;
        }
    }

    List<Tracker> createAndScheduleCoreTrackers(SolrCore core, TrackerRegistry trackerRegistry, Properties props, SolrTrackerScheduler scheduler, SOLRAPIClient repositoryClient, SolrInformationServer srv) {
        AclTracker aclTracker = this.registerAndSchedule(new AclTracker(props, repositoryClient, core.getName(), srv), core, props, trackerRegistry, scheduler);
        ContentTracker contentTracker = this.registerAndSchedule(new ContentTracker(props, repositoryClient, core.getName(), srv), core, props, trackerRegistry, scheduler);
        MetadataTracker metadataTracker = this.registerAndSchedule(new MetadataTracker(props, repositoryClient, core.getName(), (InformationServer)srv, true), core, props, trackerRegistry, scheduler);
        ShardStatePublisher coreStateTracker = this.registerAndSchedule(new ShardStatePublisher(true, props, repositoryClient, core.getName(), srv), core, props, trackerRegistry, scheduler);
        ArrayList<Tracker> trackers = new ArrayList<Tracker>();
        String cascadeTrackerEnabledProp = Optional.ofNullable((String)props.get("alfresco.cascade.tracker.enabled")).orElse("true");
        if (Boolean.valueOf(cascadeTrackerEnabledProp).booleanValue()) {
            CascadeTracker cascadeTracker = this.registerAndSchedule(new CascadeTracker(props, repositoryClient, core.getName(), srv), core, props, trackerRegistry, scheduler);
            trackers.add(cascadeTracker);
        }
        trackers.addAll(Arrays.asList(contentTracker, metadataTracker, aclTracker, coreStateTracker));
        return trackers;
    }

    private <T extends Tracker> T registerAndSchedule(T tracker, SolrCore core, Properties properties, TrackerRegistry registry, SolrTrackerScheduler scheduler) {
        registry.register(core.getName(), tracker);
        scheduler.schedule(tracker, core.getName(), properties);
        LOGGER.info("Tracker {}, instance {}, belonging to Core {}, instance {} has been registered and scheduled.", new Object[]{tracker.getClass().getSimpleName(), tracker.hashCode(), core.getName(), core.hashCode()});
        return tracker;
    }

    private void createModelTracker(String coreName, TrackerRegistry trackerRegistry, Properties props, String solrHome, SOLRAPIClient repositoryClient, SolrInformationServer srv, SolrTrackerScheduler scheduler) {
        ModelTracker mTracker = trackerRegistry.getModelTracker();
        if (mTracker == null) {
            LOGGER.debug("Creating a new Model Tracker instance.");
            mTracker = new ModelTracker(solrHome, props, repositoryClient, coreName, srv);
            trackerRegistry.setModelTracker(mTracker);
            LOGGER.info("Model Tracker: ensuring first model sync.");
            mTracker.ensureFirstModelSync();
            scheduler.schedule(mTracker, coreName, props);
            LOGGER.info("Model Tracker has been correctly initialised, registered and scheduled.");
        }
    }

    void shutdownTrackers(SolrCore core, Collection<Tracker> coreTrackers, SolrTrackerScheduler scheduler, boolean coreHasBeenReloaded) {
        coreTrackers.forEach(tracker -> this.shutdownTracker(core, (Tracker)tracker, scheduler, coreHasBeenReloaded));
    }

    private void shutdownTracker(SolrCore core, Tracker tracker, SolrTrackerScheduler scheduler, boolean coreHasBeenReloaded) {
        String coreReference = core.getName() + (String)(coreHasBeenReloaded ? "" : ", instance " + core.hashCode());
        if (tracker.isAlreadyInShutDownMode()) {
            LOGGER.info("Tracker {}, instance {} belonging to core {}, is already in shutdown mode.", new Object[]{tracker.getClass().getSimpleName(), tracker.hashCode(), coreReference});
            return;
        }
        LOGGER.info("Tracker {}, instance {} belonging to core {} shutdown procedure initiated.", new Object[]{tracker.getClass().getSimpleName(), tracker.hashCode(), coreReference});
        try {
            tracker.setShutdown(true);
            if (!scheduler.isShutdown()) {
                scheduler.deleteJobForTrackerInstance(core.getName(), tracker);
            }
            tracker.shutdown();
            LOGGER.info("Tracker {}, instance {}, belonging to core {} shutdown procedure correctly terminated.", new Object[]{tracker.getClass().getSimpleName(), tracker.hashCode(), coreReference});
        }
        catch (Exception exception) {
            LOGGER.error("Tracker {}, instance {} belonging to core {}, shutdown procedure failed. See the stacktrace below for further details.", new Object[]{tracker.getClass().getSimpleName(), tracker.hashCode(), coreReference, exception});
        }
    }

    boolean isSlaveModeEnabledFor(SolrCore core) {
        Predicate<PluginInfo> onlyReplicationHandler = plugin -> "/replication".equals(plugin.name) || plugin.className.endsWith(ReplicationHandler.class.getSimpleName());
        Function<NamedList, Boolean> isSlaveModeEnabled = params -> Optional.ofNullable(params).map(configuration -> {
            Object enable = configuration.get("enable");
            return enable == null || (enable instanceof String ? StrUtils.parseBool((String)((String)enable)) : Boolean.TRUE.equals(enable));
        }).orElse(false);
        return core.getSolrConfig().getPluginInfos(SolrRequestHandler.class.getName()).stream().filter(PluginInfo::isEnabled).filter(onlyReplicationHandler).findFirst().map(plugin -> plugin.initArgs).map(params -> params.get("slave")).map(NamedList.class::cast).map(isSlaveModeEnabled).orElse(false);
    }
}

