/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrTrackerStateIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrTrackerStateIT.initSolrServers(5, DistributedAlfrescoSolrTrackerStateIT.getSimpleClassName(), null);
        Acl acl = DistributedAlfrescoSolrTrackerStateIT.createAndIndexSomeAclData();
        DistributedAlfrescoSolrTrackerStateIT.createAndIndexTransactionWithSomeNodes(5, acl, "first");
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrTrackerStateIT.dismissSolrServers();
    }

    @Test
    public void shardStateMustBeConsistentWithCoreSummaryStats() {
        DistributedAlfrescoSolrTrackerStateIT.putHandleDefaults();
        DistributedAlfrescoSolrTrackerStateIT.getCores(solrShards).forEach(core -> {
            ShardStatePublisher tracker = Optional.of(AlfrescoSolrUtils.coreAdminHandler(core)).map(AlfrescoCoreAdminHandler::getTrackerRegistry).map(registry -> (ShardStatePublisher)registry.getTrackerForCore(core.getName(), ShardStatePublisher.class)).orElseThrow(() -> new IllegalStateException("Cannot retrieve the Metadata tracker on this test core."));
            ShardState shardStateAfterFirstIndexingRound = tracker.getShardState();
            AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(shardStateAfterFirstIndexingRound, core);
            Acl acl = DistributedAlfrescoSolrTrackerStateIT.createAndIndexSomeAclData();
            ShardState shardStateAfterIndexingSomeAdditionalAcl = tracker.getShardState();
            DistributedAlfrescoSolrTrackerStateIT.assertEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedTxId(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxId());
            DistributedAlfrescoSolrTrackerStateIT.assertEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedTxCommitTime(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxCommitTime());
            DistributedAlfrescoSolrTrackerStateIT.assertNotEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedChangeSetId(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetId());
            DistributedAlfrescoSolrTrackerStateIT.assertNotEquals((long)shardStateAfterFirstIndexingRound.getLastIndexedChangeSetCommitTime(), (long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetCommitTime());
            AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(shardStateAfterIndexingSomeAdditionalAcl, core);
            DistributedAlfrescoSolrTrackerStateIT.createAndIndexTransactionWithSomeNodes(10, acl, "second");
            ShardState shardStateAfterIndexingAnAdditionalTransaction = tracker.getShardState();
            DistributedAlfrescoSolrTrackerStateIT.assertNotEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxId(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedTxId());
            DistributedAlfrescoSolrTrackerStateIT.assertNotEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedTxCommitTime(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedTxCommitTime());
            DistributedAlfrescoSolrTrackerStateIT.assertEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetId(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedChangeSetId());
            DistributedAlfrescoSolrTrackerStateIT.assertEquals((long)shardStateAfterIndexingSomeAdditionalAcl.getLastIndexedChangeSetCommitTime(), (long)shardStateAfterIndexingAnAdditionalTransaction.getLastIndexedChangeSetCommitTime());
            AlfrescoSolrUtils.assertShardAndCoreSummaryConsistency(tracker.getShardState(), core);
        });
    }

    private static Acl createAndIndexSomeAclData() {
        try {
            AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
            Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
            Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
            AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
            AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
            AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(acl, acl2), Arrays.asList(aclReaders, aclReaders2));
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
            builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
            BooleanQuery waitForQuery = builder.build();
            DistributedAlfrescoSolrTrackerStateIT.waitForDocCountAllCores((Query)waitForQuery, 1, AlfrescoSolrUtils.MAX_WAIT_TIME);
            return acl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void createAndIndexTransactionWithSomeNodes(int howManyTestNodes, Acl acl, String sampleTextContent) {
        try {
            Transaction txn = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
            Map.Entry<List<Node>, List<NodeMetaData>> data = TestDataProvider.nSampleNodesWithSampleContent(acl, txn, howManyTestNodes);
            DistributedAlfrescoSolrTrackerStateIT.indexTransaction(txn, data.getKey(), data.getValue(), IntStream.range(0, howManyTestNodes).mapToObj(index -> sampleTextContent).collect(Collectors.toList()));
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
            builder.add(new BooleanClause(LongPoint.newExactQuery((String)"S_TXID", (long)txn.getId()), BooleanClause.Occur.MUST));
            BooleanQuery waitForQuery = builder.build();
            DistributedAlfrescoSolrTrackerStateIT.waitForDocCountAllCores((Query)waitForQuery, 1, AlfrescoSolrUtils.MAX_WAIT_TIME);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

